/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.ConsistencyChecker;
import com.raplix.rolloutexpress.RaplixShutdownException;
import com.raplix.rolloutexpress.Server;
import com.raplix.rolloutexpress.WebUIApplicationInterface;
import com.raplix.rolloutexpress.config.VariableSettingsManager;
import com.raplix.rolloutexpress.difference.DifferenceInterface;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceDBInterface;
import com.raplix.rolloutexpress.event.NotificationRPCInterface;
import com.raplix.rolloutexpress.event.rule.RuleMetaDataManager;
import com.raplix.rolloutexpress.executor.PlanInterface;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.ContextException;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportServices;
import com.raplix.rolloutexpress.node.NodeAdminSubsystem;
import com.raplix.rolloutexpress.node.NodeManagementServices;
import com.raplix.rolloutexpress.persist.DatabaseMaintenanceApplication;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBManager;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupManager;
import com.raplix.rolloutexpress.systemmodel.userdb.PermissionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBAdmin;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.UIContextServices;
import com.raplix.rolloutexpress.ui.web.ROXServlet;
import com.raplix.rolloutexpress.ui.web.StringConstants;
import com.raplix.rolloutexpress.ui.web.WebServerSubsystem;
import com.raplix.util.logger.Logger;
import com.raplix.util.message.MessageManager;
import java.util.HashSet;

public class ServerWebUIApplication
extends Server
implements StringConstants,
WebUIApplicationInterface {
    protected WebServerSubsystem mWebServerSubsystem;
    protected UIContextServices mUIContextServices;
    protected UserManager mUserManager;
    protected GroupManager mGroupManager;
    protected PermissionManager mPermissionManager;
    protected SessionManager mSessionManager;
    protected RuleMetaDataManager mRuleMetaDataManager;
    protected TransportServices mTransportServices;
    protected VariableSettingsManager mVariableSettingsManager;
    protected InstallDBManager mInstallDBManager;
    protected NodeManagementServices mNodeManagementServices;
    private static final String AVALON_VERSION = "5.2";
    private static final String DBM_INVOKE_CONFIG = "dbm.invoke";

    public ServerWebUIApplication(String[] inCommandLineArgs) throws ConfigurationException {
        super(inCommandLineArgs, false);
        try {
            UserDBAdmin userDBAdmin = this.mUserDB.getLocalUserDBAdmin();
            this.mUserManager = userDBAdmin.getUserManager();
            this.mGroupManager = userDBAdmin.getGroupManager();
            this.mPermissionManager = userDBAdmin.getPermissionManager();
            this.mSessionManager = this.mUserDB.getLocalSessionManager();
            this.mRuleMetaDataManager = (RuleMetaDataManager)this.getNetSubsystem().getRPC().getLocalService(RoxAddress.local, RuleMetaDataManager.class);
            this.mTransportServices = (TransportServices)this.getNetSubsystem().getRPC().getLocalService(RoxAddress.local, TransportServices.class);
            this.mVariableSettingsManager = (VariableSettingsManager)this.getNetSubsystem().getRPC().getLocalService(RoxAddress.local, VariableSettingsManager.class);
            this.mInstallDBManager = (InstallDBManager)this.getNetSubsystem().getRPC().getLocalService(RoxAddress.local, InstallDBManager.class);
            this.mNodeManagementServices = (NodeManagementServices)this.getNetSubsystem().getRPC().getLocalService(RoxAddress.local, NodeManagementServices.class);
            this.mWebServerSubsystem = new WebServerSubsystem(this);
            this.mUIContextServices = new UIContextServices();
            try {
                this.getNetSubsystem().getRPC().getContextManager().activateServices(this.mUIContextServices);
            }
            catch (ContextException ex) {
                Logger.error(ex.toString(), ex, this);
                throw new ConfigurationException("BOO");
            }
            ROXServlet.setApplication(this);
        }
        catch (Exception e) {
            Logger.error("Error", e, this);
        }
        this.postInit();
    }

    protected void preStartProcessing(String[] inCommandLineArgs) {
        int exitCode;
        boolean invokeDatabaseMaintenance;
        block13: {
            invokeDatabaseMaintenance = false;
            try {
                invokeDatabaseMaintenance = Boolean.valueOf(this.getConfiguration(DBM_INVOKE_CONFIG));
            }
            catch (ConfigurationException e) {
                if (!Logger.isWarnEnabled(this)) break block13;
                Logger.warn(MessageManager.messageAsString("app.MSG_INVOKE_CONFIG_READ_FAILED"), this);
            }
        }
        if (invokeDatabaseMaintenance) {
            int dBMExitCode;
            if (Logger.isInfoEnabled(this)) {
                Logger.info(MessageManager.messageAsString("app.DBM_STARTED"), this);
            }
            if ((dBMExitCode = DatabaseMaintenanceApplication.invoke(inCommandLineArgs, this)) != 0) {
                if (Logger.isErrorEnabled(this)) {
                    Logger.error(new ROXMessage("app.DBM_FAILED", new Integer[]{new Integer(dBMExitCode)}).toString(), this);
                }
                System.exit(dBMExitCode);
            }
            if (Logger.isInfoEnabled(this)) {
                Logger.info(MessageManager.messageAsString("app.DBM_SUCCESSFULL"), this);
            }
        } else if (Logger.isInfoEnabled(this)) {
            Logger.info(MessageManager.messageAsString("app.DBM_SKIPPED"), this);
        }
        if (Logger.isInfoEnabled(this)) {
            Logger.info(MessageManager.messageAsString("app.CC_INVOKED"), this);
        }
        if ((exitCode = ConsistencyChecker.invoke(inCommandLineArgs)) != 0) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(new ROXMessage("app.CC_FAILED", new Integer[]{new Integer(exitCode)}).toString(), this);
            }
            System.exit(exitCode);
        }
        if (Logger.isInfoEnabled(this)) {
            Logger.info(MessageManager.messageAsString("app.CC_SUCCESSFULL"), this);
        }
    }

    protected void shutdown() throws RaplixShutdownException {
        super.shutdown();
        this.mWebServerSubsystem.shutdown();
    }

    public WebServerSubsystem getWebServerSubsystem() {
        return this.mWebServerSubsystem;
    }

    public UIContextServices getUIContextServices() {
        return this.mUIContextServices;
    }

    public DifferenceDBInterface getDifferenceDBInterface() {
        return this.mDiffDB;
    }

    public DifferenceInterface getDifferenceInterface() {
        return this.mDiffEngine;
    }

    public NotificationRPCInterface getNotificationInterface() {
        return this.mNotificationManager;
    }

    public UserManager getUserManager() {
        return this.mUserManager;
    }

    public GroupManager getUserGroupManager() {
        return this.mGroupManager;
    }

    public PermissionManager getUserPermissionManager() {
        return this.mPermissionManager;
    }

    public SessionManager getUserSessionManager() {
        return this.mSessionManager;
    }

    public RuleMetaDataManager getRuleMetaDataManager() {
        return this.mRuleMetaDataManager;
    }

    public TransportServices getTransportServices() {
        return this.mTransportServices;
    }

    public VariableSettingsManager getVariableSettingsManager() {
        return this.mVariableSettingsManager;
    }

    public InstallDBManager getInstallDBManager() {
        return this.mInstallDBManager;
    }

    public NodeManagementServices getNodeManagementServices() {
        return this.mNodeManagementServices;
    }

    public NodeAdminSubsystem getNodeAdminSubsystem() {
        return this.mNodeAdminSubsystem;
    }

    public PlanInterface getPlanInterface() {
        return this.getPlanSubsystem();
    }

    public String getRoxVersionString() {
        return this.getVersionString();
    }

    public static void main(String[] args) {
        try {
            ServerWebUIApplication mApp = new ServerWebUIApplication(args);
            mApp.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public HashSet getCompatibleVersions() {
        HashSet supportedVersionSet = super.getCompatibleVersions();
        supportedVersionSet.add(AVALON_VERSION);
        return supportedVersionSet;
    }
}

