/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ApplicationSubsystem;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.RaplixShutdownException;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.config.ConfigGenSubsystem;
import com.raplix.rolloutexpress.difference.DifferenceEngine;
import com.raplix.rolloutexpress.difference.DifferenceInterface;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceDB;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceDBAgentInterface;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceDBInterface;
import com.raplix.rolloutexpress.event.NotificationManager;
import com.raplix.rolloutexpress.event.ROXSystemEvent;
import com.raplix.rolloutexpress.executor.PlanSubsystem;
import com.raplix.rolloutexpress.hierarchies.HierarchyBrowserSubsystem;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.node.NodeAdminSubsystem;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteUserDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBSubsystem;
import com.raplix.util.filecache.FileCache;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.net.InetAddress;
import java.util.Hashtable;

public class Server
extends Application {
    protected ApplicationSubsystem mApplicationSubsystem;
    protected NotificationManager mNotificationManager;
    protected NetSubsystem mNetworkSubsystem;
    protected HostDBSubsystem mHostDBSubsystem;
    protected PersistenceManager mPM = new PersistenceManager(this);
    protected PlanSubsystem mPE;
    protected DifferenceEngine mDiffEngine;
    protected DifferenceDB mDiffDB;
    protected ResourceSubsystem mResourceSubsystem;
    protected UserDBSubsystem mUserDB;
    protected ConfigGenSubsystem mConfigGenSubsystem;
    protected InstallDBSubsystem mInstallDBSubsystem;
    protected HierarchyBrowserSubsystem mHierarchyBrowserSubsystem;
    protected NodeAdminSubsystem mNodeAdminSubsystem;
    protected PluginDBSubsystem mPluginDBSubsystem;
    private static Application sServer = null;
    private FileCache mFileCache;

    public static void main(String[] args) {
        try {
            Server theServer = new Server(args);
            theServer.start();
        }
        catch (ConfigurationException iae) {
            System.err.println("Configuration error: " + iae.getMessage());
        }
        catch (IllegalArgumentException iae) {
            System.err.println(iae.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String getUsageString() {
        return "RolloutExpress Server (version " + this.getVersionString() + ")\n\n" + super.getUsageString();
    }

    protected String getVersionString() {
        return "5.2.1";
    }

    public Server(String[] inCommandLineArgs) throws ConfigurationException {
        this(inCommandLineArgs, true);
    }

    protected Server(String[] inCommandLineArgs, boolean runPostInit) throws ConfigurationException {
        super(inCommandLineArgs);
        this.registerSignalHandlers();
        this.mHierarchyBrowserSubsystem = new HierarchyBrowserSubsystem(this);
        this.mInstallDBSubsystem = new InstallDBSubsystem(this);
        this.mNetworkSubsystem = this.createNetSubsystem();
        this.mHostDBSubsystem = new HostDBSubsystem(this);
        this.mNotificationManager = new NotificationManager((Application)this, true);
        this.mUserDB = this.createUserDB();
        this.mConfigGenSubsystem = new ConfigGenSubsystem(this);
        this.mResourceSubsystem = new ResourceSubsystem(this);
        this.mDiffDB = new DifferenceDB(this);
        this.mPE = this.createPlanSubsystem();
        this.mDiffEngine = new DifferenceEngine(this);
        this.mApplicationSubsystem = new ApplicationSubsystem(this);
        this.mNodeAdminSubsystem = new NodeAdminSubsystem(this);
        this.mPluginDBSubsystem = new PluginDBSubsystem(this);
        RPCManager theRPC = this.mNetworkSubsystem.getRPC();
        try {
            this.mPM.registerRPCInterfaces(theRPC);
            this.mHierarchyBrowserSubsystem.registerRPCInterfaces(theRPC);
            this.mInstallDBSubsystem.registerRPCInterfaces(theRPC);
            this.mPE.registerRPCInterfaces(theRPC);
            this.mNetworkSubsystem.registerRPCInterfaces(theRPC);
            this.mUserDB.registerRPCInterfaces(theRPC);
            this.mConfigGenSubsystem.registerRPCInterfaces(theRPC);
            theRPC.registerService(DifferenceInterface.class, this.mDiffEngine);
            theRPC.registerService(DifferenceDBInterface.class, this.mDiffDB);
            theRPC.registerService(DifferenceDBAgentInterface.class, this.mDiffDB);
            this.mResourceSubsystem.registerRPCInterfaces(theRPC);
            this.mApplicationSubsystem.registerRPCInterfaces(theRPC);
            this.mNodeAdminSubsystem.registerRPCInterfaces(theRPC);
        }
        catch (RPCException rpce) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Encountered an exception while registering subsystem with RPC manager", rpce, this);
            }
            throw new ConfigurationException("Unable to register subystem with RPC manager", (Throwable)rpce);
        }
        sServer = this;
        this.mFileCache = new FileCache(new File(this.getDataDirAbsPath(), "serverFileCache"), null, "ejfc", ".jar");
        if (runPostInit) {
            this.postInit();
        }
    }

    protected void postInit() throws ConfigurationException {
        block2: {
            this.mPluginDBSubsystem.postInit();
            this.mPM.postInit();
            this.mHostDBSubsystem.postInit();
            this.mNetworkSubsystem.postInit();
            try {
                this.mNotificationManager.notifyAndWait(ROXSystemEvent.nodeStart(InetAddress.getLocalHost(), Server.getSubclassName(this.getClass())));
            }
            catch (Exception e) {
                if (!Logger.isWarnEnabled(this)) break block2;
                Logger.warn(ROXMessageManager.messageAsString("app.CANT_SEND_EVENT", new Object[]{e}), this);
            }
        }
    }

    protected void shutdown() throws RaplixShutdownException {
        block89: {
            block88: {
                block87: {
                    block86: {
                        block85: {
                            block84: {
                                block83: {
                                    block82: {
                                        block81: {
                                            block80: {
                                                block79: {
                                                    block78: {
                                                        block77: {
                                                            block76: {
                                                                block75: {
                                                                    block74: {
                                                                        block73: {
                                                                            block72: {
                                                                                block71: {
                                                                                    block70: {
                                                                                        block69: {
                                                                                            block68: {
                                                                                                block67: {
                                                                                                    block66: {
                                                                                                        block65: {
                                                                                                            block64: {
                                                                                                                block63: {
                                                                                                                    block62: {
                                                                                                                        block61: {
                                                                                                                            block60: {
                                                                                                                                try {
                                                                                                                                    this.mNotificationManager.notifyAndWait(ROXSystemEvent.nodeStop(InetAddress.getLocalHost(), Server.getSubclassName(this.getClass())));
                                                                                                                                }
                                                                                                                                catch (Exception e) {
                                                                                                                                    if (!Logger.isWarnEnabled(this)) break block60;
                                                                                                                                    Logger.warn(ROXMessageManager.messageAsString("app.CANT_SEND_EVENT", new Object[]{e}), this);
                                                                                                                                }
                                                                                                                            }
                                                                                                                            try {
                                                                                                                                this.mPluginDBSubsystem.prepareForShutdown();
                                                                                                                            }
                                                                                                                            catch (RaplixShutdownException rse) {
                                                                                                                                if (this.mShutdownRequestIsEmergency) break block61;
                                                                                                                                throw new RaplixShutdownException("Cannot shutdown: plugindb subsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                                                                                                            }
                                                                                                                        }
                                                                                                                        try {
                                                                                                                            this.mNodeAdminSubsystem.prepareForShutdown();
                                                                                                                        }
                                                                                                                        catch (RaplixShutdownException rse) {
                                                                                                                            if (this.mShutdownRequestIsEmergency) break block62;
                                                                                                                            throw new RaplixShutdownException("Cannot shutdown: NodeAdminSubsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                                                                                                        }
                                                                                                                    }
                                                                                                                    try {
                                                                                                                        this.mHierarchyBrowserSubsystem.prepareForShutdown();
                                                                                                                    }
                                                                                                                    catch (RaplixShutdownException rse) {
                                                                                                                        if (this.mShutdownRequestIsEmergency) break block63;
                                                                                                                        throw new RaplixShutdownException("Cannot shutdown: HierarchyBrowserSubsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                                                                                                    }
                                                                                                                }
                                                                                                                try {
                                                                                                                    this.mApplicationSubsystem.prepareForShutdown();
                                                                                                                }
                                                                                                                catch (RaplixShutdownException rse) {
                                                                                                                    if (this.mShutdownRequestIsEmergency) break block64;
                                                                                                                    throw new RaplixShutdownException("Cannot shutdown: Application subsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                                                                                                }
                                                                                                            }
                                                                                                            try {
                                                                                                                this.mDiffEngine.prepareForShutdown();
                                                                                                            }
                                                                                                            catch (RaplixShutdownException rse) {
                                                                                                                if (this.mShutdownRequestIsEmergency) break block65;
                                                                                                                throw new RaplixShutdownException("Cannot shutdown: diffEngine subsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                                                                                            }
                                                                                                        }
                                                                                                        try {
                                                                                                            this.mPE.prepareForShutdown();
                                                                                                        }
                                                                                                        catch (RaplixShutdownException rse) {
                                                                                                            if (this.mShutdownRequestIsEmergency) break block66;
                                                                                                            throw new RaplixShutdownException("Cannot shutdown: PlanExecutor subsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                                                                                        }
                                                                                                    }
                                                                                                    try {
                                                                                                        this.mDiffDB.prepareForShutdown();
                                                                                                    }
                                                                                                    catch (RaplixShutdownException rse) {
                                                                                                        if (this.mShutdownRequestIsEmergency) break block67;
                                                                                                        throw new RaplixShutdownException("Cannot shutdown: diffDB subsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                                                                                    }
                                                                                                }
                                                                                                try {
                                                                                                    this.mResourceSubsystem.prepareForShutdown();
                                                                                                }
                                                                                                catch (RaplixShutdownException rse) {
                                                                                                    if (this.mShutdownRequestIsEmergency) break block68;
                                                                                                    throw new RaplixShutdownException("Cannot shutdown: Resource subsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                                                                                }
                                                                                            }
                                                                                            try {
                                                                                                this.mConfigGenSubsystem.prepareForShutdown();
                                                                                            }
                                                                                            catch (RaplixShutdownException rse) {
                                                                                                if (this.mShutdownRequestIsEmergency) break block69;
                                                                                                throw new RaplixShutdownException("Cannot shutdown: config gen subsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                                                                            }
                                                                                        }
                                                                                        try {
                                                                                            this.mUserDB.prepareForShutdown();
                                                                                        }
                                                                                        catch (RaplixShutdownException rse) {
                                                                                            if (this.mShutdownRequestIsEmergency) break block70;
                                                                                            throw new RaplixShutdownException("Cannot shutdown: userDB subsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                                                                        }
                                                                                    }
                                                                                    try {
                                                                                        this.mNotificationManager.prepareForShutdown();
                                                                                    }
                                                                                    catch (RaplixShutdownException rse) {
                                                                                        if (this.mShutdownRequestIsEmergency) break block71;
                                                                                        throw new RaplixShutdownException("Cannot shutdown: notification manager cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                                                                    }
                                                                                }
                                                                                try {
                                                                                    this.mHostDBSubsystem.prepareForShutdown();
                                                                                }
                                                                                catch (RaplixShutdownException rse) {
                                                                                    if (this.mShutdownRequestIsEmergency) break block72;
                                                                                    throw new RaplixShutdownException("Cannot shutdown: hostDB subsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                                                                }
                                                                            }
                                                                            try {
                                                                                this.mNetworkSubsystem.prepareForShutdown();
                                                                            }
                                                                            catch (RaplixShutdownException rse) {
                                                                                if (this.mShutdownRequestIsEmergency) break block73;
                                                                                throw new RaplixShutdownException("Cannot shutdown: network subsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                                                            }
                                                                        }
                                                                        try {
                                                                            this.mInstallDBSubsystem.prepareForShutdown();
                                                                        }
                                                                        catch (RaplixShutdownException rse) {
                                                                            if (this.mShutdownRequestIsEmergency) break block74;
                                                                            throw new RaplixShutdownException("Cannot shutdown: installdb subsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                                                        }
                                                                    }
                                                                    try {
                                                                        this.mPM.prepareForShutdown();
                                                                    }
                                                                    catch (RaplixShutdownException rse) {
                                                                        if (this.mShutdownRequestIsEmergency) break block75;
                                                                        throw new RaplixShutdownException("Cannot shutdown: PersistenceManager subsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                                                    }
                                                                }
                                                                try {
                                                                    this.mPluginDBSubsystem.shutdown();
                                                                }
                                                                catch (RaplixShutdownException rse) {
                                                                    if (this.mShutdownRequestIsEmergency) break block76;
                                                                    throw new RaplixShutdownException("Cannot shutdown: plugindb subsystem cannot shutdown.  Specific error: " + rse.getMessage());
                                                                }
                                                            }
                                                            try {
                                                                this.mNodeAdminSubsystem.shutdown();
                                                            }
                                                            catch (RaplixShutdownException rse) {
                                                                if (this.mShutdownRequestIsEmergency) break block77;
                                                                throw new RaplixShutdownException("Cannot shutdown: NodeAdmin subsystem cannot shutdown.  Specific error: " + rse.getMessage());
                                                            }
                                                        }
                                                        try {
                                                            this.mHierarchyBrowserSubsystem.shutdown();
                                                        }
                                                        catch (RaplixShutdownException rse) {
                                                            if (this.mShutdownRequestIsEmergency) break block78;
                                                            throw new RaplixShutdownException("Cannot shutdown: HierarchyBrowserManager subsystem cannot shutdown.  Specific error: " + rse.getMessage());
                                                        }
                                                    }
                                                    try {
                                                        this.mApplicationSubsystem.shutdown();
                                                    }
                                                    catch (RaplixShutdownException rse) {
                                                        if (this.mShutdownRequestIsEmergency) break block79;
                                                        throw new RaplixShutdownException("Cannot shutdown: Application subsystem cannot shutdown.  Specific error: " + rse.getMessage());
                                                    }
                                                }
                                                try {
                                                    this.mDiffEngine.shutdown();
                                                }
                                                catch (RaplixShutdownException rse) {
                                                    if (this.mShutdownRequestIsEmergency) break block80;
                                                    throw new RaplixShutdownException("Cannot shutdown: diffEngine subsystem cannot shutdown.  Specific error: " + rse.getMessage());
                                                }
                                            }
                                            try {
                                                this.mPE.shutdown();
                                            }
                                            catch (RaplixShutdownException rse) {
                                                if (this.mShutdownRequestIsEmergency) break block81;
                                                throw new RaplixShutdownException("Cannot shutdown: PlanExecutor subsystem cannot shutdown.  Specific error: " + rse.getMessage());
                                            }
                                        }
                                        try {
                                            this.mDiffDB.shutdown();
                                        }
                                        catch (RaplixShutdownException rse) {
                                            if (this.mShutdownRequestIsEmergency) break block82;
                                            throw new RaplixShutdownException("Cannot shutdown: diffDB subsystem cannot shutdown.  Specific error: " + rse.getMessage());
                                        }
                                    }
                                    try {
                                        this.mResourceSubsystem.shutdown();
                                    }
                                    catch (RaplixShutdownException rse) {
                                        if (this.mShutdownRequestIsEmergency) break block83;
                                        throw new RaplixShutdownException("Cannot shutdown: Resource subsystem cannot shutdown.  Specific error: " + rse.getMessage());
                                    }
                                }
                                try {
                                    this.mConfigGenSubsystem.shutdown();
                                }
                                catch (RaplixShutdownException rse) {
                                    if (this.mShutdownRequestIsEmergency) break block84;
                                    throw new RaplixShutdownException("Cannot shutdown: config gen subsystem cannot shutdown.  Specific error: " + rse.getMessage());
                                }
                            }
                            this.mUserDB.shutdown();
                            try {
                                this.mNotificationManager.shutdown();
                            }
                            catch (RaplixShutdownException rse) {
                                if (this.mShutdownRequestIsEmergency) break block85;
                                throw new RaplixShutdownException("Cannot shutdown: notification manager cannot shutdown.  Specific error: " + rse.getMessage());
                            }
                        }
                        try {
                            this.mHostDBSubsystem.shutdown();
                        }
                        catch (RaplixShutdownException rse) {
                            if (this.mShutdownRequestIsEmergency) break block86;
                            throw new RaplixShutdownException("Cannot shutdown: hostDB subsystem cannot shutdown.  Specific error: " + rse.getMessage());
                        }
                    }
                    try {
                        this.mNetworkSubsystem.shutdown();
                    }
                    catch (RaplixShutdownException rse) {
                        if (this.mShutdownRequestIsEmergency) break block87;
                        throw new RaplixShutdownException("Cannot shutdown: network subsystem cannot shutdown.  Specific error: " + rse.getMessage());
                    }
                }
                try {
                    this.mInstallDBSubsystem.shutdown();
                }
                catch (RaplixShutdownException rse) {
                    if (this.mShutdownRequestIsEmergency) break block88;
                    throw new RaplixShutdownException("Cannot shutdown: installdb subsystem cannot shutdown.  Specific error: " + rse.getMessage());
                }
            }
            try {
                this.mPM.shutdown();
            }
            catch (RaplixShutdownException rse) {
                if (this.mShutdownRequestIsEmergency) break block89;
                throw new RaplixShutdownException("Cannot shutdown: PersistenceManager subsystem cannot shutdown.  Specific error: " + rse.getMessage());
            }
        }
    }

    public void immediateShutdown() throws RaplixShutdownException {
        this.shutdown();
    }

    protected void buildConfigurationFilesForSubsystems(Hashtable inTable) throws ConfigurationException {
        Subsystem.addConfigurationForSubsystem(inTable, NotificationManager.class);
        Subsystem.addConfigurationForSubsystem(inTable, NetSubsystem.class);
        Subsystem.addConfigurationForSubsystem(inTable, UserDBSubsystem.class);
        Subsystem.addConfigurationForSubsystem(inTable, HostDBSubsystem.class);
        Subsystem.addConfigurationForSubsystem(inTable, ConfigGenSubsystem.class);
        Subsystem.addConfigurationForSubsystem(inTable, PersistenceManager.class);
        Subsystem.addConfigurationForSubsystem(inTable, InstallDBSubsystem.class);
        Subsystem.addConfigurationForSubsystem(inTable, DifferenceEngine.class);
        Subsystem.addConfigurationForSubsystem(inTable, DifferenceDB.class);
        Subsystem.addConfigurationForSubsystem(inTable, PlanSubsystem.class);
        Subsystem.addConfigurationForSubsystem(inTable, ResourceSubsystem.class);
        Subsystem.addConfigurationForSubsystem(inTable, ApplicationSubsystem.class);
        Subsystem.addConfigurationForSubsystem(inTable, HierarchyBrowserSubsystem.class);
        Subsystem.addConfigurationForSubsystem(inTable, NodeAdminSubsystem.class);
        Subsystem.addConfigurationForSubsystem(inTable, PluginDBSubsystem.class);
    }

    protected UserDBSubsystem createUserDB() throws ConfigurationException {
        return new UserDBSubsystem(this);
    }

    protected NetSubsystem createNetSubsystem() throws ConfigurationException {
        return NetSubsystem.createNetSubsystemForMS(this);
    }

    protected PlanSubsystem createPlanSubsystem() throws ConfigurationException {
        return new PlanSubsystem(this);
    }

    public NotificationManager getNotificationManager() {
        return this.mNotificationManager;
    }

    public NetSubsystem getNetSubsystem() {
        return this.mNetworkSubsystem;
    }

    public HostDBSubsystem getHostDBSubsystem() {
        return this.mHostDBSubsystem;
    }

    public PersistenceManager getPMSubsystem() {
        return this.mPM;
    }

    public PlanSubsystem getPlanSubsystem() {
        return this.mPE;
    }

    public DifferenceEngine getDiffEngineSubsystem() {
        return this.mDiffEngine;
    }

    public ResourceSubsystem getResourceSubsystem() {
        return this.mResourceSubsystem;
    }

    public DifferenceDB getDiffDBSubsystem() {
        return this.mDiffDB;
    }

    public UserDBSubsystem getUserDBSubsystem() {
        return this.mUserDB;
    }

    public RemoteUserDBSubsystem getRemoteUserDBSubsystem() {
        return this.mUserDB;
    }

    public ConfigGenSubsystem getConfigGenSubsystem() {
        return this.mConfigGenSubsystem;
    }

    public InstallDBSubsystem getInstallDBSubsystem() {
        return this.mInstallDBSubsystem;
    }

    public NodeAdminSubsystem getNodeAdminSubsystem() throws UnsupportedSubsystemException {
        return this.mNodeAdminSubsystem;
    }

    public PluginDBSubsystem getPluginDBSubsystem() {
        return this.mPluginDBSubsystem;
    }

    public FileCache getFileCache() {
        return this.mFileCache;
    }

    public static Application getApp() {
        return sServer;
    }
}

