/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.util.logger.Logger;
import com.raplix.util.platform.posix.SignalHandler;

public class RoxShutdownHook
implements SignalHandler {
    protected static final String MSG_WAITINGFORSHUTDOWN = "app.WAITINGFORSHUTDOWN";
    protected static final String MSG_EXCEPTIONIGNORED = "app.EXCEPTIONIGNORED";
    protected Application mApplication;

    public RoxShutdownHook(Application inApplication) {
        this.mApplication = inApplication;
    }

    public void handle(long s) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Shutdown hook activated (" + s + ")", this);
        }
        if (this.mApplication.isShutdownRequested()) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Shutdown sequence has already begun", this);
            }
        } else {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Shutdown sequence has not yet begun", this);
            }
            this.mApplication.forceEmergencyShutdown();
            while (this.mApplication.isAlive() && !this.mApplication.forceExit()) {
                System.out.println(ROXMessageManager.messageAsString(MSG_WAITINGFORSHUTDOWN));
                if (Logger.isInfoEnabled(this)) {
                    Logger.info(ROXMessageManager.messageAsString(MSG_WAITINGFORSHUTDOWN), this);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    if (!Logger.isErrorEnabled(this)) continue;
                    Logger.error(MSG_EXCEPTIONIGNORED, ie, this);
                }
            }
        }
    }
}

