/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress;

import [Ljava.lang.String;;
import com.raplix.rolloutexpress.RaplixTest;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.AcquireReadLockTransaction;
import com.raplix.rolloutexpress.persist.AcquireWriteLockTransaction;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.TransactionManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.exception.RollbackTransactionException;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.RsrcManifest;
import com.raplix.rolloutexpress.resource.util.ResourceFileUtils;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.file.Find;
import com.raplix.util.file.RecursiveChmod;
import com.raplix.util.file.Visitor;
import com.raplix.util.junit.ConstrainedTestSuite;
import com.raplix.util.logger.Logger;
import com.raplix.util.platform.common.PlatformUtil;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import junit.framework.Protectable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

public class RaplixTestSuite
extends ConstrainedTestSuite {
    public static final int TRANSACTION_MODE_NONE = 0;
    public static final int TRANSACTION_MODE_PER_TEST = 1;
    public static final int READ_TRANSACTION_MODE_PER_TEST = 2;
    public static final int WRITE_TRANSACTION_MODE_PER_TEST = 3;
    protected int mTransactionMode = 0;
    private boolean mSysResourcesExistOnStartup;
    private HashMap mTestTxModes = new HashMap();

    public RaplixTestSuite() {
        this.init();
    }

    public RaplixTestSuite(Class theClass) {
        super(theClass);
        this.init();
    }

    public RaplixTestSuite(String name) {
        super(name);
        this.init();
    }

    public void setUp() throws Exception {
        this.mSysResourcesExistOnStartup = this.systemResourcesExist();
        this.deleteDataDir(false);
    }

    boolean systemResourcesExist() throws Exception {
        File theTopLevelDataDir = new File(RaplixTest.getTopLevelDataDir());
        File theRsrcMgrDir = new File(theTopLevelDataDir, "rsrcMgr");
        File theSuvaRsrcsDir = new File(theRsrcMgrDir, RsrcManifest.getSuvaRsrcDirName((Object)this));
        File[] theSysRsrcDirs = RsrcManifest.forTestOnly_ListSysRsrcDirs(theSuvaRsrcsDir);
        boolean exist = theSysRsrcDirs.length > 0;
        return exist;
    }

    public void resetResources() throws Exception {
        this.deleteDataDir(true);
    }

    protected static void deleteDirExcept(File root, File[] excludes) {
        final HashSet<File> excludesSet = new HashSet<File>();
        final HashSet<File> parentSet = new HashSet<File>();
        for (int i = 0; i < excludes.length; ++i) {
            File exclude = excludes[i];
            if (!exclude.exists()) continue;
            excludesSet.add(exclude);
            while ((exclude = exclude.getParentFile()) != null && parentSet.add(exclude) && !exclude.equals(root)) {
            }
        }
        Find.find(root, true, new Visitor(){

            public boolean shouldPrune(File file, int depth) {
                if (excludesSet.contains(file)) {
                    return true;
                }
                if (PlatformUtil.isPOSIX()) {
                    RecursiveChmod.change(file.getAbsolutePath(), 511L, false);
                }
                return false;
            }

            public void visit(File file, int depth) {
                if (!parentSet.contains(file)) {
                    try {
                        ResourceFileUtils.deleteDirectory(file);
                    }
                    catch (ResourceException e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            public void cannotRecurse(File file, int depth) {
                Logger.error("Error while cleaning up data dir.  Unable to recurse into dir: " + file, this);
            }
        });
    }

    public void deleteDataDir(boolean deleteOnlyRsrcMgr) throws Exception {
        File theTopLevelDataDir = new File(RaplixTest.getTopLevelDataDir());
        File theRsrcMgrDir = new File(theTopLevelDataDir, "rsrcMgr");
        File theSuvaRsrcsDir = new File(theRsrcMgrDir, RsrcManifest.getSuvaRsrcDirName((Object)this));
        Vector<File> theExcludesVec = new Vector<File>();
        theExcludesVec.add(new File(theTopLevelDataDir, "plugins"));
        theExcludesVec.add(new File(theTopLevelDataDir, "CVS"));
        File[] theSysRsrcDirs = RsrcManifest.forTestOnly_ListSysRsrcDirs(theSuvaRsrcsDir);
        for (int i = 0; i < theSysRsrcDirs.length; ++i) {
            theExcludesVec.add(theSysRsrcDirs[i]);
        }
        File[] excludes = theExcludesVec.toArray(new File[0]);
        RaplixTestSuite.deleteDirExcept(deleteOnlyRsrcMgr ? theRsrcMgrDir : theTopLevelDataDir, excludes);
    }

    public void tearDown() throws Exception {
        boolean systemDirExistsOnTearDown = this.systemResourcesExist();
        if (this.mSysResourcesExistOnStartup) {
            if (!systemDirExistsOnTearDown) {
                System.out.println("ERROR All system resources removed during test");
            } else {
                System.out.println("GOOD At least some system resources preserved during test");
            }
        } else {
            System.out.println("INFO System resources not present during test run");
        }
    }

    private void superRun(TestResult result) {
        super.run(result);
    }

    public void run(final TestResult result) {
        result.runProtected((Test)this, new Protectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void protect() throws Throwable {
                RaplixTestSuite.this.setUp();
                try {
                    RaplixTestSuite.this.superRun(result);
                }
                finally {
                    RaplixTestSuite.this.tearDown();
                }
            }
        });
    }

    private void init() {
    }

    public void runTest(final Test test, final TestResult result) {
        switch (this.getTransactionMode(test)) {
            case 1: {
                TransactionManager theTM = PersistenceManager.getInstance().getTransactionManager();
                try {
                    theTM.transact(new Transaction(){

                        public Object execute() throws PersistenceManagerException {
                            RaplixTestSuite.this.superRunTest(test, result);
                            throw new RollbackTransactionException();
                        }
                    });
                }
                catch (PersistenceManagerException e) {
                    Logger.error("Unexpected Exception caught in Test Run", e, (Object)this);
                }
                break;
            }
            case 2: {
                TransactionManager theTM = PersistenceManager.getInstance().getTransactionManager();
                try {
                    theTM.transact(new AcquireReadLockTransaction(){

                        public Object execute() throws PersistenceManagerException {
                            RaplixTestSuite.this.superRunTest(test, result);
                            throw new RollbackTransactionException();
                        }

                        public ROXMessage getLockDescription() {
                            return new ROXMessage("Running Unit Test");
                        }
                    });
                }
                catch (PersistenceManagerException e) {
                    Logger.error("Unexpected Exception caught in Test Run", e, (Object)this);
                }
                break;
            }
            case 3: {
                TransactionManager theTM = PersistenceManager.getInstance().getTransactionManager();
                try {
                    theTM.transact(new AcquireWriteLockTransaction(){

                        public Object execute() throws PersistenceManagerException {
                            RaplixTestSuite.this.superRunTest(test, result);
                            throw new RollbackTransactionException();
                        }

                        public ROXMessage getLockDescription() {
                            return new ROXMessage("Running Unit Test");
                        }
                    });
                }
                catch (PersistenceManagerException e) {
                    Logger.error("Unexpected Exception caught in Test Run", e, (Object)this);
                }
                break;
            }
            default: {
                this.superRunTest(test, result);
            }
        }
    }

    private void superRunTest(Test test, TestResult result) {
        super.runTest(test, result);
    }

    public int getTransactionMode() {
        return this.mTransactionMode;
    }

    public void setTransactionMode(int inTransactionMode) {
        this.mTransactionMode = inTransactionMode;
    }

    public int getTransactionMode(Test test) {
        Integer mode;
        if (test instanceof TestCase && (mode = (Integer)this.mTestTxModes.get(((TestCase)test).getName())) != null) {
            return mode;
        }
        return this.getTransactionMode();
    }

    public void setTransactionMode(String inTestName, int inTransactionMode) {
        this.mTestTxModes.put(inTestName, new Integer(inTransactionMode));
    }

    private static void addArg(Vector inArgs, String inPropertyName, String inROXArgName) {
        String argValue = System.getProperty(inPropertyName);
        if (argValue != null && !argValue.equals("")) {
            inArgs.add(new String("-D" + inROXArgName + "=" + argValue));
        }
    }

    public static String[] getDefaultServerArgsAsStringArray() {
        Vector theArgs = RaplixTestSuite.getDefaultServerArgsAsVector();
        String[] stringArray = (String[])CollectionUtil.mapClass(theArgs.toArray(), String;.class);
        return stringArray;
    }

    public static String[] getDefaultAgentArgsAsStringArray(int inAgentNum) {
        return new String[]{"-Drox_data_dir=" + System.getProperty("rox_data_dir") + File.separator + "testAgent" + inAgentNum};
    }

    public static Vector getDefaultServerArgsAsVector() {
        Vector theArgs = new Vector();
        RaplixTestSuite.addArg(theArgs, "db.instancename", "db.instancename");
        RaplixTestSuite.addArg(theArgs, "db.hostname", "db.hostname");
        RaplixTestSuite.addArg(theArgs, "hostdb.User", "hostdb.User");
        return theArgs;
    }

    public static String[] addDefaultServerArgs(String[] inArgs) {
        Vector theArgs = RaplixTestSuite.getDefaultServerArgsAsVector();
        theArgs.addAll(Arrays.asList(inArgs));
        String[] stringArray = (String[])CollectionUtil.mapClass(theArgs.toArray(), String;.class);
        return stringArray;
    }
}

