/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.ConfigurationFile;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.resource.util.ResourceFileUtils;
import com.raplix.util.file.RecursiveChmod;
import com.raplix.util.junit.TestBase;
import com.raplix.util.logger.Logger;
import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.threads.SafeThread;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;

public abstract class RaplixTest
extends TestBase {
    public static final String TEST_CONFIG_FILE = "config" + File.separator + "testconfig.properties";
    private static final String TEST_REFERENCE_DIR_PATH = "test_reference_dir_path";
    protected static final String FILE_INFO_LONG = "file_info_long";
    private static final String TEST_REFERENCE_FILE_PATH = "test_reference_file_path";
    private static SSHInputStreamReader sSSHReader = null;
    private ConfigurationFile mConfigurationFile = null;
    private String mTestReferenceDirPath = null;
    private String mTestReferenceFilePath = null;
    private String mUserRunner;
    private static int DEFAULT_MS_PORT;
    private static int sMSPort;
    private static String sDataDir;
    public static final ExceptionVerifier NO_FAILURE;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$RaplixTest$ExceptionVerifier;

    public RaplixTest(String name) {
        super(name);
        if (!PlatformUtil.isWin32() && sSSHReader == null) {
            sSSHReader = new SSHInputStreamReader(System.in);
            sSSHReader.setDaemon(true);
            sSSHReader.start();
        }
        try {
            this.mConfigurationFile = new ConfigurationFile(TEST_CONFIG_FILE);
        }
        catch (ConfigurationException e) {
            RaplixTest.fail((String)e.getMessage());
        }
        this.mUserRunner = System.getProperty("user.name");
        Logger.initializeLoggingSystem();
        this.setOSTypeTestReferencePaths();
    }

    private void setOSTypeTestReferencePaths() {
        if (!(PlatformUtil.isWin32() || PlatformUtil.isLinux() || PlatformUtil.isSolaris() || PlatformUtil.isAix() || PlatformUtil.isHpux())) {
            throw new IllegalArgumentException("Unknown OS: " + PlatformUtil.OS_NAME);
        }
        this.mTestReferenceDirPath = this.getConfig(TEST_REFERENCE_DIR_PATH);
        this.mTestReferenceFilePath = this.mTestReferenceDirPath + this.getConfig(TEST_REFERENCE_FILE_PATH);
    }

    public String getTestReferenceFilePath() {
        return this.mTestReferenceFilePath;
    }

    public String getTestReferenceDirPath() {
        return this.mTestReferenceDirPath;
    }

    public String getConfig(String inKey) {
        return this.mConfigurationFile.getPlatformConfig(inKey);
    }

    public String getTestReferenceFileSpec() {
        return this.getConfig(FILE_INFO_LONG);
    }

    public static boolean isSolaris() {
        return PlatformUtil.isSolaris();
    }

    public static boolean isAix() {
        return PlatformUtil.isAix();
    }

    public static boolean isHpux() {
        return PlatformUtil.isHpux();
    }

    public static boolean isLinux() {
        return PlatformUtil.isLinux();
    }

    public static boolean isLinux64() {
        return PlatformUtil.isLinux64();
    }

    public static boolean isUnix() {
        return PlatformUtil.isUnix();
    }

    public static boolean isPOSIX() {
        return PlatformUtil.isPOSIX();
    }

    public static boolean isPureWin32() {
        return PlatformUtil.isPureWin32();
    }

    public String getUserName() {
        return this.mUserRunner;
    }

    public static Test suite() {
        return new TestSuite();
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static int getMSPort() {
        if (sMSPort == DEFAULT_MS_PORT) {
            String thePortString = "";
            try {
                ConfigurationFile theConfigFile = new ConfigurationFile(TEST_CONFIG_FILE);
                thePortString = theConfigFile.get("port." + System.getProperty("user.name"));
                sMSPort = Integer.parseInt(thePortString) + 24 * RaplixTest.getInstanceNum();
            }
            catch (Exception e) {
                System.err.println("WARNING - Could Not Read Port Assignment for User: " + System.getProperty("user.name") + " using default: " + sMSPort);
            }
        }
        return sMSPort;
    }

    public static int getInstanceNum() {
        String instanceNum = System.getProperty("instance_num");
        int num = 0;
        if (instanceNum != null) {
            num = Integer.parseInt(instanceNum);
        }
        return num;
    }

    public static String getTopLevelDataDir() {
        if (sDataDir == null && ((sDataDir = System.getProperty("rox_data_dir")) == null || sDataDir.equals(""))) {
            sDataDir = System.getProperty("rox_home_dir") + File.separator + "data";
        }
        return sDataDir;
    }

    public static String getHomeDir() {
        return System.getProperty("rox_home_dir");
    }

    public static void deleteDir(File directory) throws Exception {
        if (PlatformUtil.isPOSIX()) {
            RecursiveChmod.change(directory.getAbsolutePath(), 511L, true);
        }
        ResourceFileUtils.deleteDirectory(directory);
    }

    public static ROXExceptionVerifier rExp(Class exceptionType, String key) {
        return new ROXExceptionVerifier(exceptionType, key);
    }

    public static StringExceptionVerifier sExp(Class exceptionType, String substring) {
        return new StringExceptionVerifier(exceptionType, substring);
    }

    static {
        sMSPort = DEFAULT_MS_PORT = 9000;
        NO_FAILURE = new ExceptionVerifier(null, null);
    }

    public static class StringExceptionVerifier
    extends ExceptionVerifier {
        StringExceptionVerifier(Class exceptionType, String pattern) {
            super(exceptionType, pattern);
        }

        protected void assertMsg(Exception re) {
            Assert.assertTrue((String)re.toString(), (re.getMessage().indexOf(this.getPattern()) != -1 ? 1 : 0) != 0);
        }
    }

    private static class ROXExceptionVerifier
    extends ExceptionVerifier {
        ROXExceptionVerifier(Class exceptionType, String pattern) {
            super(exceptionType, pattern);
        }

        protected void assertMsg(Exception re) {
            if (re instanceof RaplixException) {
                Assert.assertEquals((String)re.toString(), (String)this.getPattern(), ((RaplixException)re).getROXMessage() == null ? null : ((RaplixException)re).getROXMessage().getKey());
            }
        }
    }

    public static abstract class TestForFailure {
        private ExceptionVerifier mVerifier;

        protected TestForFailure(ExceptionVerifier verifier) {
            this.mVerifier = verifier;
        }

        public Object test() throws Exception {
            Object obj = null;
            try {
                obj = this.execute();
                Assert.assertTrue((String)("Failure Expected:" + this.mVerifier), (!this.mVerifier.isFailureExpected() ? 1 : 0) != 0);
            }
            catch (Exception e) {
                this.mVerifier.assertException(e);
            }
            return obj;
        }

        protected abstract Object execute() throws Exception;
    }

    public static class ExceptionVerifier {
        private String mPattern;
        private Class mExpType;

        public void assertException(Exception exception) throws Exception {
            if (!this.isFailureExpected()) {
                if (Logger.isErrorEnabled(this)) {
                    Logger.error("UnexpectedFailure", exception, class$com$raplix$rolloutexpress$RaplixTest$ExceptionVerifier == null ? (class$com$raplix$rolloutexpress$RaplixTest$ExceptionVerifier = RaplixTest.class$("com.raplix.rolloutexpress.RaplixTest$ExceptionVerifier")) : class$com$raplix$rolloutexpress$RaplixTest$ExceptionVerifier);
                }
                throw exception;
            }
            if (this.mExpType != null) {
                Assert.assertEquals((String)("Exception type mismatch:" + exception), (Object)this.mExpType, exception.getClass());
            }
            if (this.getPattern() != null) {
                this.assertMsg(exception);
            }
        }

        public boolean isFailureExpected() {
            return this.mExpType != null || this.getPattern() != null;
        }

        protected void assertMsg(Exception e) {
            Assert.assertEquals((String)this.getPattern(), (String)e.getMessage());
        }

        protected ExceptionVerifier(Class exceptionType, String inPattern) {
            this.mExpType = exceptionType;
            this.mPattern = inPattern;
        }

        public String getPattern() {
            return this.mPattern;
        }

        public String toString() {
            return "Exception:" + this.mExpType + ":pattern:" + this.mPattern;
        }
    }

    private static class SSHInputStreamReader
    extends SafeThread {
        private BufferedReader reader;

        SSHInputStreamReader(InputStream is) {
            this.reader = new BufferedReader(new InputStreamReader(is));
        }

        void close() {
            try {
                this.interruptSafe();
                this.reader.close();
            }
            catch (IOException ioe) {
                System.out.println("Error closing");
            }
        }

        public void run() {
            try {
                while (this.reader.readLine() != null) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.out.println("Input Stream has been closed - exiting the application");
            System.exit(1);
        }
    }
}

