/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.message.Severity;
import com.raplix.util.Util;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;

public class RaplixException
extends Exception {
    private transient Throwable mNestedException = null;
    private ROXMessage mMessage;
    private int mWrappingMode = 1;
    private boolean mIsInterrupted = false;
    private static final String NO_MESSAGE = "The Message Subsystem was not available so the proper message cannot be displayed.";
    public static final String NESTED_HEADER = ":NestedTrace:";
    public static final int WRAPPING_MODE_OVERRIDE = 0;
    public static final int WRAPPING_MODE_PREPEND = 1;
    public static final int WRAPPING_MODE_PASS_THROUGH = 2;
    public static final char LINEBREAK_DELIMITER = '\n';
    protected static final int INVALID_MESSAGE_TYPE = -1;

    public RaplixException(ROXMessage inMessage) {
        this.mMessage = inMessage;
    }

    public RaplixException(Throwable inNestedException) {
        this(inNestedException instanceof RaplixException ? ((RaplixException)inNestedException).getROXMessage() : null, inNestedException, 2);
    }

    public RaplixException(ROXMessage inMessage, Throwable inNestedException) {
        this(inMessage, inNestedException, 1);
    }

    public RaplixException(ROXMessage inMessage, Throwable inNestedException, int inWrappingMode) {
        this.setNestedException(inNestedException);
        this.mMessage = inMessage;
        this.mWrappingMode = inWrappingMode;
    }

    protected RaplixException() {
    }

    public RaplixException(String inMessageKey) {
        super(inMessageKey);
        this.mMessage = (ROXMessage)ROXMessageManager.message(inMessageKey);
    }

    public RaplixException(String inMessageKey, Object[] inArguments) {
        super(inMessageKey);
        this.mMessage = (ROXMessage)ROXMessageManager.message(inMessageKey, inArguments);
    }

    public RaplixException(String inMessageKey, Throwable inNestedException) {
        super(inMessageKey);
        this.setNestedException(inNestedException);
        this.mMessage = (ROXMessage)ROXMessageManager.message(inMessageKey);
    }

    public RaplixException(String inMessageKey, Throwable inNestedException, Object[] inArguments) {
        super(inMessageKey);
        this.setNestedException(inNestedException);
        this.mMessage = (ROXMessage)ROXMessageManager.message(inMessageKey, inArguments);
    }

    public Throwable nestedException() {
        return this.mNestedException;
    }

    private void setNestedException(Throwable t) {
        this.mNestedException = t;
        this.setIsInterrupted(RaplixException.isInterruptedException(t));
    }

    public static boolean isInterruptedException(Throwable t) {
        return t != null && (t instanceof InterruptedException || t instanceof InterruptedIOException || t instanceof RaplixException && ((RaplixException)t).getIsInterrupted());
    }

    private void setIsInterrupted(boolean inIsInterrupted) {
        this.mIsInterrupted = inIsInterrupted;
    }

    public ROXMessage getROXMessage() {
        return this.mMessage;
    }

    public int getMessageType() {
        int outType = 3000;
        if (this.mWrappingMode == 2) {
            int nestedType = this.getNestedType();
            if (nestedType != -1) {
                outType = nestedType;
            }
        } else if (this.mMessage != null) {
            outType = this.mMessage.getMessageType();
        }
        return outType;
    }

    protected int getNestedType() {
        if (this.nestedException() != null && this.nestedException() instanceof RaplixException) {
            return ((RaplixException)this.nestedException()).getMessageType();
        }
        return -1;
    }

    public Severity getSeverity() {
        Severity severity = null;
        if (this.mWrappingMode == 2) {
            severity = this.getNestedSeverity();
            if (severity != null) {
                return severity;
            }
        } else if (this.mMessage != null) {
            return this.mMessage.getSeverity();
        }
        return Severity.ERROR;
    }

    protected Severity getNestedSeverity() {
        if (this.nestedException() != null && this.nestedException() instanceof RaplixException) {
            return ((RaplixException)this.nestedException()).getSeverity();
        }
        return null;
    }

    public String toString() {
        return this.getMessage();
    }

    public String getMessage() {
        return this.getMessage(null);
    }

    public String getMessage(Locale inLocale) {
        String outMessage = NO_MESSAGE;
        String nMessage = null;
        if (this.mWrappingMode == 1) {
            if (this.mMessage != null) {
                outMessage = this.mMessage.getMessageString(inLocale);
            }
            if ((nMessage = this.getNestedMessage()) != null) {
                if (NO_MESSAGE.equals(outMessage)) {
                    outMessage = "";
                }
                outMessage = outMessage + '\n' + (nMessage == null ? "" : nMessage);
            }
        } else if (this.mWrappingMode == 0) {
            if (this.mMessage != null) {
                outMessage = this.mMessage.getMessageString(inLocale);
            }
        } else if (this.mWrappingMode == 2 && (nMessage = this.getNestedMessage()) != null) {
            outMessage = nMessage == null ? "" : nMessage;
        }
        return outMessage;
    }

    protected String getNestedMessage() {
        if (this.nestedException() == null) {
            return null;
        }
        return this.nestedException().getMessage();
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream ps) {
        if (this.mWrappingMode == 1) {
            super.printStackTrace(ps);
            ps.println(NESTED_HEADER);
            if (this.nestedException() != null) {
                this.nestedException().printStackTrace(ps);
            }
        } else if (this.mWrappingMode == 0) {
            super.printStackTrace(ps);
        } else if (this.mWrappingMode == 2 && this.nestedException() != null) {
            this.nestedException().printStackTrace(ps);
        }
    }

    public void printStackTrace(PrintWriter pw) {
        if (this.mWrappingMode == 1) {
            super.printStackTrace(pw);
            pw.println(NESTED_HEADER);
            if (this.nestedException() != null) {
                this.nestedException().printStackTrace(pw);
            }
        } else if (this.mWrappingMode == 0) {
            super.printStackTrace(pw);
        } else if (this.mWrappingMode == 2 && this.nestedException() != null) {
            this.nestedException().printStackTrace(pw);
        }
    }

    public String getTopLevelStackTrace() {
        StringWriter strWriter = new StringWriter(512);
        PrintWriter writer = new PrintWriter(strWriter);
        super.printStackTrace(writer);
        writer.flush();
        strWriter.flush();
        return strWriter.toString();
    }

    public static String stackTraceToString(Exception ex) {
        return Util.getStackTrace(ex);
    }

    public boolean getIsInterrupted() {
        return this.mIsInterrupted;
    }
}

