/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress;

import com.raplix.util.logger.Logger;
import java.util.Iterator;
import junit.framework.TestResult;
import junit.framework.TestSuite;

public abstract class IterantTestSuite
extends TestSuite {
    private static ThreadLocal state;

    public IterantTestSuite() {
    }

    public IterantTestSuite(Class c) {
        super(c);
    }

    public IterantTestSuite(String name) {
        super(name);
    }

    protected abstract Iterator getIterator();

    public void run(TestResult result) {
        ThreadState thrState;
        if (state == null) {
            state = new ThreadLocal();
        }
        if ((thrState = (ThreadState)state.get()) == null) {
            thrState = new ThreadState(this.getIterator());
            state.set(thrState);
        }
        while (thrState.next() && !result.shouldStop()) {
            if (Logger.isInfoEnabled((Object)this)) {
                Logger.info("running with current:" + this.getCurrentObject(), (Object)this);
            }
            this.superRun(result);
        }
        state.set(null);
    }

    public Object getCurrentObject() {
        ThreadState thrState;
        if (state != null && (thrState = (ThreadState)state.get()) != null) {
            return thrState.getCurrent();
        }
        return null;
    }

    private final void superRun(TestResult result) {
        super.run(result);
    }

    private static class ThreadState {
        private Iterator iterator;
        private Object current = null;

        ThreadState(Iterator iter) {
            this.iterator = iter;
        }

        boolean next() {
            if (this.iterator.hasNext()) {
                this.current = this.iterator.next();
                return true;
            }
            return false;
        }

        Object getCurrent() {
            return this.current;
        }
    }
}

