/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.RaplixShutdownException;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.event.NotificationManager;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.node.NodeSubsystem;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import java.util.Hashtable;

public class Distributor
extends Application {
    protected NotificationManager mNotificationManager;
    protected NetSubsystem mNetworkSubsystem;
    protected ResourceSubsystem mResourceSubsystem = null;
    protected NodeSubsystem mNodeSubsystem;

    public static void main(String[] args) {
        Distributor theApplication = null;
        try {
            theApplication = Distributor.createDistributor(args);
            theApplication.start();
        }
        catch (ConfigurationException iae) {
            System.err.println("Configuration error: " + iae.getMessage());
            if (theApplication != null) {
                theApplication.exitProcess(2);
            } else {
                System.exit(2);
            }
        }
        catch (IllegalArgumentException iae) {
            System.err.println(iae.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Distributor createDistributor(String[] args) throws ConfigurationException {
        Distributor theApplication = new Distributor(args);
        theApplication.mNetworkSubsystem = NetSubsystem.createNetSubsystemForNode(theApplication);
        theApplication.initSubsystems();
        return theApplication;
    }

    public NetSubsystem getNetSubsystem() {
        return this.mNetworkSubsystem;
    }

    public ResourceSubsystem getResourceSubsystem() {
        return this.mResourceSubsystem;
    }

    protected String getUsageString() {
        return "Usage";
    }

    protected String getVersionString() {
        return "5.2.1";
    }

    protected Distributor(String[] inCommandLineArgs) throws ConfigurationException {
        super(inCommandLineArgs);
        this.registerSignalHandlers();
    }

    protected final void initSubsystems() throws ConfigurationException {
        this.mNotificationManager = new NotificationManager((Application)this, false);
        this.mResourceSubsystem = new ResourceSubsystem(this);
        this.mNodeSubsystem = new NodeSubsystem(this);
        RPCManager theRPC = this.mNetworkSubsystem.getRPC();
        try {
            this.mNetworkSubsystem.registerRPCInterfaces(theRPC);
            this.mResourceSubsystem.registerRPCInterfaces(theRPC);
            this.mNodeSubsystem.registerRPCInterfaces(theRPC);
        }
        catch (RPCException rPCException) {
            // empty catch block
        }
        this.mNetworkSubsystem.postInit();
    }

    protected void shutdown() throws RaplixShutdownException {
        block23: {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    block16: {
                                        try {
                                            this.mNodeSubsystem.prepareForShutdown();
                                        }
                                        catch (RaplixShutdownException rse) {
                                            if (this.mShutdownRequestIsEmergency) break block16;
                                            throw new RaplixShutdownException("Cannot shutdown: Node subsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                        }
                                    }
                                    try {
                                        this.mResourceSubsystem.prepareForShutdown();
                                    }
                                    catch (RaplixShutdownException rse) {
                                        if (this.mShutdownRequestIsEmergency) break block17;
                                        throw new RaplixShutdownException("Cannot shutdown: Resource subsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                    }
                                }
                                try {
                                    this.mNotificationManager.prepareForShutdown();
                                }
                                catch (RaplixShutdownException rse) {
                                    if (this.mShutdownRequestIsEmergency) break block18;
                                    throw new RaplixShutdownException("Cannot shutdown: notification manager cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                }
                            }
                            try {
                                this.mNetworkSubsystem.prepareForShutdown();
                            }
                            catch (RaplixShutdownException rse) {
                                if (this.mShutdownRequestIsEmergency) break block19;
                                throw new RaplixShutdownException("Cannot shutdown: network subsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                            }
                        }
                        try {
                            this.mNodeSubsystem.shutdown();
                        }
                        catch (RaplixShutdownException rse) {
                            if (this.mShutdownRequestIsEmergency) break block20;
                            throw new RaplixShutdownException("Cannot shutdown: Nodesubsystem cannot shutdown.  Specific error: " + rse.getMessage());
                        }
                    }
                    try {
                        this.mResourceSubsystem.shutdown();
                    }
                    catch (RaplixShutdownException rse) {
                        if (this.mShutdownRequestIsEmergency) break block21;
                        throw new RaplixShutdownException("Cannot shutdown: Resource subsystem cannot shutdown.  Specific error: " + rse.getMessage());
                    }
                }
                try {
                    this.mNotificationManager.shutdown();
                }
                catch (RaplixShutdownException rse) {
                    if (this.mShutdownRequestIsEmergency) break block22;
                    throw new RaplixShutdownException("Cannot shutdown: notification manager cannot shutdown.  Specific error: " + rse.getMessage());
                }
            }
            try {
                this.mNetworkSubsystem.shutdown();
            }
            catch (RaplixShutdownException rse) {
                if (this.mShutdownRequestIsEmergency) break block23;
                throw new RaplixShutdownException("Cannot shutdown: network subsystem cannot shutdown.  Specific error: " + rse.getMessage());
            }
        }
    }

    protected void buildConfigurationFilesForSubsystems(Hashtable inTable) throws ConfigurationException {
        Subsystem.addConfigurationForSubsystem(inTable, NetSubsystem.class);
        Subsystem.addConfigurationForSubsystem(inTable, NodeSubsystem.class);
    }

    public NotificationManager getNotificationManager() {
        return this.mNotificationManager;
    }

    public NodeSubsystem getNodeSubsystem() throws UnsupportedSubsystemException {
        return this.mNodeSubsystem;
    }
}

