/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.ConsistencyEnforcer;
import com.raplix.rolloutexpress.Server;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.node.bootstrap.BootStrap;
import com.raplix.util.executor.Exec;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class ConsistencyChecker
extends Server {
    private static final String MSG_APP_ERR_ENFORCING_CONSISTENCY = "app.err_enforcing_consistency";
    private static final String MSG_APP_CONFIGURATION_ERR = "app.configuration_err";
    private static final String MSG_APP_UNEXPECTED_ERR = "app.unexpected_err";

    public static int invoke(String[] args) {
        try {
            long streamTimeout;
            long execTimeout;
            Process p;
            Exec e;
            boolean skip = Boolean.getBoolean("rox.cc.skip");
            if (skip) {
                if (Logger.isWarnEnabled(ConsistencyChecker.class)) {
                    Logger.warn("Skipping ConsistencyChecker", ConsistencyChecker.class);
                }
                return 0;
            }
            Vector commandLine = ConsistencyChecker.buildCommandLine(args);
            if (Logger.isDebugEnabled(ConsistencyChecker.class)) {
                Logger.debug("Invoking Consistency Checker with CommandLine:" + commandLine, ConsistencyChecker.class);
            }
            if ((e = new Exec(p = Runtime.getRuntime().exec(commandLine.toArray(new String[commandLine.size()])), new ByteArrayInputStream(new byte[0]), System.out, System.err, false, execTimeout = Long.parseLong(System.getProperty("rox.cc.execTimeout", String.valueOf(-1L))), streamTimeout = Long.parseLong(System.getProperty("rox.cc.streamTimeout", "3000")))).isTimedOut()) {
                if (Logger.isErrorEnabled(ConsistencyChecker.class)) {
                    Logger.error("Consistency Checker Timed out", ConsistencyChecker.class);
                }
                return -2;
            }
            return e.getExitCode();
        }
        catch (Exception e) {
            if (Logger.isErrorEnabled(ConsistencyChecker.class)) {
                Logger.error("Error invoking the consistency Checker", ConsistencyChecker.class);
            }
            return -1;
        }
    }

    public static Vector buildCommandLine(String[] args) {
        String classpath = System.getProperty("java.class.path");
        String roxHomeDir = System.getProperty("rox_home_dir");
        String roxWinUtilsDir = System.getProperty("rox_winutils_dir");
        String roxAppImplDir = System.getProperty("rox_appimpl_dir");
        String userHome = System.getProperty("user.home");
        String policyFile = System.getProperty("java.security.policy");
        String jaasFile = System.getProperty("java.security.auth.login.config");
        String javaHome = System.getProperty("java.home");
        String jvmMX = System.getProperty("rox.cc.xmx", "192m");
        String jvmMS = System.getProperty("rox.cc.xms", "24m");
        String jvmArgs = System.getProperty("rox.cc.jvmargs", "");
        String appArgs = System.getProperty("rox.cc.appargs", "");
        boolean noServerArgs = Boolean.getBoolean("rox.cc.noserverargs");
        Vector<String> commandLine = new Vector<String>();
        commandLine.add(new File(new File(javaHome, "bin"), "java").getAbsolutePath());
        ConsistencyChecker.addExtraOptions(commandLine, jvmArgs);
        commandLine.add("-Xms" + jvmMS);
        commandLine.add("-Xmx" + jvmMX);
        commandLine.add("-Djava.security.manager");
        commandLine.add("-Djava.security.policy=" + policyFile);
        commandLine.add("-Djava.security.auth.login.config=" + jaasFile);
        commandLine.add("-Duser.home=" + userHome);
        commandLine.add("-Drox_home_dir=" + roxHomeDir);
        commandLine.add("-Djava.net.preferIPv4Stack=true");
        if (roxWinUtilsDir != null) {
            commandLine.add("-Drox_winutils_dir=" + roxWinUtilsDir);
        }
        if (roxAppImplDir != null) {
            commandLine.add("-Drox_appimpl_dir=" + roxAppImplDir);
        }
        commandLine.add("-cp");
        commandLine.add(classpath);
        commandLine.add(BootStrap.class.getName());
        if (Logger.isDebugEnabled(ConsistencyChecker.class)) {
            commandLine.add("-verbose");
        }
        commandLine.add(ConsistencyChecker.class.getName());
        if (args != null && args.length > 0 && !noServerArgs) {
            commandLine.addAll(Arrays.asList(args));
        }
        ConsistencyChecker.addExtraOptions(commandLine, appArgs);
        return commandLine;
    }

    private static void addExtraOptions(Vector cmdLine, String args) {
        if (StringUtil.isEmpty(args)) {
            return;
        }
        StringTokenizer strTok = new StringTokenizer(args);
        while (strTok.hasMoreTokens()) {
            cmdLine.add(strTok.nextToken());
        }
    }

    public static void main(String[] args) {
        ConsistencyChecker cc = null;
        try {
            cc = new ConsistencyChecker(args);
            cc.start();
            Vector errors = cc.enforceConsistency();
            if (errors.size() > 0) {
                if (Logger.isErrorEnabled(ConsistencyChecker.class)) {
                    Logger.error(ROXMessageManager.messageAsString(new ROXMessage(MSG_APP_ERR_ENFORCING_CONSISTENCY)), ConsistencyChecker.class);
                }
                Enumeration enumeration = errors.elements();
                while (enumeration.hasMoreElements()) {
                    if (!Logger.isErrorEnabled(class$com$raplix$rolloutexpress$ConsistencyChecker == null ? ConsistencyChecker.class$("com.raplix.rolloutexpress.ConsistencyChecker") : class$com$raplix$rolloutexpress$ConsistencyChecker)) continue;
                    Logger.error("", (Throwable)enumeration.nextElement(), class$com$raplix$rolloutexpress$ConsistencyChecker == null ? ConsistencyChecker.class$("com.raplix.rolloutexpress.ConsistencyChecker") : class$com$raplix$rolloutexpress$ConsistencyChecker);
                }
            }
            cc.immediateShutdown();
            cc.exitProcess(errors.size());
        }
        catch (ConfigurationException ce) {
            if (Logger.isErrorEnabled(ConsistencyChecker.class)) {
                Logger.error(ROXMessageManager.messageAsString(new ROXMessage(MSG_APP_CONFIGURATION_ERR)), ce, ConsistencyChecker.class);
            }
            if (cc != null) {
                cc.exitProcess(127);
            } else {
                System.exit(127);
            }
        }
        catch (Exception e) {
            if (Logger.isErrorEnabled(ConsistencyChecker.class)) {
                Logger.error(ROXMessageManager.messageAsString(new ROXMessage(MSG_APP_UNEXPECTED_ERR)), e, ConsistencyChecker.class);
            }
            if (cc != null) {
                cc.exitProcess(128);
            }
            System.exit(128);
        }
    }

    public ConsistencyChecker(String[] inCommandLineArgs) throws ConfigurationException {
        super(inCommandLineArgs);
    }

    private Vector enforceConsistency() {
        Enumeration enforcers = this.consistencyEnforcers();
        ConsistencyEnforcer ce = null;
        Vector<Exception> errors = new Vector<Exception>();
        while (enforcers.hasMoreElements()) {
            ce = (ConsistencyEnforcer)enforcers.nextElement();
            try {
                ce.enforceConsistency();
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        return errors;
    }

    protected NetSubsystem createNetSubsystem() throws ConfigurationException {
        return NetSubsystem.createNetSubsystemForLocal(this);
    }

    private Enumeration consistencyEnforcers() {
        Vector<Subsystem> enforcers = new Vector<Subsystem>();
        enforcers.add(this.getResourceSubsystem());
        enforcers.add(this.getPlanSubsystem());
        enforcers.add(this.getDiffEngineSubsystem());
        return enforcers.elements();
    }
}

