/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.util.platform.common.PlatformUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;

public class ConfigurationFile {
    protected Properties mVariables;

    public ConfigurationFile(String inFilename) throws ConfigurationException {
        try {
            this.initFromStream(new FileInputStream(inFilename));
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Configuration file " + inFilename + " not found.");
        }
    }

    public ConfigurationFile(InputStream configStream) throws ConfigurationException {
        this.initFromStream(configStream);
    }

    private void initFromStream(InputStream configStream) throws ConfigurationException {
        Properties tempProps = new Properties();
        try {
            tempProps.load(configStream);
            this.mVariables = this.makeAllKeysLowerCase(tempProps);
        }
        catch (IOException ioex) {
            throw new ConfigurationException("Error while loading configuration: " + ioex.toString());
        }
    }

    public String getPlatformConfig(String inKey) {
        String thePlatformKey = null;
        if (PlatformUtil.isAix()) {
            thePlatformKey = "aix.";
        } else if (PlatformUtil.isHpux()) {
            thePlatformKey = "hpux.";
        } else if (PlatformUtil.isSolaris()) {
            thePlatformKey = "solaris.";
        } else if (PlatformUtil.isLinux()) {
            thePlatformKey = "linux.";
        } else if (PlatformUtil.isCygwin()) {
            thePlatformKey = "cygwin.";
        } else if (PlatformUtil.isWin32()) {
            thePlatformKey = "win.";
        }
        thePlatformKey = thePlatformKey + inKey;
        String outValue = this.get(thePlatformKey);
        if (outValue == null) {
            outValue = this.get(inKey);
        }
        return outValue;
    }

    public String get(String inVariableTag) {
        return this.mVariables.getProperty(inVariableTag.toLowerCase());
    }

    protected Properties makeAllKeysLowerCase(Properties inSourceProperties) {
        Enumeration<?> enumeration = inSourceProperties.propertyNames();
        Properties returnProps = new Properties();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            returnProps.put(key.toLowerCase(), inSourceProperties.getProperty(key));
        }
        return returnProps;
    }

    public String toString() {
        return this.mVariables.toString();
    }
}

