/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress;

import com.raplix.util.executor.Exec;
import com.raplix.util.file.CopyUtil;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.PasswordEscape;
import com.raplix.util.string.StringUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;

public class CRKeys {
    private HashMap mArgValues = new HashMap();
    private String mAppHome;
    private File mTrustStore;
    private File mPrivateStore;
    private static final String ARG_PRIVATE = "-private";
    private static final String ARG_TRUST = "-trust";
    private static final String ARG_GENERATE = "-generate";
    private static final String ARG_ALIAS = "-alias";
    private static final String ARG_MODE = "-mode";
    private static final String ARG_PASSWORD = "-password";
    private static final String ARG_NEW_PASSWORD = "-new";
    private static final String ARG_KEY_ALG = "-keyalg";
    private static final String ARG_KEY_SIZE = "-keysize";
    private static final String ARG_VALIDITY = "-validity";
    private static final String ARG_FILE = "-file";
    private static final String ARG_EXPORT = "-export";
    private static final String ARG_IMPORT = "-import";
    private static final String ARG_DELETE = "-delete";
    private static final String ARG_CPASS = "-cpass";
    private static final String ARG_EPASS = "-epass";
    private static final String ARG_LIST = "-list";
    private static final String ARG_HELP = "-help";
    private static final String MODE_CARRIER = "OU=";
    private static final String UPSTREAM_ANNOTATION = "upstream";
    private static final String DOWNSTREAM_ANNOTATION = "downstream";
    private static final HashSet BOOLEAN_ARGS = new HashSet<String>(Arrays.asList("-private", "-trust", "-generate", "-export", "-import", "-delete", "-cpass", "-epass", "-help", "-list"));
    private static final HashSet ARG_ARGS = new HashSet<String>(Arrays.asList("-alias", "-mode", "-password", "-new", "-keyalg", "-keysize", "-validity", "-file"));

    public static void main(String[] args) {
        Logger.initializeLoggingSystem();
        CRKeys crk = new CRKeys();
        crk.execute(args);
    }

    private CRKeys() {
    }

    private void init() {
        this.mAppHome = System.getProperty("rox_home_dir");
        if (this.mAppHome == null) {
            this.exitWithError("Please set the property 'rox_home_dir'");
        }
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(new File(new File(this.mAppHome, "config"), "config.properties")));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.exitWithError("Error when loading the properties file");
        }
        String privateStore = properties.getProperty("net.ssl.private.store.path");
        this.mPrivateStore = StringUtil.isEmpty(privateStore) ? new File(new File(this.mAppHome, "data"), "private.store") : new File(privateStore);
        String trustStore = properties.getProperty("net.ssl.trust.store.path");
        this.mTrustStore = StringUtil.isEmpty(trustStore) ? new File(new File(this.mAppHome, "data"), "trust.store") : new File(trustStore);
    }

    private void execute(String[] args) {
        this.parseArgs(args);
        this.init();
        if (this.mArgValues.containsKey(ARG_CPASS)) {
            this.changePass();
        } else if (this.mArgValues.containsKey(ARG_LIST)) {
            this.list();
        } else if (this.mArgValues.containsKey(ARG_GENERATE)) {
            this.generate();
        } else if (this.mArgValues.containsKey(ARG_IMPORT)) {
            this.importKey();
        } else if (this.mArgValues.containsKey(ARG_EXPORT)) {
            this.exportKey();
        } else if (this.mArgValues.containsKey(ARG_EPASS)) {
            this.encodePassword();
        } else if (this.mArgValues.containsKey(ARG_DELETE)) {
            this.deleteKey();
        } else {
            this.printUsage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void changePass() {
        boolean success;
        File trustBackup;
        File privateBackup;
        block56: {
            block55: {
                block54: {
                    block53: {
                        block51: {
                            block52: {
                                File verifyStore = null;
                                if (this.mPrivateStore.exists()) {
                                    verifyStore = this.mPrivateStore;
                                } else if (this.mTrustStore.exists()) {
                                    verifyStore = this.mTrustStore;
                                } else {
                                    this.exitWithError("Cannot change password, No keystores initialized");
                                }
                                String password = this.getPassword(true);
                                String newPassword = this.getPassword(ARG_NEW_PASSWORD, true);
                                if (this.verifyPass(password, verifyStore) == 0) {
                                    System.err.println("Verified password...");
                                } else {
                                    this.exitWithError("Invalid password, try again...");
                                }
                                privateBackup = new File(this.mPrivateStore.getParentFile(), "private.store.backup");
                                if (privateBackup.exists() && privateBackup.delete()) {
                                    this.exitWithError("Could not deleted " + privateBackup.getAbsolutePath() + ". Please make sure that this file doesn't exist");
                                }
                                if ((trustBackup = new File(this.mTrustStore.getParentFile(), "trust.store.backup")).exists() && trustBackup.delete()) {
                                    this.exitWithError("Could not deleted " + privateBackup.getAbsolutePath() + ". Please make sure that this file doesn't exist");
                                }
                                System.err.println("Creating temporary keystores for changing passwords");
                                success = false;
                                try {
                                    try {
                                        if (this.mPrivateStore.exists()) {
                                            CopyUtil.copyBinary(this.mPrivateStore.getAbsolutePath(), privateBackup.getAbsolutePath());
                                            System.err.println("Created " + privateBackup.getAbsolutePath());
                                        }
                                        if (this.mTrustStore.exists()) {
                                            CopyUtil.copyBinary(this.mTrustStore.getAbsolutePath(), trustBackup.getAbsolutePath());
                                            System.err.println("Created " + trustBackup.getAbsolutePath());
                                        }
                                        if (this.mTrustStore.exists()) {
                                            System.err.println("Changing trust store password");
                                            int status = this.execKeyTool(new String[]{"-storepasswd", ARG_NEW_PASSWORD, newPassword, "-storepass", password, "-keystore", trustBackup.getAbsolutePath()});
                                            if (status == 0) {
                                                System.err.println("Changed trust store password " + trustBackup.getAbsolutePath());
                                            } else {
                                                System.err.println("Error changing trust store password " + trustBackup.getAbsolutePath());
                                                Object var12_10 = null;
                                                if (!success) break block51;
                                                System.err.println("Copying the temporary keystores with changed passwords onto the actual keystores");
                                                break block52;
                                            }
                                        }
                                        if (this.mPrivateStore.exists()) {
                                            String[] aliases = this.getAliases(privateBackup);
                                            if (aliases == null) {
                                                break block53;
                                            }
                                            System.err.println("Changing passwords for " + aliases.length + " aliases");
                                            String alias = null;
                                            for (int i = 0; i < aliases.length; ++i) {
                                                alias = aliases[i];
                                                int status = this.execKeyTool(new String[]{"-keypasswd", ARG_NEW_PASSWORD, newPassword, ARG_ALIAS, alias, "-keypass", password, "-storepass", password, "-keystore", privateBackup.getAbsolutePath()});
                                                if (status == 0) {
                                                    System.err.println("Changed key password for alias:" + alias);
                                                    continue;
                                                }
                                                System.err.println("Error changing key password for alias:" + alias);
                                                break block54;
                                            }
                                            System.err.println("Changing private store password");
                                            int status = this.execKeyTool(new String[]{"-storepasswd", ARG_NEW_PASSWORD, newPassword, "-storepass", password, "-keystore", privateBackup.getAbsolutePath()});
                                            if (status != 0) {
                                                System.err.println("Error changing private store password" + privateBackup.getAbsolutePath());
                                                break block55;
                                            }
                                            System.err.println("Changed private store password :" + privateBackup.getAbsolutePath());
                                        }
                                        success = true;
                                        break block56;
                                    }
                                    catch (IOException e) {
                                        System.err.println("Error changing password:" + e);
                                        Object var12_15 = null;
                                        if (!success) {
                                            System.err.println("Change passwords failed, deleting temporary keystores");
                                            trustBackup.delete();
                                            privateBackup.delete();
                                            System.exit(1);
                                            return;
                                        }
                                        System.err.println("Copying the temporary keystores with changed passwords onto the actual keystores");
                                        try {
                                            if (trustBackup.exists()) {
                                                CopyUtil.copyBinary(trustBackup.getAbsolutePath(), this.mTrustStore.getAbsolutePath());
                                            }
                                            if (privateBackup.exists()) {
                                                CopyUtil.copyBinary(privateBackup.getAbsolutePath(), this.mPrivateStore.getAbsolutePath());
                                            }
                                            System.err.println("Passwords changed...");
                                            trustBackup.delete();
                                            privateBackup.delete();
                                            return;
                                        }
                                        catch (IOException e2) {
                                            this.exitWithError("Error copying the temporary stores over, passwords not changed:" + e2);
                                            return;
                                        }
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var12_16 = null;
                                    if (!success) {
                                        System.err.println("Change passwords failed, deleting temporary keystores");
                                        trustBackup.delete();
                                        privateBackup.delete();
                                        System.exit(1);
                                        throw throwable;
                                    }
                                    System.err.println("Copying the temporary keystores with changed passwords onto the actual keystores");
                                    try {}
                                    catch (IOException e2) {
                                        this.exitWithError("Error copying the temporary stores over, passwords not changed:" + e2);
                                        throw throwable;
                                    }
                                    if (trustBackup.exists()) {
                                        CopyUtil.copyBinary(trustBackup.getAbsolutePath(), this.mTrustStore.getAbsolutePath());
                                    }
                                    if (privateBackup.exists()) {
                                        CopyUtil.copyBinary(privateBackup.getAbsolutePath(), this.mPrivateStore.getAbsolutePath());
                                    }
                                    System.err.println("Passwords changed...");
                                    trustBackup.delete();
                                    privateBackup.delete();
                                    throw throwable;
                                }
                            }
                            try {}
                            catch (IOException e2) {
                                this.exitWithError("Error copying the temporary stores over, passwords not changed:" + e2);
                                return;
                            }
                            if (trustBackup.exists()) {
                                CopyUtil.copyBinary(trustBackup.getAbsolutePath(), this.mTrustStore.getAbsolutePath());
                            }
                            if (privateBackup.exists()) {
                                CopyUtil.copyBinary(privateBackup.getAbsolutePath(), this.mPrivateStore.getAbsolutePath());
                            }
                            System.err.println("Passwords changed...");
                            trustBackup.delete();
                            privateBackup.delete();
                            return;
                        }
                        System.err.println("Change passwords failed, deleting temporary keystores");
                        trustBackup.delete();
                        privateBackup.delete();
                        System.exit(1);
                        return;
                    }
                    Object var12_11 = null;
                    if (success) {
                        System.err.println("Copying the temporary keystores with changed passwords onto the actual keystores");
                        try {}
                        catch (IOException e2) {
                            this.exitWithError("Error copying the temporary stores over, passwords not changed:" + e2);
                            return;
                        }
                        if (trustBackup.exists()) {
                            CopyUtil.copyBinary(trustBackup.getAbsolutePath(), this.mTrustStore.getAbsolutePath());
                        }
                        if (privateBackup.exists()) {
                            CopyUtil.copyBinary(privateBackup.getAbsolutePath(), this.mPrivateStore.getAbsolutePath());
                        }
                        System.err.println("Passwords changed...");
                        trustBackup.delete();
                        privateBackup.delete();
                        return;
                    }
                    System.err.println("Change passwords failed, deleting temporary keystores");
                    trustBackup.delete();
                    privateBackup.delete();
                    System.exit(1);
                    return;
                }
                Object var12_12 = null;
                if (success) {
                    System.err.println("Copying the temporary keystores with changed passwords onto the actual keystores");
                    try {}
                    catch (IOException e2) {
                        this.exitWithError("Error copying the temporary stores over, passwords not changed:" + e2);
                        return;
                    }
                    if (trustBackup.exists()) {
                        CopyUtil.copyBinary(trustBackup.getAbsolutePath(), this.mTrustStore.getAbsolutePath());
                    }
                    if (privateBackup.exists()) {
                        CopyUtil.copyBinary(privateBackup.getAbsolutePath(), this.mPrivateStore.getAbsolutePath());
                    }
                    System.err.println("Passwords changed...");
                    trustBackup.delete();
                    privateBackup.delete();
                    return;
                }
                System.err.println("Change passwords failed, deleting temporary keystores");
                trustBackup.delete();
                privateBackup.delete();
                System.exit(1);
                return;
            }
            Object var12_13 = null;
            if (success) {
                System.err.println("Copying the temporary keystores with changed passwords onto the actual keystores");
                try {}
                catch (IOException e2) {
                    this.exitWithError("Error copying the temporary stores over, passwords not changed:" + e2);
                    return;
                }
                if (trustBackup.exists()) {
                    CopyUtil.copyBinary(trustBackup.getAbsolutePath(), this.mTrustStore.getAbsolutePath());
                }
                if (privateBackup.exists()) {
                    CopyUtil.copyBinary(privateBackup.getAbsolutePath(), this.mPrivateStore.getAbsolutePath());
                }
                System.err.println("Passwords changed...");
                trustBackup.delete();
                privateBackup.delete();
                return;
            }
            System.err.println("Change passwords failed, deleting temporary keystores");
            trustBackup.delete();
            privateBackup.delete();
            System.exit(1);
            return;
        }
        Object var12_14 = null;
        if (success) {
            System.err.println("Copying the temporary keystores with changed passwords onto the actual keystores");
            try {}
            catch (IOException e2) {
                this.exitWithError("Error copying the temporary stores over, passwords not changed:" + e2);
                return;
            }
            if (trustBackup.exists()) {
                CopyUtil.copyBinary(trustBackup.getAbsolutePath(), this.mTrustStore.getAbsolutePath());
            }
            if (privateBackup.exists()) {
                CopyUtil.copyBinary(privateBackup.getAbsolutePath(), this.mPrivateStore.getAbsolutePath());
            }
            System.err.println("Passwords changed...");
            trustBackup.delete();
            privateBackup.delete();
            return;
        }
        System.err.println("Change passwords failed, deleting temporary keystores");
        trustBackup.delete();
        privateBackup.delete();
        System.exit(1);
    }

    private String[] getAliases(File keystore) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.execKeyTool(new String[]{ARG_LIST, "-keystore", keystore.getAbsolutePath()}, baos);
            baos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            BufferedReader reader = new BufferedReader(new InputStreamReader(bais));
            String line = null;
            Vector<String> aliases = new Vector<String>();
            while ((line = reader.readLine()) != null) {
                int idx;
                if (line.indexOf("keyEntry") == -1 || (idx = line.indexOf(44)) == -1 || StringUtil.isEmpty(line = line.substring(0, idx))) continue;
                aliases.add(line);
            }
            return aliases.toArray(new String[aliases.size()]);
        }
        catch (IOException e) {
            System.err.println("Error listing aliases from keystore:" + keystore.getAbsolutePath() + ":" + e);
            return null;
        }
    }

    private void generate() {
        if (this.mArgValues.containsKey(ARG_TRUST)) {
            System.err.println("Cannot generate keys into trust store");
            this.printUsage();
        }
        File keyStore = this.getOpnKeyStore();
        this.verifyFileWritable("Keystore", keyStore, false);
        String alias = this.getArgValue(ARG_ALIAS, true);
        String mode = this.getArgValue(ARG_MODE, true);
        if (!mode.equalsIgnoreCase(UPSTREAM_ANNOTATION) && !mode.equalsIgnoreCase(DOWNSTREAM_ANNOTATION)) {
            this.exitWithError("The value of parameter mode can only be upstream or downstream.");
        }
        String password = this.getPassword(true);
        String dname = "CN=" + alias + ", OU=" + mode.toLowerCase() + ", O=Sun Microsystems, L=Menlo Park, ST=CA, C=US";
        String keyalg = this.getArgValue(ARG_KEY_ALG, "rsa");
        String keysize = this.getArgValue(ARG_KEY_SIZE, "1024");
        String validity = this.getArgValue(ARG_VALIDITY, "365");
        if (!keyStore.exists() && this.verifyPass(password, this.mTrustStore) != 0) {
            this.exitWithError("The password doesn't match the trust store password");
        }
        System.exit(this.execKeyTool(new String[]{"-genkey", ARG_ALIAS, alias, ARG_KEY_ALG, keyalg, ARG_KEY_SIZE, keysize, "-dname", dname, ARG_VALIDITY, validity, "-keystore", keyStore.getAbsolutePath(), "-storepass", password}));
    }

    private void importKey() {
        if (this.mArgValues.containsKey(ARG_PRIVATE)) {
            System.err.println("Cannot import certifcates into private store");
            this.printUsage();
        }
        File keyStore = this.getOpnKeyStore();
        this.verifyFileWritable("Keystore", keyStore, false);
        String alias = this.getArgValue(ARG_ALIAS, true);
        String file = this.getArgValue(ARG_FILE, true);
        file = new File(file).getAbsolutePath();
        String mode = this.getMode(file);
        String nodeType = new File(this.mAppHome).getName();
        if (nodeType.equals("agent") && mode.equalsIgnoreCase(DOWNSTREAM_ANNOTATION)) {
            this.exitWithError("Cannot import certificates with downstream mode into a Remote Agent trust store.");
        }
        if (nodeType.equals("cli") && mode.equalsIgnoreCase(UPSTREAM_ANNOTATION)) {
            this.exitWithError("Cannot import certificates with upstream mode into a CLI trust store.");
        }
        String password = this.getPassword(true);
        if (!keyStore.exists() && this.verifyPass(password, this.mPrivateStore) != 0) {
            this.exitWithError("The password doesn't match the private store password");
        }
        System.exit(this.execKeyTool(new String[]{ARG_IMPORT, "-noprompt", ARG_ALIAS, alias, ARG_FILE, file, "-keystore", keyStore.getAbsolutePath(), "-storepass", password}));
    }

    private void exportKey() {
        File keyStore = this.getOpnKeyStore();
        this.verifyFileReadable("Keystore", keyStore);
        String password = this.getPassword(false);
        String alias = this.getArgValue(ARG_ALIAS, true);
        String file = this.getArgValue(ARG_FILE, true);
        file = new File(file).getAbsolutePath();
        Vector<String> args = new Vector<String>();
        args.add(ARG_EXPORT);
        args.add("-rfc");
        args.add(ARG_ALIAS);
        args.add(alias);
        args.add(ARG_FILE);
        args.add(file);
        args.add("-keystore");
        args.add(keyStore.getAbsolutePath());
        if (password != null) {
            args.add("-storepass");
            args.add(password);
        }
        System.exit(this.execKeyTool(args.toArray(new String[args.size()])));
    }

    private void encodePassword() {
        String password = this.getPassword(false);
        if (StringUtil.isEmpty(password)) {
            System.err.println("Please specify a value for the password.");
            this.printUsage();
        }
        try {
            System.out.println(PasswordEscape.encodePassword(password));
        }
        catch (IOException io) {
            System.err.println("Unable to encode password:" + io.toString());
            System.exit(1);
        }
        System.exit(0);
    }

    private void deleteKey() {
        File keyStore = this.getOpnKeyStore();
        this.verifyFileWritable("Keystore", keyStore, true);
        String alias = this.getArgValue(ARG_ALIAS, true);
        String password = this.getPassword(true);
        System.exit(this.execKeyTool(new String[]{ARG_DELETE, ARG_ALIAS, alias, "-keystore", keyStore.getAbsolutePath(), "-storepass", password}));
    }

    private void list() {
        File keyStore = this.getOpnKeyStore();
        this.verifyFileReadable("Keystore", keyStore);
        String password = this.getPassword(false);
        Vector<String> args = new Vector<String>();
        args.add(ARG_LIST);
        args.add("-v");
        args.add("-keystore");
        args.add(keyStore.getAbsolutePath());
        if (password != null) {
            args.add("-storepass");
            args.add(password);
        }
        System.exit(this.execKeyTool(args.toArray(new String[args.size()])));
    }

    private int verifyPass(String password, File keyStore) {
        if (keyStore.exists()) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int status = this.execKeyTool(new String[]{ARG_LIST, "-keystore", keyStore.getAbsolutePath(), "-storepass", password}, baos);
                baos.close();
                if (status != 0) {
                    System.out.write(baos.toByteArray());
                }
                return status;
            }
            catch (IOException e) {
                this.exitWithError("Error verifying the password with keystore:" + keyStore.getAbsolutePath() + ":" + e);
                return -1;
            }
        }
        return 0;
    }

    private File getOpnKeyStore() {
        if (this.mArgValues.containsKey(ARG_TRUST)) {
            if (this.mArgValues.containsKey(ARG_PRIVATE)) {
                System.err.println("Please specify only one of -trust|-private");
                this.printUsage();
            }
            return this.mTrustStore;
        }
        if (this.mArgValues.containsKey(ARG_PRIVATE)) {
            return this.mPrivateStore;
        }
        this.exitWithError("Please specify a target keystore {-trust|-private}");
        return null;
    }

    private void verifyFileReadable(String msgName, File file) {
        if (!file.exists()) {
            this.exitWithError(msgName + " file doesn't exist:" + file.getAbsolutePath());
        }
        if (!file.canRead()) {
            this.exitWithError(msgName + " file is not readable:" + file.getAbsolutePath());
        }
    }

    private void verifyFileWritable(String msgName, File file, boolean shouldExist) {
        if (!file.exists()) {
            if (shouldExist) {
                this.exitWithError(msgName + " file doesn't exist:" + file.getAbsolutePath());
            } else {
                if (!file.getParentFile().exists()) {
                    this.exitWithError(msgName + " file cannot be written to, parent directory doesn't exist:" + file.getParentFile().getAbsolutePath());
                }
                if (!file.getParentFile().canWrite()) {
                    this.exitWithError(msgName + " file cannot be written to, parent directory is not writable:" + file.getParentFile().getAbsolutePath());
                }
            }
            return;
        }
        if (!file.canWrite()) {
            this.exitWithError(msgName + " file is not writable:" + file.getAbsolutePath());
        }
    }

    private String getArgValue(String argName, String defaultValue) {
        String value = (String)this.mArgValues.get(argName);
        if (StringUtil.isEmpty(value)) {
            return defaultValue;
        }
        return value;
    }

    private String getArgValue(String argName, boolean notEmpty) {
        String value = (String)this.mArgValues.get(argName);
        if (StringUtil.isEmpty(value) && notEmpty) {
            System.err.println("Please specify value of the argument <" + argName + ">");
            this.printUsage();
        }
        return value;
    }

    private String getPassword(boolean verify) {
        return this.getPassword(ARG_PASSWORD, verify);
    }

    private String getPassword(String argName, boolean verify) {
        String pass = (String)this.mArgValues.get(argName);
        if (verify) {
            if (pass == null) {
                this.exitWithError("Please specify the key store password using " + argName);
            }
            if (pass.length() < 6) {
                this.exitWithError("Invalild password (" + argName + "). The password has to be greater than 6 characters in length");
            }
        }
        return pass;
    }

    private void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (BOOLEAN_ARGS.contains(args[i])) {
                this.mArgValues.put(args[i], new Object());
                continue;
            }
            if (ARG_ARGS.contains(args[i])) {
                if (args.length <= i + 1) {
                    System.err.println("Please specify an argument for " + args[i]);
                    this.printUsage();
                }
                this.mArgValues.put(args[i], args[++i]);
                continue;
            }
            System.err.println("Unrecognized parameter :" + args[i]);
            this.printUsage();
        }
    }

    private int execKeyTool(String[] args) {
        return this.execKeyTool(args, System.out);
    }

    private int execKeyTool(String[] args, OutputStream output) {
        String javaHome = System.getProperty("java.home");
        String keyTool = new File(new File(javaHome, "bin"), "keytool").getAbsolutePath();
        Vector<String> argList = new Vector<String>(Arrays.asList(args));
        argList.add(0, keyTool);
        try {
            Process process = Runtime.getRuntime().exec(argList.toArray(new String[argList.size()]));
            Exec exec = new Exec(process, new ByteArrayInputStream(new byte[0]), output, new NullOutputStream(), false, -1L, -1L);
            return exec.getExitCode();
        }
        catch (Exception e) {
            this.exitWithError("Error executing keytool:" + e);
            return -1;
        }
    }

    private String getMode(String fileName) {
        String mode;
        block5: {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int status = this.execKeyTool(new String[]{"-printcert", "-v", ARG_FILE, fileName}, baos);
            mode = null;
            try {
                baos.close();
                if (status != 0) {
                    this.exitWithError("Unable to read certificate " + fileName + ". Please ensure that the certificate was generated using crkeys -export option.");
                }
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                BufferedReader reader = new BufferedReader(new InputStreamReader(bais));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    int idxStart = line.indexOf(MODE_CARRIER);
                    if (idxStart <= -1) continue;
                    int idxEnd = line.indexOf(32, idxStart);
                    mode = idxEnd > -1 ? line.substring(idxStart + MODE_CARRIER.length(), idxEnd - 1) : null;
                    break;
                }
            }
            catch (IOException ioe) {
                if (!Logger.isDebugEnabled(this)) break block5;
                Logger.debug("An error was encountered while reading the certificate " + fileName, this);
            }
        }
        if (mode == null) {
            this.exitWithError("Certificate " + fileName + " has unexpected contents. " + "Please ensure that the certificate was generated using crkeys -export option.");
        }
        return mode;
    }

    private void exitWithError(String msg) {
        System.err.println("ERROR:" + msg);
        System.exit(1);
    }

    private void printUsage() {
        System.err.println("Usage:");
        System.err.println("");
        System.err.println("crkeys -private -generate -mode {upstream|downstream}");
        System.err.println("        -alias node_name [-keyalg keyalg] [-keysize keysize]");
        System.err.println("        [-validity days_valid] -password password");
        System.err.println("");
        System.err.println("crkeys -private -export -file cert_file");
        System.err.println("        -alias node_name [-password password]");
        System.err.println("");
        System.err.println("crkeys -trust -import -file cert_file");
        System.err.println("        -alias node_name -password password");
        System.err.println("");
        System.err.println("crkeys {-private|-trust} -delete");
        System.err.println("        -alias node_name -password password");
        System.err.println("");
        System.err.println("crkeys {-private|-trust} -list [-password password]");
        System.err.println("");
        System.err.println("crkeys -cpass -password oldpassword");
        System.err.println("        -new newpassword");
        System.err.println("");
        System.err.println("crkeys -epass -password plaintextpassword");
        System.err.println("");
        System.err.println("crkeys -help");
        System.exit(1);
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        public void write(int b) {
        }
    }
}

