/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress;

import com.raplix.rolloutexpress.AixPlatformApplication;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.ConfigurationFile;
import com.raplix.rolloutexpress.CygwinPlatformApplication;
import com.raplix.rolloutexpress.HpuxPlatformApplication;
import com.raplix.rolloutexpress.LinuxPlatformApplication;
import com.raplix.rolloutexpress.PlatformApplication;
import com.raplix.rolloutexpress.RaplixShutdownException;
import com.raplix.rolloutexpress.RoxShutdownHook;
import com.raplix.rolloutexpress.SolarisPlatformApplication;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.WindowsPlatformApplication;
import com.raplix.rolloutexpress.command.NativePlatformIntegration;
import com.raplix.rolloutexpress.command.rpcinterfaces.SnapshotServices;
import com.raplix.rolloutexpress.config.ConfigGenSubsystem;
import com.raplix.rolloutexpress.difference.DifferenceEngine;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceDB;
import com.raplix.rolloutexpress.event.NotificationManager;
import com.raplix.rolloutexpress.executor.PlanSubsystem;
import com.raplix.rolloutexpress.logger.LoggerSubsystem;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCInterface;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.node.NodeAdminSubsystem;
import com.raplix.rolloutexpress.node.NodeSubsystem;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.userdb.RemoteUserDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBSubsystem;
import com.raplix.util.ClassLoaderFactory;
import com.raplix.util.file.RecursiveChmod;
import com.raplix.util.logger.Logger;
import com.raplix.util.platform.common.Platform;
import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.platform.posix.Signal;
import com.raplix.util.platform.posix.SignalHandler;
import com.raplix.util.platform.windows.WindowsServicesException;
import com.raplix.util.threads.SafeThread;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class Application
extends SafeThread {
    protected static final String APP_PREFIX = "app.";
    private static final String DEFAULT_APPLICATION_NAME = "Unspecified application";
    protected static final String MSG_UNSUPPORTED_OS = "app.UNSUPPORTED_OS";
    protected static final String MSG_REQUESTSHUTDOWN = "app.REQUESTSHUTDOWN";
    protected static final String MSG_REQUESTEMERGENCY = "app.REQUESTEMERGENCY";
    protected static final String SHUTDOWN_CALLED_HAS_RUNNING_TASKS = "app.SHUTDOWN_CALLED_HAS_RUNNING_TASKS";
    protected static final String MSG_UNKNOWN_APPLICATION = "app.OTHER";
    protected static final String MSG_APPLICATION_NAME_MISSING = "app.APPLICATION_NAME_MISSING";
    protected static final String MSG_SIGNAL_IGNORED = "app.SIGNAL_IGNORED";
    protected static final String MSG_CANT_SEND_EVENT = "app.CANT_SEND_EVENT";
    protected static final String MSG_APPLICATION_CONFIG_PARAM_MISSING = "app.MSG_APPLICATION_CONFIG_PARAM_MISSING";
    protected static final String MSG_DIR_NOT_VALID = "app.MSG_DIR_NOT_VALID";
    protected static final String TMP_DIR_CANNOT_BE_DELETED = "app.TMP_DIR_CANNOT_BE_DELETED";
    protected static final String MSG_DIR_CANNOT_BE_CREATED = "app.MSG_DIR_CANNOT_BE_CREATED";
    public static final String MSG_CONFIG_ERROR = "app.configuration_err_with_msg";
    public static final String MSG_WINUTILS_ABSENT = "app.WIN32_UTILS_CANNOT_BE_LOADED";
    protected static final String MSG_INVOKE_CONFIG_READ_FAILED = "app.MSG_INVOKE_CONFIG_READ_FAILED";
    protected static final String MSG_DBM_STARTED = "app.DBM_STARTED";
    protected static final String MSG_DBM_SUCCESSFULL = "app.DBM_SUCCESSFULL";
    protected static final String MSG_DBM_FAILED = "app.DBM_FAILED";
    protected static final String MSG_DBM_SKIPPED = "app.DBM_SKIPPED";
    protected static final String MSG_CC_INVOKED = "app.CC_INVOKED";
    protected static final String MSG_CC_FAILED = "app.CC_FAILED";
    protected static final String MSG_CC_SUCCESSFULL = "app.CC_SUCCESSFULL";
    public static final String USER_MUST_PROVIDE_DEFAULT_MESSAGE = "<operator must provide value>";
    public static final String NO_CONFIG_DOCUMENTATION = "Mystery Variable FIXME";
    public static final String ERROR_NO_WEBSERVER = "This application does not have a Webserver.";
    public static final String ERROR_NO_NATIVE = "This application does not have a NativePlatformIntegration.";
    public static final String ERROR_NO_NOTIFICATION = "This application does not have a Notification Subsystem.";
    public static final String ERROR_NO_CONFIGGEN_SUBSYSTEM = "This application does not have a Configuration Generation Subsystem.";
    public static final String ERROR_NO_INSTALLDB_SUBSYSTEM = "This application does not have an Install Database Subsystem.";
    public static final String ERROR_NO_USERDB_SUBSYSTEM = "This application does not have a User Database Subsystem.";
    public static final String ERROR_NO_REMOTE_USERDB_SUBSYSTEM = "This application does not have a Remote User Database Subsystem.";
    public static final String ERROR_NO_NET = "This application does not have a Network Subsystem.";
    public static final String ERROR_NO_HOSTDB = "This application does not have a HostDB Subsystem.";
    public static final String ERROR_NO_PLAN = "This application does not have a PlanExecution Subsystem";
    public static final String ERROR_NO_PERSISTENCE_MANAGER = "This application does not have a PersistenceManager Subsystem.";
    public static final String ERROR_NO_PLUGINDB = "This application does not have a PluginDB Subsystem.";
    public static final String ERROR_NO_RESOURCE = "This application does not have a Resource Subsystem.";
    public static final String ERROR_NO_NODE = "This application does not have a Node Subsystem.";
    public static final String ERROR_NO_NODE_ADMIN = "This application does not have a Node Admin Subsystem.";
    public static final String ERROR_NO_DIFF_SUBSYSTEM = "This application does not have a Difference Subsystem.";
    public static final String ERROR_NO_SNAPSHOT_SUBSYSTEM = "This application does not have a Snapshot Subsystem.";
    public static final String ERROR_NO_DIFF_ENGINE = "This application does not have a DifferenceEngine Subsystem.";
    public static final int EXIT_VALUE_SUCCESS = 0;
    public static final int EXIT_VALUE_CANNOT_SHUTDOWN = 1;
    public static final int EXIT_VALUE_FAILURE = 2;
    public static final String[] HELP_FLAGS = new String[]{"-h", "--h", "-help", "--help"};
    public static final String[] VERSION_FLAGS = new String[]{"-v", "--v", "-version", "--version"};
    public static final String[] BUILD_FLAGS = new String[]{"-build", "--build", "-buildnumber", "--buildnumber"};
    public static final String[] GENERATE_CONFIG_FLAGS = new String[]{"-generateconfig", "--generateconfig"};
    public static final String OVERRIDE_CONFIG_FILENAME_FLAG = "-C";
    public static final String EXTRA_CONFIG_FILENAME_FLAG = "-O";
    public static final String OVERRIDE_CONFIG_FLAG = "-D";
    public static final String DEFAULT_LOGGER_FILE_NAME = "logger_config.xml";
    public static final String DEFAULT_HOME_DIR_PATH = ".";
    public static final String ROX_HOME_DIR_CONFIG_FLAG = "rox_home_dir";
    public static final String ROX_WINUTILS_DIR_CONFIG_FLAG = "rox_winutils_dir";
    public static final String ROX_APP_IMPL_DIR_CONFIG_FLAG = "rox_appimpl_dir";
    public static final String ROX_DATA_DIR_CONFIG_FLAG = "rox_data_dir";
    public static final String ROX_CONFIG_DIR_CONFIG_FLAG = "rox_config_dir";
    public static final String ROX_TMP_DIR_CONFIG_FLAG = "rox_tmp_dir";
    public static final String ROX_DATA_DIR_DEFAULT = "data";
    public static final String ROX_CONFIG_DIR_DEFAULT = "config";
    public static final String ROX_TMP_DIR_DEFAULT = "tmp";
    public static final long ROX_TMP_DIR_POSIX_DEFAULT_PERMISSIONS = 511L;
    public static final String DEFAULT_CONFIGURATION_FILE_NAME = "config.properties";
    private static Hashtable sConfigurationFiles = new Hashtable();
    private static Application sApplication;
    private String mHomeDirAbsPath;
    private String mDataDirAbsPath;
    private String mConfigDirAbsPath;
    private String mTmpDirAbsPath;
    private PlatformApplication mPlatform;
    private ClassLoader mAppImplLoader;
    protected volatile boolean mShutdownRequested = false;
    protected volatile boolean mShutdownRequestIsEmergency = false;
    protected Hashtable mConfigurationOverrides = new Hashtable();
    protected boolean mForceExit = false;
    protected BufferedReader mStdinReader;
    protected RoxShutdownHook mShutdownHook;
    private LinkedList mSubsystems = new LinkedList();
    protected String mDefaultConfigurationFileName = null;
    protected String mOverrideConfigurationFileName = null;

    public static Application getApp() {
        return sApplication;
    }

    public PlatformApplication getPlatform() {
        return this.mPlatform;
    }

    public String getApplicationName() {
        return Application.getSubclassName(this.getClass());
    }

    public static String getSubclassName(Class subclass) {
        StringBuffer classToken = new StringBuffer(APP_PREFIX);
        String className = subclass.getName();
        classToken.append(className);
        String humanName = DEFAULT_APPLICATION_NAME;
        String messageNotFoundMessage = ROXMessageManager.messageAsString("messageNotFound");
        humanName = ROXMessageManager.messageAsString(classToken.toString());
        if (messageNotFoundMessage.equals(humanName)) {
            humanName = ROXMessageManager.messageAsString(MSG_UNKNOWN_APPLICATION);
        }
        return humanName;
    }

    public static String getGlobalDefaultConfigurationFileName() {
        return DEFAULT_CONFIGURATION_FILE_NAME;
    }

    public HashSet getCompatibleVersions() {
        return new HashSet<String>(Arrays.asList(this.getRoxVersionNumber()));
    }

    protected Application(String[] inCommandLineArgs) {
        ClassLoader loader = this.getClass().getClassLoader();
        if (loader != null) {
            Thread.currentThread().setContextClassLoader(loader);
        }
        sApplication = this;
        if (this.argsContainsFlag(inCommandLineArgs, HELP_FLAGS)) {
            System.out.println(this.getUsageString());
            System.exit(0);
        }
        if (this.argsContainsFlag(inCommandLineArgs, VERSION_FLAGS)) {
            System.out.println(this.getVersionString());
            System.exit(0);
        }
        if (this.argsContainsFlag(inCommandLineArgs, BUILD_FLAGS)) {
            System.out.println(this.getBuildNumberString());
            System.exit(0);
        }
        if (this.argsContainsFlag(inCommandLineArgs, GENERATE_CONFIG_FLAGS)) {
            try {
                this.generateConfigFiles();
                System.exit(0);
            }
            catch (ConfigurationException ex) {
                System.out.println("Unable to generate config files");
                ex.printStackTrace();
                System.exit(2);
            }
        }
        this.parseCommandLineConfiguration(inCommandLineArgs);
        this.setupHomeAndConfigDirs();
        String logFilePath = this.getConfigDirAbsPath() + File.separator + DEFAULT_LOGGER_FILE_NAME;
        long loggerUpdateDelay = 10L;
        try {
            LoggerSubsystem loggerSubsystem = new LoggerSubsystem(this);
            loggerUpdateDelay = loggerSubsystem.getConfigConfigUpdateDelay();
        }
        catch (ConfigurationException e) {
            System.out.println("Invalid value for  configUpdateDelay using default 10 exception: " + e.getMessage());
        }
        Logger.initializeLoggingSystem(logFilePath, loggerUpdateDelay);
        this.preStartProcessing(inCommandLineArgs);
        if (PlatformUtil.isSolaris()) {
            this.mPlatform = new SolarisPlatformApplication();
        } else if (PlatformUtil.isAix()) {
            this.mPlatform = new AixPlatformApplication();
        } else if (PlatformUtil.isHpux()) {
            this.mPlatform = new HpuxPlatformApplication();
        } else if (PlatformUtil.isLinux()) {
            this.mPlatform = new LinuxPlatformApplication();
        } else if (PlatformUtil.isCygwin()) {
            this.mPlatform = new CygwinPlatformApplication();
        } else if (PlatformUtil.isWin32()) {
            try {
                this.mPlatform = new WindowsPlatformApplication();
            }
            catch (WindowsServicesException ex) {
                if (Logger.isErrorEnabled(Application.class.getName())) {
                    Logger.error(ROXMessageManager.messageAsString(MSG_WINUTILS_ABSENT), ex, Application.class.getName());
                }
                System.exit(2);
            }
        } else {
            if (Logger.isErrorEnabled(Application.class.getName())) {
                Logger.error(ROXMessageManager.messageAsString(MSG_UNSUPPORTED_OS, new Object[]{Platform.LOCAL.toString()}), Application.class.getName());
            }
            System.exit(2);
        }
        this.setupDataAndTmpDirs();
    }

    void addSubsystem(Subsystem subsystem) {
        this.mSubsystems.add(subsystem);
    }

    protected void preStartProcessing(String[] inCommandLineArgs) {
    }

    protected void registerSignalHandlers() {
        if (!this.getPlatform().supportSignals()) {
            return;
        }
        this.mShutdownHook = new RoxShutdownHook(this);
        DoNothingHandler sighup = new DoNothingHandler("SIGHUP");
        try {
            Signal.register(Signal.SIGTERM, this.mShutdownHook);
            Signal.register(Signal.SIGHUP, sighup);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void setupHomeAndConfigDirs() throws IllegalArgumentException {
        String theHomeDirPath = System.getProperty(ROX_HOME_DIR_CONFIG_FLAG);
        if (theHomeDirPath == null) {
            throw new IllegalArgumentException(ROXMessageManager.messageAsString(MSG_APPLICATION_CONFIG_PARAM_MISSING, new Object[]{ROX_HOME_DIR_CONFIG_FLAG}));
        }
        File theHomeDirFile = new File(theHomeDirPath);
        if (!theHomeDirFile.isDirectory()) {
            throw new IllegalArgumentException(ROXMessageManager.messageAsString(MSG_DIR_NOT_VALID, new Object[]{ROX_HOME_DIR_CONFIG_FLAG, theHomeDirPath}));
        }
        this.mHomeDirAbsPath = theHomeDirFile.getAbsolutePath();
        String configDirPath = this.mHomeDirAbsPath + File.separator + ROX_CONFIG_DIR_DEFAULT;
        this.mConfigDirAbsPath = this.getSubDirectoryOverride(ROX_CONFIG_DIR_CONFIG_FLAG, configDirPath, false, 0L);
        if (this.mDefaultConfigurationFileName == null) {
            this.mDefaultConfigurationFileName = this.mConfigDirAbsPath + File.separator + DEFAULT_CONFIGURATION_FILE_NAME;
        }
    }

    private void setupDataAndTmpDirs() throws IllegalArgumentException {
        String dataDirDefault = this.mHomeDirAbsPath + File.separator + ROX_DATA_DIR_DEFAULT;
        this.mDataDirAbsPath = this.getSubDirectoryOverride(ROX_DATA_DIR_CONFIG_FLAG, dataDirDefault, true, 0L);
        String tmpDirDefault = this.mDataDirAbsPath + File.separator + ROX_TMP_DIR_DEFAULT;
        this.mTmpDirAbsPath = this.getSubDirectoryOverride(ROX_TMP_DIR_CONFIG_FLAG, tmpDirDefault, true, 511L);
        System.setProperty("java.io.tmpdir", this.mTmpDirAbsPath);
    }

    private String getSubDirectoryOverride(String inOverideName, String inDefaultFullPath, boolean inCreate, long inPermissions) throws IllegalArgumentException {
        String outFullDirPath;
        String theDirPath = (String)this.mConfigurationOverrides.get(inOverideName);
        if (theDirPath == null || theDirPath.equals("")) {
            theDirPath = System.getProperty(inOverideName);
        }
        File theDirFile = null;
        if (theDirPath != null && !theDirPath.equals("")) {
            theDirFile = new File(theDirPath);
            outFullDirPath = theDirFile.getAbsolutePath();
        } else {
            outFullDirPath = inDefaultFullPath;
            theDirFile = new File(outFullDirPath);
        }
        if (!theDirFile.exists()) {
            if (inCreate) {
                boolean success = theDirFile.mkdir();
                if (inPermissions > 0L && PlatformUtil.isPOSIX()) {
                    RecursiveChmod.change(outFullDirPath, inPermissions, false);
                }
                if (!success) {
                    throw new IllegalArgumentException(ROXMessageManager.messageAsString(MSG_DIR_CANNOT_BE_CREATED, new Object[]{outFullDirPath}));
                }
            } else {
                throw new IllegalArgumentException(ROXMessageManager.messageAsString(MSG_DIR_NOT_VALID, new Object[]{inOverideName, outFullDirPath}));
            }
        }
        if (!theDirFile.isDirectory()) {
            throw new IllegalArgumentException(ROXMessageManager.messageAsString(MSG_DIR_NOT_VALID, new Object[]{inOverideName, outFullDirPath}));
        }
        return outFullDirPath;
    }

    private boolean argsContainsFlag(String[] inArgs, String[] inFlags) {
        if (inArgs == null) {
            return false;
        }
        for (int i = 0; i < inArgs.length; ++i) {
            for (int j = 0; j < inFlags.length; ++j) {
                if (!inArgs[i].equalsIgnoreCase(inFlags[j])) continue;
                return true;
            }
        }
        return false;
    }

    protected String getUsageString() {
        return "Usage:\n   -help              display this message\n   -version           display application version\n   -build             display application build number\n   -generateconfig    generate default configuration files\n                      (files will be created in local directory with .sample extensions)\n   -Dname=value       override configuration variable 'name' with value 'value'\n   -Cconfigfile       override name of default configuration file (file must be in classpath)\n   -Oconfigfile       name of override configuration file (file must be in classpath)";
    }

    protected abstract String getVersionString();

    public String getBuildNumberString() {
        return "20060419020000";
    }

    public void requestShutdown() {
        if (Logger.isInfoEnabled(this)) {
            Logger.info(ROXMessageManager.messageAsString(MSG_REQUESTSHUTDOWN), this);
        }
        this.mShutdownRequested = true;
    }

    public void forceEmergencyShutdown() {
        if (Logger.isInfoEnabled(this)) {
            Logger.info(ROXMessageManager.messageAsString(MSG_REQUESTEMERGENCY), this);
        }
        this.mShutdownRequested = true;
        this.mShutdownRequestIsEmergency = true;
    }

    protected abstract void shutdown() throws RaplixShutdownException;

    public String overrideConfiguration(String inConfigurationTag) {
        String cmdLineCheckValue = (String)this.mConfigurationOverrides.get(inConfigurationTag.toLowerCase());
        if (cmdLineCheckValue != null) {
            return cmdLineCheckValue;
        }
        return null;
    }

    protected void parseCommandLineConfiguration(String[] inCommandLineArgs) throws IllegalArgumentException {
        if (inCommandLineArgs == null) {
            return;
        }
        for (int i = 0; i < inCommandLineArgs.length; ++i) {
            String filename;
            if (inCommandLineArgs[i].startsWith(OVERRIDE_CONFIG_FILENAME_FLAG)) {
                if (inCommandLineArgs[i].length() <= OVERRIDE_CONFIG_FILENAME_FLAG.length()) {
                    System.err.println("Error: -C should be followed by a configuration file name (e.g. \"-Cconfig.properties\")");
                    System.exit(1);
                }
                this.mDefaultConfigurationFileName = filename = inCommandLineArgs[i].substring(OVERRIDE_CONFIG_FILENAME_FLAG.length());
                continue;
            }
            if (inCommandLineArgs[i].startsWith(EXTRA_CONFIG_FILENAME_FLAG)) {
                if (inCommandLineArgs[i].length() <= EXTRA_CONFIG_FILENAME_FLAG.length()) {
                    System.err.println("Error: -O should be followed by a configuration file name (e.g. \"-Oconfig.properties\")");
                    System.exit(1);
                }
                this.mOverrideConfigurationFileName = filename = inCommandLineArgs[i].substring(EXTRA_CONFIG_FILENAME_FLAG.length());
                continue;
            }
            if (!inCommandLineArgs[i].startsWith(OVERRIDE_CONFIG_FLAG)) continue;
            String cmd = inCommandLineArgs[i].substring(2);
            if (cmd.indexOf("=") == -1) {
                throw new IllegalArgumentException("Illegal command line argument: configuration overrides must have form -Dname=value with no whitespace.");
            }
            StringTokenizer st = new StringTokenizer(cmd, "=");
            String name = st.nextToken();
            if (!st.hasMoreTokens()) {
                throw new IllegalArgumentException("Illegal command line argument: configuration overrides must have form -Dname=value with no whitespace.");
            }
            String value = st.nextToken();
            Object existingValue = this.mConfigurationOverrides.get(name = name.toLowerCase());
            if (existingValue != null) {
                throw new IllegalArgumentException("Illegal command line argument: cannot override configuration variable \"" + name + "\" twice.");
            }
            this.mConfigurationOverrides.put(name, value);
        }
    }

    public Hashtable buildDefaultConfigurationFiles() throws ConfigurationException {
        Hashtable ret = new Hashtable();
        this.buildConfigurationFilesForSubsystems(ret);
        return ret;
    }

    public String getDefaultConfigurationFileName() {
        return this.mDefaultConfigurationFileName;
    }

    public String getOverrideConfigurationFileName() {
        return this.mOverrideConfigurationFileName;
    }

    public void closedAllConnections() {
    }

    public void closedMainConnection() {
    }

    protected abstract void buildConfigurationFilesForSubsystems(Hashtable var1) throws ConfigurationException;

    protected void generateConfigFiles() throws ConfigurationException {
        Hashtable files = this.buildDefaultConfigurationFiles();
        Enumeration fileNames = files.keys();
        while (fileNames.hasMoreElements()) {
            String fileName = (String)fileNames.nextElement();
            try {
                String lineSep = System.getProperty("line.separator");
                StringBuffer body = (StringBuffer)files.get(fileName);
                FileWriter out = new FileWriter(fileName + ".sample");
                out.write("# RolloutExpress Configuration File: " + fileName + lineSep);
                out.write("#" + lineSep);
                out.write("# Configuration for " + this.getClass().getName() + " v" + this.getVersionString() + lineSep);
                out.write("# This file was auto-generated at " + new Date().toString() + lineSep);
                out.write(lineSep + lineSep);
                out.write(body.toString());
                out.flush();
                out.close();
            }
            catch (IOException ieox) {
                System.err.println("Unable to write file \"" + fileName + "\" -- skipping.");
            }
        }
    }

    protected void exitProcess(int inExitCode) {
        this.mForceExit = true;
        System.exit(inExitCode);
    }

    public void run() {
        boolean isShutdown = false;
        while (!isShutdown) {
            try {
                while (!this.mShutdownRequested) {
                    Application.sleep(1000L);
                }
            }
            catch (InterruptedException ioex) {
                // empty catch block
            }
            if (!this.mShutdownRequested) continue;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Shutdown request has been received", this);
            }
            try {
                this.shutdown();
                isShutdown = true;
            }
            catch (RaplixShutdownException rse) {
                if (Logger.isErrorEnabled(this)) {
                    Logger.error("Unable to shutdown(" + rse + ")", rse, this);
                }
                if (this.mShutdownRequestIsEmergency) {
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("Emergency shutdown has been requested, shutting down anyway", this);
                    }
                    this.exitProcess(1);
                    break;
                }
                this.mShutdownRequested = false;
            }
        }
        if (this.mShutdownRequestIsEmergency) {
            this.exitProcess(0);
        }
    }

    public RPCInterface getRPCInterface(RoxAddress inAddress, Class interfaceClass) throws RPCException {
        return this.getNetSubsystem().getRPC().getService(inAddress, interfaceClass);
    }

    public RPCInterface getLocalProxiedService(RoxAddress inAddress, Class interfaceClass) throws RPCException {
        return this.getNetSubsystem().getRPC().getLocalProxiedService(inAddress, interfaceClass);
    }

    public String getHomeDirAbsPath() {
        return this.mHomeDirAbsPath;
    }

    public String getConfigDirAbsPath() {
        return this.mConfigDirAbsPath;
    }

    public String getDataDirAbsPath() {
        return this.mDataDirAbsPath;
    }

    public String getTmpDirAbsPath() {
        return this.mTmpDirAbsPath;
    }

    public RoxAddress getLocalNodeAddress() {
        return this.getNetSubsystem().getTransport().getNodeAddress();
    }

    public String getSystemUser() {
        return System.getProperty("user.name");
    }

    public String getRoxBuildNumber() {
        return "20060419020000";
    }

    public String getRoxVersionNumber() {
        return this.getVersionString();
    }

    public final String getConfiguration(String inConfigurationTag) throws ConfigurationException {
        return this.getConfiguration(inConfigurationTag, null);
    }

    String getConfiguration(String inConfigurationTag, Subsystem inSubsystem) throws ConfigurationException {
        ConfigurationFile configFile;
        String prefixedTag = Application.getPrefixedPropertyName(inConfigurationTag = inConfigurationTag.toLowerCase(), inSubsystem);
        String overrideCheck = this.overrideConfiguration(prefixedTag);
        if (overrideCheck != null) {
            return overrideCheck;
        }
        String returnValue = null;
        String overrideConfigFilename = this.getOverrideConfigurationFileName();
        if (overrideConfigFilename != null && (configFile = Application.lookupConfigurationFile(overrideConfigFilename)) != null) {
            returnValue = configFile.get(prefixedTag);
        }
        if (returnValue == null) {
            configFile = null;
            configFile = inSubsystem != null ? Application.lookupConfigurationFile(inSubsystem.getConfigurationFileName()) : Application.lookupConfigurationFile(this.getDefaultConfigurationFileName());
            if (configFile != null) {
                returnValue = configFile.get(prefixedTag);
            }
        }
        if (inSubsystem != null && returnValue == null) {
            returnValue = inSubsystem.getDefaultConfiguration(inConfigurationTag);
        }
        return returnValue;
    }

    protected static String getPrefixedPropertyName(String inPropertyName, Subsystem inSubsystem) {
        String prefix = inSubsystem == null ? "app" : inSubsystem.getConfigurationPropertyPrefix();
        if (prefix == null) {
            prefix = "";
        }
        if ((prefix = prefix.toLowerCase()) != null && prefix.length() > 0 && !prefix.endsWith(DEFAULT_HOME_DIR_PATH)) {
            prefix = prefix + '.';
        }
        return prefix + inPropertyName;
    }

    public NotificationManager getNotificationManager() throws UnsupportedSubsystemException {
        throw new UnsupportedSubsystemException(ERROR_NO_NOTIFICATION);
    }

    public ConfigGenSubsystem getConfigGenSubsystem() throws UnsupportedSubsystemException {
        throw new UnsupportedSubsystemException(ERROR_NO_CONFIGGEN_SUBSYSTEM);
    }

    public InstallDBSubsystem getInstallDBSubsystem() throws UnsupportedSubsystemException {
        throw new UnsupportedSubsystemException(ERROR_NO_INSTALLDB_SUBSYSTEM);
    }

    public UserDBSubsystem getUserDBSubsystem() throws UnsupportedSubsystemException {
        throw new UnsupportedSubsystemException(ERROR_NO_USERDB_SUBSYSTEM);
    }

    public DifferenceDB getDiffDBSubsystem() throws UnsupportedSubsystemException {
        throw new UnsupportedSubsystemException(ERROR_NO_DIFF_SUBSYSTEM);
    }

    public RemoteUserDBSubsystem getRemoteUserDBSubsystem() throws UnsupportedSubsystemException {
        throw new UnsupportedSubsystemException(ERROR_NO_REMOTE_USERDB_SUBSYSTEM);
    }

    public NativePlatformIntegration getNativeSubsystem() throws UnsupportedSubsystemException {
        throw new UnsupportedSubsystemException(ERROR_NO_NATIVE);
    }

    public SnapshotServices getSnapshotServices() throws UnsupportedSubsystemException {
        throw new UnsupportedSubsystemException(ERROR_NO_SNAPSHOT_SUBSYSTEM);
    }

    public abstract NetSubsystem getNetSubsystem();

    public HostDBSubsystem getHostDBSubsystem() throws UnsupportedSubsystemException {
        throw new UnsupportedSubsystemException(ERROR_NO_HOSTDB);
    }

    public PersistenceManager getPMSubsystem() throws UnsupportedSubsystemException {
        throw new UnsupportedSubsystemException(ERROR_NO_PERSISTENCE_MANAGER);
    }

    public PlanSubsystem getPlanSubsystem() throws UnsupportedSubsystemException {
        throw new UnsupportedSubsystemException(ERROR_NO_PLAN);
    }

    public DifferenceEngine getDiffEngineSubsystem() throws UnsupportedSubsystemException {
        throw new UnsupportedSubsystemException(ERROR_NO_DIFF_ENGINE);
    }

    public ResourceSubsystem getResourceSubsystem() throws UnsupportedSubsystemException {
        throw new UnsupportedSubsystemException(ERROR_NO_RESOURCE);
    }

    public NodeSubsystem getNodeSubsystem() throws UnsupportedSubsystemException {
        throw new UnsupportedSubsystemException(ERROR_NO_NODE);
    }

    public NodeAdminSubsystem getNodeAdminSubsystem() throws UnsupportedSubsystemException {
        throw new UnsupportedSubsystemException(ERROR_NO_NODE_ADMIN);
    }

    public PluginDBSubsystem getPluginDBSubsystem() throws UnsupportedSubsystemException {
        throw new UnsupportedSubsystemException(ERROR_NO_PLUGINDB);
    }

    public boolean isShutdownRequested() {
        return this.mShutdownRequested;
    }

    public boolean isEmergencyShutdownRequested() {
        return this.mShutdownRequestIsEmergency;
    }

    public boolean forceExit() {
        return this.mForceExit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConfigurationFile lookupConfigurationFile(String inConfigFileName) {
        ConfigurationFile ret = (ConfigurationFile)sConfigurationFiles.get(inConfigFileName);
        if (ret != null) {
            return ret;
        }
        Hashtable hashtable = sConfigurationFiles;
        synchronized (hashtable) {
            try {
                ret = new ConfigurationFile(inConfigFileName);
                sConfigurationFiles.put(inConfigFileName, ret);
                return ret;
            }
            catch (ConfigurationException ce) {
                return null;
            }
        }
    }

    public String promptForInput(String[] inPrompts) throws IOException {
        if (this.mStdinReader == null) {
            this.mStdinReader = new BufferedReader(new InputStreamReader(System.in));
        }
        for (int i = 0; i < inPrompts.length; ++i) {
            System.err.println(inPrompts[i]);
        }
        System.err.flush();
        return this.mStdinReader.readLine();
    }

    public void quitService(String[] args) {
        if (this.getPlatform() != null && !this.getPlatform().supportJavaService()) {
            return;
        }
        this.requestShutdown();
    }

    public static void quitGlobal(String[] args) {
        Application.getApp().quitService(args);
    }

    public Properties getCurrentConfiguration() throws ConfigurationException {
        Properties config = new Properties();
        Iterator subsystems = this.mSubsystems.iterator();
        while (subsystems.hasNext()) {
            HashMap configMap = ((Subsystem)subsystems.next()).getCurrentConfiguration();
            config.putAll((Map<?, ?>)configMap);
        }
        config.put(ROX_HOME_DIR_CONFIG_FLAG, this.getHomeDirAbsPath());
        config.put(ROX_CONFIG_DIR_CONFIG_FLAG, this.getConfigDirAbsPath());
        config.put(ROX_DATA_DIR_CONFIG_FLAG, this.getDataDirAbsPath());
        config.put(ROX_TMP_DIR_CONFIG_FLAG, this.getTmpDirAbsPath());
        return config;
    }

    public synchronized ClassLoader getAppImplClassLoader() throws IOException {
        if (this.mAppImplLoader == null) {
            File libDir;
            String homeDir = System.getProperty(ROX_HOME_DIR_CONFIG_FLAG);
            String soapDir = System.getProperty(ROX_APP_IMPL_DIR_CONFIG_FLAG);
            if (soapDir != null) {
                homeDir = soapDir;
            }
            if (!((libDir = new File(new File(new File(homeDir, "lib"), "platform"), "common").getCanonicalFile()).exists() && libDir.isDirectory() || !Logger.isErrorEnabled(Application.class))) {
                Logger.error(libDir + " is not a valid installation directory", Application.class);
            }
            this.mAppImplLoader = ClassLoaderFactory.createLoader(libDir, Application.class.getClassLoader());
        }
        return this.mAppImplLoader;
    }

    protected class DoNothingHandler
    implements SignalHandler {
        protected String mLabel;

        protected DoNothingHandler(String inLabel) {
            this.mLabel = inLabel;
        }

        public void handle(long s) {
            if (Logger.isInfoEnabled(this)) {
                Logger.info(ROXMessageManager.messageAsString(Application.MSG_SIGNAL_IGNORED, new Object[]{this.mLabel, new Long(s)}), this);
            }
        }
    }
}

