/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.RaplixShutdownException;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.command.NativePlatformIntegration;
import com.raplix.rolloutexpress.command.impl.FileOperationsImpl;
import com.raplix.rolloutexpress.command.impl.MEMIXImpl;
import com.raplix.rolloutexpress.command.impl.SnapshotImpl;
import com.raplix.rolloutexpress.command.rpcinterfaces.FileOperationsInterface;
import com.raplix.rolloutexpress.command.rpcinterfaces.MEMIXInterface;
import com.raplix.rolloutexpress.command.rpcinterfaces.SnapshotServices;
import com.raplix.rolloutexpress.command.rpcinterfaces.ToolsInterface;
import com.raplix.rolloutexpress.command.stickydata.StickyInterface;
import com.raplix.rolloutexpress.command.stickydata.StickySubsystem;
import com.raplix.rolloutexpress.difference.DifferenceAgentEngine;
import com.raplix.rolloutexpress.event.NotificationManager;
import com.raplix.rolloutexpress.hierarchies.HierarchyBrowserLoaderSubsystem;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.node.NodeSubsystem;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBSubsystem;
import com.raplix.util.filecache.FileCache;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.util.Hashtable;

public class Agent
extends Application {
    protected NativePlatformIntegration mNativePlatformIntegration;
    protected NetSubsystem mNet;
    protected FileOperationsInterface mFileImpl;
    protected ToolsInterface mToolsImpl;
    protected SnapshotServices mSnapshotImpl;
    protected ResourceSubsystem mResourceSubsystem;
    protected HierarchyBrowserLoaderSubsystem mHierarchySubsystem;
    protected DifferenceAgentEngine mDiffAgentEngine;
    protected NotificationManager mNotificationManager;
    protected NodeSubsystem mNodeSubsystem;
    protected static final String MSG_UNSUPPORTED_OS = "app.UNSUPPORTED_OS";
    protected MEMIXImpl mMEMIXImpl;
    protected StickySubsystem mStickySubsystem;
    private FileCache mExecJavaFileCache;

    public static void main(String[] args) {
        Agent theAgent = null;
        try {
            theAgent = Agent.createAgent(args);
            theAgent.start();
        }
        catch (Exception e) {
            System.out.println("Unable to start Agent: " + e.toString());
            if (Logger.isErrorEnabled("Agent")) {
                Logger.error(e.toString(), e, "Agent");
            }
            if (theAgent != null) {
                theAgent.exitProcess(2);
            }
            System.exit(2);
        }
    }

    public static Agent createAgent(String[] args) throws ConfigurationException {
        Agent theAgent = new Agent(args);
        theAgent.mNet = NetSubsystem.createNetSubsystemForNode(theAgent);
        theAgent.initSubsystems();
        return theAgent;
    }

    protected Agent(String[] inCommandLineArgs) throws ConfigurationException {
        super(inCommandLineArgs);
        this.registerSignalHandlers();
    }

    protected void initSubsystems() throws ConfigurationException {
        this.mStickySubsystem = new StickySubsystem(this);
        this.mNotificationManager = new NotificationManager((Application)this, false);
        this.mResourceSubsystem = new ResourceSubsystem(this);
        this.mHierarchySubsystem = new HierarchyBrowserLoaderSubsystem(this);
        this.mNativePlatformIntegration = this.createNativeSubsystem(this);
        this.mNodeSubsystem = new NodeSubsystem(this);
        try {
            this.mDiffAgentEngine = new DifferenceAgentEngine(this);
            this.mFileImpl = new FileOperationsImpl(this);
            this.mMEMIXImpl = new MEMIXImpl(this);
            this.mToolsImpl = this.getPlatform().createTools(this);
            this.mSnapshotImpl = new SnapshotImpl(this);
        }
        catch (UnsupportedSubsystemException ex) {
            throw new ConfigurationException("Unable to create FileOperations impl", (Throwable)ex);
        }
        RPCManager theRPC = this.mNet.getRPC();
        try {
            this.mNet.registerRPCInterfaces(theRPC);
            theRPC.registerService(StickyInterface.class, this.mStickySubsystem);
            this.mNativePlatformIntegration.registerRPCInterfaces(theRPC);
            theRPC.registerService(FileOperationsInterface.class, this.mFileImpl);
            theRPC.registerService(MEMIXInterface.class, this.mMEMIXImpl);
            theRPC.registerService(ToolsInterface.class, this.mToolsImpl);
            theRPC.registerService(SnapshotServices.class, this.mSnapshotImpl);
            this.mResourceSubsystem.registerRPCInterfaces(theRPC);
            HostDBSubsystem.registerAgentServices(theRPC, this);
            this.mHierarchySubsystem.registerRPCInterfaces(theRPC);
            this.mNodeSubsystem.registerRPCInterfaces(theRPC);
        }
        catch (RPCException rpce) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Error registering interfaces", rpce, this);
            }
            throw new ConfigurationException("Error registering RPC interfaces", (Throwable)rpce);
        }
        this.mNet.postInit();
        File execJavaCacheRoot = new File(this.getDataDirAbsPath(), "execJavaCache");
        File execJavaLibRsrcCacheRoot = new File(this.getDataDirAbsPath(), "execJavaLibCache");
        this.mExecJavaFileCache = new FileCache(execJavaCacheRoot, execJavaLibRsrcCacheRoot, "ejfc", ".jar");
    }

    protected void shutdown() throws RaplixShutdownException {
        block44: {
            block43: {
                block42: {
                    block41: {
                        block40: {
                            block39: {
                                block38: {
                                    block37: {
                                        block36: {
                                            block35: {
                                                block34: {
                                                    block33: {
                                                        block32: {
                                                            block31: {
                                                                block30: {
                                                                    try {
                                                                        this.mNodeSubsystem.prepareForShutdown();
                                                                    }
                                                                    catch (RaplixShutdownException rse) {
                                                                        if (this.mShutdownRequestIsEmergency) break block30;
                                                                        throw new RaplixShutdownException("Cannot shutdown: NodeSubsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                                                    }
                                                                }
                                                                try {
                                                                    this.mHierarchySubsystem.prepareForShutdown();
                                                                }
                                                                catch (RaplixShutdownException rse) {
                                                                    if (this.mShutdownRequestIsEmergency) break block31;
                                                                    throw new RaplixShutdownException("Cannot shutdown: HierarchyBrowserSubsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                                                }
                                                            }
                                                            try {
                                                                this.mDiffAgentEngine.prepareForShutdown();
                                                            }
                                                            catch (RaplixShutdownException rse) {
                                                                if (this.mShutdownRequestIsEmergency) break block32;
                                                                throw new RaplixShutdownException("Cannot shutdown: Diff subsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                                            }
                                                        }
                                                        try {
                                                            this.mNativePlatformIntegration.prepareForShutdown();
                                                        }
                                                        catch (RaplixShutdownException rse) {
                                                            if (this.mShutdownRequestIsEmergency) break block33;
                                                            throw new RaplixShutdownException("Cannot shutdown: network subsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                                        }
                                                    }
                                                    try {
                                                        this.mResourceSubsystem.prepareForShutdown();
                                                    }
                                                    catch (RaplixShutdownException rse) {
                                                        if (this.mShutdownRequestIsEmergency) break block34;
                                                        throw new RaplixShutdownException("Cannot shutdown: Resource subsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                                    }
                                                }
                                                try {
                                                    this.mNotificationManager.prepareForShutdown();
                                                }
                                                catch (RaplixShutdownException rse) {
                                                    if (this.mShutdownRequestIsEmergency) break block35;
                                                    throw new RaplixShutdownException("Cannot shutdown: notification manager cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                                }
                                            }
                                            try {
                                                this.mNet.prepareForShutdown();
                                            }
                                            catch (RaplixShutdownException rse) {
                                                if (this.mShutdownRequestIsEmergency) break block36;
                                                throw new RaplixShutdownException("Cannot shutdown: network subsystem cannot be prepared for shutdown.  Specific error: " + rse.getMessage());
                                            }
                                        }
                                        this.mStickySubsystem.prepareForShutdown();
                                        try {
                                            this.mNodeSubsystem.shutdown();
                                        }
                                        catch (RaplixShutdownException rse) {
                                            if (this.mShutdownRequestIsEmergency) break block37;
                                            throw new RaplixShutdownException("Cannot shutdown: NodeSubsystem cannot shutdown.  Specific error: " + rse.getMessage());
                                        }
                                    }
                                    try {
                                        this.mHierarchySubsystem.shutdown();
                                    }
                                    catch (RaplixShutdownException rse) {
                                        if (this.mShutdownRequestIsEmergency) break block38;
                                        throw new RaplixShutdownException("Cannot shutdown: HierarchyBrowserSubsystem cannot shutdown.  Specific error: " + rse.getMessage());
                                    }
                                }
                                try {
                                    this.mNativePlatformIntegration.shutdown();
                                }
                                catch (RaplixShutdownException rse) {
                                    if (this.mShutdownRequestIsEmergency) break block39;
                                    throw new RaplixShutdownException("Cannot shutdown: network subsystem cannot shutdown.  Specific error: " + rse.getMessage());
                                }
                            }
                            try {
                                this.mDiffAgentEngine.shutdown();
                            }
                            catch (RaplixShutdownException rse) {
                                if (this.mShutdownRequestIsEmergency) break block40;
                                throw new RaplixShutdownException("Cannot shutdown: diff subsystem cannot shutdown.  Specific error: " + rse.getMessage());
                            }
                        }
                        try {
                            this.mResourceSubsystem.shutdown();
                        }
                        catch (RaplixShutdownException rse) {
                            if (this.mShutdownRequestIsEmergency) break block41;
                            throw new RaplixShutdownException("Cannot shutdown: Resource subsystem cannot shutdown.  Specific error: " + rse.getMessage());
                        }
                    }
                    try {
                        this.mNotificationManager.shutdown();
                    }
                    catch (RaplixShutdownException rse) {
                        if (this.mShutdownRequestIsEmergency) break block42;
                        throw new RaplixShutdownException("Cannot shutdown: notification manager cannot shutdown.  Specific error: " + rse.getMessage());
                    }
                }
                try {
                    this.mNet.shutdown();
                }
                catch (RaplixShutdownException rse) {
                    if (this.mShutdownRequestIsEmergency) break block43;
                    throw new RaplixShutdownException("Cannot shutdown: network subsystem cannot shutdown.  Specific error: " + rse.getMessage());
                }
            }
            try {
                this.mStickySubsystem.shutdown();
            }
            catch (RaplixShutdownException rse) {
                if (this.mShutdownRequestIsEmergency) break block44;
                throw new RaplixShutdownException("Cannot shutdown: sticky data subsystem cannot shutdown.  Specific error: " + rse.getMessage());
            }
        }
    }

    protected NativePlatformIntegration createNativeSubsystem(Application inApp) throws ConfigurationException {
        return this.getPlatform().createNativeSubsystem(inApp);
    }

    protected Class getNativeIntegrationClass() {
        return this.getPlatform().getNativeIntegrationClass();
    }

    protected String getVersionString() {
        return "5.2.1";
    }

    protected void buildConfigurationFilesForSubsystems(Hashtable inTable) throws ConfigurationException {
        Subsystem.addConfigurationForSubsystem(inTable, StickySubsystem.class);
        Subsystem.addConfigurationForSubsystem(inTable, NetSubsystem.class);
        Subsystem.addConfigurationForSubsystem(inTable, this.getNativeIntegrationClass());
        Subsystem.addConfigurationForSubsystem(inTable, ResourceSubsystem.class);
        Subsystem.addConfigurationForSubsystem(inTable, DifferenceAgentEngine.class);
        Subsystem.addConfigurationForSubsystem(inTable, NodeSubsystem.class);
    }

    public NativePlatformIntegration getNativeSubsystem() throws UnsupportedSubsystemException {
        if (this.mNativePlatformIntegration == null) {
            throw new UnsupportedSubsystemException("Native susbsystem is null");
        }
        return this.mNativePlatformIntegration;
    }

    public NetSubsystem getNetSubsystem() {
        return this.mNet;
    }

    public ResourceSubsystem getResourceSubsystem() {
        return this.mResourceSubsystem;
    }

    public DifferenceAgentEngine getDiffAgentEngine() {
        return this.mDiffAgentEngine;
    }

    public NotificationManager getNotificationManager() {
        return this.mNotificationManager;
    }

    public NodeSubsystem getNodeSubsystem() throws UnsupportedSubsystemException {
        return this.mNodeSubsystem;
    }

    public MEMIXImpl getMEMIXSubsystem() {
        return this.mMEMIXImpl;
    }

    public StickySubsystem getStickySubsystem() {
        return this.mStickySubsystem;
    }

    public SnapshotServices getSnapshotServices() {
        return this.mSnapshotImpl;
    }

    public FileCache getExecJavaFileCache() {
        return this.mExecJavaFileCache;
    }
}

