<%--
    Copyright (c) 2006 Sun Microsystems, Inc. All rights reserved
    SUN PROPRIETARY/CONFIDENTIAL.
    Use is subject to license terms.
--%>


<%@ page import="com.iplanet.am.util.Debug" %>
<%@ page import="com.iplanet.sso.SSOToken" %>
<%@ page import="com.sun.identity.saml2.common.SAML2Utils" %>
<%@ page import="com.sun.identity.saml2.common.SAML2Constants" %>
<%@ page import="com.sun.identity.saml2.common.SAML2Exception" %>
<%@ page import="com.sun.identity.saml2.profile.LogoutUtil" %>
<%@ page import="com.sun.identity.saml2.profile.SPSingleLogout" %>
<%@ page import="java.util.HashMap" %>

<%--
    spSingleLogoutInit.jsp 
    - initiates the LogoutRequest at the Service Provider.    
        
    Required parameters to this jsp are :
    - binding - binding used for this request
       
    Some of the other optional parameters are :
    "RelayState" - the target URL on successful Single Logout
    "Destination" - A URI Reference indicating the address to 
                    which the request has been sent.
    "Consent" - Specifies a URI a SAML defined identifier
                known as Consent Identifiers.
    "Extension" - Specifies a list of Extensions as list of 
                  String objects.
    
    Check the SAML2 Documentation for supported parameters.    
--%>
<html>

<head>
    <title>SAMLv2 Single Logout Initiation at SP</title>
</head>
<body bgcolor="#FFFFFF" text="#000000">

<%
    // Retrieves the Request Query Parameters 
    // Binding are the required query parameters
    // binding - binding used for this request
    
    try {
        String RelayState = request.getParameter(SAML2Constants.RELAY_STATE);

        SSOToken ssoToken = SAML2Utils.getSSOToken(request);
        if (ssoToken == null) {
            response.sendError(response.SC_BAD_REQUEST,
                SAML2Utils.bundle.getString("nullSSOToken"));
            return;
        }
        String metaAlias = 
        	ssoToken.getProperty(SAML2Constants.SP_METAALIAS);
        if (metaAlias == null) {
            SAML2Utils.destroySession(ssoToken);
            if (RelayState != null) {
                response.sendRedirect(RelayState);
            } else {            
		%>
                <jsp:forward page="/saml2/jsp/default.jsp?message=spSloSuccess"/>
                <%
            }
            return;
        }
        	    
        String idpEntityID = request.getParameter("idpEntityID");

        if ((idpEntityID == null) || (idpEntityID.length() == 0)) {
            response.sendError(response.SC_BAD_REQUEST,
			   SAML2Utils.bundle.getString("nullIDPEntityID"));
            return;
        }

	String binding = LogoutUtil.getSLOBindingInfo(request, metaAlias,
	                                SAML2Constants.SP_ROLE, idpEntityID);
        /**
        * Parses the request parameters and builds the Logout
        * Request to be sent to the IDP.
        *
        * @param request the HttpServletRequest.
        * @param response the HttpServletResponse.
        * @param metaAlias metaAlias of Service Provider. The format of
        *               this parameter is /realm_name/SP_name.
        * @param binding binding used for this request.
        * @param paramsMap Map of all other parameters.
        *       Following parameters names with their respective
        *       String values are allowed in this paramsMap.
        *       "RelayState" - the target URL on successful Single Logout
        *       "Destination" - A URI Reference indicating the address to 
        *                       which the request has been sent.
        *       "Consent" - Specifies a URI a SAML defined identifier
        *                   known as Consent Identifiers.
        *       "Extension" - Specifies a list of Extensions as list of 
        *                   String objects.
        * @throws SAML2Exception if error initiating request to IDP.
        */
        HashMap paramsMap = new HashMap();
        paramsMap.put("metaAlias", metaAlias);
        paramsMap.put("idpEntityID", idpEntityID);
        paramsMap.put(SAML2Constants.ROLE, SAML2Constants.SP_ROLE);
        paramsMap.put(SAML2Constants.BINDING, binding);
        paramsMap.put("Destination", request.getParameter("Destination"));
        paramsMap.put("Consent", request.getParameter("Consent"));
        paramsMap.put("Extension", request.getParameter("Extension"));
        if (RelayState != null) {
            paramsMap.put(SAML2Constants.RELAY_STATE, RelayState);
        }
        
        SPSingleLogout.initiateLogoutRequest(request,response,
            binding,paramsMap);
        if (binding.equalsIgnoreCase(SAML2Constants.SOAP)) {
            if (RelayState != null) {
                response.sendRedirect(RelayState);
            } else {            
		%>
                <jsp:forward page="/saml2/jsp/default.jsp?message=spSloSuccess"/>
                <%
            }
        }        
    } catch (SAML2Exception sse) {
        SAML2Utils.debug.error("Error sending Logout Request " , sse);
        response.sendError(response.SC_BAD_REQUEST,
                 SAML2Utils.bundle.getString("LogoutRequestCreationError"));
        return;
    } catch (Exception e) {
        SAML2Utils.debug.error("Error initializing Request ",e);
        response.sendError(response.SC_BAD_REQUEST,
                 SAML2Utils.bundle.getString("LogoutRequestCreationError"));
        return;
    }
%>

</body>
</html>
