<%--
    Copyright (c) 2006 Sun Microsystems, Inc. All rights reserved
    SUN PROPRIETARY/CONFIDENTIAL.
    Use is subject to license terms.
--%>


<%@ page import="com.iplanet.am.util.Debug" %>
<%@ page import="com.iplanet.sso.SSOToken" %>
<%@ page import="com.sun.identity.saml2.common.SAML2Constants" %>
<%@ page import="com.sun.identity.saml2.common.SAML2Utils" %>
<%@ page import="com.sun.identity.saml2.common.SAML2Exception" %>
<%@ page import="com.sun.identity.saml2.profile.DoManageNameID" %>
<%@ page import="java.util.HashMap" %>

<%--
    idpMNIRequestInit.jsp initiates the ManageNameIDRequest at 
    the Identity Provider.
    Required parameters to this jsp are :
    - metaAlias - identifier for Service Provider
    - idpEntityID - identifier for Identity Provider
    - requestType - the request type of ManageNameIDRequest (Terminate / NewID)
    
    Somce of the other optional parameters are :
    - relayState - the target URL on successful complete of the Request

    Check the SAML2 Documentation for supported parameters.
    
--%>
<html>

<head>
<title>SAMLv2 SP ManageNameIDRequest Initiation JSP</title>
</head>
<body bgcolor="#FFFFFF" text="#000000">

<%
    // Retreive the Request Query Parameters 
    // metaAlias, idpEntiyID and RequestType are the required query parameters
    // metaAlias - Hosted Entity Id 
    // idpEntityID - Identity Provider Identifier
    // requestType - the request type of ManageNameIDRequest (Terminate / NewID)
    // Query parameters supported will be documented.
    try {
	String metaAlias = request.getParameter("metaAlias");
        if ((metaAlias ==  null) || (metaAlias.length() == 0)) {
            response.sendError(response.SC_BAD_REQUEST,
		           SAML2Utils.bundle.getString("nullIDPEntityID"));
            return;
        }
         
        String idpEntityID = request.getParameter("idpEntityID");

        if ((idpEntityID == null) || (idpEntityID.length() == 0)) {
            response.sendError(response.SC_BAD_REQUEST,
			   SAML2Utils.bundle.getString("nullIDPEntityID"));
            return;
        }
        
        String requestType = request.getParameter("requestType");

        if ((requestType == null) || (requestType.length() == 0)) {
            response.sendError(response.SC_BAD_REQUEST,
			   SAML2Utils.bundle.getString("nullRequestType"));
            return;
        }

        String RelayState = request.getParameter(SAML2Constants.RELAY_STATE);
	String binding = DoManageNameID.getMNIBindingInfo(request, metaAlias,
	                                SAML2Constants.SP_ROLE, idpEntityID);

        HashMap paramsMap = new HashMap();
        paramsMap.put("metaAlias", metaAlias);
        paramsMap.put("idpEntityID", idpEntityID);
        paramsMap.put("requestType", requestType);
        paramsMap.put(SAML2Constants.ROLE, SAML2Constants.SP_ROLE);
        paramsMap.put(SAML2Constants.BINDING, binding);

        if (RelayState != null) {
            paramsMap.put(SAML2Constants.RELAY_STATE, RelayState);
        }
        
        SSOToken ssoToken = SAML2Utils.checkSSOToken(request,response,
	                                  metaAlias, paramsMap);
	if (ssoToken == null) {
	    return;
	}
	
	DoManageNameID.initiateManageNameIDRequest(request,response,
	                                  metaAlias, idpEntityID, paramsMap);

        if (binding.equalsIgnoreCase(SAML2Constants.SOAP)) {
            if (RelayState != null) {
                response.sendRedirect(RelayState);
            } else {            
		%>
                <jsp:forward page="/saml2/jsp/default.jsp?message=mniSuccess" />
                <%
            }
        }        
    } catch (SAML2Exception e) {
	SAML2Utils.debug.error("Error sending ManageNameIDRequest " , e);
	response.sendError(response.SC_BAD_REQUEST,
		SAML2Utils.bundle.getString("requestProcessingMNIError"));
    }
%>

</body>
</html>
