<%--
    Copyright (c) 2006 Sun Microsystems, Inc. All rights reserved
    SUN PROPRIETARY/CONFIDENTIAL.
    Use is subject to license terms.
--%>


<%@ page import="com.iplanet.am.util.Debug" %>
<%@ page import="com.sun.identity.saml2.common.SAML2Constants" %>
<%@ page import="com.sun.identity.saml2.common.SAML2Utils" %>
<%@ page import="com.sun.identity.saml2.common.SAML2Exception" %>
<%@ page import="com.sun.identity.saml2.profile.DoManageNameID" %>
<%@ page import="java.util.HashMap" %>

<%--
    spMNIHTTPRedirect.jsp processes the ManageNameIDRequest from 
    the Service Provider with HttpRedirect binding.
    Required parameters to this jsp are : NONE
--%>
<html>

<head>
<title>SAMLv2 SP ManageNameIDRequest Process JSP with HttpRedirect binding</title>
</head>
<body bgcolor="#FFFFFF" text="#000000">
<%
    try {
        HashMap paramsMap = new HashMap();
        paramsMap.put(SAML2Constants.ROLE, SAML2Constants.SP_ROLE);
	String samlRequest =
		request.getParameter(SAML2Constants.SAML_REQUEST);
		
        String samlResponse =
		request.getParameter(SAML2Constants.SAML_RESPONSE);
		
        if (samlRequest != null) {
	    DoManageNameID.processHttpRequest(request, response, paramsMap);
	}
	
        if (samlResponse != null) {
	    boolean success = DoManageNameID.processManageNameIDResponse(
                                              request, response, paramsMap);
            if (success == true) {
	        String relayState =
		    request.getParameter(SAML2Constants.RELAY_STATE);
                if (relayState != null) {
                    response.sendRedirect(relayState);
                } else {
		    %>
                    <jsp:forward
			page="/saml2/jsp/default.jsp?message=mniSuccess" />
                    <%
                }                
            } else {
	        response.sendError(response.SC_BAD_REQUEST,
		  SAML2Utils.bundle.getString("requestProcessingMNIError"));
            }
	}
    } catch (SAML2Exception e) {
	SAML2Utils.debug.error("Error processing ManageNameIDRequest " , e);
	response.sendError(response.SC_BAD_REQUEST,
		SAML2Utils.bundle.getString("requestProcessingMNIError"));
    }
%>

</body>
</html>
