<%--
    Copyright (c) 2006 Sun Microsystems, Inc. All rights reserved
    SUN PROPRIETARY/CONFIDENTIAL.
    Use is subject to license terms.
--%>



<%@page
import="com.iplanet.am.util.AMURLEncDec,
com.iplanet.sso.SSOToken,
com.sun.identity.authentication.AuthContext,
com.sun.identity.federation.common.FSUtils,
com.sun.identity.saml.common.SAMLUtils,
com.sun.identity.saml2.common.SAML2Constants,
com.sun.identity.saml2.common.SAML2Exception,
com.sun.identity.saml2.common.SAML2Utils,
com.sun.identity.saml2.meta.SAML2MetaException,
com.sun.identity.saml2.meta.SAML2MetaManager,
com.sun.identity.saml2.meta.SAML2MetaUtils,
com.sun.identity.saml2.profile.ResponseInfo,
com.sun.identity.saml2.profile.SPACSUtils,
com.sun.identity.saml2.protocol.Response
"
%>

<html>
<head>
    <title>SP Assertion Consumer Service</title>
</head>

<%!
    private String getLocalLoginUrl(
				String orgName,
				String hostEntityId,
				SAML2MetaManager metaManager,
				ResponseInfo respInfo,
				String requestURL,
				String relayState)
    {
	String localLoginUrl = SPACSUtils.prepareForLocalLogin(
		orgName, hostEntityId, metaManager, respInfo, requestURL);
	if (localLoginUrl.indexOf("?") == -1) {
            localLoginUrl += "?goto=";
        } else {
            localLoginUrl += "&goto=";
        }
        String gotoURL = requestURL + "?resID="
			+ AMURLEncDec.encode(respInfo.getResponse().getID());
        if (relayState != null && relayState.length() != 0) {
                gotoURL += "&RelayState=" + AMURLEncDec.encode(relayState);
        }
        localLoginUrl += AMURLEncDec.encode(gotoURL);
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("spAssertionConsumer.jsp: local login "
			+ "url=" + localLoginUrl);
        } 
	return localLoginUrl;
    }
%>

<body>
<%
    // check request, response, content length
    if ((request == null) || (response == null)) {
	response.sendError(response.SC_BAD_REQUEST,
			SAML2Utils.bundle.getString("nullInput"));
	return;
    }
    // to avoid dos attack
    // or use SAML2Utils?
    try {
	SAMLUtils.checkHTTPContentLength(request);
    } catch (ServletException se) {
	response.sendError(response.SC_BAD_REQUEST, se.getMessage());
	return;
    }

    String requestURL = request.getRequestURL().toString();
    // get entity id and orgName
    String metaAlias = SAML2MetaUtils.getMetaAliasByUri(requestURL);
    SAML2MetaManager metaManager = SAML2Utils.getSAML2MetaManager();
    if (metaManager == null) {
	// logging?
	response.sendError(response.SC_INTERNAL_SERVER_ERROR,
			SAML2Utils.bundle.getString("errorMetaManager"));
	return;
    }
    String hostEntityId = null;
    try {
        hostEntityId = metaManager.getEntityByMetaAlias(metaAlias);
    } catch (SAML2MetaException sme) {
	// logging?
	response.sendError(response.SC_INTERNAL_SERVER_ERROR,
			SAML2Utils.bundle.getString("metaDataError"));
	return;
    }
    if (hostEntityId == null) {
	// logging?
	response.sendError(response.SC_INTERNAL_SERVER_ERROR,
			SAML2Utils.bundle.getString("metaDataError"));
	return;
    }

    String orgName = SAML2MetaUtils.getRealmByMetaAlias(metaAlias);
    if (orgName == null || orgName.length() == 0) {
	orgName = "/";
    }

    String relayState = request.getParameter(SAML2Constants.RELAY_STATE);
    // federate flag
    String federate = request.getParameter(SAML2Constants.FEDERATE);
    try {
	ResponseInfo respInfo = SPACSUtils.getResponse(request, response,
					orgName, hostEntityId, metaManager);
	SSOToken token = SAML2Utils.getSSOToken(request);
	if (federate != null && federate.trim().equals("true") && token == null)
	{
	    if (SAML2Utils.debug.messageEnabled()) {
		SAML2Utils.debug.message("spAssertionConsumer.jsp: federate "
		    + "is true, and token is null. do local login first.");
	    }
            FSUtils.forwardRequest(request, response, getLocalLoginUrl(
								orgName,
								hostEntityId,
								metaManager,
								respInfo,
								requestURL,
								relayState));
	    return;
	}
	AuthContext ac = SPACSUtils.processResponse(response, token, respInfo,
				orgName, hostEntityId, metaManager);
	if (ac.getStatus() == AuthContext.Status.SUCCESS) {
	    SAML2Utils.debug.message("AuthContext status SUCCESS");
	    SPACSUtils.handleSuccessSSO(request, response, ac, metaAlias);
	    // redirect to relay state
	    String finalUrl = SPACSUtils.getRelayState(
			relayState, orgName, hostEntityId, metaManager);
	    String redirectUrl = SPACSUtils.getIntermediateURL(
			orgName, hostEntityId, metaManager);
	    if (redirectUrl != null && redirectUrl.length() != 0) {
		if (finalUrl != null && finalUrl.length() != 0) {
		    if (redirectUrl.indexOf("?") != -1) {
			redirectUrl += "&goto=";
		    } else {
	    		redirectUrl += "?goto=";
	            }
	    	    redirectUrl += AMURLEncDec.encode(finalUrl);
		}
    	    } else {
	    	redirectUrl = finalUrl;
    	    }
	    if (redirectUrl == null || redirectUrl.length() == 0) {
	        %>
		<jsp:forward page="/saml2/jsp/default.jsp?message=ssoSuccess" />
	        <%
	    } else {
		// log it
		response.sendRedirect(redirectUrl);
	    }
        } else if (ac.getStatus() == AuthContext.Status.FAILED) {
            if (((ac.getLoginException()).getMessage()).
                 equals("NoUserMapping")) {
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message("spAssertionConsumer.jsp:need "
                        + " local login!!");
                }
                // logging?
                FSUtils.forwardRequest(request, response, getLocalLoginUrl(
								orgName,
								hostEntityId,
								metaManager,
								respInfo,
								requestURL,
								relayState));
            } else {
		SAML2Utils.debug.error("spAssertionConsumer.jsp: SSO failed.");
                response.sendError(response.SC_INTERNAL_SERVER_ERROR,
                    SAML2Utils.bundle.getString("SSOFailed"));
            }
        } else {
	    if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("Unknown AuthContext status: "
                    + ac.getStatus());
        	SAML2Utils.debug.message("spAssertionConsumer.jsp:Login has "
		    + "failed!!");
	    }
	    // could I get more detailed error message from ac?
            // logging
            response.sendError(response.SC_INTERNAL_SERVER_ERROR,
		SAML2Utils.bundle.getString("SSOFailed"));
        }
    } catch (SAML2Exception e) {
	// logging ?
	// error is already set in response
    }

%>
