<%--
    Copyright (c) 2006 Sun Microsystems, Inc. All rights reserved
    SUN PROPRIETARY/CONFIDENTIAL.
    Use is subject to license terms.
--%>


<%@ page import="com.iplanet.am.util.Debug" %>
<%@ page import="com.sun.identity.saml2.common.SAML2Utils" %>
<%@ page import="com.sun.identity.saml2.common.SAML2Constants" %>
<%@ page import="com.sun.identity.saml2.common.SAML2Exception" %>
<%@ page import="com.sun.identity.saml2.profile.IDPSingleLogout" %>
<%@ page import="java.util.Map" %>

<%--
    idpSingleLogoutRedirect.jsp 
     
    - receives the LogoutRequest and sends the LogoutResponse to 
    Service Provider from the Identity Provider.
    OR
    - receives the LogoutResponse from the Service Provider.
    
    Required parameters to this jsp are :
    - RelayState - the target URL on successful Single Logout 
    - SAMLRequest - the LogoutRequest
    OR
    - SAMLResponse - the LogoutResponse
            
    Check the SAML2 Documentation for supported parameters.    
--%>
<html>

<head>
    <title>SAMLv2 Single Logout Redirect binding at IDP</title>
</head>
<body bgcolor="#FFFFFF" text="#000000">

<%
    // Retrieves the LogoutRequest or LogoutResponse
    //Retrieves :
    //- RelayState - the target URL on successful Single Logout 
    //- SAMLRequest - the LogoutRequest
    //OR
    //- SAMLResponse - the LogoutResponse    
    
    String relayState = request.getParameter(SAML2Constants.RELAY_STATE);

    String samlResponse = request.getParameter(SAML2Constants.SAML_RESPONSE);
    if (samlResponse != null) {
        boolean doRelayState = true;
        try {
        /**
         * Gets and processes the Single <code>LogoutResponse</code> from SP,
         * destroys the local session, checks response's issuer
         * and inResponseTo.
         *
         * @param request the HttpServletRequest.
         * @param response the HttpServletResponse.
         * @param samlResponse <code>LogoutResponse</code> in the
         *          XML string format.
         * @param relayState the target URL on successful
         * <code>LogoutResponse</code>.
         * @throws SAML2Exception if error processing
         *          <code>LogoutResponse</code>.
         */
            doRelayState = IDPSingleLogout.processLogoutResponse(
                request, response,samlResponse, relayState);
        } catch (SAML2Exception sse) {
            SAML2Utils.debug.error("Error processing LogoutResponse :", sse);
            response.sendError(response.SC_BAD_REQUEST,
                 SAML2Utils.bundle.getString("LogoutResponseProcessingError"));
            return;
        } catch (Exception e) {
            SAML2Utils.debug.error("Error processing LogoutResponse ",e);
            response.sendError(response.SC_BAD_REQUEST,
                 SAML2Utils.bundle.getString("LogoutResponseProcessingError"));
            return;
        }
        
        if (!doRelayState) {
            if (relayState != null) {
                response.sendRedirect(relayState);
            } else {
	        %>
                <jsp:forward page="/saml2/jsp/default.jsp?message=idpSloSuccess" />
                <%
            }
        }
    } else {
        String samlRequest = request.getParameter(SAML2Constants.SAML_REQUEST);
        if (samlRequest != null) {
            try {
            /**
             * Gets and processes the Single <code>LogoutRequest</code> from SP.
             *
             * @param request the HttpServletRequest.
             * @param response the HttpServletResponse.
             * @param samlRequest <code>LogoutRequest</code> in the
             *          XML string format.
             * @param relayState the target URL on successful
             * <code>LogoutRequest</code>.
             * @throws SAML2Exception if error processing
             *          <code>LogoutRequest</code>.
             */
            IDPSingleLogout.processLogoutRequest(request,response,
                samlRequest,relayState);
            } catch (SAML2Exception sse) {
                SAML2Utils.debug.error("Error processing LogoutRequest :", sse);
                response.sendError(response.SC_BAD_REQUEST,
                     SAML2Utils.bundle.getString("LogoutRequestProcessingError"));
                return;
            } catch (Exception e) {
                SAML2Utils.debug.error("Error processing LogoutRequest ",e);
                response.sendError(response.SC_BAD_REQUEST,
                     SAML2Utils.bundle.getString("LogoutRequestProcessingError"));
                return;
            }
        }
    }
%>

</body>
</html>
