<%--
    Copyright (c) 2006 Sun Microsystems, Inc. All rights reserved
    SUN PROPRIETARY/CONFIDENTIAL.
    Use is subject to license terms.
--%>


<%@ page import="com.iplanet.am.util.Debug" %>
<%@ page import="com.iplanet.sso.SSOToken" %>
<%@ page import="com.sun.identity.saml2.common.SAML2Utils" %>
<%@ page import="com.sun.identity.saml2.common.SAML2Constants" %>
<%@ page import="com.sun.identity.saml2.common.SAML2Exception" %>
<%@ page import="com.sun.identity.saml2.profile.IDPSingleLogout" %>
<%@ page import="com.sun.identity.saml2.profile.LogoutUtil" %>
<%@ page import="java.util.HashMap" %>

<%--
    idpSingleLogoutInit.jsp 
    - initiates the LogoutRequest at the Identity Provider.    
        
    Required parameters to this jsp are :
    - binding - binding used for this request
        
    Some of the other optional parameters are :
    "RelayState" - the target URL on successful Single Logout
    "Destination" - A URI Reference indicating the address to 
                    which the request has been sent.
    "Consent" - Specifies a URI a SAML defined identifier
                known as Consent Identifiers.
    "Extension" - Specifies a list of Extensions as list of 
                 String objects.
    "logoutAll" - Specifies IDP sends slo request to SP without any session 
                 index.
    
    Check the SAML2 Documentation for supported parameters.
    
--%>
<html>

<head>
    <title>SAMLv2 Single Logout Initiation at IDP</title>
</head>
<body bgcolor="#FFFFFF" text="#000000">

<%
    // Retreive the Request Query Parameters 
    // binding are the required query parameters
    // binding - binding used for this request
    
    try {
        String RelayState = request.getParameter(SAML2Constants.RELAY_STATE);
        SSOToken ssoToken = SAML2Utils.getSSOToken(request);
        if (ssoToken == null) {
            response.sendError(response.SC_BAD_REQUEST,
                SAML2Utils.bundle.getString("nullSSOToken"));
            return;
        }
        String metaAlias = 
        	ssoToken.getProperty(SAML2Constants.IDP_META_ALIAS);
        if (metaAlias == null) {
            SAML2Utils.destroySession(ssoToken);
            if (RelayState != null) {
                response.sendRedirect(RelayState);
            } else {            
		%>
                <jsp:forward
		    page="/saml2/jsp/default.jsp?message=idpSloSuccess" />
                <%
            } 
            return;
        }

        String idpEntityID = 
            SAML2Utils.getSAML2MetaManager().getEntityByMetaAlias(metaAlias);
        	    
	String binding = LogoutUtil.getSLOBindingInfo(request, metaAlias,
	                                SAML2Constants.SP_ROLE, idpEntityID);

	String logoutAll = request.getParameter(SAML2Constants.LOGOUT_ALL);
        /**
        * Parses the request parameters and builds the Logout
        * Request to be sent to the SP.
        *
        * @param request the HttpServletRequest.
        * @param response the HttpServletResponse.
        * @param binding binding used for this request.
        * @param paramsMap Map of all other parameters.
        *       Following parameters names with their respective
        *       String values are allowed in this paramsMap.
        *       "RelayState" - the target URL on successful Single Logout
        *       "Destination" - A URI Reference indicating the address to 
        *                       which the request has been sent.
        *       "Consent" - Specifies a URI a SAML defined identifier
        *                   known as Consent Identifiers.
        *       "Extension" - Specifies a list of Extensions as list of 
        *                   String objects.
        * @throws SAML2Exception if error initiating request to SP.
        */
        HashMap paramsMap = new HashMap();
        paramsMap.put("metaAlias", metaAlias);
        paramsMap.put(SAML2Constants.ROLE, SAML2Constants.IDP_ROLE);
        paramsMap.put(SAML2Constants.BINDING, binding);
        paramsMap.put("Destination", request.getParameter("Destination"));
        paramsMap.put("Consent", request.getParameter("Consent"));
        paramsMap.put("Extension", request.getParameter("Extension"));
        if (RelayState != null) {
            paramsMap.put(SAML2Constants.RELAY_STATE, RelayState);
        }

        if (logoutAll != null) {
            paramsMap.put(SAML2Constants.LOGOUT_ALL, logoutAll);
        }
           
        IDPSingleLogout.initiateLogoutRequest(request,response,
            binding,paramsMap);
        if (binding.equalsIgnoreCase(SAML2Constants.SOAP)) {
            if (RelayState != null) {
                response.sendRedirect(RelayState);
            } else {            
		%>
                <jsp:forward
		    page="/saml2/jsp/default.jsp?message=idpSloSuccess" />
                <%
            }
        }        
    } catch (SAML2Exception sse) {
        SAML2Utils.debug.error("Error sending Logout Request " , sse);
        response.sendError(response.SC_BAD_REQUEST,
                SAML2Utils.bundle.getString("requestProcessingError"));
        return;
    } catch (Exception e) {
        SAML2Utils.debug.error("Error processing Request ",e);
        response.sendError(response.SC_BAD_REQUEST,
                SAML2Utils.bundle.getString("requestProcessingError"));
        return;
    }
%>

</body>
</html>
