<%--
    Copyright (c) 2006 Sun Microsystems, Inc. All rights reserved
    SUN PROPRIETARY/CONFIDENTIAL.
    Use is subject to license terms.
--%>



<%@ page import="com.iplanet.am.util.Debug" %>
<%@ page import="com.sun.identity.saml2.common.SAML2Constants" %>
<%@ page import="com.sun.identity.saml2.common.SAML2Exception" %>
<%@ page import="com.sun.identity.saml2.common.SAML2Utils" %>
<%@ page import="com.sun.identity.saml2.profile.IDPSSOUtil" %>
<%@ page import="com.sun.identity.saml2.profile.IDPSSOFederate" %>

<html>
<head><title>IDP SSO Federation Service</title></head>

<body>
<%
    // check request, response
    if ((request == null) || (response == null)) {
	response.sendError(response.SC_BAD_REQUEST,
			SAML2Utils.bundle.getString("nullInput"));
	return;
    }

    try {
        String cachedResID = request.getParameter(SAML2Constants.RES_INFO_ID);
        // if this id is set, then this is a redirect from the COT 
        // cookie writer. There is already an assertion response
        // cached in this provider. Send it back directly.
        if ((cachedResID != null) && (cachedResID.length() != 0)) {
            IDPSSOUtil.sendResponse(response, cachedResID);
            return;
        }
    } catch (SAML2Exception sse) {
        SAML2Utils.debug.error("Error processing request " , sse);
        response.sendError(response.SC_BAD_REQUEST,
            SAML2Utils.bundle.getString("requestProcessingError"));
        return;
    }

    /*
     * This call handles the federation and/or single sign on request
     * from a service provider. It processes the AuthnRequest
     * sent by the service provider and generates a proper
     * SAML Response that contains an Assertion.
     * It sends back a response containing error status if
     * something is wrong during the request processing.
     */
    IDPSSOFederate.doSSOFederate(request, response);
%>
