/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jserv;

import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.http.Cookie;

public final class JServUtils {
    private static SimpleDateFormat cookieDate = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss zz", Locale.US);

    public static final String URLEncode(String string) {
        if (string == null) {
            return null;
        }
        return URLEncoder.encode(string);
    }

    public static final String URLDecode(String string) throws IllegalArgumentException {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        stringBuffer.ensureCapacity(string.length());
        while (n < n2) {
            char c;
            int n3;
            for (n3 = n; n3 < n2 && (c = string.charAt(n3)) != '+' && c != '%'; ++n3) {
            }
            if (n3 > n) {
                stringBuffer.append(string.substring(n, n3));
                n = n3;
            }
            if (n >= n2) break;
            c = string.charAt(n);
            if (c == '+') {
                stringBuffer.append(' ');
                ++n;
                continue;
            }
            if (c != '%') continue;
            try {
                stringBuffer.append((char)Integer.parseInt(string.substring(n + 1, n + 3), 16));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("invalid hexadecimal " + string.substring(n + 1, n + 3) + " in URLencoded string (illegal unescaped '%'?)");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                throw new IllegalArgumentException("illegal unescaped '%'  in URLencoded string");
            }
            n += 3;
        }
        return stringBuffer.toString();
    }

    public static Cookie[] parseCookieHeader(String string) {
        Object[] objectArray;
        Vector<Cookie> vector = new Vector<Cookie>();
        if (string == null || string.length() == 0) {
            return new Cookie[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "; ");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                String string2;
                objectArray = stringTokenizer.nextToken();
                int n = objectArray.indexOf(61);
                if (n > 0) {
                    string2 = objectArray.substring(0, n);
                    String string3 = objectArray.substring(n + 1);
                    vector.addElement(new Cookie(string2, string3));
                    continue;
                }
                if (objectArray.length() <= 0 || n != -1) continue;
                string2 = JServUtils.URLDecode((String)objectArray);
                vector.addElement(new Cookie(string2, ""));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        objectArray = new Cookie[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String encodeCookie(Cookie cookie) {
        StringBuffer stringBuffer = new StringBuffer(cookie.getName());
        stringBuffer.append('=');
        stringBuffer.append(cookie.getValue());
        long l = cookie.getMaxAge();
        if (l > 0L) {
            stringBuffer.append("; expires=");
            stringBuffer.append(cookieDate.format(new Date(System.currentTimeMillis() + l * 1000L)));
        } else if (l == 0L) {
            stringBuffer.append("; expires=");
            stringBuffer.append(cookieDate.format(new Date(1000L)));
        }
        if (cookie.getDomain() != null) {
            stringBuffer.append("; domain=");
            stringBuffer.append(cookie.getDomain());
        }
        if (cookie.getPath() != null) {
            stringBuffer.append("; path=");
            stringBuffer.append(cookie.getPath());
        }
        if (cookie.getSecure()) {
            stringBuffer.append("; secure");
        }
        return stringBuffer.toString();
    }

    public static String parseCharacterEncoding(String string) {
        int n;
        if (string == null || (n = string.indexOf("charset=")) == -1) {
            return "ISO-8859-1";
        }
        String string2 = string.substring(n + 8);
        int n2 = string2.indexOf(";");
        if (n2 > -1) {
            return string2.substring(0, n2);
        }
        return string2;
    }

    static {
        cookieDate.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

