/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jserv;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpUtils;
import org.apache.java.lang.AdaptiveClassLoader;
import org.apache.java.util.Configurations;
import org.apache.java.util.ExtendedProperties;
import org.apache.jserv.JServ;
import org.apache.jserv.JServContext;
import org.apache.jserv.JServLogChannels;
import org.apache.jserv.JServSTMStore;
import org.apache.jserv.JServSendError;
import org.apache.jserv.JServSession;

public class JServServletManager
implements HttpSessionContext,
Runnable,
JServLogChannels {
    private static final int NAME = 0;
    private static final int VALUE = 1;
    static final String SESSION_IDENTIFIER_BASE = "JServSessionId";
    long initTimeout;
    long destroyTimeout;
    long sessionTimeout;
    long newSessionTimeout;
    long sessionCheckFrequency;
    boolean checkFile;
    boolean checkClasses;
    protected File confFile;
    protected long lastInitialization;
    protected Configurations confs;
    protected Properties defaultArgs;
    protected AdaptiveClassLoader loader;
    private Hashtable servletContexts;
    protected ThreadGroup tGroup;
    protected String session_identifier;
    protected String name;
    protected String[] startups;
    protected Vector servletNames;
    protected Hashtable sessions;
    boolean sessionUseCookies = true;
    private static int session_count = 0;
    private static long lastTimeVal = 0L;
    private static Random randomSource = new Random();
    public static final long maxRandomLen = 2176782336L;
    public static final long maxSessionLifespanTics = 46656L;
    public static final long ticDifference = 2000L;

    JServServletManager(String string, String string2) {
        this.name = string;
        this.confFile = new File(string2);
        this.session_identifier = SESSION_IDENTIFIER_BASE + string;
        this.servletContexts = new Hashtable();
        this.tGroup = new ThreadGroup(string + "-Servlets");
    }

    public synchronized void init(JServSendError jServSendError) {
        Enumeration enumeration;
        Object object;
        Enumeration enumeration2;
        try {
            this.confs = new Configurations(new ExtendedProperties(this.confFile.getAbsolutePath()));
        }
        catch (Exception exception) {
            JServ.fail("Could not read servlet zone configuration file", exception);
        }
        this.initTimeout = this.confs.getLong("init.timeout", 10000L);
        this.destroyTimeout = this.confs.getLong("destroy.timeout", 10000L);
        this.sessionTimeout = this.confs.getLong("session.timeout", 1800000L);
        this.newSessionTimeout = this.confs.getLong("session.newtimeout", 1800000L);
        this.sessionCheckFrequency = this.confs.getLong("session.checkFrequency", 5000L);
        this.sessionUseCookies = this.confs.getBoolean("session.useCookies", true);
        this.checkFile = this.confs.getBoolean("autoreload.file", true);
        this.checkClasses = this.confs.getBoolean("autoreload.classes", true);
        this.defaultArgs = this.confs.getProperties("servlets.default.initArgs");
        this.startups = this.confs.getStringArray("servlets.startup");
        if (JServ.log.active) {
            JServ.log.log("info", "Initialisation timeout: " + this.initTimeout / 1000L + " seconds");
            JServ.log.log("info", "Destroy timeout: " + this.destroyTimeout / 1000L + " seconds");
            JServ.log.log("info", "Session timeout: " + this.sessionTimeout / 1000L + " seconds");
            JServ.log.log("info", "New session timeout: " + this.newSessionTimeout / 1000L + " seconds");
            JServ.log.log("info", "Session check frequency: " + this.sessionCheckFrequency / 1000L + " seconds");
            JServ.log.log("info", "Autoreload on zone file changes: " + this.checkFile);
            JServ.log.log("info", "Autoreload on classfile changes: " + this.checkClasses);
            JServ.log.log("info", "Default initArgs: " + this.defaultArgs);
        }
        if ((enumeration2 = this.confs.getList("repositories")) == null) {
            JServ.fail("Please define a servlet repository for servlet zone " + this.name + "." + "\nThis is done by adding a \"repositories=\" line in the " + this.name + ".properties file for the zone and defining it to be a path to a " + "directory that exists on disk.");
        }
        Vector<File> vector = new Vector<File>();
        while (enumeration2.hasMoreElements()) {
            vector.addElement(new File((String)enumeration2.nextElement()));
        }
        try {
            this.loader = new AdaptiveClassLoader(vector, this.getClass().getClassLoader());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JServ.log.log("warning", "Error creating classloader for servlet zone " + this.name + " : " + illegalArgumentException.toString());
        }
        this.servletNames = new Vector();
        Enumeration enumeration3 = this.confs.getKeys();
        while (enumeration3.hasMoreElements()) {
            object = (String)enumeration3.nextElement();
            if (!((String)object).startsWith("servlet.") || !((String)object).endsWith(".code")) continue;
            enumeration = ((String)object).substring(8, ((String)object).length() - 5);
            if (JServ.log.active) {
                JServ.log.log("info", "Servlet name: " + (String)((Object)enumeration));
            }
            this.servletNames.addElement(enumeration);
        }
        this.lastInitialization = this.confFile.lastModified();
        if (this.sessions != null) {
            try {
                object = new Hashtable(this.sessions.size());
                enumeration = this.sessions.keys();
                String string = null;
                JServSession jServSession = null;
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    jServSession = (JServSession)this.sessions.get(string);
                    ((Hashtable)object).put(string, (JServServletManager)jServSession.getSessionContext());
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(this.sessions);
                objectOutputStream.flush();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                ACLObjectInputStream aCLObjectInputStream = new ACLObjectInputStream(byteArrayInputStream);
                this.sessions = (Hashtable)aCLObjectInputStream.readObject();
                enumeration = this.sessions.keys();
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    jServSession = (JServSession)this.sessions.get(string);
                    jServSession.setSessionContext((JServServletManager)((Hashtable)object).get(string));
                }
                if (JServ.log.active) {
                    JServ.log.log("debug", "Restoring sessions hashtable.");
                }
            }
            catch (Exception exception) {
                if (JServ.log.active) {
                    JServ.log.log("debug", "Restoring sessions hashtable failed:" + exception.toString());
                }
                this.sessions = new Hashtable();
            }
        } else {
            if (JServ.log.active) {
                JServ.log.log("debug", "Creating new sessions hashtable.");
            }
            this.sessions = new Hashtable();
        }
        this.loadStartupServlets(jServSendError);
        object = new Thread(this);
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
    }

    public synchronized void checkReload(JServSendError jServSendError) throws Exception {
        String string = "The classloader was not properly instantiated because of a configuration error. \nThis is probably due to the fact that one of your property \nfiles is misconfigured or could not be found. Please check \nthe paths and permissions on all of your properties files. \nAlso check to make sure that the paths and permissions on \nall of the paths within your properties files are also correct.\n";
        if (this.loader == null) {
            throw new Exception(string);
        }
        if (this.checkClasses && this.loader.shouldReload() || this.checkFile && this.confFile.lastModified() != this.lastInitialization) {
            this.destroyServlets();
            this.loader = this.loader.reinstantiate();
            this.init(jServSendError);
        }
    }

    public Enumeration getServletNames() {
        return this.servletNames.elements();
    }

    public synchronized Enumeration getLoadedServlets() {
        Vector<Servlet> vector = new Vector<Servlet>();
        Enumeration enumeration = this.servletContexts.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (v instanceof JServContext) {
                vector.addElement(((JServContext)v).servlet);
                continue;
            }
            if (!(v instanceof JServSTMStore)) continue;
            Servlet[] servletArray = ((JServSTMStore)v).getServlets();
            for (int i = servletArray.length - 1; i >= 0; --i) {
                vector.addElement(servletArray[i]);
            }
        }
        return vector.elements();
    }

    public synchronized JServContext loadServlet(String string, JServSendError jServSendError) throws ServletException {
        JServContext jServContext = null;
        Object v = this.servletContexts.get(string);
        if (v != null) {
            if (v instanceof JServContext) {
                return (JServContext)v;
            }
            if (v instanceof JServSTMStore) {
                return ((JServSTMStore)v).getContext(jServSendError);
            }
            return null;
        }
        jServContext = this.load_init(string, jServSendError);
        if (jServContext == null) {
            return null;
        }
        if (jServContext.servlet != null && jServContext.servlet instanceof SingleThreadModel) {
            JServSTMStore jServSTMStore = new JServSTMStore(this.confs, this, string, jServSendError, jServContext);
            jServContext = jServSTMStore.getContext(jServSendError);
            this.servletContexts.put(string, jServSTMStore);
        } else {
            this.servletContexts.put(string, jServContext);
        }
        return jServContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JServContext load_init(String string, JServSendError jServSendError) throws ServletException {
        Properties properties;
        Servlet servlet;
        boolean bl;
        JServContext jServContext;
        block16: {
            jServContext = null;
            String string2 = "servlet." + string;
            String string3 = this.confs.getString(string2 + ".code", null);
            bl = true;
            if (string3 == null) {
                string3 = string;
                bl = false;
            }
            try {
                servlet = (Servlet)this.loader.loadClass(string3).newInstance();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                jServSendError.sendError(404, "NoClassDefFoundError: " + string3);
                return null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                jServSendError.sendError(404, "ClassNotFoundException: " + string3);
                return null;
            }
            catch (ClassFormatError classFormatError) {
                jServSendError.sendError(classFormatError);
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                jServSendError.sendError(illegalAccessException);
                return null;
            }
            catch (InstantiationException instantiationException) {
                jServSendError.sendError(instantiationException);
                return null;
            }
            properties = this.confs.getProperties(string2 + ".initArgs", this.defaultArgs);
            try {
                InputStream inputStream = this.loader.getResourceAsStream(string3.replace('.', File.separatorChar) + ".initArgs");
                if (inputStream == null) break block16;
                try {
                    properties.load(new BufferedInputStream(inputStream));
                }
                finally {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            jServContext = new JServContext(servlet, this, properties, bl ? string : null);
            servlet.init((ServletConfig)jServContext);
        }
        catch (ServletException servletException) {
            throw servletException;
        }
        catch (Exception exception) {
            jServSendError.sendError(exception);
            return null;
        }
        catch (Error error) {
            jServSendError.sendError(error);
            throw (Error)error.fillInStackTrace();
        }
        return jServContext;
    }

    private void loadStartupServlets(JServSendError jServSendError) {
        if (this.startups == null) {
            return;
        }
        for (int i = 0; i < this.startups.length; ++i) {
            String string = this.startups[i];
            if (string == null) continue;
            try {
                this.loadServlet(string, jServSendError);
                continue;
            }
            catch (ServletException servletException) {
                jServSendError.sendError(servletException);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    void returnSTMS(String string, JServContext jServContext) {
        Object v;
        if (string != null && jServContext != null && (v = this.servletContexts.get(string)) != null && v instanceof JServSTMStore) {
            ((JServSTMStore)v).returnContext(jServContext);
        }
    }

    /*
     * Exception decompiling
     */
    public synchronized void destroyServlet(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroyServlets() {
        if (JServ.log.active) {
            JServ.log.log("info", "Destroying Servlets");
        }
        String[] stringArray = new String[this.servletContexts.size()];
        int n = 0;
        Enumeration enumeration = this.servletContexts.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        --n;
        try {
            while (n >= 0) {
                this.destroyServlet(stringArray[n--]);
            }
        }
        finally {
            this.servletContexts.clear();
        }
    }

    public final String getUrlSessionId(String string) {
        if (string == null) {
            return null;
        }
        try {
            Hashtable hashtable = HttpUtils.parseQueryString((String)string);
            Object v = hashtable.get(this.session_identifier);
            if (v == null) {
                return null;
            }
            if (v instanceof String) {
                return (String)v;
            }
            return ((String[])v)[0];
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return null;
        }
    }

    public final String getCookieSessionId(Cookie[] cookieArray) {
        if (!this.sessionUseCookies) {
            return null;
        }
        if (cookieArray == null || cookieArray.length == 0) {
            return null;
        }
        for (int i = 0; i < cookieArray.length; ++i) {
            if (!cookieArray[i].getName().equals(this.session_identifier)) continue;
            return cookieArray[i].getValue();
        }
        return null;
    }

    public String encodeUrl(String string, String string2) {
        int n = string.indexOf(35);
        if (n == 0) {
            return string;
        }
        int n2 = string.indexOf(63);
        boolean bl = n2 >= 0;
        int n3 = string.length();
        if (n > 0 && n2 < n) {
            n3 -= string.length() - n;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.insert(n3++, bl ? (char)'&' : '?');
        stringBuffer.insert(n3, this.session_identifier + '=' + string2);
        return stringBuffer.toString();
    }

    private static synchronized String getIdentifier() {
        StringBuffer stringBuffer = new StringBuffer();
        long l = randomSource.nextLong();
        if (l < 0L) {
            l = -l;
        }
        l %= 2176782336L;
        stringBuffer.append(Long.toString(l += 2176782336L, 36).substring(1));
        long l2 = System.currentTimeMillis() / 2000L;
        l2 %= 46656L;
        stringBuffer.append(Long.toString(l2 += 46656L, 36).substring(1));
        if (lastTimeVal != l2) {
            lastTimeVal = l2;
            session_count = 0;
        }
        stringBuffer.append(Long.toString(++session_count, 36));
        return stringBuffer.toString();
    }

    private synchronized String getIdentifier(String string) {
        if (string != null && string.length() > 0) {
            return JServServletManager.getIdentifier() + "." + string;
        }
        return JServServletManager.getIdentifier();
    }

    public synchronized HttpSession getSession(String string) {
        return (HttpSession)this.sessions.get(string);
    }

    public synchronized Enumeration getIds() {
        Vector vector = new Vector();
        Enumeration enumeration = this.sessions.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector.elements();
    }

    public synchronized JServSession createSession(HttpServletResponse httpServletResponse) {
        return this.createSession(httpServletResponse, null);
    }

    public synchronized JServSession createSession(HttpServletResponse httpServletResponse, String string) {
        JServSession jServSession = new JServSession(this.getIdentifier(string), this);
        this.sessions.put(jServSession.id, jServSession);
        if (this.sessionUseCookies) {
            Cookie cookie = new Cookie(this.session_identifier, jServSession.id);
            String string2 = this.confs.getString("session.topleveldomain", null);
            if (string2 != null) {
                cookie.setDomain(string2);
            }
            cookie.setPath("/");
            httpServletResponse.addCookie(cookie);
        }
        return jServSession;
    }

    public synchronized void removeSession(JServSession jServSession) {
        this.sessions.remove(jServSession.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block7: while (true) {
            try {
                Thread.sleep(this.sessionCheckFrequency);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Enumeration enumeration = this.sessions.elements();
            long l = System.currentTimeMillis();
            while (true) {
                JServSession jServSession;
                if (!enumeration.hasMoreElements()) continue block7;
                JServSession jServSession2 = jServSession = (JServSession)enumeration.nextElement();
                synchronized (jServSession2) {
                    try {
                        if (l - jServSession.lastAccessTime > this.sessionTimeout || jServSession.isNew() && l - jServSession.lastAccessTime > this.newSessionTimeout) {
                            jServSession.invalidate();
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
            }
            break;
        }
    }

    class ACLObjectInputStream
    extends ObjectInputStream {
        ACLObjectInputStream(InputStream inputStream) throws IOException {
            super(inputStream);
        }

        protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            return JServServletManager.this.loader.loadClass(objectStreamClass.getName());
        }
    }
}

