/*
 * Decompiled with CFR 0.152.
 */
package org.apache.java.recycle.pool;

import org.apache.java.lang.Stoppable;
import org.apache.java.recycle.Recyclable;
import org.apache.java.recycle.RecycleBin;

class Worker
extends Thread
implements Recyclable {
    private Stoppable work;
    private RecycleBin pool;
    private boolean alive;

    protected Worker(ThreadGroup threadGroup, RecycleBin recycleBin, String string) {
        super(threadGroup, string);
        this.pool = recycleBin;
        this.work = null;
        this.alive = true;
        this.setDaemon(false);
    }

    public final synchronized void run() {
        this.notifyAll();
        while (this.alive) {
            while (this.work == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                this.work.run();
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.pool.recycle(this);
        }
    }

    protected synchronized void execute(Stoppable stoppable) {
        this.work = stoppable;
        this.notify();
    }

    public void clean() {
        this.work = null;
    }

    public void destroy() {
        this.alive = false;
        this.work.stop();
    }
}

