/*
 * Decompiled with CFR 0.152.
 */
package org.apache.java.lang;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.java.io.SimpleFileFilter;

public class AdaptiveClassLoader
extends ClassLoader {
    private static int generationCounter = 0;
    private int generation;
    private Hashtable cache;
    private ClassLoader myParentClassLoader;
    private Vector repository;

    public AdaptiveClassLoader(Vector vector) throws IllegalArgumentException {
        this(vector, null);
    }

    public AdaptiveClassLoader(Vector vector, ClassLoader classLoader) throws IllegalArgumentException {
        this.myParentClassLoader = classLoader;
        this.cache = new Hashtable();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            File file;
            Object e = enumeration.nextElement();
            try {
                file = (File)e;
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("Object " + e + "is not a valid \"File\" instance");
            }
            File[] fileArray = SimpleFileFilter.fileOrFiles(file);
            if (fileArray == null) continue;
            for (int i = 0; i < fileArray.length; ++i) {
                file = fileArray[i];
                if (!file.exists()) {
                    throw new IllegalArgumentException("Repository " + file.getAbsolutePath() + " doesn't exist!");
                }
                if (!file.canRead()) {
                    throw new IllegalArgumentException("Do not have read access for file " + file.getAbsolutePath());
                }
                if (file.isDirectory() || this.isZipOrJarArchive(file)) continue;
                throw new IllegalArgumentException(file.getAbsolutePath() + " is not a directory or zip/jar file" + " or if it's a zip/jar file then it is corrupted.");
            }
        }
        this.repository = vector;
        this.generation = generationCounter++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isZipOrJarArchive(File file) {
        boolean bl = true;
        ZipFile zipFile = null;
        zipFile = new ZipFile(file);
        Object var6_4 = null;
        if (zipFile == null) return bl;
        try {
            zipFile.close();
            return bl;
        }
        catch (IOException iOException) {}
        return bl;
        {
            catch (ZipException zipException) {
                bl = false;
                Object var6_5 = null;
                if (zipFile == null) return bl;
                try {
                    zipFile.close();
                    return bl;
                }
                catch (IOException iOException) {}
                return bl;
            }
            catch (IOException iOException) {
                bl = false;
                Object var6_6 = null;
                if (zipFile == null) return bl;
                try {
                    zipFile.close();
                    return bl;
                }
                catch (IOException iOException2) {}
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (zipFile == null) throw throwable;
            try {
                zipFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public synchronized boolean shouldReload(String string) {
        ClassCacheEntry classCacheEntry = (ClassCacheEntry)this.cache.get(string);
        if (classCacheEntry == null) {
            return false;
        }
        if (classCacheEntry.isSystemClass()) {
            return false;
        }
        boolean bl = classCacheEntry.origin.lastModified() != classCacheEntry.lastModified;
        return bl;
    }

    public synchronized boolean shouldReload() {
        Enumeration enumeration = this.cache.elements();
        while (enumeration.hasMoreElements()) {
            ClassCacheEntry classCacheEntry = (ClassCacheEntry)enumeration.nextElement();
            if (classCacheEntry.isSystemClass()) continue;
            long l = classCacheEntry.origin.lastModified();
            if (l == 0L) {
                return true;
            }
            if (l == classCacheEntry.lastModified) continue;
            return true;
        }
        return false;
    }

    public AdaptiveClassLoader reinstantiate() {
        return new AdaptiveClassLoader(this.repository, this.myParentClassLoader);
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = null;
        ClassCacheEntry classCacheEntry = (ClassCacheEntry)this.cache.get(string);
        if (classCacheEntry != null) {
            clazz = classCacheEntry.loadedClass;
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        if (!this.securityAllowsClass(string)) {
            return this.loadSystemClass(string, bl);
        }
        try {
            clazz = this.loadSystemClass(string, bl);
            if (clazz != null) {
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (Exception exception) {
            clazz = null;
        }
        Enumeration enumeration = this.repository.elements();
        ClassCacheEntry classCacheEntry2 = new ClassCacheEntry();
        while (enumeration.hasMoreElements()) {
            byte[] byArray = null;
            File file = (File)enumeration.nextElement();
            File[] fileArray = SimpleFileFilter.fileOrFiles(file);
            for (int i = 0; i < fileArray.length; ++i) {
                file = fileArray[i];
                try {
                    if (file.isDirectory()) {
                        byArray = this.loadClassFromDirectory(file, string, classCacheEntry2);
                        continue;
                    }
                    byArray = this.loadClassFromZipfile(file, string, classCacheEntry2);
                    continue;
                }
                catch (IOException iOException) {
                    byArray = null;
                }
            }
            if (byArray == null) continue;
            classCacheEntry2.loadedClass = clazz = this.defineClass(string, byArray, 0, byArray.length);
            classCacheEntry2.lastModified = classCacheEntry2.origin.lastModified();
            this.cache.put(string, classCacheEntry2);
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        throw new ClassNotFoundException(string);
    }

    private Class loadSystemClass(String string, boolean bl) throws NoClassDefFoundError, ClassNotFoundException {
        if (this.myParentClassLoader != null) {
            return this.myParentClassLoader.loadClass(string);
        }
        Class<?> clazz = this.findSystemClass(string);
        ClassCacheEntry classCacheEntry = new ClassCacheEntry();
        classCacheEntry.origin = null;
        classCacheEntry.loadedClass = clazz;
        classCacheEntry.lastModified = Long.MAX_VALUE;
        this.cache.put(string, classCacheEntry);
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private boolean securityAllowsClass(String string) {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                return true;
            }
            int n = string.lastIndexOf(46);
            securityManager.checkPackageDefinition(n > -1 ? string.substring(0, n) : "");
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadClassFromDirectory(File file, String string, ClassCacheEntry classCacheEntry) throws IOException {
        File file2;
        String string2 = string.replace('.', File.separatorChar) + ".class";
        if (!Character.isJavaIdentifierStart(string2.charAt(0))) {
            int n = 1;
            while (!Character.isJavaIdentifierStart(string2.charAt(n++))) {
            }
            string2 = string2.substring(n);
        }
        if ((file2 = new File(file, string2)).exists()) {
            classCacheEntry.origin = file2;
            FileInputStream fileInputStream = new FileInputStream(file2);
            try {
                byte[] byArray = this.loadBytesFromStream(fileInputStream, (int)file2.length());
                return byArray;
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadClassFromZipfile(File file, String string, ClassCacheEntry classCacheEntry) throws IOException {
        String string2 = string.replace('.', '/') + ".class";
        ZipFile zipFile = new ZipFile(file);
        try {
            ZipEntry zipEntry = zipFile.getEntry(string2);
            if (zipEntry != null) {
                classCacheEntry.origin = file;
                byte[] byArray = this.loadBytesFromStream(zipFile.getInputStream(zipEntry), (int)zipEntry.getSize());
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            zipFile.close();
        }
    }

    private byte[] loadBytesFromStream(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        int n3 = 0;
        while (n > 0 && (n2 = inputStream.read(byArray, n3, n)) != -1) {
            n3 += n2;
            n -= n2;
        }
        return byArray;
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = null;
        if (this.myParentClassLoader != null) {
            inputStream = this.myParentClassLoader.getResourceAsStream(string);
        }
        if (inputStream == null) {
            inputStream = AdaptiveClassLoader.getSystemResourceAsStream(string);
        }
        if (inputStream == null) {
            Enumeration enumeration = this.repository.elements();
            while (enumeration.hasMoreElements()) {
                File file = (File)enumeration.nextElement();
                if (file.isDirectory()) {
                    inputStream = this.loadResourceFromDirectory(file, string);
                } else if (string.endsWith(".initArgs")) {
                    String string2 = file.getParent();
                    if (string2 != null) {
                        File file2 = new File(string2);
                        inputStream = this.loadResourceFromDirectory(file2, string);
                    }
                } else {
                    inputStream = this.loadResourceFromZipfile(file, string);
                }
                if (inputStream == null) continue;
                break;
            }
        }
        return inputStream;
    }

    private InputStream loadResourceFromDirectory(File file, String string) {
        String string2 = string.replace('/', File.separatorChar);
        File file2 = new File(file, string2);
        if (file2.exists()) {
            try {
                return new FileInputStream(file2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private InputStream loadResourceFromZipfile(File file, String string) {
        IOException iOException322;
        InputStream inputStream;
        InputStream inputStream2;
        ZipFile zipFile;
        block22: {
            block19: {
                IOException iOException2222;
                ByteArrayInputStream byteArrayInputStream;
                block20: {
                    zipFile = null;
                    inputStream2 = null;
                    zipFile = new ZipFile(file);
                    ZipEntry zipEntry = zipFile.getEntry(string);
                    if (zipEntry == null) break block19;
                    long l = zipEntry.getSize();
                    inputStream2 = zipFile.getInputStream(zipEntry);
                    byte[] byArray = this.loadBytesFromStream(inputStream2, (int)l);
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    Object var11_12 = null;
                    if (inputStream2 == null) break block20;
                    try {
                        inputStream2.close();
                    }
                    catch (IOException iOException2222) {
                        // empty catch block
                    }
                }
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException2222) {
                        // empty catch block
                    }
                }
                return byteArrayInputStream;
            }
            inputStream = null;
            Object var11_13 = null;
            if (inputStream2 == null) break block22;
            try {
                inputStream2.close();
            }
            catch (IOException iOException322) {
                // empty catch block
            }
        }
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException iOException322) {
                // empty catch block
            }
        }
        return inputStream;
        catch (IOException iOException4) {
            IOException iOException5222;
            InputStream inputStream3;
            block24: {
                try {
                    inputStream3 = null;
                    Object var11_14 = null;
                    if (inputStream2 == null) break block24;
                }
                catch (Throwable throwable) {
                    block26: {
                        IOException iOException6222;
                        Object var11_15 = null;
                        if (inputStream2 != null) {
                            try {
                                inputStream2.close();
                            }
                            catch (IOException iOException6222) {
                                // empty catch block
                            }
                        }
                        if (zipFile == null) break block26;
                        try {
                            zipFile.close();
                        }
                        catch (IOException iOException6222) {}
                    }
                    throw throwable;
                }
                try {
                    inputStream2.close();
                }
                catch (IOException iOException5222) {
                    // empty catch block
                }
            }
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException5222) {
                    // empty catch block
                }
            }
            return inputStream3;
        }
    }

    public URL getResource(String string) {
        if (string == null) {
            return null;
        }
        URL uRL = null;
        if (this.myParentClassLoader != null) {
            uRL = this.myParentClassLoader.getResource(string);
        }
        if (uRL == null) {
            uRL = AdaptiveClassLoader.getSystemResource(string);
        }
        if (uRL != null) {
            return uRL;
        }
        Enumeration enumeration = this.repository.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object object2;
            File file = (File)enumeration.nextElement();
            if (file.isDirectory()) {
                object2 = string.replace('/', File.separatorChar);
                object = new File(file, (String)object2);
                if (!((File)object).exists()) continue;
                try {
                    return new URL("file", null, ((File)object).getAbsolutePath());
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                    return null;
                }
            }
            try {
                object2 = new ZipFile(file.getAbsolutePath());
                object = ((ZipFile)object2).getEntry(string);
                if (object == null) continue;
                try {
                    return new URL("jar:file:" + file.getAbsolutePath() + "!/" + string);
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                    return null;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public long lastModified(String string) throws ClassNotFoundException {
        ClassCacheEntry classCacheEntry = (ClassCacheEntry)this.cache.get(string);
        if (classCacheEntry == null) {
            throw new ClassNotFoundException("Could not find class: " + string);
        }
        return classCacheEntry.lastModified;
    }

    private static class ClassCacheEntry {
        Class loadedClass;
        File origin;
        long lastModified;

        private ClassCacheEntry() {
        }

        public boolean isSystemClass() {
            return this.origin == null;
        }
    }
}

