/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.util;

import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;

public class RetainCalendar {
    public static final int SCHEMA1 = 1;
    public static final int SCHEMA2 = 2;
    public static final int SCHEMA3 = 3;
    public static final int SCHEMA4 = 4;

    public static boolean isSnapshotRetainedOnDay(GregorianCalendar theDate, GregorianCalendar today, int schema) {
        GregorianCalendar date = (GregorianCalendar)theDate.clone();
        GregorianCalendar compareDate = (GregorianCalendar)today.clone();
        date.set(11, 0);
        date.set(12, 0);
        date.set(13, 0);
        date.set(14, 0);
        compareDate.set(11, 0);
        compareDate.set(12, 0);
        compareDate.set(13, 0);
        compareDate.set(14, 0);
        today.set(11, 0);
        today.set(12, 0);
        today.set(13, 0);
        today.set(14, 0);
        switch (schema) {
            case 1: {
                return RetainCalendar.testSchema1(date, compareDate, today);
            }
            case 2: {
                return RetainCalendar.testSchema2(date, compareDate, today);
            }
            case 3: {
                return RetainCalendar.testSchema3(date, compareDate, today);
            }
            case 4: {
                return RetainCalendar.testSchema4(date, compareDate, today);
            }
        }
        return true;
    }

    private static boolean testSchema1(GregorianCalendar date, GregorianCalendar compareDate, GregorianCalendar today) {
        long dateMillis = date.getTimeInMillis();
        compareDate.add(5, -21);
        if (dateMillis >= compareDate.getTimeInMillis()) {
            return dateMillis <= today.getTimeInMillis();
        }
        compareDate.add(5, 21);
        compareDate.add(2, -2);
        if (dateMillis >= compareDate.getTimeInMillis()) {
            return date.get(7) == date.getFirstDayOfWeek();
        }
        compareDate.add(2, -4);
        if (dateMillis >= compareDate.getTimeInMillis() && date.get(7) == date.getFirstDayOfWeek()) {
            int theMonth = date.get(2);
            date.add(7, -7);
            return date.get(2) != theMonth;
        }
        int theMonth = date.get(2);
        if (date.get(7) == date.getFirstDayOfWeek()) {
            date.add(7, -7);
            return date.get(2) != theMonth && (theMonth == 2 || theMonth == 5 || theMonth == 8 || theMonth == 11);
        }
        return false;
    }

    private static boolean testSchema2(GregorianCalendar date, GregorianCalendar compareDate, GregorianCalendar today) {
        long dateMillis = date.getTimeInMillis();
        compareDate.add(5, -42);
        if (dateMillis >= compareDate.getTimeInMillis()) {
            return dateMillis <= today.getTimeInMillis();
        }
        if (date.get(7) != date.getFirstDayOfWeek()) {
            return false;
        }
        GregorianCalendar testDate = (GregorianCalendar)compareDate.clone();
        testDate.add(7, testDate.getFirstDayOfWeek() - testDate.get(7));
        boolean passTest = false;
        int year = date.get(1);
        int month = date.get(2);
        int day = date.get(5);
        SimpleDateFormat fmt = new SimpleDateFormat();
        do {
            if (testDate.get(1) == year && testDate.get(2) == month && testDate.get(5) == day) {
                passTest = true;
                break;
            }
            testDate.add(5, -14);
        } while (testDate.getTimeInMillis() >= dateMillis);
        if (!passTest) {
            return false;
        }
        compareDate.add(5, 42);
        compareDate.add(1, -1);
        if (dateMillis >= compareDate.getTimeInMillis()) {
            return true;
        }
        int theMonth = date.get(2);
        date.add(7, -14);
        return date.get(2) != theMonth && (theMonth == 2 || theMonth == 5 || theMonth == 8 || theMonth == 11);
    }

    private static boolean testSchema3(GregorianCalendar date, GregorianCalendar compareDate, GregorianCalendar today) {
        long dateMillis = date.getTimeInMillis();
        compareDate.add(2, -3);
        if (dateMillis >= compareDate.getTimeInMillis()) {
            return dateMillis <= today.getTimeInMillis();
        }
        if (date.get(5) != 1) {
            return false;
        }
        compareDate.add(2, 3);
        compareDate.add(1, -2);
        if (dateMillis >= compareDate.getTimeInMillis()) {
            return true;
        }
        return date.get(2) == 0 && date.get(5) == 1;
    }

    private static boolean testSchema4(GregorianCalendar date, GregorianCalendar compareDate, GregorianCalendar today) {
        long dateMillis = date.getTimeInMillis();
        compareDate.add(5, -21);
        if (dateMillis >= compareDate.getTimeInMillis()) {
            return dateMillis <= today.getTimeInMillis();
        }
        if (date.get(7) != 5) {
            return false;
        }
        compareDate.add(5, 21);
        compareDate.add(2, -2);
        if (dateMillis >= compareDate.getTimeInMillis()) {
            return true;
        }
        if (date.get(5) < 15) {
            return false;
        }
        GregorianCalendar testDate = (GregorianCalendar)date.clone();
        testDate.add(5, -7);
        if (testDate.get(5) >= 15) {
            return false;
        }
        compareDate.add(2, -4);
        if (dateMillis >= compareDate.getTimeInMillis()) {
            return true;
        }
        int theMonth = date.get(2);
        return theMonth == 2 || theMonth == 5 || theMonth == 8 || theMonth == 11;
    }

    public static int getNumMonthsForSchema(int schema) {
        switch (schema) {
            case 1: {
                return 12;
            }
            case 2: {
                return 18;
            }
            case 3: {
                return 36;
            }
            case 4: {
                return 12;
            }
        }
        return 12;
    }
}

