/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.util;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class ConversionUtil {
    public static final long MINUTE = 60L;
    public static final long HOUR = 3600L;
    public static final long DAY = 86400L;
    public static final long WEEK = 604800L;
    public static final long MONTH = 2592000L;
    public static final long YEAR = 31536000L;

    public static int getSizeUnitAsInteger(String sizeUnitStr) {
        int sizeUnitInt = -1;
        if (sizeUnitStr.equals("bytes")) {
            sizeUnitInt = 0;
        } else if (sizeUnitStr.equals("kbytes")) {
            sizeUnitInt = 1;
        } else if (sizeUnitStr.equals("mbytes")) {
            sizeUnitInt = 2;
        } else if (sizeUnitStr.equals("gbytes")) {
            sizeUnitInt = 3;
        } else if (sizeUnitStr.equals("tbytes")) {
            sizeUnitInt = 4;
        }
        return sizeUnitInt;
    }

    public static String getSizeUnitAsString(int sizeUnitInt) {
        String sizeUnitStr = "";
        if (sizeUnitInt == 0) {
            sizeUnitStr = "bytes";
        } else if (sizeUnitInt == 1) {
            sizeUnitStr = "kbytes";
        } else if (sizeUnitInt == 2) {
            sizeUnitStr = "mbytes";
        } else if (sizeUnitInt == 3) {
            sizeUnitStr = "gbytes";
        } else if (sizeUnitInt == 4) {
            sizeUnitStr = "tbytes";
        }
        return sizeUnitStr;
    }

    public static int getAgeUnitAsInteger(String ageUnitStr) {
        int ageUnitInt = -1;
        if (ageUnitStr.equals("seconds")) {
            ageUnitInt = 5;
        } else if (ageUnitStr.equals("minutes")) {
            ageUnitInt = 6;
        } else if (ageUnitStr.equals("hours")) {
            ageUnitInt = 7;
        } else if (ageUnitStr.equals("days")) {
            ageUnitInt = 8;
        } else if (ageUnitStr.equals("weeks")) {
            ageUnitInt = 9;
        }
        return ageUnitInt;
    }

    public static int strToIntVal(String str) throws SamFSException {
        int intVal = -1;
        if (str != null) {
            if (str.length() != 0) {
                try {
                    intVal = Integer.parseInt(str);
                }
                catch (NumberFormatException e) {
                    throw new SamFSException(e.toString());
                }
            } else {
                intVal = -2;
            }
        }
        return intVal;
    }

    public static long strToLongVal(String str) throws SamFSException {
        long longVal = -1L;
        if (str != null) {
            if (str.length() != 0) {
                try {
                    longVal = Long.parseLong(str);
                }
                catch (NumberFormatException e) {
                    throw new SamFSException(e.toString());
                }
            } else {
                longVal = -2L;
            }
        }
        return longVal;
    }

    public static Integer strToInteger(String str) throws SamFSException {
        if (str == null) {
            return null;
        }
        Integer retVal = null;
        try {
            retVal = new Integer(str);
        }
        catch (NumberFormatException e) {
            throw new SamFSException(e.toString());
        }
        return retVal;
    }

    public static Properties strToProps(String str) throws SamFSException {
        TraceUtil.trace3("props str: " + str);
        Properties props = new Properties();
        if (str == null) {
            return props;
        }
        String[] parts = str.split("\"");
        String crtKey = null;
        String val = null;
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].length() == 0) {
                if (i % 2 != 0) continue;
                val = val + "\"";
                continue;
            }
            if (i % 2 == 1) {
                val = val + parts[i];
                props.setProperty(crtKey, val);
                continue;
            }
            if (i > 0) {
                parts[i] = parts[i].replaceFirst(",", "");
            }
            String[] pairs = parts[i].split(",");
            for (int j = 0; j < pairs.length; ++j) {
                int idx = pairs[j].indexOf(61);
                if (idx == -1) {
                    idx = pairs[j].length();
                    val = "";
                } else {
                    val = pairs[j].substring(idx + 1).trim();
                }
                crtKey = pairs[j].substring(0, idx).trim();
                props.setProperty(crtKey, val);
            }
        }
        return props;
    }

    public static String[] strToArray(String str, char sep) throws SamFSException {
        ArrayList<String> lst = new ArrayList<String>();
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str);
        while (st.hasMoreTokens()) {
            lst.add(st.nextToken());
        }
        String[] arr = new String[lst.size()];
        return lst.toArray(arr);
    }

    public static String arrayToStr(Object[] objs, char sep) {
        StringBuffer s = new StringBuffer();
        if (null != objs) {
            for (int i = 0; i < objs.length; ++i) {
                s.append(objs[i]);
                if (i == objs.length - 1) continue;
                s.append(sep);
            }
        }
        return s.toString();
    }
}

