/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.server;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.media.MediaUtil;
import com.sun.netstorage.samqfs.web.model.Common;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.server.ServerCommonViewBeanBase;
import com.sun.netstorage.samqfs.web.server.ServerUtil;
import com.sun.netstorage.samqfs.web.util.PageTitleUtil;
import com.sun.netstorage.samqfs.web.util.PropertySheetUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.view.html.CCStaticTextField;

public class SiteInformationViewBean
extends ServerCommonViewBeanBase {
    private static final String PAGE_NAME = "SiteInformation";
    private static final String DEFAULT_DISPLAY_URL = "/jsp/server/SiteInformation.jsp";
    private static final int TAB_NAME = 1;
    private static final String CHILD_STATIC_TEXT = "StaticText";
    private static CCPageTitleModel pageTitleModel = null;
    private static CCPropertySheetModel propertySheetModel = null;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCStaticTextField;

    public SiteInformationViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL, 1);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        pageTitleModel = this.createPageTitleModel();
        propertySheetModel = this.createPropertySheetModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    protected void registerChildren() {
        TraceUtil.trace3("Entering");
        super.registerChildren();
        PageTitleUtil.registerChildren((ContainerViewBase)this, pageTitleModel);
        PropertySheetUtil.registerChildren((ContainerViewBase)this, propertySheetModel);
        this.registerChild(CHILD_STATIC_TEXT, class$com$sun$web$ui$view$html$CCStaticTextField == null ? (class$com$sun$web$ui$view$html$CCStaticTextField = SiteInformationViewBean.class$("com.sun.web.ui.view.html.CCStaticTextField")) : class$com$sun$web$ui$view$html$CCStaticTextField);
        TraceUtil.trace3("Exiting");
    }

    protected View createChild(String name) {
        TraceUtil.trace3(new NonSyncStringBuffer("Entering: name is ").append(name).toString());
        View child = null;
        if (super.isChildSupported(name)) {
            child = super.createChild(name);
        } else if (PageTitleUtil.isChildSupported(pageTitleModel, name)) {
            child = PageTitleUtil.createChild((ContainerView)this, pageTitleModel, name);
        } else if (PropertySheetUtil.isChildSupported(propertySheetModel, name)) {
            child = PropertySheetUtil.createChild((ContainerView)this, propertySheetModel, name);
        } else if (name.equals(CHILD_STATIC_TEXT)) {
            child = new CCStaticTextField((ContainerView)this, name, null);
        } else {
            throw new IllegalArgumentException("Invalid child name [" + name + "]");
        }
        TraceUtil.trace3("Exiting");
        return child;
    }

    private CCPageTitleModel createPageTitleModel() {
        TraceUtil.trace3("Entering");
        if (pageTitleModel == null) {
            pageTitleModel = new CCPageTitleModel(SamUtil.createBlankPageTitleXML());
        }
        TraceUtil.trace3("Exiting");
        return pageTitleModel;
    }

    private CCPropertySheetModel createPropertySheetModel() {
        TraceUtil.trace3("Entering");
        if (propertySheetModel == null) {
            propertySheetModel = PropertySheetUtil.createModel("/jsp/server/SiteInformationPropertySheet.xml");
        }
        TraceUtil.trace3("Exiting");
        return propertySheetModel;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        this.loadContent();
        TraceUtil.trace3("Exiting");
    }

    private void loadContent() {
        TraceUtil.trace3("Entering");
        SamQFSSystemModel[] allSystemModel = null;
        try {
            SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
            if (appModel == null) {
                throw new SamFSException(null, -2501);
            }
            appModel.updateDownServers();
            allSystemModel = appModel.getAllSamQFSSystemModels();
            if (allSystemModel == null) {
                return;
            }
            if (allSystemModel.length == 0) {
                return;
            }
            this.loadServerContent(allSystemModel);
            this.loadMediaContent();
        }
        catch (SamFSException samEx) {
            propertySheetModel.setValue("ServerText", (Object)SamUtil.getResourceString("SiteInformation.server.failed"));
            propertySheetModel.setValue("MediaText", (Object)SamUtil.getResourceString("SiteInformation.media.failed"));
            return;
        }
    }

    private void loadMediaContent() throws SamFSException {
        TraceUtil.trace3("Entering");
        NonSyncStringBuffer allMediaStringBuf = new NonSyncStringBuffer();
        Library[] allLibraries = Common.getAllLibrariesFromServers();
        if (allLibraries == null || allLibraries.length == 0) {
            propertySheetModel.setVisible("media", false);
            return;
        }
        propertySheetModel.setVisible("media", true);
        for (int i = 0; i < allLibraries.length; ++i) {
            if (allMediaStringBuf.length() != 0) {
                allMediaStringBuf.append("<br /><br />");
            }
            allMediaStringBuf.append(MediaUtil.createLibraryEntry(allLibraries[i]));
        }
        if (allMediaStringBuf.length() != 0) {
            propertySheetModel.setValue("MediaText", (Object)allMediaStringBuf.toString());
        }
        TraceUtil.trace3("Exiting");
    }

    private void loadServerContent(SamQFSSystemModel[] allSystemModel) throws SamFSException {
        int i;
        TraceUtil.trace3("Entering");
        NonSyncStringBuffer allServerStringBuf = new NonSyncStringBuffer();
        String serverName = null;
        for (i = 0; i < allSystemModel.length; ++i) {
            if (allSystemModel[i].isDown() || !allSystemModel[i].isClusterNode()) continue;
            serverName = allSystemModel[i].getHostname();
            try {
                if (allServerStringBuf.length() != 0) {
                    allServerStringBuf.append("<br /><br />");
                }
                allServerStringBuf.append(ServerUtil.createServerEntry(allSystemModel[i]));
                continue;
            }
            catch (SamFSException samEx) {
                TraceUtil.trace1("Error connecting to " + allSystemModel[i].getHostname() + " while compiling site information.");
                TraceUtil.trace1("Reason: " + samEx.getMessage());
                SamUtil.processException((Exception)((Object)samEx), ((Object)((Object)this)).getClass(), "initModelRows()", "Unknown exception occur while connecting to server", serverName);
            }
        }
        for (i = 0; i < allSystemModel.length; ++i) {
            if (allSystemModel[i].isDown() || allSystemModel[i].isClusterNode()) continue;
            serverName = allSystemModel[i].getHostname();
            try {
                if (allServerStringBuf.length() != 0) {
                    allServerStringBuf.append("<br /><br />");
                }
                allServerStringBuf.append(ServerUtil.createServerEntry(allSystemModel[i]));
                continue;
            }
            catch (SamFSException samEx) {
                TraceUtil.trace1("Error connecting to " + allSystemModel[i].getHostname() + " while compiling site information.");
                TraceUtil.trace1("Reason: " + samEx.getMessage());
                SamUtil.processException((Exception)((Object)samEx), ((Object)((Object)this)).getClass(), "initModelRows()", "Unknown exception occur while connecting to server", serverName);
            }
        }
        if (allServerStringBuf.length() != 0) {
            propertySheetModel.setValue("ServerText", (Object)allServerStringBuf.toString().trim());
        }
        TraceUtil.trace3("Exiting");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

