/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.server;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.ClusterNodeInfo;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.server.AddClusterView;
import com.sun.netstorage.samqfs.web.util.CommonSecondaryViewBeanBase;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.PageTitleUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.view.alert.CCAlertInline;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCLabel;
import com.sun.web.ui.view.html.CCTextField;
import java.io.IOException;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class AddServerViewBean
extends CommonSecondaryViewBeanBase {
    private static final String PAGE_NAME = "AddServer";
    private static final String DEFAULT_DISPLAY_URL = "/jsp/server/AddServer.jsp";
    public static final String ALERT = "Alert2";
    public static final String CHILD_HIDDEN_MESSAGES = "HiddenMessages";
    public static final String SELECTED_NODES = "SelectedNodes";
    public static final String CHILD_LABEL = "Label";
    public static final String CHILD_NAME_VALUE = "nameValue";
    public static final String ADD_CLUSTER_VIEW = "AddClusterView";
    private CCPageTitleModel pageTitleModel = null;
    private Map models = null;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCLabel;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCTextField;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHiddenField;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$server$AddClusterView;
    static /* synthetic */ Class class$com$sun$web$ui$view$alert$CCAlertInline;

    public AddServerViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.pageTitleModel = this.createPageTitleModel();
        this.registerChildren();
        this.initializeTableModels();
        TraceUtil.trace3("Exiting");
    }

    protected void registerChildren() {
        TraceUtil.trace3("Entering");
        super.registerChildren();
        this.registerChild(CHILD_LABEL, class$com$sun$web$ui$view$html$CCLabel == null ? (class$com$sun$web$ui$view$html$CCLabel = AddServerViewBean.class$("com.sun.web.ui.view.html.CCLabel")) : class$com$sun$web$ui$view$html$CCLabel);
        this.registerChild(CHILD_NAME_VALUE, class$com$sun$web$ui$view$html$CCTextField == null ? (class$com$sun$web$ui$view$html$CCTextField = AddServerViewBean.class$("com.sun.web.ui.view.html.CCTextField")) : class$com$sun$web$ui$view$html$CCTextField);
        this.registerChild(CHILD_HIDDEN_MESSAGES, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = AddServerViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(SELECTED_NODES, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = AddServerViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(ADD_CLUSTER_VIEW, class$com$sun$netstorage$samqfs$web$server$AddClusterView == null ? (class$com$sun$netstorage$samqfs$web$server$AddClusterView = AddServerViewBean.class$("com.sun.netstorage.samqfs.web.server.AddClusterView")) : class$com$sun$netstorage$samqfs$web$server$AddClusterView);
        this.registerChild(ALERT, class$com$sun$web$ui$view$alert$CCAlertInline == null ? (class$com$sun$web$ui$view$alert$CCAlertInline = AddServerViewBean.class$("com.sun.web.ui.view.alert.CCAlertInline")) : class$com$sun$web$ui$view$alert$CCAlertInline);
        PageTitleUtil.registerChildren((ContainerViewBase)this, this.pageTitleModel);
        TraceUtil.trace3("Exiting");
    }

    protected View createChild(String name) {
        TraceUtil.trace3("Entering");
        Object child = null;
        if (super.isChildSupported(name)) {
            child = super.createChild(name);
        } else if (name.equals(CHILD_LABEL)) {
            child = new CCLabel((ContainerView)this, name, null);
        } else if (name.equals(CHILD_HIDDEN_MESSAGES)) {
            child = new CCHiddenField((ContainerView)this, name, (Object)new NonSyncStringBuffer(SamUtil.getResourceString("AddServer.errMsg1")).append("###").append(SamUtil.getResourceString("AddServer.errMsg2")).append("###").append(SamUtil.getResourceString("AddServer.errMsg3")).append("###").append(SamUtil.getResourceString("AddCluster.error.selectone")).toString());
        } else if (name.equals(SELECTED_NODES)) {
            child = new CCHiddenField((ContainerView)this, name, null);
        } else if (name.equals(CHILD_NAME_VALUE)) {
            child = new CCTextField((ContainerView)this, name, null);
        } else if (name.equals(ADD_CLUSTER_VIEW)) {
            child = new AddClusterView((View)this, this.models, name);
        } else if (name.equals(ALERT)) {
            child = new CCAlertInline((ContainerView)this, name, null);
        } else if (PageTitleUtil.isChildSupported(this.pageTitleModel, name)) {
            child = PageTitleUtil.createChild((ContainerView)this, this.pageTitleModel, name);
        } else {
            throw new IllegalArgumentException("Invalid child name [" + name + "]");
        }
        TraceUtil.trace3("Exiting");
        return child;
    }

    private CCPageTitleModel createPageTitleModel() {
        TraceUtil.trace3("Entering");
        if (this.pageTitleModel == null) {
            this.pageTitleModel = PageTitleUtil.createModel("/jsp/server/AddServerPageTitle.xml");
        }
        TraceUtil.trace3("Exiting");
        return this.pageTitleModel;
    }

    private void initializeTableModels() {
        this.models = new HashMap();
        ServletContext sc = RequestManager.getRequestContext().getServletContext();
        CCActionTableModel model = new CCActionTableModel(sc, "/jsp/server/AddClusterTable.xml");
        this.models.put("AddClusterTable", model);
    }

    public void handleSubmitRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        String clusterNode = (String)this.getParentViewBean().getPageSessionAttribute("SAMQFS_CLUSTER_NODE");
        if (clusterNode == null) {
            this.addSingleHost();
        } else {
            this.addClusterHosts();
        }
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void populateAddClusterTableModel() {
        AddClusterView clusterView = (AddClusterView)this.getChild(ADD_CLUSTER_VIEW);
        clusterView.populateTableModel();
    }

    public void beginDisplay(DisplayEvent evt) throws ModelControlException {
        TraceUtil.trace3("Entering");
        super.beginDisplay(evt);
        String clusterNode = (String)this.getParentViewBean().getPageSessionAttribute("SAMQFS_CLUSTER_NODE");
        if (clusterNode != null && clusterNode.length() != 0) {
            this.populateAddClusterTableModel();
            ((CCLabel)this.getChild(CHILD_LABEL)).setValue((Object)SamUtil.getResourceString("AddServer.label.addedserver"));
            ((CCTextField)this.getChild(CHILD_NAME_VALUE)).setReadOnly(true);
        }
        TraceUtil.trace3("Exiting");
    }

    private void addSingleHost() {
        boolean hasError = false;
        String nameInput = (String)((CCTextField)this.getChild(CHILD_NAME_VALUE)).getValue();
        nameInput = nameInput.trim();
        try {
            SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
            if (appModel == null) {
                throw new SamFSException(null, -2501);
            }
            LogUtil.info(((Object)((Object)this)).getClass(), "handleCancelHrefRequest", new NonSyncStringBuffer().append("Start adding host ").append(nameInput).toString());
            appModel.addHost(nameInput);
            LogUtil.info(((Object)((Object)this)).getClass(), "handleCancelHrefRequest", new NonSyncStringBuffer().append("Done adding host ").append(nameInput).toString());
            SamUtil.setInfoAlert((ContainerView)this.getParentViewBean(), "Alert", "success.summary", SamUtil.getResourceString("ServerSelection.action.add", nameInput), "");
        }
        catch (SamFSException ex) {
            hasError = true;
            SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "handleSubmitRequest()", "Failed to add server", nameInput);
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "ServerSelection.error.add", ex.getSAMerrno(), ex.getMessage(), nameInput);
        }
        if (!hasError) {
            try {
                SamQFSSystemModel sysModel = SamUtil.getModel(nameInput);
                boolean isClusterNode = sysModel.isClusterNode();
                if (isClusterNode && this.hasMoreNodesToAdd(nameInput)) {
                    this.getParentViewBean().setPageSessionAttribute("SAMQFS_CLUSTER_NODE", (Serializable)((Object)nameInput));
                } else {
                    this.setSubmitSuccessful(true);
                }
            }
            catch (SamFSException ex) {
                SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "handleSubmitRequest()", "Failed to check if the added host is a part of cluster", nameInput);
                SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "AddCluster.error.showall", ex.getSAMerrno(), ex.getMessage(), nameInput);
            }
        }
    }

    private boolean hasMoreNodesToAdd(String hostName) {
        try {
            SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
            if (appModel == null) {
                throw new SamFSException(null, -2501);
            }
            SamQFSSystemModel sysModel = appModel.getSamQFSSystemModel(hostName);
            ClusterNodeInfo[] nodeInfos = sysModel.getClusterNodes();
            if (nodeInfos == null || nodeInfos.length == 0) {
                return false;
            }
            for (int i = 0; i < nodeInfos.length; ++i) {
                if (appModel.getInetHostName(nodeInfos[i].getName()) != null) continue;
                return true;
            }
        }
        catch (SamFSException ex) {
            TraceUtil.trace1("Exception caught while checking if there are more cluster nodes to add!");
            return false;
        }
        catch (UnknownHostException ex) {
            TraceUtil.trace1("Exception caught while checking if there are more cluster nodes to add!");
            return false;
        }
        return false;
    }

    private void addClusterHosts() {
        String clusterNode = (String)this.getParentViewBean().getPageSessionAttribute("SAMQFS_CLUSTER_NODE");
        String serverlist = (String)this.getDisplayFieldValue(SELECTED_NODES);
        String[] serverArray = serverlist.split(", ");
        try {
            SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
            if (appModel == null) {
                throw new SamFSException(null, -2501);
            }
            for (int i = 0; i < serverArray.length; ++i) {
                LogUtil.info(((Object)((Object)this)).getClass(), "addClusterHosts", new NonSyncStringBuffer("Start adding node ").append(serverArray[i]).toString());
                appModel.addHost(serverArray[i]);
                LogUtil.info(((Object)((Object)this)).getClass(), "addClusterHosts", new NonSyncStringBuffer("Done adding node ").append(serverArray[i]).toString());
            }
            SamUtil.setInfoAlert((ContainerView)this.getParentViewBean(), ALERT, "success.summary", SamUtil.getResourceString("ServerSelection.action.add", serverlist), "");
            this.setSubmitSuccessful(true);
        }
        catch (SamFSException samEx) {
            TraceUtil.trace1("SamFSException caught!");
            TraceUtil.trace1("Error adding  selected cluster nodes. Reason: " + samEx.getMessage());
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), ALERT, "AddCluster.error.showall", samEx.getSAMerrno(), samEx.getMessage(), clusterNode);
        }
        this.removePageSessionAttribute("SAMQFS_CLUSTER_NODE");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

