/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.test.fs;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.impl.test.BaseTest;
import com.sun.netstorage.samqfs.web.model.impl.test.fs.DiskDiscoveryTest;
import com.sun.netstorage.samqfs.web.model.media.DiskCache;

public class GrowFSTest {
    public static FileSystem[] getAllFileSystems(SamQFSSystemModel model) throws SamFSException {
        return model.getSamQFSSystemFSManager().getAllFileSystems();
    }

    public static void main(String[] args) {
        try {
            SamQFSSystemModel[] models = BaseTest.getAllSamQFSSystemModels();
            if (models != null && models.length > 0) {
                for (int i = 0; i < models.length; ++i) {
                    System.out.println("Calling Filesystems...");
                    FileSystem[] fsList = GrowFSTest.getAllFileSystems(models[i]);
                    System.out.println("Filesystems for host: " + models[i].getHostname());
                    System.out.println("No of file systems: " + fsList.length);
                    if (fsList != null && fsList.length > 0) {
                        for (int j = 0; j < fsList.length; ++j) {
                            int k;
                            System.out.println("Filesystem " + (j + 1) + ":");
                            System.out.println("----------------------");
                            if (!fsList[j].getName().equals("samqfs_cm1")) continue;
                            System.out.println("Before Growing...");
                            System.out.println(fsList[j]);
                            System.out.println("Done. Press enter.");
                            System.in.read();
                            System.out.println("Starting grow steps...");
                            DiskCache[] disks = DiskDiscoveryTest.discoverAvailableAllocatableUnits(models[i]);
                            System.out.println("Done discovery...");
                            DiskCache[] meta = new DiskCache[2];
                            DiskCache[] data = new DiskCache[5];
                            for (k = 0; k < 2; ++k) {
                                meta[k] = disks[k];
                            }
                            for (k = 0; k < 5; ++k) {
                                data[k] = disks[k + 2];
                            }
                            System.out.println("Starting actual grow...");
                            models[i].getSamQFSSystemFSManager().growFileSystem(fsList[j], meta, data, null);
                            System.out.println("Done. Press enter.");
                            System.in.read();
                            System.out.println("File system after grow..");
                            System.out.println(fsList[j]);
                        }
                    }
                    System.out.println("===================================");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

