/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.test.archive43;

import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteria;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteriaCopy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteriaProp;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.impl.test.BaseTest;

public class PolCriteriaTest {
    public static void main(String[] args) {
        try {
            SamQFSSystemModel[] models = BaseTest.getAllSamQFSSystemModels();
            if (models != null && models.length > 0) {
                for (int i = 0; i < models.length; ++i) {
                    ArchivePolicy[] pols = models[i].getSamQFSSystemArchiveManager43().getAllArchivePolicies();
                    if (pols == null || pols.length <= 0) continue;
                    ArchivePolicy pol = pols[0];
                    String policyName = pol.getPolicyName();
                    System.out.println("Policy before adding a criteria.");
                    System.out.println(pol);
                    System.out.println("--------\n");
                    System.out.println("Default criteria for this pol.");
                    ArchivePolCriteria defCrit = pol.getDefaultArchivePolCriteriaForPolicy();
                    System.out.println(defCrit);
                    System.out.println("--------\n");
                    ArchivePolCriteriaProp prop = defCrit.getArchivePolCriteriaProperties();
                    prop.setStartingDir("polCritTest");
                    ArchivePolCriteriaCopy[] copies = defCrit.getArchivePolCriteriaCopies();
                    for (int j = 0; j < copies.length; ++j) {
                        copies[j].setArchiveAge(991 + j);
                        copies[j].setArchiveAgeUnit(7);
                    }
                    System.out.println("criteria to be added to pol.");
                    System.out.println(defCrit);
                    System.out.println("--------\n");
                    FileSystem[] fs2 = models[i].getSamQFSSystemFSManager().getAllFileSystems();
                    String[] fsNames = new String[fs2.length];
                    for (int j = 0; j < fs2.length; ++j) {
                        fsNames[j] = fs2[j].getName();
                        System.out.println("FS added: " + fs2[j].getName());
                    }
                    pol.addArchivePolCriteria(defCrit, fsNames);
                    System.out.println("Done adding criteria.");
                    System.out.println("Check archiver.cmd.");
                    System.out.println("Then hit Enter.");
                    System.in.read();
                    System.out.println("Policy after adding a criteria.");
                    System.out.println(pol);
                    System.out.println("--------\n");
                    pols = models[i].getSamQFSSystemArchiveManager43().getAllArchivePolicies();
                    pol = models[i].getSamQFSSystemArchiveManager43().getArchivePolicy(policyName);
                    System.out.println("Policy after re-reading.");
                    System.out.println(pol);
                    System.out.println("--------\n");
                    defCrit = pol.getArchivePolCriteria(0);
                    System.out.println("Criteria to be deleted.");
                    System.out.println(defCrit);
                    System.out.println("--------\n");
                    pol.deleteArchivePolCriteria(0);
                    System.out.println("Done deleting criteria.");
                    System.out.println("Check archiver.cmd.");
                    System.out.println("Then hit Enter.");
                    System.in.read();
                    System.out.println("Policy after deleting criteria.");
                    System.out.println(pol);
                    System.out.println("--------\n");
                    pols = models[i].getSamQFSSystemArchiveManager43().getAllArchivePolicies();
                    pol = models[i].getSamQFSSystemArchiveManager43().getArchivePolicy(policyName);
                    System.out.println("Policy after re-reading.");
                    System.out.println(pol);
                    System.out.println("--------\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

