/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator.media;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.impl.simulator.media.BaseDeviceImpl;
import com.sun.netstorage.samqfs.web.model.media.DiskCache;

public class DiskCacheImpl
extends BaseDeviceImpl
implements DiskCache {
    private int diskType = -1;
    private int diskCacheType = 0;
    private long capacity = -1L;
    private long availableSpace = -1L;
    private int consumedSpace = -1;
    private int noOfInodesRemaining = -1;
    private String vendor = new String();
    private String productId = new String();

    public DiskCacheImpl() {
    }

    public DiskCacheImpl(String devicePath, int diskType, long capacity) throws SamFSException {
        super(devicePath);
        super.setEquipType(diskType);
        super.setState(0);
        this.diskType = diskType;
        this.capacity = capacity;
        this.availableSpace = capacity;
        this.consumedSpace = 0;
    }

    public DiskCacheImpl(int diskType, long capacity, long availableSpace) {
        this.diskType = diskType;
        this.capacity = capacity;
        this.availableSpace = availableSpace;
        this.consumedSpace = (int)((capacity - availableSpace) * 100L / capacity);
    }

    public DiskCacheImpl(int diskType, int diskCacheType, long capacity, long availableSpace, int noOfInodesRemaining) {
        this.diskType = diskType;
        this.diskCacheType = diskCacheType;
        this.capacity = capacity;
        this.availableSpace = availableSpace;
        this.consumedSpace = (int)((capacity - availableSpace) * 100L / capacity);
        this.noOfInodesRemaining = noOfInodesRemaining;
    }

    public DiskCacheImpl(int diskType, int diskCacheType, String vendor, String productId, long capacity, long availableSpace, int noOfInodesRemaining) {
        this.diskType = diskType;
        this.diskCacheType = diskCacheType;
        this.vendor = vendor;
        this.productId = productId;
        this.capacity = capacity;
        this.availableSpace = availableSpace;
        this.consumedSpace = (int)((capacity - availableSpace) * 100L / capacity);
        this.noOfInodesRemaining = noOfInodesRemaining;
    }

    public DiskCacheImpl(DiskCache diskVal) {
        this.setDevicePath(diskVal.getDevicePath());
        this.setEquipOrdinal(diskVal.getEquipOrdinal());
        this.setEquipType(diskVal.getEquipType());
        this.setFamilySetName(diskVal.getFamilySetName());
        this.setFamilySetEquipOrdinal(diskVal.getFamilySetEquipOrdinal());
        this.setState(diskVal.getState());
        this.setAdditionalParamFilePath(diskVal.getAdditionalParamFilePath());
        this.setDiskType(diskVal.getDiskType());
        this.setDiskCacheType(diskVal.getDiskCacheType());
        this.setCapacity(diskVal.getCapacity());
        this.setAvailableSpace(diskVal.getAvailableSpace());
        this.setConsumedSpacePercentage(diskVal.getConsumedSpacePercentage());
        this.setNoOfInodesRemaining(diskVal.getNoOfInodesRemaining());
        this.setVendor(diskVal.getVendor());
        this.setProductId(diskVal.getProductId());
    }

    public int getDiskType() {
        return this.diskType;
    }

    public void setDiskType(int diskType) {
        this.diskType = diskType;
    }

    public int getDiskCacheType() {
        return this.diskCacheType;
    }

    public void setDiskCacheType(int diskCacheType) {
        this.diskCacheType = diskCacheType;
    }

    public static boolean isHADevice(String devPath) {
        return devPath.startsWith("/dev/global/") || devPath.startsWith("/dev/did/") || devPath.matches("/dev/((md)|(vx))/[^/]+/r?dsk/[^\\s]+");
    }

    public boolean isHA() {
        return DiskCacheImpl.isHADevice(this.getDevicePath());
    }

    public long getCapacity() {
        return this.capacity;
    }

    public void setCapacity(long capacity) {
        this.capacity = capacity;
        if (capacity > 0L) {
            this.consumedSpace = (int)((capacity - this.availableSpace) * 100L / capacity);
        }
    }

    public long getAvailableSpace() {
        return this.availableSpace;
    }

    public void setAvailableSpace(long availableSpace) {
        this.availableSpace = availableSpace;
        this.consumedSpace = (int)((this.capacity - availableSpace) * 100L / this.capacity);
    }

    public int getConsumedSpacePercentage() {
        return this.consumedSpace;
    }

    public void setConsumedSpacePercentage(int consumedSpace) {
        this.consumedSpace = consumedSpace;
    }

    public int getNoOfInodesRemaining() {
        return this.noOfInodesRemaining;
    }

    public void setNoOfInodesRemaining(int no) {
        this.noOfInodesRemaining = no;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append("Disk Type: " + this.diskType + "\n");
        buf.append("Disk Cache Type: " + this.diskCacheType + "\n");
        buf.append("Capacity: " + this.capacity + "\n");
        buf.append("Vendor: " + this.vendor + "\n");
        buf.append("Product ID: " + this.productId + "\n");
        buf.append("Available Space: " + this.availableSpace + "\n");
        buf.append("Consumed Space: " + this.consumedSpace + "% \n");
        buf.append("No Of Inodes Remaining: " + this.noOfInodesRemaining + "\n");
        return buf.toString();
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public Object clone() {
        DiskCacheImpl newObj = new DiskCacheImpl();
        newObj.setDevicePath(this.getDevicePath());
        newObj.setEquipOrdinal(this.getEquipOrdinal());
        newObj.setEquipType(this.getEquipType());
        newObj.setFamilySetName(this.getFamilySetName());
        newObj.setFamilySetEquipOrdinal(this.getFamilySetEquipOrdinal());
        newObj.setState(this.getState());
        newObj.setAdditionalParamFilePath(this.getAdditionalParamFilePath());
        newObj.setDiskType(this.getDiskType());
        newObj.setDiskCacheType(this.getDiskCacheType());
        newObj.setCapacity(this.getCapacity());
        newObj.setAvailableSpace(this.getAvailableSpace());
        newObj.setConsumedSpacePercentage(this.getConsumedSpacePercentage());
        newObj.setNoOfInodesRemaining(this.getNoOfInodesRemaining());
        newObj.setVendor(this.getVendor());
        newObj.setProductId(this.getProductId());
        return newObj;
    }
}

