/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator.fs;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.fs.RestoreFile;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Random;

public class RestoreFileImpl
implements RestoreFile {
    private boolean isDirectory;
    private String absolutePath;
    private String parentPath;
    private String name;
    private String size;
    private String protection;
    private String user;
    private String group;
    private Boolean isDamaged;
    private Boolean isOnline;
    private GregorianCalendar modifiedDate;
    private GregorianCalendar createdDate;
    private String restorePath;
    private int stageCopy = 2000;

    public RestoreFileImpl(boolean isDirectory, String absolutePath, String size, String protection, String user, String group, GregorianCalendar modifiedDate, GregorianCalendar createdDate, Boolean isDamaged, Boolean isOnline) throws SamFSException {
        this.isDirectory = isDirectory;
        this.absolutePath = absolutePath;
        this.restorePath = absolutePath;
        File file = new File(absolutePath);
        this.name = file.getName();
        this.size = size;
        this.modifiedDate = (GregorianCalendar)modifiedDate.clone();
        this.createdDate = (GregorianCalendar)createdDate.clone();
        this.user = user;
        this.group = group;
        this.protection = protection;
        this.isDamaged = isDamaged;
        this.isOnline = isOnline;
        this.parentPath = file.getParent();
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public String getFileName() {
        return this.name;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public String getRestorePath() {
        return this.restorePath;
    }

    public void setRestorePath(String restorePath) {
        this.restorePath = restorePath;
    }

    public String getProtection() {
        return this.protection;
    }

    public String getSize() {
        return this.size;
    }

    public String getUser() {
        return this.user;
    }

    public String getGroup() {
        return this.group;
    }

    public GregorianCalendar getCreationTime() {
        return this.createdDate;
    }

    public GregorianCalendar getModTime() {
        return this.modifiedDate;
    }

    public Boolean getIsDamaged() {
        return this.isDamaged;
    }

    public Boolean getIsOnline() {
        return this.isOnline;
    }

    public String[] getArchCopies() {
        GregorianCalendar now = new GregorianCalendar();
        Random rand = new Random(now.getTimeInMillis());
        int num = rand.nextInt(3) + 1;
        GregorianCalendar date = (GregorianCalendar)this.modifiedDate.clone();
        date.add(5, -1);
        date.set(11, 0);
        date.set(12, 0);
        date.set(13, 0);
        date.set(14, 0);
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd HH:mm:ss");
        String mumboJumbo = "  b8.1  dk arc1 f184";
        String[] archCopies = new String[num];
        for (int i = 0; i < num; ++i) {
            date.add(11, 4);
            NonSyncStringBuffer buf = new NonSyncStringBuffer().append(sdf.format(date.getTime())).append(mumboJumbo);
            archCopies[i] = buf.toString();
        }
        return archCopies;
    }

    public void setStageCopy(int copy) {
        if (copy != 2000 && copy != 1000 && copy != 3000 && (copy < 0 || copy > 3)) {
            TraceUtil.trace1("Invalid value for stage copy:  " + copy);
            this.stageCopy = 2000;
        } else {
            this.stageCopy = copy;
        }
    }

    public int getStageCopy() {
        return this.stageCopy;
    }
}

