/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator.archive43;

import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteria;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteriaProp;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSUtil;

public class ArchivePolCriteriaPropImpl
implements ArchivePolCriteriaProp {
    private ArchivePolCriteria archPolCriteria = null;
    private boolean global = false;
    private String startingDir = new String();
    private long minSize = -1L;
    private int minSizeUnit = -1;
    private long maxSize = -1L;
    private int maxSizeUnit = -1;
    private String namePattern = new String();
    private String owner = new String();
    private String group = new String();
    private int stageAttribs = -1;
    private int releaseAttribs = -1;
    private long accessAge = -1L;
    private int accessAgeUnit = -1;

    public ArchivePolCriteriaPropImpl() {
    }

    public ArchivePolCriteriaPropImpl(ArchivePolCriteria archPolCriteria, String startingDir, long minSize, int minSizeUnit, long maxSize, int maxSizeUnit, String namePattern, String owner, String group, int stageAttribs, int releaseAttribs, long accessAge, int accessAgeUnit) {
        this.archPolCriteria = archPolCriteria;
        this.startingDir = startingDir;
        this.minSize = minSize;
        this.minSizeUnit = minSizeUnit;
        this.maxSize = maxSize;
        this.maxSizeUnit = maxSizeUnit;
        this.namePattern = namePattern;
        this.owner = owner;
        this.group = group;
        this.stageAttribs = stageAttribs;
        this.releaseAttribs = releaseAttribs;
        this.accessAge = accessAge;
        this.accessAgeUnit = accessAgeUnit;
        if (minSize >= 0L) {
            this.minSizeUnit = 0;
        }
        if (maxSize >= 0L) {
            this.maxSizeUnit = 0;
        }
        if (accessAge >= 0L) {
            this.accessAgeUnit = 6;
        }
    }

    public ArchivePolCriteria getArchivePolCriteria() {
        return this.archPolCriteria;
    }

    public void setArchivePolCriteria(ArchivePolCriteria archPolCriteria) {
        this.archPolCriteria = archPolCriteria;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public String getStartingDir() {
        return this.startingDir;
    }

    public void setStartingDir(String startingDir) {
        if (startingDir != null) {
            this.startingDir = startingDir;
        }
    }

    public long getMinSize() {
        return this.minSize;
    }

    public void setMinSize(long size) {
        this.minSize = size;
    }

    public long getMinSizeInBytes() {
        long size = -1L;
        if (this.minSizeUnit != -1 && this.minSize >= 0L) {
            size = SamQFSUtil.getSizeInBytes(this.minSize, this.minSizeUnit);
        }
        return size;
    }

    public int getMinSizeUnit() {
        return this.minSizeUnit;
    }

    public void setMinSizeUnit(int sizeUnit) {
        this.minSizeUnit = sizeUnit;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(long size) {
        this.maxSize = size;
    }

    public long getMaxSizeInBytes() {
        long size = -1L;
        if (this.maxSizeUnit != -1 && this.maxSize >= 0L) {
            size = SamQFSUtil.getSizeInBytes(this.maxSize, this.maxSizeUnit);
        }
        return size;
    }

    public int getMaxSizeUnit() {
        return this.maxSizeUnit;
    }

    public void setMaxSizeUnit(int sizeUnit) {
        this.maxSizeUnit = sizeUnit;
    }

    public String getNamePattern() {
        return this.namePattern;
    }

    public void setNamePattern(String pattern) {
        this.namePattern = pattern;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public int getStageAttributes() {
        return this.stageAttribs;
    }

    public void setStageAttributes(int attribs) {
        this.stageAttribs = attribs;
    }

    public int getReleaseAttributes() {
        return this.releaseAttribs;
    }

    public void setReleaseAttributes(int attribs) {
        this.releaseAttribs = attribs;
    }

    public long getAccessAge() {
        return this.accessAge;
    }

    public void setAccessAge(long accessAge) {
        this.accessAge = accessAge;
    }

    public int getAccessAgeUnit() {
        return this.accessAgeUnit;
    }

    public void setAccessAgeUnit(int accessAgeUnit) {
        this.accessAgeUnit = accessAgeUnit;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.archPolCriteria == null) {
            buf.append("Policy criteria is null for this property object.\n");
        }
        buf.append("Starting Dir: " + this.startingDir + "\n");
        buf.append("Min Size: " + this.minSize + "\n");
        buf.append("Min Size Unit: " + this.minSizeUnit + "\n");
        buf.append("Max Size: " + this.maxSize + "\n");
        buf.append("Max Size Unit: " + this.maxSizeUnit + "\n");
        buf.append("Name Pattern: " + this.namePattern + "\n");
        buf.append("Owner: " + this.owner + "\n");
        buf.append("Group: " + this.group + "\n");
        buf.append("Stage Attributes: " + this.stageAttribs + "\n");
        buf.append("Release Attributes: " + this.releaseAttribs + "\n");
        buf.append("Access Age: " + this.accessAge + "\n");
        buf.append("Access Age Unit: " + this.accessAgeUnit + "\n");
        return buf.toString();
    }
}

