/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.simulator;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiHostException;
import com.sun.netstorage.samqfs.web.model.MDSAddresses;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemSharedFSManager;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.fs.FileSystemMountProperties;
import com.sun.netstorage.samqfs.web.model.fs.SharedMember;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSAppModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.simulator.fs.FileSystemImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.fs.SharedMemberImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.media.DiskCacheImpl;
import com.sun.netstorage.samqfs.web.model.impl.simulator.media.SharedDiskCacheImpl;
import com.sun.netstorage.samqfs.web.model.media.DiskCache;
import com.sun.netstorage.samqfs.web.model.media.SharedDiskCache;
import com.sun.netstorage.samqfs.web.model.media.StripedGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class SamQFSSystemSharedFSManagerImpl
implements SamQFSSystemSharedFSManager {
    private SamQFSAppModelImpl appModel = null;
    private HashMap sharedMap = new HashMap();

    public SamQFSSystemSharedFSManagerImpl(SamQFSAppModelImpl appModel) {
        this.appModel = appModel;
    }

    public SharedDiskCache[] discoverAllocatableUnitsForShared(String[] servers, String[] clients) throws SamFSMultiHostException {
        if (servers == null || servers.length < 1 || !SamQFSUtil.isValidString(servers[0])) {
            throw new SamFSMultiHostException("logic.invalidFSParam");
        }
        ArrayList list = null;
        ArrayList<SharedDiskCacheImpl> sDiskList = new ArrayList<SharedDiskCacheImpl>();
        try {
            list = SamQFSUtil.createAUs(101, 20);
            for (int i = 0; i < 20; ++i) {
                ArrayList tmpList;
                SamQFSSystemModelImpl model;
                int j;
                DiskCacheImpl disk = (DiskCacheImpl)list.get(i);
                SharedDiskCacheImpl sDisk = new SharedDiskCacheImpl(disk);
                sDiskList.add(sDisk);
                for (j = 0; j < servers.length; ++j) {
                    if (j != 0) {
                        sDisk.addServer(servers[j]);
                    }
                    model = this.getSystem(servers[j]);
                    tmpList = model.getAvailableAUs();
                    tmpList.add(sDisk.clone());
                }
                if (i < 10 || clients == null || clients.length <= 0) continue;
                for (j = 0; j < clients.length; ++j) {
                    sDisk.addClient(clients[j]);
                    model = this.getSystem(clients[j]);
                    tmpList = model.getAvailableAUs();
                    tmpList.add(sDisk.clone());
                }
            }
        }
        catch (SamFSException e) {
            ArrayList<String> errorHostNames = new ArrayList<String>();
            ArrayList<SamFSException> errorExceptions = new ArrayList<SamFSException>();
            errorHostNames.add("simulator");
            errorExceptions.add(e);
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
        }
        return sDiskList.toArray(new SharedDiskCache[0]);
    }

    public FileSystem createSharedFileSystem(String fsName, String mountPoint, int DAUSize, SharedMember[] membersIn, FileSystemMountProperties mountProps, DiskCache[] metadataDevices, DiskCache[] dataDevices, StripedGroup[] stripedGroups, boolean single, boolean mountAtBoot, boolean createMountPoint, boolean mountAfterCreate) throws SamFSMultiHostException {
        String serverName = null;
        int archType = 3;
        int equipOrdinal = -1;
        int fsType = 0;
        String[] potentialMDServers = null;
        String[] clients = null;
        FileSystemImpl fs2 = null;
        ArrayList<String> tmpPMDS = new ArrayList<String>();
        ArrayList<String> tmpClients = new ArrayList<String>();
        try {
            FileSystemImpl tempFS;
            int i;
            block7: for (int i2 = 0; i2 < membersIn.length; ++i2) {
                switch (membersIn[i2].getType()) {
                    case 0: {
                        serverName = membersIn[i2].getHostName();
                        continue block7;
                    }
                    case 1: {
                        tmpPMDS.add(membersIn[i2].getHostName());
                        continue block7;
                    }
                    case 2: {
                        tmpClients.add(membersIn[i2].getHostName());
                    }
                }
            }
            if (!SamQFSUtil.isValidString(serverName)) {
                throw new SamFSMultiHostException("logic.invalidFSParam");
            }
            potentialMDServers = tmpPMDS.toArray(new String[0]);
            clients = tmpClients.toArray(new String[0]);
            SamQFSSystemModelImpl model = this.getSystem(serverName);
            if (model == null) {
                throw new SamFSMultiHostException("logic.unknownHost");
            }
            HashMap<String, MDSAddresses[]> members = new HashMap<String, MDSAddresses[]>();
            fs2 = (FileSystemImpl)model.getSamQFSSystemFSManager().createFileSystem(fsName, fsType, archType, equipOrdinal, mountPoint, 1, DAUSize, mountProps, metadataDevices, dataDevices, stripedGroups, single, mountAtBoot, createMountPoint, mountAfterCreate);
            fs2.setServerName(serverName);
            members.put(serverName, new MDSAddresses[0]);
            this.sharedMap.put(fsName + "@" + serverName, members);
            if (potentialMDServers != null && potentialMDServers.length > 0) {
                for (i = 0; i < potentialMDServers.length; ++i) {
                    model = this.getSystem(potentialMDServers[i]);
                    if (model == null) continue;
                    tempFS = (FileSystemImpl)model.getSamQFSSystemFSManager().createFileSystem(fsName, fsType, archType, equipOrdinal, mountPoint, 2, DAUSize, mountProps, metadataDevices, dataDevices, stripedGroups, single, mountAtBoot, createMountPoint, mountAfterCreate);
                    tempFS.setServerName(serverName);
                    members.put(potentialMDServers[i], new MDSAddresses[0]);
                }
            }
            if (clients != null && clients.length > 0) {
                for (i = 0; i < clients.length; ++i) {
                    model = this.getSystem(clients[i]);
                    if (model == null) continue;
                    tempFS = (FileSystemImpl)model.getSamQFSSystemFSManager().createFileSystem(fsName, fsType, archType, equipOrdinal, mountPoint, 3, DAUSize, mountProps, metadataDevices, dataDevices, stripedGroups, single, mountAtBoot, createMountPoint, mountAfterCreate);
                    tempFS.setServerName(serverName);
                    members.put(clients[i], new MDSAddresses[0]);
                }
            }
        }
        catch (SamFSException e) {
            ArrayList<String> errorHostNames = new ArrayList<String>();
            ArrayList<SamFSException> errorExceptions = new ArrayList<SamFSException>();
            errorHostNames.add("simulator");
            errorExceptions.add(e);
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
        }
        return fs2;
    }

    public FileSystem addHostToSharedFS(String fsName, String mdServerName, String mountPoint, String hostName, String[] hostIP, boolean readOnly, boolean mountAtBoot, boolean creatMountPoint, boolean mountAfterCreate, boolean potentialMdServer, boolean bg) throws SamFSMultiHostException {
        FileSystemImpl fsN = null;
        try {
            SamQFSSystemModelImpl model = this.getSystem(mdServerName);
            if (model == null) {
                throw new SamFSMultiHostException("logic.unknownHost");
            }
            FileSystemImpl fs2 = (FileSystemImpl)model.getSamQFSSystemFSManager().getFileSystem(fsName);
            if (fs2 == null) {
                throw new SamFSMultiHostException("logic.unknownSharedFS");
            }
            model = this.getSystem(hostName);
            if (model == null) {
                throw new SamFSMultiHostException("logic.unknownHost");
            }
            HashMap members = (HashMap)this.sharedMap.get(fsName + "@" + mdServerName);
            if (members == null) {
                throw new SamFSMultiHostException("logic.unknownSharedFS");
            }
            MDSAddresses[] myAddresses = (MDSAddresses[])members.get(hostName);
            if (myAddresses != null) {
                throw new SamFSMultiHostException("logic.sharedMemberPresent");
            }
            int shareStatus = 3;
            if (potentialMdServer) {
                shareStatus = 2;
            }
            fsN = (FileSystemImpl)model.getSamQFSSystemFSManager().createFileSystem(fsName, fs2.getFSType(), fs2.getArchivingType(), -1, mountPoint, shareStatus, fs2.getDAUSize(), fs2.getMountProperties(), fs2.getMetadataDevices(), fs2.getDataDevices(), fs2.getStripedGroups(), true, mountAtBoot, creatMountPoint, mountAfterCreate);
            fsN.setServerName(mdServerName);
            members.put(hostName, new MDSAddresses[0]);
        }
        catch (SamFSException e) {
            ArrayList<String> errorHostNames = new ArrayList<String>();
            ArrayList<SamFSException> errorExceptions = new ArrayList<SamFSException>();
            errorHostNames.add("simulator");
            errorExceptions.add(e);
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
        }
        return fsN;
    }

    public void deleteSharedFileSystem(String hostName, String fsName, String mdServer) throws SamFSMultiHostException {
        try {
            SamQFSSystemModelImpl model = this.getSystem(hostName);
            if (model == null) {
                throw new SamFSMultiHostException("logic.unknownHost");
            }
            FileSystemImpl fs2 = (FileSystemImpl)model.getSamQFSSystemFSManager().getFileSystem(fsName);
            if (fs2 == null) {
                System.out.println("Throwing exception in deleteSharedFileSystem!");
                throw new SamFSMultiHostException("logic.unknownSharedFS");
            }
            String mdServerName = fs2.getServerName();
            HashMap members = (HashMap)this.sharedMap.get(fsName + "@" + mdServerName);
            if (fs2.getSharedMember().getType() == 1 || fs2.getSharedMember().getType() == 2) {
                model.getSamQFSSystemFSManager().deleteFileSystem(fs2);
                if (members != null) {
                    members.remove(hostName);
                }
            } else if (fs2.getSharedMember().getType() == 0) {
                if (members != null) {
                    Iterator it = members.keySet().iterator();
                    while (it.hasNext()) {
                        model = this.getSystem((String)it.next());
                        fs2 = (FileSystemImpl)model.getSamQFSSystemFSManager().getFileSystem(fsName);
                        model.getSamQFSSystemFSManager().deleteFileSystem(fs2);
                    }
                }
                this.sharedMap.remove(fsName + "@" + hostName);
            }
        }
        catch (SamFSException e) {
            ArrayList<String> errorHostNames = new ArrayList<String>();
            ArrayList<SamFSException> errorExceptions = new ArrayList<SamFSException>();
            errorHostNames.add("simulator");
            errorExceptions.add(e);
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
        }
    }

    public boolean failingover(String mdServer, String fsName) throws SamFSException {
        SamQFSSystemModelImpl model = this.getSystem(mdServer);
        if (model == null) {
            throw new SamFSException("logic.unknownHost");
        }
        FileSystemImpl fs2 = (FileSystemImpl)model.getSamQFSSystemFSManager().getFileSystem(fsName);
        if (fs2 == null) {
            throw new SamFSException("logic.unknownSharedFS");
        }
        return false;
    }

    public int getSharedFSType(String hostName, String fsName) throws SamFSException {
        SamQFSSystemModelImpl model = this.getSystem(hostName);
        if (model == null) {
            throw new SamFSException("logic.unknownHost");
        }
        FileSystemImpl fs2 = (FileSystemImpl)model.getSamQFSSystemFSManager().getFileSystem(fsName);
        if (fs2 == null) {
            System.out.println("Throwing exception in getSharedFSType!");
            throw new SamFSException("logic.unknownSharedFS");
        }
        return fs2.getSharedMember().getType();
    }

    public SharedMember[] getSharedMembers(String mdServer, String fsName) throws SamFSMultiHostException {
        ArrayList<SharedMember> shared = new ArrayList<SharedMember>();
        try {
            HashMap members = (HashMap)this.sharedMap.get(fsName + "@" + mdServer);
            if (members == null) {
                throw new SamFSMultiHostException("logic.unknownSharedFS");
            }
            Iterator it = members.keySet().iterator();
            while (it.hasNext()) {
                SamQFSSystemModelImpl model = this.getSystem((String)it.next());
                if (model == null) {
                    throw new SamFSMultiHostException("logic.unknownHost");
                }
                FileSystemImpl fs2 = (FileSystemImpl)model.getSamQFSSystemFSManager().getFileSystem(fsName);
                if (fs2 == null) {
                    throw new SamFSMultiHostException("logic.unknownSharedFS");
                }
                shared.add(fs2.getSharedMember());
            }
        }
        catch (SamFSException e) {
            ArrayList<String> errorHostNames = new ArrayList<String>();
            ArrayList<SamFSException> errorExceptions = new ArrayList<SamFSException>();
            errorHostNames.add("simulator");
            errorExceptions.add(e);
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
        }
        return shared.toArray(new SharedMember[0]);
    }

    public int[] getSharedLicenses(String[] hostNames) throws SamFSException {
        int[] licenses = null;
        if (hostNames != null) {
            licenses = new int[hostNames.length];
            for (int i = 0; i < hostNames.length; ++i) {
                SamQFSSystemModelImpl model = this.getSystem(hostNames[i]);
                if (model == null) {
                    throw new SamFSException("logic.unknownHost");
                }
                licenses[i] = model.isDown() ? -1 : 1;
            }
        }
        return licenses;
    }

    public void setSharedMountOptions(String mdServer, String fsName, FileSystemMountProperties options) throws SamFSMultiHostException {
        try {
            SamQFSSystemModelImpl model = this.getSystem(mdServer);
            if (model == null) {
                throw new SamFSMultiHostException("logic.unknownHost");
            }
            FileSystemImpl fs2 = (FileSystemImpl)model.getSamQFSSystemFSManager().getFileSystem(fsName);
            if (fs2 == null) {
                throw new SamFSMultiHostException("logic.unknownSharedFS");
            }
            HashMap members = (HashMap)this.sharedMap.get(fsName + "@" + mdServer);
            if (members != null) {
                Iterator it = members.keySet().iterator();
                while (it.hasNext()) {
                    model = this.getSystem((String)it.next());
                    fs2 = (FileSystemImpl)model.getSamQFSSystemFSManager().getFileSystem(fsName);
                    fs2.setMountProperties(options);
                }
            }
        }
        catch (SamFSException e) {
            ArrayList<String> errorHostNames = new ArrayList<String>();
            ArrayList<SamFSException> errorExceptions = new ArrayList<SamFSException>();
            errorHostNames.add("simulator");
            errorExceptions.add(e);
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
        }
    }

    public String[] getHostsNotUsedBy(String fsName, String mdServer) throws SamFSException {
        HashMap members;
        SamQFSSystemModel[] models = this.appModel.getAllSamQFSSystemModels();
        ArrayList<String> hostNames = new ArrayList<String>();
        if (models != null) {
            for (int i = 0; i < models.length; ++i) {
                hostNames.add(models[i].getHostname());
            }
        }
        if ((members = (HashMap)this.sharedMap.get(fsName + "@" + mdServer)) != null) {
            Iterator it = members.keySet().iterator();
            while (it.hasNext()) {
                int index = hostNames.indexOf((String)it.next());
                if (index == -1) continue;
                hostNames.remove(index);
            }
        }
        return hostNames.toArray(new String[0]);
    }

    public String[] getIPAddresses(String hostName) throws SamFSException {
        String[] ipAddresses = null;
        SamQFSSystemModelImpl model = this.getSystem(hostName);
        if (model != null) {
            ipAddresses = model.getIPAddresses();
        }
        return ipAddresses;
    }

    public SharedMember createSharedMember(String name, String[] ips, int type) {
        return new SharedMemberImpl(name, ips, type, false);
    }

    private SamQFSSystemModelImpl getSystem(String hostName) {
        SamQFSSystemModelImpl model = null;
        try {
            model = (SamQFSSystemModelImpl)this.appModel.getSamQFSSystemModel(hostName);
        }
        catch (SamFSException samFSException) {
            // empty catch block
        }
        return model;
    }

    public void freeResources() {
    }

    public MDSAddresses[] getAdvancedNetworkConfig(String hostName, String fsName) throws SamFSException {
        SamQFSSystemModelImpl model = this.getSystem(hostName);
        String mdServerName = model.getSamQFSSystemFSManager().getFileSystem(fsName).getServerName();
        HashMap members = (HashMap)this.sharedMap.get(fsName + "@" + mdServerName);
        if (members == null) {
            throw new SamFSMultiHostException("logic.unknownSharedFS");
        }
        return (MDSAddresses[])members.get(hostName);
    }

    private void setAdvancedNetworkConfig(String hostName, String fsName, MDSAddresses[] addresses) throws SamFSException {
        SamQFSSystemModelImpl model = this.getSystem(hostName);
        String mdServerName = model.getSamQFSSystemFSManager().getFileSystem(fsName).getServerName();
        HashMap members = (HashMap)this.sharedMap.get(fsName + "@" + mdServerName);
        if (members == null) {
            throw new SamFSMultiHostException("logic.unknownSharedFS");
        }
        members.put(hostName, addresses);
        this.sharedMap.put(fsName + "@" + mdServerName, members);
    }

    public void setAdvancedNetworkConfigToMultipleHosts(String[] hostNames, String fsName, String mdsName, MDSAddresses[] addresses) throws SamFSMultiHostException, SamFSException {
        if (hostNames == null || hostNames.length == 0) {
            throw new SamFSMultiHostException("Developers' bug found!");
        }
        ArrayList<String> errorHostNames = new ArrayList<String>();
        ArrayList<SamFSException> errorExceptions = new ArrayList<SamFSException>();
        for (int i = 0; i < hostNames.length; ++i) {
            try {
                this.setAdvancedNetworkConfig(hostNames[i], fsName, addresses);
                continue;
            }
            catch (SamFSException e) {
                errorHostNames.add(hostNames[i]);
                errorExceptions.add(e);
            }
        }
        if (!errorHostNames.isEmpty()) {
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
        }
    }
}

