/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.media;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.arc.DiskVol;
import com.sun.netstorage.samqfs.web.model.media.DiskVolume;
import com.sun.netstorage.samqfs.web.util.TraceUtil;

public class DiskVolumeImpl
implements DiskVolume {
    DiskVol vol;

    public DiskVolumeImpl(DiskVol vol) {
        this.vol = vol;
        if (vol == null) {
            TraceUtil.trace1("Internal error: null DiskVol");
        }
    }

    public String getName() {
        return this.vol.getVolName();
    }

    public String getRemoteHost() {
        return this.vol.getHost();
    }

    public String getPath() {
        return this.vol.getPath();
    }

    public long getCapacityKB() {
        long cap = this.vol.getCapacity();
        if (cap == 0L) {
            cap = -1L;
        }
        return cap;
    }

    public long getAvailableSpaceKB() {
        long avail = this.vol.getAvailableSpace();
        if (0L == this.vol.getCapacity()) {
            avail = -1L;
        }
        return avail;
    }

    public boolean isLabeled() {
        return this.vol.isLabeled();
    }

    public void setLabeled(boolean labeled) {
        this.vol.setLabeled(labeled);
    }

    public boolean isReadOnly() {
        return this.vol.isReadOnly();
    }

    public void setReadOnly(boolean readOnly) {
        this.vol.setReadOnly(readOnly);
    }

    public boolean isBadMedia() {
        return this.vol.isBadMedia();
    }

    public void setBadMedia(boolean badMedia) {
        this.vol.setBadMedia(badMedia);
    }

    public boolean isUnavailable() {
        return this.vol.isUnavailable();
    }

    public void setUnavailable(boolean unavailable) {
        this.vol.setUnavailable(unavailable);
    }

    public boolean isRemote() {
        return this.vol.isRemote();
    }

    public boolean isUnknown() {
        return this.vol.isUnknown();
    }

    public void updateFlags(Ctx ctx) throws SamFSException {
        this.vol.setStatusFlags(ctx);
    }
}

