/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.archive;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.arc.VSNMap;
import com.sun.netstorage.samqfs.mgmt.arc.VSNOp;
import com.sun.netstorage.samqfs.mgmt.arc.VSNPool;
import com.sun.netstorage.samqfs.mgmt.media.CatEntry;
import com.sun.netstorage.samqfs.mgmt.media.Media;
import com.sun.netstorage.samqfs.web.model.archive.ArchiveCopy;
import com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.archive.ArchiveVSNMap;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive.VSNPoolImpl;
import java.util.ArrayList;

public class ArchiveVSNMapImpl
implements ArchiveVSNMap,
Cloneable {
    private SamQFSSystemModelImpl model = null;
    private VSNMap map = null;
    private ArchiveCopy archCopy = null;
    private int archType = -1;
    private ArrayList availVSNNames = new ArrayList();
    private ArrayList vsnPools = new ArrayList();
    private String vsnExpression = new String();
    private String startVSNname = new String();
    private String endVSNname = new String();
    private String poolExpression = new String();
    private boolean mapUpdateNeeded = false;
    private long availableSpace = -1L;

    public ArchiveVSNMapImpl() {
    }

    public ArchiveVSNMapImpl(ArchiveCopy archCopy, int archType, ArrayList vsns, ArrayList vsnPools) throws SamFSException {
        int i;
        this.archCopy = archCopy;
        this.archType = archType;
        if (vsns != null && vsns.size() > 0) {
            this.availVSNNames = vsns;
            StringBuffer vsnBuf = new StringBuffer();
            for (i = 0; i < vsns.size(); ++i) {
                if (i != 0) {
                    vsnBuf.append(",");
                }
                vsnBuf.append((String)this.availVSNNames.get(i));
            }
            this.vsnExpression = vsnBuf.toString();
        }
        if (vsnPools != null && vsnPools.size() > 0) {
            this.vsnPools = vsnPools;
            StringBuffer poolBuf = new StringBuffer();
            for (i = 0; i < vsnPools.size(); ++i) {
                if (i != 0) {
                    poolBuf.append(",");
                }
                poolBuf.append(((com.sun.netstorage.samqfs.web.model.archive.VSNPool)vsnPools.get(i)).getPoolName());
            }
            this.poolExpression = poolBuf.toString();
        }
    }

    public ArchiveVSNMapImpl(SamQFSSystemModelImpl model, ArchiveCopy archCopy, VSNMap map) throws SamFSException {
        this.model = model;
        this.archCopy = archCopy;
        this.map = map;
        this.archType = SamQFSUtil.getMediaTypeInteger(map.getMediaType());
        this.vsnExpression = SamQFSUtil.createVSNExpressionFromStrings(map.getVSNNames());
        this.poolExpression = SamQFSUtil.createVSNExpressionFromStrings(map.getPoolNames());
        this.availableSpace = 0L;
        this.availVSNNames.clear();
        this.updatePoolsFromPoolNames(map.getPoolNames());
        this.updateVSNsFromExpressionList(map.getVSNNames());
    }

    public void update() throws SamFSException {
        if (this.mapUpdateNeeded) {
            boolean commaNeeded = false;
            StringBuffer exp = new StringBuffer();
            if (SamQFSUtil.isValidString(this.vsnExpression)) {
                exp.append(this.vsnExpression);
                commaNeeded = true;
            }
            if (SamQFSUtil.isValidString(this.startVSNname) || SamQFSUtil.isValidString(this.endVSNname)) {
                if (commaNeeded) {
                    exp.append(",");
                }
                exp.append(SamQFSUtil.createExpression(this.startVSNname, this.endVSNname));
            }
            this.vsnExpression = exp.toString();
        }
        if (this.map == null && this.archType != -1) {
            ArchivePolicy archPolicy = null;
            if (this.archCopy != null) {
                archPolicy = this.archCopy.getArchivePolicy();
            }
            if (archPolicy != null) {
                this.map = new VSNMap(archPolicy.getPolicyName() + "." + this.archCopy.getCopyNumber(), SamQFSUtil.getMediaTypeString(this.archType), SamQFSUtil.getStringsFromCommaStream(this.getMapExpression()), SamQFSUtil.getStringsFromCommaStream(this.getPoolExpression()));
                if (this.model != null) {
                    VSNOp.addMap((Ctx)this.model.getJniContext(), (VSNMap)this.map);
                }
            }
        } else if (this.map != null && this.archType != -1) {
            this.map.setVSNNames(SamQFSUtil.getStringsFromCommaStream(this.getMapExpression()));
            this.map.setPoolNames(SamQFSUtil.getStringsFromCommaStream(this.getPoolExpression()));
            if (this.model != null) {
                VSNOp.modifyMap((Ctx)this.model.getJniContext(), (VSNMap)this.map);
            }
        }
        if (this.map != null) {
            this.availableSpace = 0L;
            this.availVSNNames.clear();
            this.updatePoolsFromPoolNames(this.map.getPoolNames());
            this.updateVSNsFromExpressionList(this.map.getVSNNames());
        }
    }

    public void removeJniMap() throws SamFSException {
        if (this.model != null && this.map != null) {
            VSNOp.removeMap((Ctx)this.model.getJniContext(), (String)this.map.getCopyName());
            this.map = null;
        }
    }

    public ArchiveCopy getArchiveCopy() throws SamFSException {
        return this.archCopy;
    }

    public void setArchiveCopy(ArchiveCopy copy) throws SamFSException {
        this.archCopy = copy;
    }

    public void setModel(SamQFSSystemModelImpl model) {
        this.model = model;
    }

    public int getArchiveMediaType() throws SamFSException {
        return this.archType;
    }

    public void setArchiveMediaType(int type) throws SamFSException {
        this.archType = type;
        if (this.map != null) {
            this.map.setMediaType(SamQFSUtil.getMediaTypeString(type));
        }
    }

    public com.sun.netstorage.samqfs.web.model.archive.VSNPool[] getVSNPools() throws SamFSException {
        return this.vsnPools.toArray(new com.sun.netstorage.samqfs.web.model.archive.VSNPool[0]);
    }

    public void setVSNPools(com.sun.netstorage.samqfs.web.model.archive.VSNPool[] pools) throws SamFSException {
        this.vsnPools.clear();
        ArrayList<String> poolNames = new ArrayList<String>();
        if (pools != null) {
            for (int i = 0; i < pools.length; ++i) {
                this.vsnPools.add(pools[i]);
                poolNames.add(pools[i].getPoolName());
            }
        }
        this.poolExpression = SamQFSUtil.createVSNExpressionFromStrings(poolNames.toArray(new String[0]));
        if (this.map != null) {
            this.map.setPoolNames(poolNames.toArray(new String[0]));
        }
    }

    public String getPoolExpression() {
        return this.poolExpression;
    }

    public void setPoolExpression(String poolExp) {
        if (poolExp != null) {
            this.poolExpression = poolExp;
            if (this.map != null) {
                this.map.setPoolNames(SamQFSUtil.getStringsFromCommaStream(poolExp));
            }
        }
    }

    public String getMapExpression() throws SamFSException {
        return this.vsnExpression;
    }

    public void setMapExpression(String expression) throws SamFSException {
        if (expression != null) {
            this.vsnExpression = expression;
            if (this.map != null) {
                this.map.setVSNNames(SamQFSUtil.getStringsFromCommaStream(expression));
            }
        }
    }

    public String getMapExpressionStartVSN() throws SamFSException {
        return this.startVSNname;
    }

    public void setMapExpressionStartVSN(String expression) throws SamFSException {
        if (expression != null & !this.startVSNname.equals(expression)) {
            this.startVSNname = expression;
            this.mapUpdateNeeded = true;
        }
    }

    public String getMapExpressionEndVSN() throws SamFSException {
        return this.endVSNname;
    }

    public void setMapExpressionEndVSN(String expression) throws SamFSException {
        if (expression != null & !this.endVSNname.equals(expression)) {
            this.endVSNname = expression;
            this.mapUpdateNeeded = true;
        }
    }

    public String[] getAvailableVSNs() throws SamFSException {
        return this.availVSNNames.toArray(new String[0]);
    }

    public long getAvailableSpace() throws SamFSException {
        return this.availableSpace;
    }

    public Object clone() {
        ArchiveVSNMapImpl map = null;
        try {
            int i;
            ArrayList listVSN = null;
            ArrayList listPool = null;
            if (this.availVSNNames != null) {
                listVSN = new ArrayList();
                for (i = 0; i < this.availVSNNames.size(); ++i) {
                    listVSN.add(this.availVSNNames.get(i));
                }
            }
            if (this.vsnPools != null) {
                listPool = new ArrayList();
                for (i = 0; i < this.vsnPools.size(); ++i) {
                    listPool.add(this.vsnPools.get(i));
                }
            }
            map = new ArchiveVSNMapImpl(this.getArchiveCopy(), this.getArchiveMediaType(), listVSN, listPool);
            map.setMapExpression(this.getMapExpression());
            map.setMapExpressionStartVSN(this.getMapExpressionStartVSN());
            map.setMapExpressionEndVSN(this.getMapExpressionEndVSN());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.archCopy != null) {
            try {
                buf.append("Archive Copy Number: " + this.archCopy.getCopyNumber() + "\n");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        buf.append("Archive Type: " + this.archType + "\n");
        try {
            if (this.availVSNNames != null) {
                for (int i = 0; i < this.availVSNNames.size(); ++i) {
                    buf.append("VSN: \n" + (String)this.availVSNNames.get(i) + "\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.vsnPools != null) {
                for (int i = 0; i < this.vsnPools.size(); ++i) {
                    buf.append("VSN Pools: \n" + ((com.sun.netstorage.samqfs.web.model.archive.VSNPool)this.vsnPools.get(i)).getPoolName() + "\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            String[] availVSNs = this.getAvailableVSNs();
            if (availVSNs != null) {
                for (int i = 0; i < availVSNs.length; ++i) {
                    buf.append("Available VSN: \n" + availVSNs[i] + "\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            buf.append("Space Available: " + this.getAvailableSpace() + "\n");
            buf.append("VSN Expression: " + this.getMapExpression() + "\n");
            buf.append("Pool Expression: " + this.getPoolExpression() + "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buf.toString();
    }

    private void updateVSNsFromExpressionList(String[] vsnExpressions) throws SamFSException {
        CatEntry[] vsnFromCat = null;
        if (vsnExpressions != null) {
            for (int i = 0; i < vsnExpressions.length; ++i) {
                Ctx ctx = null;
                if (this.model != null) {
                    ctx = this.model.getJniContext();
                }
                if ((vsnFromCat = Media.getCatEntriesForRegexp((Ctx)ctx, (String)vsnExpressions[i], (int)-1, (int)-1, (short)4, (boolean)false)) == null) continue;
                for (int j = 0; j < vsnFromCat.length; ++j) {
                    if (vsnFromCat[j].getFreeSpace() <= 0L || this.availVSNNames.indexOf(vsnFromCat[j].getVSN()) != -1) continue;
                    this.availVSNNames.add(vsnFromCat[j].getVSN());
                    this.availableSpace += vsnFromCat[j].getFreeSpace();
                }
            }
        }
    }

    private void updatePoolsFromPoolNames(String[] poolNames) throws SamFSException {
        this.vsnPools.clear();
        if (this.model != null && poolNames != null && poolNames.length > 0) {
            Ctx ctx = this.model.getJniContext();
            for (int i = 0; i < poolNames.length; ++i) {
                VSNPool jniPool = VSNOp.getPool((Ctx)ctx, (String)poolNames[i]);
                if (jniPool == null) continue;
                VSNPoolImpl pool = new VSNPoolImpl(this.model, jniPool);
                this.vsnPools.add(pool);
                this.availableSpace += pool.getSpaceAvailable();
                String[] members = pool.getMemberVSNNames();
                if (members == null) continue;
                for (int j = 0; j < members.length; ++j) {
                    if (this.availVSNNames.indexOf(members[j]) != -1) continue;
                    this.availVSNNames.add(members[j]);
                }
            }
        }
    }
}

