/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.adm.Fault;
import com.sun.netstorage.samqfs.mgmt.adm.FaultAttr;
import com.sun.netstorage.samqfs.mgmt.adm.FaultSummary;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemAlarmManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.alarm.Alarm;
import com.sun.netstorage.samqfs.web.model.alarm.AlarmSummary;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.alarm.AlarmImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.alarm.AlarmSummaryImpl;
import java.util.ArrayList;

public class SamQFSSystemAlarmManagerImpl
implements SamQFSSystemAlarmManager {
    SamQFSSystemModelImpl theModel;
    private ArrayList alarms = new ArrayList();

    public SamQFSSystemAlarmManagerImpl(SamQFSSystemModel model) {
        this.theModel = (SamQFSSystemModelImpl)model;
    }

    public AlarmSummary getAlarmSummary() throws SamFSException {
        FaultSummary jniFaultSummary = Fault.getSummary((Ctx)this.theModel.getJniContext());
        return new AlarmSummaryImpl(jniFaultSummary);
    }

    public Alarm[] getAllAlarms() throws SamFSException {
        byte b = -1;
        FaultAttr[] faults = Fault.get((Ctx)this.theModel.getJniContext(), (int)-1, (byte)b, (byte)b, (long)-1L);
        this.alarms.clear();
        if (faults != null && faults.length > 0) {
            for (int i = 0; i < faults.length; ++i) {
                AlarmImpl a = new AlarmImpl(this.theModel, faults[i]);
                this.alarms.add(a);
            }
        }
        return this.alarms.toArray(new Alarm[0]);
    }

    public Alarm getAlarm(long alarmID) throws SamFSException {
        Alarm alarm = null;
        int index = this.getAlarmIndexInList(alarmID);
        if (index != -1) {
            alarm = (Alarm)this.alarms.get(index);
        }
        return alarm;
    }

    public void deleteAlarm(long alarmID) throws SamFSException {
        long[] list = new long[]{alarmID};
        Fault.delete((Ctx)this.theModel.getJniContext(), (long[])list);
        int index = this.getAlarmIndexInList(alarmID);
        if (index != -1) {
            this.alarms.remove(index);
        }
    }

    public void deleteAlarm(long[] alarmIDs) throws SamFSException {
        if (alarmIDs != null) {
            Fault.delete((Ctx)this.theModel.getJniContext(), (long[])alarmIDs);
            for (int i = 0; i < alarmIDs.length; ++i) {
                int index = this.getAlarmIndexInList(alarmIDs[i]);
                if (index == -1) continue;
                this.alarms.remove(index);
            }
        }
    }

    public void acknowledgeAlarm(long[] alarmIDs) throws SamFSException {
        AlarmImpl alarm = null;
        if (alarmIDs != null) {
            Fault.ack((Ctx)this.theModel.getJniContext(), (long[])alarmIDs);
            for (int i = 0; i < alarmIDs.length; ++i) {
                alarm = (AlarmImpl)this.getAlarm(alarmIDs[i]);
                if (alarm == null) continue;
                alarm.setStatusAcknowledged();
            }
        }
    }

    private int getAlarmIndexInList(long alarmID) {
        int index = -1;
        Alarm temp = null;
        if (this.alarms != null) {
            for (int i = 0; i < this.alarms.size(); ++i) {
                try {
                    temp = (Alarm)this.alarms.get(i);
                    if (temp.getAlarmID() != alarmID) continue;
                    index = i;
                    break;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return index;
    }
}

