/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.fs;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.admin.Schedule;
import com.sun.netstorage.samqfs.web.model.fs.DumpSchedDateTimeModel;
import com.sun.netstorage.samqfs.web.model.fs.DumpSchedRetention;
import com.sun.netstorage.samqfs.web.util.ConversionUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;

public class DumpSched
extends Schedule
implements Serializable {
    protected static final String KEY_LOCATION = "location";
    protected static final String KEY_NAME_PREFIX = "name_prefix";
    protected static final String KEY_NAMES = "names";
    protected static final String KEY_COMPRESS = "compress";
    protected static final String KEY_AUTO_INDEX = "autoindex";
    protected static final String KEY_DISABLED = "disabled";
    protected static final String KEY_RETAIN_SCHEME = "retainfor";
    protected static final String KEY_PRESCRIPT_SKIP = "prescrfatal";
    protected static final String KEY_EXCLUDE_DIRS = "excludedirs";
    public static final String EXCLUDE_DIRS_DELIMITER = ":";
    String location;
    String pattern;
    String prefix;
    String compress;
    DumpSchedRetention retentionScheme = null;
    Boolean autoindex = null;
    Boolean enabled = null;
    Boolean preScriptSkip = null;
    String excludeDirs = null;

    public DumpSched(Properties dumpProps) throws SamFSException {
        super(dumpProps);
        this.location = dumpProps.getProperty(KEY_LOCATION);
        this.excludeDirs = dumpProps.getProperty(KEY_EXCLUDE_DIRS);
        this.prefix = dumpProps.getProperty(KEY_NAME_PREFIX);
        this.pattern = dumpProps.getProperty(KEY_NAMES);
        this.compress = dumpProps.getProperty(KEY_COMPRESS);
        Boolean disabled = DumpSched.parseDumpBoolean(dumpProps.getProperty(KEY_DISABLED));
        this.enabled = disabled != false ? Boolean.FALSE : Boolean.TRUE;
        this.autoindex = DumpSched.parseDumpBoolean(dumpProps.getProperty(KEY_AUTO_INDEX));
        this.preScriptSkip = DumpSched.parseDumpBoolean(dumpProps.getProperty(KEY_PRESCRIPT_SKIP));
        String retentionStr = dumpProps.getProperty(KEY_RETAIN_SCHEME);
        if (retentionStr != null) {
            this.retentionScheme = new DumpSchedRetention(retentionStr);
        }
    }

    public DumpSched(long startTime, long repeat, String preScript, Boolean preScriptSkip, String postScript, String logPath, String location, String excludeDirs, String prefix, String pattern, String compress, Boolean autoindex, Boolean enabled, DumpSchedRetention retentionScheme) {
        super(startTime, repeat, preScript, postScript, logPath);
        this.preScriptSkip = preScriptSkip;
        this.location = location;
        this.excludeDirs = excludeDirs;
        this.prefix = prefix;
        this.pattern = pattern;
        this.compress = compress;
        this.autoindex = autoindex;
        this.enabled = enabled;
        this.retentionScheme = retentionScheme;
    }

    private static Boolean parseDumpBoolean(String inprop) throws SamFSException {
        if (inprop == null) {
            return Boolean.FALSE;
        }
        if (inprop.equals("1")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean getPreScriptSkip() {
        return this.preScriptSkip;
    }

    public String getLocation() {
        return this.location;
    }

    public String getExcludeDirs() {
        return this.excludeDirs;
    }

    public String getFilePrefix() {
        return this.prefix;
    }

    public String getFilePattern() {
        return this.pattern;
    }

    public String getCompress() {
        return this.compress;
    }

    public Boolean getAutoindex() {
        return this.autoindex;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public DumpSchedRetention getRetentionScheme() {
        return this.retentionScheme;
    }

    public String toString() {
        NonSyncStringBuffer s = new NonSyncStringBuffer().append(super.toString()).append(",").append(KEY_LOCATION).append("=").append(this.location).append(",").append(KEY_NAME_PREFIX).append("=").append(this.prefix).append(",").append(KEY_NAMES).append("=").append(this.pattern);
        if (this.compress != null) {
            s.append(",").append(KEY_COMPRESS).append("=").append(this.compress);
        }
        if (this.excludeDirs != null) {
            s.append(",").append(KEY_EXCLUDE_DIRS).append("=").append(this.excludeDirs);
        }
        if (this.preScriptSkip != null) {
            s.append(",").append(KEY_PRESCRIPT_SKIP).append("=").append(this.preScriptSkip != false ? "1" : "0");
        }
        if (this.autoindex != null && this.autoindex.booleanValue()) {
            s.append(",").append(KEY_AUTO_INDEX).append("=1");
        }
        if (this.enabled != null && !this.enabled.booleanValue()) {
            s.append(",").append(KEY_DISABLED).append("=1");
        }
        if (this.retentionScheme != null) {
            s.append(",").append(KEY_RETAIN_SCHEME).append("=").append(this.retentionScheme.getServerString());
        }
        return s.toString();
    }

    /*
     * Unable to fully structure code
     */
    public String getDisplayString() {
        dtModel = new DumpSchedDateTimeModel();
        intervalName = DumpSchedDateTimeModel.getIntervalNameFromUnit(this.getRepeatCnt());
        intervalKey = dtModel.getRepeatIntervalPresentation(intervalName);
        intervalDisp = "";
        if (intervalName.equals("Interval4Hours")) ** GOTO lbl-1000
        if (intervalName.equals("Interval8Hours")) ** GOTO lbl-1000
        if (intervalName.equals("monthly")) lbl-1000:
        // 3 sources

        {
            intervalDisp = SamUtil.getResourceString(intervalKey);
        } else if (intervalName.equals("weekly")) {
            dayOfWeekKey = "";
            start = new GregorianCalendar();
            start.setTimeInMillis(this.getStartTimeInMillis());
            switch (start.get(7)) {
                case 1: {
                    dayOfWeekKey = "FSScheduleDump.repeatInterval.sundays";
                    break;
                }
                case 2: {
                    dayOfWeekKey = "FSScheduleDump.repeatInterval.mondays";
                    break;
                }
                case 3: {
                    dayOfWeekKey = "FSScheduleDump.repeatInterval.tuesdays";
                    break;
                }
                case 4: {
                    dayOfWeekKey = "FSScheduleDump.repeatInterval.wednesdays";
                    break;
                }
                case 5: {
                    dayOfWeekKey = "FSScheduleDump.repeatInterval.thursdays";
                    break;
                }
                case 6: {
                    dayOfWeekKey = "FSScheduleDump.repeatInterval.fridays";
                    break;
                }
                case 7: {
                    dayOfWeekKey = "FSScheduleDump.repeatInterval.saturdays";
                    break;
                }
            }
            intervalDisp = SamUtil.getResourceString(dayOfWeekKey);
        } else {
            intervalDisp = SamUtil.getLockhartTagString(intervalKey);
        }
        timeFmt = DateFormat.getTimeInstance(3);
        startTime = timeFmt.format(new Date(this.getStartTimeInMillis()));
        dateFmt = DateFormat.getDateInstance(3);
        startDate = dateFmt.format(new Date(this.getStartTimeInMillis()));
        futureSched = false;
        if (this.getStartTimeInMillis() > new Date().getTime()) {
            futureSched = true;
        }
        buf = new NonSyncStringBuffer();
        buf.append(intervalDisp);
        if (intervalName.equals("Interval4Hours")) ** GOTO lbl-1000
        if (intervalName.equals("Interval8Hours")) ** GOTO lbl-1000
        if (intervalName.equals("hourly")) lbl-1000:
        // 3 sources

        {
            buf.append(SamUtil.getResourceString("FSSummary.dumpSchedule.startingAt"));
        } else {
            buf.append(SamUtil.getResourceString("FSSummary.dumpSchedule.at"));
        }
        buf.append(startTime);
        if (futureSched) {
            buf.append(SamUtil.getResourceString("FSSummary.dumpSchedule.beginning")).append(startDate);
        }
        if (this.enabled != null && !this.enabled.booleanValue()) {
            buf.append(" ");
            buf.append(SamUtil.getResourceString("FSSummary.dumpSchedule.disabled"));
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        try {
            DumpSched s = new DumpSched(ConversionUtil.strToProps("location=/andrei,excludedirs=/myfs/bigdir:/biggerdir:/humongodirname_prefix=samfs1,names=samfs1-%Y%m%d,frequency=1234p67890,prescript=/andrei/prescript,prescrfatal=1postscript=/andrei/postscript,compress=none,logfile=andrei/logautoindex=1disabled=0,retainfor=3D"));
            System.out.println("back to string: " + s + "\n\nnow pick invalid key... EXPECT ERROR");
            s = new DumpSched(ConversionUtil.strToProps("wrongkey=someval"));
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

