/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.media.wizards;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.media.wizards.AddStandAloneImplData;
import com.sun.netstorage.samqfs.web.media.wizards.AddStandAloneSaveView;
import com.sun.netstorage.samqfs.web.media.wizards.AddStandAloneSelectDriveView;
import com.sun.netstorage.samqfs.web.media.wizards.AddStandAloneSelectEQView;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.media.Drive;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.netstorage.samqfs.web.wizard.SamWizardImpl;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCWizardWindowModel;
import com.sun.web.ui.model.wizard.WizardEvent;
import com.sun.web.ui.model.wizard.WizardInterface;
import com.sun.web.ui.view.html.CCTextField;
import com.sun.web.ui.view.table.CCActionTable;
import javax.servlet.http.HttpServletRequest;

public class AddStandAloneImpl
extends SamWizardImpl {
    public static final String WIZARDPAGEMODELNAME = "AddPageModelName";
    public static final String WIZARDPAGEMODELNAME_PREFIX = "WizardModel";
    public static final String WIZARDIMPLNAME = "AddStandAloneImpl";
    public static final String WIZARDIMPLNAME_PREFIX = "WizardImpl";
    public static final String WIZARDCLASSNAME = "com.sun.netstorage.samqfs.web.media.wizards.AddStandAloneImpl";
    private Drive myDrive = null;
    private boolean dumpOn = false;
    private String dumpPath = null;
    private boolean wizardInitialized = false;
    private String serverName = null;

    public static WizardInterface create(RequestContext requestContext) {
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        return new AddStandAloneImpl(requestContext);
    }

    public AddStandAloneImpl(RequestContext requestContext) {
        super(requestContext, WIZARDPAGEMODELNAME);
        this.processInitialRequest(requestContext.getRequest());
        this.initializeWizard();
        this.initializeWizardControl(requestContext);
    }

    private void initializeWizard() {
        TraceUtil.trace3("Entering");
        this.wizardName = WIZARDIMPLNAME;
        this.wizardTitle = "AddStandAlone.title";
        this.pageClass = AddStandAloneImplData.pageClass;
        this.pageTitle = AddStandAloneImplData.pageTitle;
        this.stepHelp = AddStandAloneImplData.stepHelp;
        this.stepText = AddStandAloneImplData.stepText;
        this.stepInstruction = AddStandAloneImplData.stepInstruction;
        this.cancelMsg = AddStandAloneImplData.cancelMsg;
        try {
            this.getDumpValue();
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "AddStandAloneImpl()", "Failed to get preferences status", this.serverName);
            this.wizardModel.setValue("ERROR", "Yes");
            this.wizardModel.setValue("ERROR_MSGS", ex.getMessage());
            this.wizardModel.setValue("ERROR_CODE", Integer.toString(ex.getSAMerrno()));
        }
        this.pages = this.dumpOn ? AddStandAloneImplData.prefOnPages : AddStandAloneImplData.prefOffPages;
        this.setShowResultsPage(true);
        this.initializeWizardPages(this.pages);
        TraceUtil.trace3("Exiting");
    }

    private void processInitialRequest(HttpServletRequest request) {
        this.serverName = request.getParameter("serverNameParam");
        if (this.serverName != null) {
            SamUtil.doPrint(new NonSyncStringBuffer("Wizard Key: serverName is ").append(this.serverName).toString());
            this.wizardModel.setValue("SERVER_NAME", this.serverName);
        } else {
            this.serverName = "";
            SamUtil.doPrint("Wizard Key: serverName is null");
        }
    }

    public static CCWizardWindowModel createModel(String cmdChild) {
        return AddStandAloneImpl.getWizardWindowModel(WIZARDIMPLNAME, "AddStandAlone.title", WIZARDCLASSNAME, cmdChild);
    }

    public Class getPageClass(String pageId) {
        TraceUtil.trace3(new NonSyncStringBuffer().append("Entered with pageID = ").append(pageId).toString());
        int page = this.pageIdToPage(pageId);
        if (this.wizardInitialized) {
            this.wizardModel.setValue("ERROR", "No");
        }
        return super.getPageClass(pageId);
    }

    public boolean cancelStep(WizardEvent wizardEvent) {
        super.cancelStep(wizardEvent);
        SamUtil.doPrint("Start clearing wizard Model ...");
        this.wizardModel.clear();
        SamUtil.doPrint("Done clearing wizard Model ...");
        return true;
    }

    public void closeStep(WizardEvent wizardEvent) {
        SamUtil.doPrint("Start clearing wizard Model ...");
        this.wizardModel.clear();
        SamUtil.doPrint("Done clearing wizard Model ...");
    }

    public boolean nextStep(WizardEvent wizardEvent) {
        TraceUtil.trace3("Entering");
        super.nextStep(wizardEvent);
        this.wizardInitialized = true;
        String pageId = wizardEvent.getPageId();
        boolean result = true;
        TraceUtil.trace3(new NonSyncStringBuffer().append("nextStep() pageID: ").append(pageId).toString());
        int page = this.pageIdToPage(pageId);
        switch (this.pages[page]) {
            case 0: {
                result = this.processSelectDrivePage(wizardEvent);
                break;
            }
            case 1: {
                result = this.processSelectEQPage(wizardEvent);
                break;
            }
            case 2: {
                result = this.processSaveLocationPage(true, wizardEvent);
            }
        }
        TraceUtil.trace3("Exiting");
        return result;
    }

    public boolean previousStep(WizardEvent wizardEvent) {
        TraceUtil.trace3("Entering: Calling previousStep");
        super.previousStep(wizardEvent);
        boolean result = true;
        String pageId = wizardEvent.getPageId();
        TraceUtil.trace3(new NonSyncStringBuffer().append("previousStep() pageID: ").append(pageId).toString());
        int page = this.pageIdToPage(pageId);
        if (this.pages[page] == 2) {
            result = this.processSaveLocationPage(false, wizardEvent);
        }
        TraceUtil.trace3("Exiting");
        return result;
    }

    public boolean finishStep(WizardEvent wizardEvent) {
        TraceUtil.trace3("Entering");
        if (!super.finishStep(wizardEvent)) {
            return false;
        }
        boolean returnValue = true;
        String errMsg = null;
        String errCode = null;
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
            String devicePath = ((String)this.wizardModel.getValue("devicePathValue")).trim();
            String eq = ((String)this.wizardModel.getValue("EQValue")).trim();
            if (this.myDrive != null) {
                LogUtil.info(this.getClass(), "finishStep", "Start adding standalone tape drives ");
                sysModel.getSamQFSSystemMediaManager().addStandAloneDrive(this.myDrive);
                LogUtil.info(this.getClass(), "finishStep", "Done adding standalone tape drives ");
            }
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "finishStep", "Failed to add stand-alone tape drive", this.serverName);
            errMsg = ex.getMessage();
            errCode = Integer.toString(ex.getSAMerrno());
            returnValue = false;
        }
        if (returnValue) {
            this.wizardModel.setValue("Finish_result", "successful");
            this.wizardModel.setValue("WizardResultAlertSummary", "success.summary");
            this.wizardModel.setValue("WizardResultAlertDetail", "StandAloneSummary.action.add");
        } else {
            this.wizardModel.setValue("Finish_result", "Failed");
            this.wizardModel.setValue("WizardResultAlertSummary", "StandAloneSummary.error.add");
            this.wizardModel.setValue("WizardResultAlertDetail", errMsg);
            this.wizardModel.setValue("Detail_code", errCode);
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    private void getDumpValue() throws SamFSException {
        TraceUtil.trace3("Entering");
        SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
        if (appModel == null) {
            throw new SamFSException(null, -2501);
        }
        this.dumpOn = appModel.isDumpOn();
        if (this.dumpOn) {
            this.wizardModel.setValue("DUMP", "on");
            SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
            this.wizardModel.setValue("LOCATION", sysModel.getDefaultDumpPath());
        } else {
            this.wizardModel.setValue("DUMP", "off");
            this.wizardModel.setValue("saveValue", "AddStandAlone.page3.radio1");
        }
        TraceUtil.trace3("Exiting");
    }

    private boolean processSaveLocationPage(boolean isNextStep, WizardEvent wizardEvent) {
        TraceUtil.trace3("Entering");
        SamUtil.doPrint(new NonSyncStringBuffer("processSaveLocationPage: isNextStep is ").append(isNextStep).toString());
        AddStandAloneSaveView pageView = (AddStandAloneSaveView)wizardEvent.getView();
        String saveChanges = null;
        saveChanges = (String)pageView.getDisplayFieldValue("RadioButton");
        this.dumpPath = (String)pageView.getDisplayFieldValue("DumpPathTextField");
        if (this.dumpPath != null) {
            this.dumpPath = this.dumpPath.trim();
        }
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
            if (saveChanges == null) {
                if (isNextStep) {
                    this.setErrorMessage(wizardEvent, "AddStandAlone.page3.errMsg");
                    TraceUtil.trace3("Exiting: return false");
                    return false;
                }
            } else if (saveChanges.equals("AddStandAlone.page3.radio2")) {
                if (isNextStep) {
                    if (this.dumpPath == null) {
                        this.setErrorMessage(wizardEvent, "AddStandAlone.page3.errMsg2");
                        TraceUtil.trace3("Exiting: return false");
                        return false;
                    }
                    if (this.dumpPath.length() == 0) {
                        this.setErrorMessage(wizardEvent, "AddStandAlone.page3.errMsg2");
                        TraceUtil.trace3("Exiting: return false");
                        return false;
                    }
                    if (!SamUtil.isValidString(this.dumpPath)) {
                        this.setErrorMessage(wizardEvent, "wizard.space.errMsg");
                        ((CCTextField)pageView.getChild("DumpPathTextField")).setDisabled(false);
                        TraceUtil.trace3("Exiting: return false");
                        return false;
                    }
                    if (!SamUtil.isValidNonSpecialCharString(this.dumpPath)) {
                        this.setErrorMessage(wizardEvent, "AddStandAlone.page3.errMsg3");
                        ((CCTextField)pageView.getChild("DumpPathTextField")).setDisabled(false);
                        TraceUtil.trace3("Exiting: return false");
                        return false;
                    }
                    sysModel.setDumpPath(this.dumpPath);
                }
                this.wizardModel.setValue("DUMP", "on");
                this.wizardModel.setValue("LOCATION", this.dumpPath);
                this.wizardModel.setValue("saveValue", new NonSyncStringBuffer().append(SamUtil.getResourceString("AddStandAlone.page3.radio2")).append(" ").append(this.dumpPath).toString());
            } else if (saveChanges.equals("AddStandAlone.page3.radio1")) {
                sysModel.setDumpPath(null);
                this.wizardModel.setValue("DUMP", "off");
                this.wizardModel.setValue("saveValue", "AddStandAlone.page3.radio1");
            }
        }
        catch (SamFSException smfex) {
            SamUtil.processException((Exception)((Object)smfex), this.getClass(), "processSaveDumpLocationPage", "Failed to process saving information", this.serverName);
            this.wizardModel.setValue("ERROR", "Yes");
            this.wizardModel.setValue("ERROR_MSGS", smfex.getMessage());
            this.wizardModel.setValue("ERROR_CODE", Integer.toString(smfex.getSAMerrno()));
        }
        TraceUtil.trace3("Exiting: return true");
        return true;
    }

    private boolean processSelectDrivePage(WizardEvent wizardEvent) {
        TraceUtil.trace3("Entering");
        try {
            AddStandAloneSelectDriveView pageView = (AddStandAloneSelectDriveView)wizardEvent.getView();
            Drive[] allDrives = pageView.getAllDrives();
            CCActionTable actionTable = (CCActionTable)pageView.getChild("SelectDriveTable");
            actionTable.restoreStateData();
            CCActionTableModel drvModel = (CCActionTableModel)actionTable.getModel();
            Integer[] selectedRows = drvModel.getSelectedRows();
            if (selectedRows.length <= 0) {
                this.setErrorMessage(wizardEvent, "AddStandAlone.page1.errMsg");
                TraceUtil.trace3("Exiting: return false");
                return false;
            }
            int row = selectedRows[0];
            drvModel.setRowIndex(row);
            String vendorID = (String)drvModel.getValue("Text0");
            String productID = (String)drvModel.getValue("Text1");
            String devPath = (String)drvModel.getValue("Text2");
            this.wizardModel.setValue("vendorIDValue", vendorID);
            this.wizardModel.setValue("productIDValue", productID);
            this.wizardModel.setValue("devicePathValue", devPath);
            for (int i = 0; i < allDrives.length; ++i) {
                if (!allDrives[i].getDevicePath().equals(devPath)) continue;
                this.myDrive = allDrives[i];
                break;
            }
        }
        catch (ModelControlException mcex) {
            SamUtil.processException((Exception)((Object)mcex), this.getClass(), "nextStep", "ModelControlException in nextStep()", this.serverName);
            this.wizardModel.setValue("ERROR", "Yes");
            this.wizardModel.setValue("ERROR_MSGS", mcex.getMessage());
            this.wizardModel.setValue("ERROR_CODE", Integer.toString(-2509));
        }
        TraceUtil.trace3("Exiting: return true");
        return true;
    }

    private boolean processSelectEQPage(WizardEvent wizardEvent) {
        TraceUtil.trace3("Entering");
        AddStandAloneSelectEQView pageView = (AddStandAloneSelectEQView)wizardEvent.getView();
        String eqString = (String)pageView.getDisplayFieldValue("EQValue");
        int showError = 0;
        try {
            if (eqString.length() != 0) {
                if (!SamUtil.isValidString(eqString.trim())) {
                    showError = 1;
                } else {
                    int eq = Integer.parseInt(eqString.trim());
                    if (eq <= 0) {
                        showError = 2;
                    } else {
                        this.myDrive.setEquipOrdinal(eq);
                    }
                }
            }
        }
        catch (NumberFormatException numEx) {
            showError = 2;
        }
        if (showError == 1 || showError == 2) {
            if (showError == 1) {
                this.setErrorMessage(wizardEvent, "wizard.space.errMsg");
            } else {
                this.setErrorMessage(wizardEvent, "AddStandAlone.page2.errMsg");
            }
            TraceUtil.trace3("Exiting: return false");
            return false;
        }
        TraceUtil.trace3("Exiting: return true");
        return true;
    }

    private void setErrorMessage(WizardEvent wizardEvent, String errMsg) {
        wizardEvent.setSeverity(0);
        wizardEvent.setErrorMessage(errMsg);
    }
}

