/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.media;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.model.media.VSN;
import com.sun.netstorage.samqfs.web.util.LargeDataSet;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;

public final class VSNSummaryData
implements LargeDataSet {
    private static String serverName;
    private static String libraryName;

    public VSNSummaryData(String serverName, String libraryName) {
        TraceUtil.initTrace();
        VSNSummaryData.serverName = serverName;
        VSNSummaryData.libraryName = libraryName;
        TraceUtil.trace3("Entering");
    }

    public Object[] getData(int start, int num, String sortName, String sortOrder) throws SamFSException {
        SamUtil.doPrint(new NonSyncStringBuffer("Entering start = ").append(start).append(" num = ").append(num).append(" sortName = ").append(sortName).append(" sortOrder = ").append(sortOrder).toString());
        Library myLibrary = this.getMyLibrary();
        int sortby = 7;
        if (sortName != null) {
            if ("SlotText".compareTo(sortName) == 0) {
                sortby = 7;
            } else if ("VSNText".compareTo(sortName) == 0) {
                sortby = 8;
            } else if ("FreeSpaceText".compareTo(sortName) == 0) {
                sortby = 9;
            }
        }
        boolean ascending = true;
        if (sortOrder != null && "descending".compareTo(sortOrder) == 0) {
            ascending = false;
        }
        SamUtil.doPrint(new NonSyncStringBuffer("sortby is ").append(sortby).toString());
        SamUtil.doPrint(new NonSyncStringBuffer("ascending is ").append(ascending).toString());
        VSN[] allVSN = myLibrary.getVSNs(start, num, sortby, ascending);
        if (allVSN == null) {
            allVSN = new VSN[]{};
        }
        TraceUtil.trace3("Exiting");
        return allVSN;
    }

    public int getTotalRecords() throws SamFSException {
        TraceUtil.trace3("Entering");
        TraceUtil.trace3("Exiting");
        return this.getMyLibrary().getTotalVSNInLibrary();
    }

    private Library getMyLibrary() throws SamFSException {
        TraceUtil.trace3("Entering");
        SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
        Library myLibrary = sysModel.getSamQFSSystemMediaManager().getLibraryByName(libraryName);
        if (myLibrary == null) {
            throw new SamFSException(null, -2502);
        }
        TraceUtil.trace3("Exiting");
        return myLibrary;
    }
}

