/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.media;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.media.LibraryDriveSummaryModel;
import com.sun.netstorage.samqfs.web.media.LibraryDriveSummaryTiledView;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.media.Drive;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.util.Authorization;
import com.sun.netstorage.samqfs.web.util.CommonTableContainerView;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.SecurityManagerFactory;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCHref;
import com.sun.web.ui.view.html.CCRadioButton;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.IOException;
import javax.servlet.ServletException;

public class LibraryDriveSummaryView
extends CommonTableContainerView {
    public static final String CHILD_TILED_VIEW = "LibraryDriveSummaryTiledView";
    public static final String CHILD_ACTIONMENU_HREF = "ActionMenuHref";
    private LibraryDriveSummaryModel model = null;
    public static final String CHILD_EQ_HIDDEN_FIELD = "EQHiddenField";
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$media$LibraryDriveSummaryTiledView;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHref;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHiddenField;

    public LibraryDriveSummaryView(View parent, String name) {
        super(parent, name);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.CHILD_ACTION_TABLE = "LibraryDriveSummaryTable";
        this.model = new LibraryDriveSummaryModel(this.isSharedCapable());
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    public void registerChildren() {
        TraceUtil.trace3("Entering");
        this.registerChild(CHILD_TILED_VIEW, class$com$sun$netstorage$samqfs$web$media$LibraryDriveSummaryTiledView == null ? (class$com$sun$netstorage$samqfs$web$media$LibraryDriveSummaryTiledView = LibraryDriveSummaryView.class$("com.sun.netstorage.samqfs.web.media.LibraryDriveSummaryTiledView")) : class$com$sun$netstorage$samqfs$web$media$LibraryDriveSummaryTiledView);
        this.registerChild(CHILD_ACTIONMENU_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = LibraryDriveSummaryView.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        this.registerChild(CHILD_EQ_HIDDEN_FIELD, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = LibraryDriveSummaryView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        super.registerChildren(this.model);
        TraceUtil.trace3("Exiting");
    }

    public View createChild(String name) {
        TraceUtil.trace3(new NonSyncStringBuffer("Entering: name is ").append(name).toString());
        Object child = null;
        if (name.equals(CHILD_ACTIONMENU_HREF)) {
            child = new CCHref((ContainerView)this, name, null);
        } else if (name.equals(CHILD_EQ_HIDDEN_FIELD)) {
            child = new CCHiddenField((ContainerView)this, name, null);
        } else if (name.equals(CHILD_TILED_VIEW)) {
            child = new LibraryDriveSummaryTiledView((View)this, this.model, name);
        } else {
            return super.createChild(this.model, name, CHILD_TILED_VIEW);
        }
        TraceUtil.trace3("Exiting");
        return child;
    }

    public void handleIdleButtonRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        this.executeCommand("handleIdleButtonRequest");
        TraceUtil.trace3("Existing");
    }

    public void handleUnloadButtonRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        this.executeCommand("handleUnloadButtonRequest");
        TraceUtil.trace3("Existing");
    }

    public void handleCleanButtonRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        this.executeCommand("handleCleanButtonRequest");
        TraceUtil.trace3("Existing");
    }

    public void handleActionMenuHrefRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        int value = 2;
        try {
            value = Integer.parseInt((String)this.getDisplayFieldValue("ActionMenu"));
        }
        catch (NumberFormatException numEx) {
            TraceUtil.trace1("NumEx caught while parsing drop down selection!");
        }
        this.executeCommand("handleActionMenuHrefRequest" + value);
        ((CCDropDownMenu)this.getChild("ActionMenu")).setValue((Object)"0");
        TraceUtil.trace3("Existing");
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        if (!SecurityManagerFactory.getSecurityManager().hasAuthorization(Authorization.CONFIG)) {
            this.model.setSelectionType("none");
        }
        CCActionTable myTable = (CCActionTable)this.getChild(this.CHILD_ACTION_TABLE);
        CCRadioButton myRadio = (CCRadioButton)myTable.getChild("SelectionRadiobutton");
        myRadio.setTitle("");
        myRadio.setTitleDisabled("");
        TraceUtil.trace3("Exiting");
    }

    private void executeCommand(String handlerName) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        TraceUtil.trace3(new NonSyncStringBuffer().append("handlerName is ").append(handlerName).toString());
        String eq = this.getSelectedRowKey(0);
        try {
            String libraryName = this.getLibraryName();
            if (libraryName == null) {
                throw new SamFSException(null, -2502);
            }
            SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
            Library myLibrary = sysModel.getSamQFSSystemMediaManager().getLibraryByName(libraryName);
            if (myLibrary == null) {
                throw new SamFSException(null, -2502);
            }
            Drive[] allDrives = myLibrary.getDrives();
            Drive myDrive = null;
            if (allDrives == null) {
                throw new SamFSException(null, -2503);
            }
            for (int i = 0; i < allDrives.length; ++i) {
                if (allDrives[i].getEquipOrdinal() != Integer.parseInt(eq)) continue;
                myDrive = allDrives[i];
            }
            if (myDrive == null) {
                throw new SamFSException(null, -2503);
            }
            String op = null;
            if (handlerName.equals("handleIdleButtonRequest")) {
                op = "LibraryDriveSummary.action.idle";
                LogUtil.info(((Object)((Object)this)).getClass(), handlerName, new NonSyncStringBuffer("Start idling drive with eq ").append(eq).toString());
                myDrive.idle();
                LogUtil.info(((Object)((Object)this)).getClass(), handlerName, new NonSyncStringBuffer("Done idling drive with eq ").append(eq).toString());
            } else if (handlerName.equals("handleUnloadButtonRequest")) {
                op = "LibraryDriveSummary.action.unload";
                LogUtil.info(((Object)((Object)this)).getClass(), handlerName, new NonSyncStringBuffer("Start unloading tape in drive with eq").append(eq).toString());
                myDrive.unload();
                LogUtil.info(((Object)((Object)this)).getClass(), handlerName, new NonSyncStringBuffer("Done unloading tape in drive with eq").append(eq).toString());
            } else if (handlerName.equals("handleCleanButtonRequest")) {
                op = "LibraryDriveSummary.action.clean";
                LogUtil.info(((Object)((Object)this)).getClass(), handlerName, new NonSyncStringBuffer("Start cleaning drive with eq ").append(eq).toString());
                myDrive.clean();
                LogUtil.info(((Object)((Object)this)).getClass(), handlerName, new NonSyncStringBuffer("Done cleaning drive with eq ").append(eq).toString());
            } else if (handlerName.startsWith("handleActionMenuHrefRequest")) {
                int value = Integer.parseInt(handlerName.substring(27, 28));
                op = value == 1 ? "LibraryDriveSummary.action.share" : "LibraryDriveSummary.action.unshare";
                LogUtil.info(((Object)((Object)this)).getClass(), handlerName, value == 1 ? new NonSyncStringBuffer("Start sharing drive ").append(eq).toString() : new NonSyncStringBuffer("Start unsharing drive ").append(eq).toString());
                myDrive.setShared(value == 1);
                LogUtil.info(((Object)((Object)this)).getClass(), handlerName, value == 1 ? new NonSyncStringBuffer("Done sharing drive ").append(eq).toString() : new NonSyncStringBuffer("Done unsharing drive ").append(eq).toString());
            }
            this.setSuccessAlert(op, eq);
        }
        catch (SamFSException samEx) {
            String errString = null;
            if (handlerName.equals("handleIdleButtonRequest")) {
                errString = "LibraryDriveSummary.error.idle";
            } else if (handlerName.equals("handleUnloadButtonRequest")) {
                errString = "LibraryDriveSummary.error.unload";
            } else if (handlerName.equals("handleCleanButtonRequest")) {
                errString = "LibraryDriveSummary.error.clean";
            } else if (handlerName.startsWith("handleActionMenuHrefRequest")) {
                int value = Integer.parseInt(handlerName.substring(27, 28));
                switch (value) {
                    case 1: {
                        errString = "LibraryDriveSummary.error.share";
                        break;
                    }
                    case 2: {
                        errString = "LibraryDriveSummary.error.unshare";
                    }
                }
            }
            this.setErrorAlertWithProcessException((Exception)((Object)samEx), handlerName, errString, errString);
        }
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void populateData(String serverName, String libraryName) throws SamFSException {
        TraceUtil.trace3("Entering");
        this.model.initModelRows(serverName, libraryName);
        this.model.setRowSelected(false);
        TraceUtil.trace3("Exiting");
    }

    private String getSelectedRowKey(int choice) throws ModelControlException {
        TraceUtil.trace3("Entering");
        String returnValue = null;
        CCActionTable actionTable = (CCActionTable)this.getChild(this.CHILD_ACTION_TABLE);
        try {
            actionTable.restoreStateData();
        }
        catch (ModelControlException mcex) {
            SamUtil.processException((Exception)((Object)mcex), ((Object)((Object)this)).getClass(), "getSelectedRowKey()", "ModelControlException occurred within framework", this.getServerName());
            throw mcex;
        }
        LibraryDriveSummaryModel drvModel = (LibraryDriveSummaryModel)actionTable.getModel();
        Integer[] selectedRows = drvModel.getSelectedRows();
        int row = selectedRows[0];
        drvModel.setRowIndex(row);
        switch (choice) {
            case 0: {
                returnValue = (String)drvModel.getValue("EQHidden");
                TraceUtil.trace3(new NonSyncStringBuffer("Selected Drive's EQ is ").append(returnValue).toString());
                break;
            }
            case 1: {
                returnValue = (String)drvModel.getValue("StateHidden");
                TraceUtil.trace3(new NonSyncStringBuffer("Selected Drive's state is ").append(returnValue).toString());
            }
        }
        TraceUtil.trace3("Exiting");
        return returnValue;
    }

    private void setSuccessAlert(String msg, String item) {
        TraceUtil.trace3("Entering");
        SamUtil.setInfoAlert((ContainerView)this.getParentViewBean(), "Alert", "success.summary", SamUtil.getResourceString(msg, item), this.getServerName());
        TraceUtil.trace3("Exiting");
    }

    private String getServerName() {
        return (String)this.getParentViewBean().getPageSessionAttribute("SERVER_NAME");
    }

    private String getLibraryName() {
        return (String)this.getParentViewBean().getPageSessionAttribute("SAMQFS_LIBRARY_NAME");
    }

    private void setErrorAlertWithProcessException(Exception ex, String handlerName, String backupMessage, String alertKey) {
        SamUtil.processException(ex, ((Object)((Object)this)).getClass(), handlerName, backupMessage, this.getServerName());
        if (ex instanceof SamFSException) {
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", alertKey, ((SamFSException)((Object)ex)).getSAMerrno(), ((SamFSException)((Object)ex)).getMessage(), this.getServerName());
        } else {
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", alertKey, -99001, "ModelControlException caught in the framework", this.getServerName());
        }
    }

    private Drive getSelectedDrive() throws SamFSException, ModelControlException {
        String eqValue = this.getSelectedRowKey(0);
        SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
        Library myLibrary = sysModel.getSamQFSSystemMediaManager().getLibraryByName(this.getLibraryName());
        if (myLibrary == null) {
            throw new SamFSException(null, -2502);
        }
        Drive[] allDrives = null;
        Drive myDrive = null;
        allDrives = myLibrary.getDrives();
        if (allDrives == null) {
            throw new SamFSException(null, -2503);
        }
        for (int i = 0; i < allDrives.length; ++i) {
            if (allDrives[i].getEquipOrdinal() != Integer.parseInt(eqValue)) continue;
            myDrive = allDrives[i];
        }
        if (myDrive == null) {
            throw new SamFSException(null, -2503);
        }
        return myDrive;
    }

    private boolean isSharedCapable() {
        boolean sharedCapable = Boolean.valueOf((String)this.getParentViewBean().getPageSessionAttribute("SAMQFS_SHARE_CAPABLE"));
        return sharedCapable;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

