/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.media;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.HtmlUtil;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.BasicCommandField;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.media.HistorianData;
import com.sun.netstorage.samqfs.web.media.HistorianModel;
import com.sun.netstorage.samqfs.web.media.HistorianTiledView;
import com.sun.netstorage.samqfs.web.media.wizards.ReservationImpl;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.model.media.VSN;
import com.sun.netstorage.samqfs.web.util.Authorization;
import com.sun.netstorage.samqfs.web.util.CommonTableContainerView;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.SecurityManagerFactory;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCWizardWindowModel;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCRadioButton;
import com.sun.web.ui.view.table.CCActionTable;
import com.sun.web.ui.view.wizard.CCWizardWindow;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletException;

public class HistorianView
extends CommonTableContainerView {
    public static final String CHILD_TILED_VIEW = "HistorianTiledView";
    private HistorianModel model = null;
    public static final String ROLE = "Role";
    public static final String CHILD_FRWD_TO_CMDCHILD = "forwardToVb";
    private boolean wizardLaunched = false;
    private CCWizardWindowModel wizWinModel;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHiddenField;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$media$HistorianTiledView;
    static /* synthetic */ Class class$com$iplanet$jato$view$BasicCommandField;

    public HistorianView(View parent, String name) {
        super(parent, name);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.CHILD_ACTION_TABLE = "HistorianTable";
        HistorianData dataSet = new HistorianData(this.getServerName());
        this.model = new HistorianModel(dataSet);
        this.initializeWizard();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    public void registerChildren() {
        TraceUtil.trace3("Entering");
        this.registerChild(ROLE, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = HistorianView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_TILED_VIEW, class$com$sun$netstorage$samqfs$web$media$HistorianTiledView == null ? (class$com$sun$netstorage$samqfs$web$media$HistorianTiledView = HistorianView.class$("com.sun.netstorage.samqfs.web.media.HistorianTiledView")) : class$com$sun$netstorage$samqfs$web$media$HistorianTiledView);
        this.registerChild(CHILD_FRWD_TO_CMDCHILD, class$com$iplanet$jato$view$BasicCommandField == null ? (class$com$iplanet$jato$view$BasicCommandField = HistorianView.class$("com.iplanet.jato.view.BasicCommandField")) : class$com$iplanet$jato$view$BasicCommandField);
        super.registerChildren(this.model);
        TraceUtil.trace3("Exiting");
    }

    public View createChild(String name) {
        TraceUtil.trace3(new NonSyncStringBuffer("Entering: name is ").append(name).toString());
        HistorianTiledView child = null;
        if (name.equals(CHILD_TILED_VIEW)) {
            child = new HistorianTiledView((View)this, this.model, name);
        } else if (name.equals(ROLE)) {
            child = new CCHiddenField((ContainerView)this, name, null);
        } else if (name.equals(CHILD_FRWD_TO_CMDCHILD)) {
            child = new BasicCommandField((View)this, name);
        } else {
            return super.createChild(this.model, name, CHILD_TILED_VIEW);
        }
        TraceUtil.trace3("Exiting");
        return child;
    }

    public void handleExportButtonRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        this.execute("ExportButton");
        TraceUtil.trace3("Exiting");
    }

    private void execute(String buttonName) throws ModelControlException {
        block10: {
            TraceUtil.trace3("Entering");
            String slotNum = this.getSelectedRowKey();
            try {
                Library myLibrary = this.getHistorian();
                VSN myVSN = null;
                if (myLibrary == null) {
                    throw new SamFSException(null, -2502);
                }
                try {
                    myVSN = myLibrary.getVSN(Integer.parseInt(slotNum));
                }
                catch (NumberFormatException numEx) {
                    SamUtil.doPrint("NumberFormatException caught while parsing slotKey to integer.");
                    throw new SamFSException(null, -2507);
                }
                if (myVSN == null) {
                    throw new SamFSException(null, -2507);
                }
                if (buttonName.equals("ExportButton")) {
                    LogUtil.info(((Object)((Object)this)).getClass(), "handleExportButtonRequest", new NonSyncStringBuffer("Start exporting tape with VSN in slot ").append(slotNum).toString());
                    myVSN.export();
                    LogUtil.info(((Object)((Object)this)).getClass(), "handleExportButtonRequest", new NonSyncStringBuffer("Done exporting tape with VSN in slot ").append(slotNum).toString());
                    this.setSuccessAlert("Historian.action.export", slotNum);
                } else if (buttonName.equals("UnreserveButton")) {
                    LogUtil.info(((Object)((Object)this)).getClass(), "handleUnreserveButtonRequest", new NonSyncStringBuffer("Start unreserving tape with VSN in slot ").append(slotNum).toString());
                    myVSN.reserve(null, null, -1, null);
                    LogUtil.info(((Object)((Object)this)).getClass(), "handleUnreserveButtonRequest", new NonSyncStringBuffer("Done unreserving tape with VSN in slot ").append(slotNum).toString());
                    this.setSuccessAlert("Historian.action.unreserve", slotNum);
                }
            }
            catch (SamFSException samEx) {
                if (buttonName.equals("ExportButton")) {
                    this.setErrorAlertWithProcessException((Exception)((Object)samEx), "handleExportButtonRequest", "Failed to export tape", "Historian.error.export");
                }
                if (!buttonName.equals("UnreserveButton")) break block10;
                this.setErrorAlertWithProcessException((Exception)((Object)samEx), "handleUnreserveButtonRequest", "Failed to unreserve tape", "Historian.error.unreserve");
            }
        }
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleSamQFSWizardReserveButtonRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        this.wizardLaunched = true;
        this.model.setRowSelected(false);
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleUnreserveButtonRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        this.execute("UnreserveButton");
        TraceUtil.trace3("Exiting");
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        this.checkRolePrivilege();
        this.setResWizardState();
        CCActionTable myTable = (CCActionTable)this.getChild(this.CHILD_ACTION_TABLE);
        CCRadioButton myRadio = (CCRadioButton)myTable.getChild("SelectionRadiobutton");
        myRadio.setTitle("");
        myRadio.setTitleDisabled("");
        TraceUtil.trace3("Exiting");
    }

    private void initializeWizard() {
        TraceUtil.trace3("Entering");
        ViewBean view = this.getParentViewBean();
        NonSyncStringBuffer cmdChild = new NonSyncStringBuffer().append(view.getQualifiedName()).append(".").append("HistorianView.").append(CHILD_FRWD_TO_CMDCHILD);
        this.wizWinModel = ReservationImpl.createModel(cmdChild.toString());
        this.model.setModel("SamQFSWizardReserveButton", this.wizWinModel);
        this.wizWinModel.setValue("SamQFSWizardReserveButton", (Object)"vsn.button.reserve");
        TraceUtil.trace3("Exiting");
    }

    public void handleForwardToVbRequest(RequestInvocationEvent event) {
        TraceUtil.trace3("Entering");
        this.wizardLaunched = false;
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void populateData() throws SamFSException {
        TraceUtil.trace3("Entering");
        CCActionTable actionTable = (CCActionTable)this.getChild(this.CHILD_ACTION_TABLE);
        try {
            actionTable.restoreStateData();
        }
        catch (ModelControlException mcex) {
            this.setErrorAlertWithProcessException((Exception)((Object)mcex), "populateData", "ModelControlException occurred within framework", "Historian.error.populateData");
        }
        this.model.initModelRows();
        this.model.setRowSelected(false);
        TraceUtil.trace3("Exiting");
    }

    private String getSelectedRowKey() throws ModelControlException {
        TraceUtil.trace3("Entering");
        CCActionTable actionTable = (CCActionTable)this.getChild(this.CHILD_ACTION_TABLE);
        try {
            actionTable.restoreStateData();
        }
        catch (ModelControlException mcex) {
            SamUtil.processException((Exception)((Object)mcex), ((Object)((Object)this)).getClass(), "getSelectedRowKey", "ModelControlException occurred within framework", this.getServerName());
            throw mcex;
        }
        HistorianModel hisModel = (HistorianModel)actionTable.getModel();
        Integer[] selectedRows = hisModel.getSelectedRows();
        int row = selectedRows[0];
        hisModel.setRowIndex(row);
        String concatString = (String)hisModel.getValue("InformationHidden");
        String[] returnValue = concatString.split("###");
        if (returnValue.length > 0) {
            TraceUtil.trace3("Exiting");
            return returnValue[0];
        }
        TraceUtil.trace3("Exiting - Invalid information key found!");
        return "";
    }

    private void setResWizardState() {
        TraceUtil.trace3("Entering");
        ViewBean view = this.getParentViewBean();
        String temp = (String)this.getParentViewBean().getPageSessionAttribute("ReservationPageModelName");
        String modelName = (String)view.getPageSessionAttribute("ReservationPageModelName");
        String implName = (String)view.getPageSessionAttribute("ReservationWizardImpl");
        if (modelName == null) {
            modelName = new NonSyncStringBuffer().append("WizardModel").append("_").append(HtmlUtil.getUniqueValue()).toString();
            view.setPageSessionAttribute("ReservationPageModelName", (Serializable)((Object)modelName));
        }
        this.wizWinModel.setValue("ReservationPageModelName", (Object)modelName);
        if (implName == null) {
            implName = new NonSyncStringBuffer().append("WizardImpl").append("_").append(HtmlUtil.getUniqueValue()).toString();
            view.setPageSessionAttribute("ReservationWizardImpl", (Serializable)((Object)implName));
        }
        this.wizWinModel.setValue("wizName", (Object)implName);
        TraceUtil.trace3("Exiting");
    }

    private void setSuccessAlert(String msg, String item) {
        TraceUtil.trace3("Entering");
        SamUtil.setInfoAlert((ContainerView)this.getParentViewBean(), "Alert", "success.summary", SamUtil.getResourceString(msg, item), this.getServerName());
        TraceUtil.trace3("Exiting");
    }

    private void setErrorAlertWithProcessException(Exception ex, String handlerName, String backupMessage, String alertKey) {
        SamUtil.processException(ex, ((Object)((Object)this)).getClass(), handlerName, backupMessage, this.getServerName());
        if (ex instanceof SamFSException) {
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", alertKey, ((SamFSException)((Object)ex)).getSAMerrno(), ((SamFSException)((Object)ex)).getMessage(), this.getServerName());
        } else {
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", alertKey, -99001, "ModelControlException caught in the framework", this.getServerName());
        }
    }

    private Library getHistorian() throws SamFSException {
        TraceUtil.trace3("Entering");
        SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
        Library myLibrary = sysModel.getSamQFSSystemMediaManager().getLibraryByName("Historian");
        if (myLibrary == null) {
            throw new SamFSException(null, -2506);
        }
        TraceUtil.trace3("Exiting");
        return myLibrary;
    }

    private void checkRolePrivilege() {
        if (SecurityManagerFactory.getSecurityManager().hasAuthorization(Authorization.CONFIG)) {
            ((CCHiddenField)this.getChild(ROLE)).setValue((Object)"CONFIG");
            ((CCWizardWindow)this.getChild("SamQFSWizardReserveButton")).setDisabled(this.wizardLaunched);
        } else if (SecurityManagerFactory.getSecurityManager().hasAuthorization(Authorization.MEDIA_OPERATOR)) {
            ((CCHiddenField)this.getChild(ROLE)).setValue((Object)"MEDIA");
        } else {
            this.model.setSelectionType("none");
        }
    }

    private String getServerName() {
        return (String)this.getParentViewBean().getPageSessionAttribute("SERVER_NAME");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

