/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.media;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.media.Drive;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.model.media.VSN;
import com.sun.netstorage.samqfs.web.util.CommonSecondaryViewBeanBase;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.PageTitleUtil;
import com.sun.netstorage.samqfs.web.util.PropertySheetUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCCheckBox;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletException;

public class EditVSNViewBean
extends CommonSecondaryViewBeanBase {
    private static final String PAGE_NAME = "EditVSN";
    private static final String DEFAULT_DISPLAY_URL = "/jsp/media/EditVSN.jsp";
    private CCPageTitleModel pageTitleModel = null;
    private static CCPropertySheetModel propertySheetModel = null;

    public EditVSNViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.pageTitleModel = this.createPageTitleModel();
        propertySheetModel = this.createPropertySheetModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    protected void registerChildren() {
        TraceUtil.trace3("Entering");
        super.registerChildren();
        PageTitleUtil.registerChildren((ContainerViewBase)this, this.pageTitleModel);
        PropertySheetUtil.registerChildren((ContainerViewBase)this, propertySheetModel);
        TraceUtil.trace3("Exiting");
    }

    protected View createChild(String name) {
        TraceUtil.trace3(new NonSyncStringBuffer().append("Entering: name is ").append(name).toString());
        View child = null;
        if (super.isChildSupported(name)) {
            child = super.createChild(name);
        } else if (PageTitleUtil.isChildSupported(this.pageTitleModel, name)) {
            child = PageTitleUtil.createChild((ContainerView)this, this.pageTitleModel, name);
        } else if (PropertySheetUtil.isChildSupported(propertySheetModel, name)) {
            child = PropertySheetUtil.createChild((ContainerView)this, propertySheetModel, name);
        } else {
            throw new IllegalArgumentException(new NonSyncStringBuffer().append("Invalid child name [").append(name).append("]").toString());
        }
        TraceUtil.trace3("Exiting");
        return child;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        super.beginDisplay(event);
        this.loadPropertySheetModel(propertySheetModel);
        TraceUtil.trace3("Exiting");
    }

    private void disableCheckBoxes() {
        TraceUtil.trace3("Entering");
        ((CCCheckBox)this.getChild("damagedValue")).setDisabled(true);
        ((CCCheckBox)this.getChild("duplicateValue")).setDisabled(true);
        ((CCCheckBox)this.getChild("readonlyValue")).setDisabled(true);
        ((CCCheckBox)this.getChild("writeprotectedValue")).setDisabled(true);
        ((CCCheckBox)this.getChild("foreignValue")).setDisabled(true);
        ((CCCheckBox)this.getChild("recycleValue")).setDisabled(true);
        ((CCCheckBox)this.getChild("fullValue")).setDisabled(true);
        ((CCCheckBox)this.getChild("unavailableValue")).setDisabled(true);
        ((CCCheckBox)this.getChild("needAuditValue")).setDisabled(true);
        TraceUtil.trace3("Exiting");
    }

    private void disablePageButtons() {
        TraceUtil.trace3("Entering");
        ((CCButton)this.getChild("Submit")).setDisabled(true);
        ((CCButton)this.getChild("Reset")).setDisabled(true);
        TraceUtil.trace3("Exiting");
    }

    private CCPageTitleModel createPageTitleModel() {
        TraceUtil.trace3("Entering");
        if (this.pageTitleModel == null) {
            this.pageTitleModel = PageTitleUtil.createModel("/jsp/media/EditVSNPageTitle.xml");
        }
        TraceUtil.trace3("Exiting");
        return this.pageTitleModel;
    }

    private CCPropertySheetModel createPropertySheetModel() {
        TraceUtil.trace3("Entering");
        if (propertySheetModel == null) {
            propertySheetModel = PropertySheetUtil.createModel("/jsp/media/EditVSNPropertySheet.xml");
        }
        TraceUtil.trace3("Exiting");
        return propertySheetModel;
    }

    private void loadPropertySheetModel(CCPropertySheetModel propertySheetModel) {
        TraceUtil.trace3("Entering");
        propertySheetModel.clear();
        try {
            VSN myVSN = null;
            try {
                myVSN = this.getThisVSN();
            }
            catch (NumberFormatException numEx) {
                SamUtil.doPrint(new NonSyncStringBuffer().append("NumberFormatException caught while ").append("parsing slotKey to integer.").toString());
                throw new SamFSException(null, -2507);
            }
            ((CCCheckBox)this.getChild("damagedValue")).setChecked(myVSN.isMediaDamaged());
            ((CCCheckBox)this.getChild("duplicateValue")).setChecked(myVSN.isDuplicateVSN());
            ((CCCheckBox)this.getChild("readonlyValue")).setChecked(myVSN.isReadOnly());
            ((CCCheckBox)this.getChild("writeprotectedValue")).setChecked(myVSN.isWriteProtected());
            ((CCCheckBox)this.getChild("foreignValue")).setChecked(myVSN.isForeignMedia());
            ((CCCheckBox)this.getChild("recycleValue")).setChecked(myVSN.isRecycled());
            ((CCCheckBox)this.getChild("fullValue")).setChecked(myVSN.isVolumeFull());
            ((CCCheckBox)this.getChild("unavailableValue")).setChecked(myVSN.isUnavailable());
            ((CCCheckBox)this.getChild("needAuditValue")).setChecked(myVSN.isNeedAudit());
        }
        catch (SamFSException samEx) {
            SamUtil.processException((Exception)((Object)samEx), ((Object)((Object)this)).getClass(), "loadPropertySheetModel", "Failed to retrieve VSN information", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "EditVSN.error.loadpsheet", samEx.getSAMerrno(), samEx.getMessage(), this.getServerName());
            this.disablePageButtons();
            this.disableCheckBoxes();
        }
        TraceUtil.trace3("Exiting");
    }

    public void handleSubmitRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        VSN myVSN = null;
        String vsnName = "";
        try {
            try {
                myVSN = this.getThisVSN();
                vsnName = myVSN.getVSN();
            }
            catch (NumberFormatException numEx) {
                SamUtil.doPrint("NumberFormatException caught while parsing slotKey to integer.");
                throw new SamFSException(null, -2507);
            }
            LogUtil.info(((Object)((Object)this)).getClass(), "executeEditVSN", "Start editing attribute of tape");
            myVSN.setMediaDamaged(Boolean.valueOf((String)this.getDisplayFieldValue("damagedValue")));
            myVSN.setDuplicateVSN(Boolean.valueOf((String)this.getDisplayFieldValue("duplicateValue")));
            myVSN.setReadOnly(Boolean.valueOf((String)this.getDisplayFieldValue("readonlyValue")));
            myVSN.setWriteProtected(Boolean.valueOf((String)this.getDisplayFieldValue("writeprotectedValue")));
            myVSN.setForeignMedia(Boolean.valueOf((String)this.getDisplayFieldValue("foreignValue")));
            myVSN.setRecycled(Boolean.valueOf((String)this.getDisplayFieldValue("recycleValue")));
            myVSN.setVolumeFull(Boolean.valueOf((String)this.getDisplayFieldValue("fullValue")));
            myVSN.setUnavailable(Boolean.valueOf((String)this.getDisplayFieldValue("unavailableValue")));
            myVSN.setNeedAudit(Boolean.valueOf((String)this.getDisplayFieldValue("needAuditValue")));
            myVSN.changeAttributes();
            LogUtil.info(((Object)((Object)this)).getClass(), "handleSubmitRequest", "Done editing attribute of tape");
            SamUtil.setInfoAlert((ContainerView)this.getParentViewBean(), "Alert", "success.summary", SamUtil.getResourceString("EditVSN.action.editattributes", vsnName), this.getServerName());
            this.setSubmitSuccessful(true);
        }
        catch (SamFSException samEx) {
            SamUtil.processException((Exception)((Object)samEx), ((Object)((Object)this)).getClass(), "handleSubmitRequest", "Failed to set Media Attributes", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this, "Alert", SamUtil.getResourceString("EditVSN.error.editattributes", vsnName), samEx.getSAMerrno(), samEx.getMessage(), this.getServerName());
        }
        this.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    private String getLibraryName() {
        String libraryName = (String)this.getPageSessionAttribute("SAMQFS_LIBRARY_NAME");
        if (libraryName == null) {
            libraryName = RequestManager.getRequest().getParameter("SAMQFS_LIBRARY_NAME");
            if (libraryName != null) {
                this.setPageSessionAttribute("SAMQFS_LIBRARY_NAME", (Serializable)((Object)libraryName));
            }
            if (libraryName == null) {
                throw new IllegalArgumentException("Library Name not supplied");
            }
        }
        return libraryName;
    }

    private int getEQValue() throws NumberFormatException {
        String eqValue = (String)this.getPageSessionAttribute("SAMQFS_EQ");
        if (eqValue == null) {
            eqValue = RequestManager.getRequest().getParameter("SAMQFS_EQ");
            if (eqValue != null) {
                this.setPageSessionAttribute("SAMQFS_EQ", (Serializable)((Object)eqValue));
            }
            if (eqValue == null) {
                throw new IllegalArgumentException("EQ value not supplied");
            }
        }
        return Integer.parseInt(eqValue);
    }

    private String getVSNName() {
        String vsnName = (String)this.getPageSessionAttribute("SAMQFS_VSN_NAME");
        if (vsnName == null) {
            vsnName = RequestManager.getRequest().getParameter("SAMQFS_VSN_NAME");
            if (vsnName != null) {
                this.setPageSessionAttribute("SAMQFS_VSN_NAME", (Serializable)((Object)vsnName));
            }
            if (vsnName == null) {
                throw new IllegalArgumentException("VSN_NAME not supplied");
            }
        }
        return vsnName;
    }

    private int getSlotNumber() throws SamFSException {
        String slotNum = (String)this.getPageSessionAttribute("SAMQFS_SLOT_NUMBER");
        if (slotNum == null) {
            slotNum = RequestManager.getRequest().getParameter("SAMQFS_SLOT_NUMBER");
            if (slotNum != null) {
                this.setPageSessionAttribute("SAMQFS_SLOT_NUMBER", (Serializable)((Object)slotNum));
            }
            if (slotNum == null) {
                throw new IllegalArgumentException("Slot Number not supplied");
            }
        }
        return Integer.parseInt(slotNum);
    }

    private VSN getThisVSN() throws SamFSException, NumberFormatException {
        VSN myVSN = null;
        SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
        if (this.getLibraryName().equals("$STANDALONE")) {
            Drive myDrive = sysModel.getSamQFSSystemMediaManager().getStdAloneByEQ(this.getEQValue());
            myVSN = myDrive != null ? myDrive.getVSN() : sysModel.getSamQFSSystemMediaManager().searchVSNInStandAloneDrive(this.getVSNName(), this.getEQValue());
        } else {
            Library myLibrary = sysModel.getSamQFSSystemMediaManager().getLibraryByName(this.getLibraryName());
            if (myLibrary == null) {
                throw new SamFSException(null, -2501);
            }
            myVSN = myLibrary.getVSN(this.getSlotNumber());
        }
        if (myVSN == null) {
            throw new SamFSException(null, -2507);
        }
        return myVSN;
    }
}

