/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.jobs;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.job.ArchiveJob;
import com.sun.netstorage.samqfs.web.model.job.ArchiveScanJob;
import com.sun.netstorage.samqfs.web.model.job.BaseJob;
import com.sun.netstorage.samqfs.web.model.job.EnableDumpJob;
import com.sun.netstorage.samqfs.web.model.job.FSDumpJob;
import com.sun.netstorage.samqfs.web.model.job.LabelJob;
import com.sun.netstorage.samqfs.web.model.job.MountJob;
import com.sun.netstorage.samqfs.web.model.job.ReleaseJob;
import com.sun.netstorage.samqfs.web.model.job.RestoreJob;
import com.sun.netstorage.samqfs.web.model.job.RestoreSearchJob;
import com.sun.netstorage.samqfs.web.model.job.SamfsckJob;
import com.sun.netstorage.samqfs.web.model.job.StageJob;
import com.sun.netstorage.samqfs.web.util.FormattedDate;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import java.util.ArrayList;

public final class AllJobsData
extends ArrayList {
    public static final String[] headings = new String[]{"Jobs.heading1", "Jobs.heading2", "Jobs.heading3", "Jobs.heading4", "AllJobs.heading5"};
    public static final String button = new String("Jobs.button1");
    public static final String[] filterOptions = new String[]{"Jobs.filterOptions0", "Jobs.filterOptions1", "Jobs.filterOptions2", "Jobs.filterOptions3", "Jobs.filterOptions4"};

    public AllJobsData(String serverName) throws SamFSException {
        int j;
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
        if (sysModel == null) {
            throw new SamFSException(null, -2001);
        }
        BaseJob[] baseJobs = null;
        BaseJob[] currentJobs = sysModel.getSamQFSSystemJobManager().getJobsByCondition(0);
        BaseJob[] pendingJobs = sysModel.getSamQFSSystemJobManager().getJobsByCondition(1);
        int currentJobLength = 0;
        int pendingJobLength = 0;
        if (currentJobs != null) {
            currentJobLength = currentJobs.length;
        }
        if (pendingJobs != null) {
            pendingJobLength = pendingJobs.length;
        }
        baseJobs = new BaseJob[currentJobLength + pendingJobLength];
        for (int i = 0; i < currentJobLength; ++i) {
            baseJobs[i] = currentJobs[i];
        }
        for (j = 0; j < pendingJobLength; ++j) {
            baseJobs[i++] = pendingJobs[j];
        }
        TraceUtil.trace3("baseJobs.length is " + baseJobs.length);
        for (j = 0; j < baseJobs.length; ++j) {
            String vsn;
            String fileSystem;
            String jobTypeString = null;
            String description = new String();
            String comma = ",";
            int jobType = baseJobs[j].getType();
            if (jobType == 1) {
                jobTypeString = "Jobs.jobType1";
                ArchiveJob archiveJob = (ArchiveJob)baseJobs[j];
                fileSystem = archiveJob.getFileSystemName();
                String policyName = archiveJob.getPolicyName();
                String copyNumber2 = Integer.toString(archiveJob.getCopyNumber());
                description = SamUtil.processJobDescription(new String[]{fileSystem, policyName, copyNumber2});
            } else if (jobType == 2) {
                jobTypeString = "Jobs.jobType5";
                ArchiveScanJob archiveScanJob = (ArchiveScanJob)baseJobs[j];
                description = fileSystem = archiveScanJob.getFileSystemName();
                description = SamUtil.processJobDescription(new String[]{fileSystem});
            } else if (jobType == 4) {
                jobTypeString = "Jobs.jobType2";
                StageJob stageJob = (StageJob)baseJobs[j];
                vsn = stageJob.getVSNName();
                description = SamUtil.processJobDescription(new String[]{vsn});
            } else if (jobType == 5) {
                jobTypeString = "Jobs.jobType3";
                ReleaseJob releaseJob = (ReleaseJob)baseJobs[j];
                fileSystem = releaseJob.getFileSystemName();
                String lwm = releaseJob.getLWM();
                String spaceConsumed = releaseJob.getConsumedSpacePercentage();
                description = SamUtil.processJobDescription(new String[]{fileSystem, lwm, spaceConsumed});
            } else if (jobType == 7) {
                jobTypeString = "Jobs.jobType4";
                MountJob mountJob = (MountJob)baseJobs[j];
                vsn = mountJob.getVSNName();
                String mediaType = SamUtil.getMediaTypeString(mountJob.getMediaType());
                description = SamUtil.processJobDescription(new String[]{vsn, mediaType});
            } else if (jobType == 8) {
                jobTypeString = "Jobs.jobType6";
                SamfsckJob fsckJob = (SamfsckJob)baseJobs[j];
                String fsName = fsckJob.getFileSystemName();
                String initUser = fsckJob.getInitiatingUser();
                String repair = "";
                repair = fsckJob.isRepair() ? "Jobs.repair" : "Jobs.non-repair";
                description = SamUtil.processJobDescription(new String[]{fsName, initUser, SamUtil.getResourceString(repair)});
            } else if (jobType == 9) {
                jobTypeString = "Jobs.jobType7";
                LabelJob labelJob = (LabelJob)baseJobs[j];
                String lib = labelJob.getLibraryName();
                String vsn2 = labelJob.getVSNName();
                description = SamUtil.processJobDescription(new String[]{lib, vsn2});
            } else if (jobType == 23) {
                jobTypeString = "Jobs.jobType.restore";
                RestoreJob restoreJob = (RestoreJob)baseJobs[j];
                description = SamUtil.processJobDescription(new String[]{restoreJob.getFileSystemName(), restoreJob.getFileName()});
            } else if (jobType == 22) {
                jobTypeString = "Jobs.jobType.restoreSearch";
                RestoreSearchJob searchJob = (RestoreSearchJob)baseJobs[j];
                description = SamUtil.processJobDescription(new String[]{searchJob.getFileSystemName(), searchJob.getDumpFileName()});
            } else if (jobType == 20) {
                jobTypeString = "Jobs.jobType.dump";
                FSDumpJob dumpJob = (FSDumpJob)baseJobs[j];
                description = dumpJob.getFileSystemName();
            } else if (jobType == 21) {
                jobTypeString = "Jobs.jobType.dumpEnable";
                EnableDumpJob enableDumpJob = (EnableDumpJob)baseJobs[j];
                description = SamUtil.processJobDescription(new String[]{enableDumpJob.getFileSystemName(), enableDumpJob.getDumpFileName()});
            }
            TraceUtil.trace3("Job id is " + Long.toString(baseJobs[j].getJobId()));
            int condition = baseJobs[j].getCondition();
            String conditionString = "";
            if (condition == 0) {
                conditionString = "Jobs.conditionCurrent";
            } else if (condition == 1) {
                conditionString = "Jobs.conditionPending";
            }
            super.add(new Object[]{new Long(baseJobs[j].getJobId()), jobTypeString, new FormattedDate(baseJobs[j].getStartDateTime(), SamUtil.getTimeFormat()), description, conditionString});
        }
        TraceUtil.trace3("Exiting");
    }
}

