/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs.wizards;

import com.iplanet.jato.model.Model;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.RequestHandlingViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.fs.FileSystemMountProperties;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.netstorage.samqfs.web.wizard.SamWizardModel;
import com.sun.web.ui.view.alert.CCAlertInline;
import com.sun.web.ui.view.html.CCCheckBox;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCLabel;
import com.sun.web.ui.view.html.CCStaticTextField;
import com.sun.web.ui.view.html.CCTextField;
import com.sun.web.ui.view.wizard.CCWizardPage;

public class NewWizardMountView
extends RequestHandlingViewBase
implements CCWizardPage {
    public static final String PAGE_NAME = "NewWizardMountView";
    public static final String CHILD_LABEL = "Label";
    public static final String CHILD_MOUNT_FIELD = "mountValue";
    public static final String CHILD_HWM_FIELD = "hwmValue";
    public static final String CHILD_LWM_FIELD = "lwmValue";
    public static final String CHILD_TRACE_DROPDOWN = "traceDropDown";
    public static final String CHILD_CREATE_TEXT = "createText";
    public static final String CHILD_BOOT_CHECKBOX = "bootTimeCheckBox";
    public static final String CHILD_MOUNT_CHECKBOX = "mountOptionCheckBox";
    public static final String CHILD_OPTIMIZE_CHECKBOX = "optimizeCheckBox";
    public static final String CHILD_ALERT = "Alert";
    public static final String CHILD_ERROR = "errorOccur";
    protected String serverName = null;
    private boolean previous_error = false;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCLabel;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCTextField;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCDropDownMenu;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCStaticTextField;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCCheckBox;
    static /* synthetic */ Class class$com$sun$web$ui$view$alert$CCAlertInline;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHiddenField;

    public NewWizardMountView(View parent, Model model) {
        this(parent, model, PAGE_NAME);
    }

    public NewWizardMountView(View parent, Model model, String name) {
        super(parent, name);
        TraceUtil.initTrace();
        this.setDefaultModel(model);
        SamWizardModel wizardModel = (SamWizardModel)this.getDefaultModel();
        this.serverName = (String)wizardModel.getValue("SERVER_NAME");
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    protected void registerChildren() {
        TraceUtil.trace3("Entering");
        this.registerChild(CHILD_LABEL, class$com$sun$web$ui$view$html$CCLabel == null ? (class$com$sun$web$ui$view$html$CCLabel = NewWizardMountView.class$("com.sun.web.ui.view.html.CCLabel")) : class$com$sun$web$ui$view$html$CCLabel);
        this.registerChild(CHILD_MOUNT_FIELD, class$com$sun$web$ui$view$html$CCTextField == null ? (class$com$sun$web$ui$view$html$CCTextField = NewWizardMountView.class$("com.sun.web.ui.view.html.CCTextField")) : class$com$sun$web$ui$view$html$CCTextField);
        this.registerChild(CHILD_HWM_FIELD, class$com$sun$web$ui$view$html$CCTextField == null ? (class$com$sun$web$ui$view$html$CCTextField = NewWizardMountView.class$("com.sun.web.ui.view.html.CCTextField")) : class$com$sun$web$ui$view$html$CCTextField);
        this.registerChild(CHILD_LWM_FIELD, class$com$sun$web$ui$view$html$CCTextField == null ? (class$com$sun$web$ui$view$html$CCTextField = NewWizardMountView.class$("com.sun.web.ui.view.html.CCTextField")) : class$com$sun$web$ui$view$html$CCTextField);
        this.registerChild(CHILD_TRACE_DROPDOWN, class$com$sun$web$ui$view$html$CCDropDownMenu == null ? (class$com$sun$web$ui$view$html$CCDropDownMenu = NewWizardMountView.class$("com.sun.web.ui.view.html.CCDropDownMenu")) : class$com$sun$web$ui$view$html$CCDropDownMenu);
        this.registerChild(CHILD_CREATE_TEXT, class$com$sun$web$ui$view$html$CCStaticTextField == null ? (class$com$sun$web$ui$view$html$CCStaticTextField = NewWizardMountView.class$("com.sun.web.ui.view.html.CCStaticTextField")) : class$com$sun$web$ui$view$html$CCStaticTextField);
        this.registerChild(CHILD_BOOT_CHECKBOX, class$com$sun$web$ui$view$html$CCCheckBox == null ? (class$com$sun$web$ui$view$html$CCCheckBox = NewWizardMountView.class$("com.sun.web.ui.view.html.CCCheckBox")) : class$com$sun$web$ui$view$html$CCCheckBox);
        this.registerChild(CHILD_MOUNT_CHECKBOX, class$com$sun$web$ui$view$html$CCCheckBox == null ? (class$com$sun$web$ui$view$html$CCCheckBox = NewWizardMountView.class$("com.sun.web.ui.view.html.CCCheckBox")) : class$com$sun$web$ui$view$html$CCCheckBox);
        this.registerChild(CHILD_OPTIMIZE_CHECKBOX, class$com$sun$web$ui$view$html$CCCheckBox == null ? (class$com$sun$web$ui$view$html$CCCheckBox = NewWizardMountView.class$("com.sun.web.ui.view.html.CCCheckBox")) : class$com$sun$web$ui$view$html$CCCheckBox);
        this.registerChild(CHILD_ALERT, class$com$sun$web$ui$view$alert$CCAlertInline == null ? (class$com$sun$web$ui$view$alert$CCAlertInline = NewWizardMountView.class$("com.sun.web.ui.view.alert.CCAlertInline")) : class$com$sun$web$ui$view$alert$CCAlertInline);
        this.registerChild(CHILD_ERROR, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = NewWizardMountView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        TraceUtil.trace3("Exiting");
    }

    protected View createChild(String name) {
        TraceUtil.trace3("Entering");
        CCLabel child = null;
        if (name.equals(CHILD_LABEL)) {
            child = new CCLabel((ContainerView)this, name, null);
        } else if (name.equals(CHILD_HWM_FIELD) || name.equals(CHILD_LWM_FIELD) || name.equals(CHILD_MOUNT_FIELD)) {
            child = new CCTextField((ContainerView)this, name, null);
        } else if (name.equals(CHILD_CREATE_TEXT)) {
            child = new CCStaticTextField((ContainerView)this, name, null);
        } else if (name.equals(CHILD_BOOT_CHECKBOX) || name.equals(CHILD_OPTIMIZE_CHECKBOX)) {
            CCCheckBox boxChild = new CCCheckBox((ContainerView)this, name, (Object)"samqfsui.yes", (Object)"samqfsui.no", false);
            boxChild.setBoundName(name);
            child = boxChild;
        } else if (name.equals(CHILD_MOUNT_CHECKBOX)) {
            CCCheckBox boxChild = new CCCheckBox((ContainerView)this, name, (Object)"samqfsui.yes", (Object)"samqfsui.no", true);
            boxChild.setBoundName(name);
            child = boxChild;
        } else if (name.equals(CHILD_TRACE_DROPDOWN)) {
            CCDropDownMenu dropdownChild = new CCDropDownMenu((ContainerView)this, name, null);
            OptionList traceOptions = new OptionList(new String[]{"FSWizard.new.traceoption1", "FSWizard.new.traceoption2"}, new String[]{"samqfsui.yes", "samqfsui.no"});
            dropdownChild.setOptions(traceOptions);
            dropdownChild.setBoundName(name);
            child = dropdownChild;
        } else if (name.equals(CHILD_ALERT)) {
            CCAlertInline alert = new CCAlertInline((ContainerView)this, name, null);
            alert.setValue((Object)"error");
            TraceUtil.trace3("Exiting");
            child = alert;
        } else if (name.equals(CHILD_ERROR)) {
            CCHiddenField text = new CCHiddenField((ContainerView)this, name, null);
            TraceUtil.trace3("Exiting");
            child = text;
        } else {
            throw new IllegalArgumentException("NewWizardMountView : Invalid child name [" + name + "]");
        }
        TraceUtil.trace3("Exiting");
        return child;
    }

    public String getPageletUrl() {
        String url = null;
        if (!this.previous_error) {
            SamWizardModel wizardModel = (SamWizardModel)this.getDefaultModel();
            boolean archiveEnabled = false;
            Boolean archiveEnabledValue = (Boolean)wizardModel.getValue("archiveEnabled");
            if (archiveEnabledValue != null) {
                archiveEnabled = archiveEnabledValue;
            }
            int fsLicense = 3;
            Short fsLicenseValue = (Short)wizardModel.getValue("LICENSE_TYPE");
            if (fsLicenseValue != null) {
                fsLicense = fsLicenseValue.shortValue();
            }
            TraceUtil.trace3("archiveEnabled = " + archiveEnabled);
            TraceUtil.trace3("fsLicense = " + fsLicense);
            url = fsLicense == 1 || !archiveEnabled ? "/jsp/fs/NewWizardQFSMountPage.jsp" : "/jsp/fs/NewWizardMountPage.jsp";
        } else {
            url = "/jsp/fs/wizardErrorPage.jsp";
        }
        return url;
    }

    public boolean beginOptimizeCheckBoxDisplay(ChildDisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        SamWizardModel wizardModel = (SamWizardModel)this.getDefaultModel();
        String metaLocationVal = (String)wizardModel.getValue("metaLocationSelect");
        if (metaLocationVal.equals("FSWizard.new.fstype.qfs.metaSame")) {
            wizardModel.setValue(CHILD_OPTIMIZE_CHECKBOX, "samqfsui.no");
            return false;
        }
        return true;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        String t;
        TraceUtil.trace3("Entering");
        super.beginDisplay(event);
        SamWizardModel wizardModel = (SamWizardModel)this.getDefaultModel();
        String mountPoint = (String)wizardModel.getValue(CHILD_MOUNT_FIELD);
        if (mountPoint == null) {
            this.fillDefaultValues(wizardModel);
        }
        if ((t = (String)wizardModel.getValue("ERROR")) != null && t.equals("Yes")) {
            String msgs = (String)wizardModel.getValue("ERROR_MSGS");
            int code = Integer.parseInt((String)wizardModel.getValue("ERROR_CODE"));
            String errorSummary = "FSWizard.new.error.steps";
            this.previous_error = true;
            String errorDetails = (String)wizardModel.getValue("ERROR_DETAIL");
            if (errorDetails != null) {
                errorSummary = (String)wizardModel.getValue("ERROR_SUMMARY");
                this.previous_error = !errorDetails.equals("INLINE_ALERT");
            }
            if (this.previous_error) {
                SamUtil.setErrorAlert((ContainerView)this, CHILD_ALERT, errorSummary, code, msgs, this.serverName);
            } else {
                SamUtil.setWarningAlert((ContainerView)this, CHILD_ALERT, errorSummary, msgs);
            }
        }
        if (this.isHAFS()) {
            ((CCStaticTextField)this.getChild(CHILD_CREATE_TEXT)).setValue((Object)"FSWizard.new.mount.hafs");
            String temp = (String)wizardModel.getValue(CHILD_MOUNT_FIELD);
            String fsName = (String)wizardModel.getValue("fsNameValue");
            mountPoint = temp == null ? "/global/".concat(fsName) : temp;
            wizardModel.setValue(CHILD_MOUNT_FIELD, mountPoint);
        }
        TraceUtil.trace3("Exiting");
    }

    private void fillDefaultValues(SamWizardModel wizardModel) {
        String fsType = (String)wizardModel.getValue("fsTypeKey");
        String dauSize = (String)wizardModel.getValue("DAUDropDown");
        int dau = Integer.parseInt(dauSize);
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
            if (sysModel == null) {
                throw new SamFSException(null, -2001);
            }
            int type = -1;
            int archType = -1;
            int shareStatus = 0;
            if (fsType.equals("qfs")) {
                type = 0;
                archType = 3;
            } else if (fsType.equals("fs")) {
                type = 1;
                archType = 2;
            }
            FileSystemMountProperties properties = sysModel.getSamQFSSystemFSManager().getDefaultMountProperties(type, archType, dau, false, shareStatus, false);
            String traceString = "No";
            if (properties.isTrace()) {
                traceString = "samqfsui.yes";
            }
            String hwmString = Integer.toString(properties.getHWM());
            String lwmString = Integer.toString(properties.getLWM());
            wizardModel.setValue(CHILD_HWM_FIELD, hwmString);
            wizardModel.setValue(CHILD_LWM_FIELD, lwmString);
            wizardModel.setValue(CHILD_TRACE_DROPDOWN, traceString);
        }
        catch (SamFSException smfex) {
            ((CCHiddenField)this.getChild(CHILD_ERROR)).setValue((Object)"exception");
            SamUtil.processException((Exception)((Object)smfex), ((Object)((Object)this)).getClass(), "beginDisplay()", "Failed to populate mount option value", this.serverName);
            SamUtil.setErrorAlert((ContainerView)this, CHILD_ALERT, "FSWizard.new.error.steps", smfex.getSAMerrno(), smfex.getMessage(), this.serverName);
        }
        TraceUtil.trace3("Exiting");
    }

    public String getErrorMsg() {
        TraceUtil.trace3("Entering");
        SamWizardModel wm = (SamWizardModel)this.getDefaultModel();
        String mountPoint = ((String)wm.getWizardValue(CHILD_MOUNT_FIELD)).trim();
        String hwmString = ((String)wm.getWizardValue(CHILD_HWM_FIELD)).trim();
        String lwmString = ((String)wm.getWizardValue(CHILD_LWM_FIELD)).trim();
        boolean isValid = true;
        String msgs = new String();
        int hwm = -1;
        int lwm = -1;
        int stripe = -1;
        try {
            hwm = Integer.parseInt(hwmString);
            lwm = Integer.parseInt(lwmString);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (mountPoint.equals("")) {
            isValid = false;
            msgs = "FSWizard.new.error.mountpoint";
        } else if (!SamUtil.isValidNonSpecialCharString(mountPoint)) {
            isValid = false;
            msgs = "FSWizard.new.error.invalidmountpoint";
        } else if (!mountPoint.startsWith("/")) {
            isValid = false;
            msgs = "FSWizard.new.error.mountpoint.absolutePath";
        } else if (!hwmString.equals("")) {
            if (hwm < 0 || hwm > 100) {
                isValid = false;
                msgs = "FSWizard.new.error.hwmrange";
            } else if (!lwmString.equals("")) {
                if (lwm < 0 || lwm > 100) {
                    isValid = false;
                    msgs = "FSWizard.new.error.lwmrange";
                } else if (lwm >= hwm) {
                    isValid = false;
                    msgs = "FSWizard.new.error.lwmbhwm";
                }
            }
        }
        TraceUtil.trace3("Exiting");
        return isValid ? null : msgs;
    }

    public boolean beginBootTimeCheckBoxDisplay(ChildDisplayEvent evt) throws ModelControlException {
        return !this.isHAFS();
    }

    private boolean isHAFS() {
        SamWizardModel wm = (SamWizardModel)this.getDefaultModel();
        String hafs = (String)wm.getValue("hafs");
        return hafs == null ? false : hafs.equals("true");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

