/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs.wizards;

import com.iplanet.jato.model.Model;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.RequestHandlingViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.fs.FileSystemMountProperties;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.netstorage.samqfs.web.wizard.SamWizardModel;
import com.sun.web.ui.view.alert.CCAlertInline;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCLabel;
import com.sun.web.ui.view.html.CCStaticTextField;
import com.sun.web.ui.view.html.CCTextField;
import com.sun.web.ui.view.wizard.CCWizardPage;

public class NewWizardFSDAUView
extends RequestHandlingViewBase
implements CCWizardPage {
    public static final String PAGE_NAME = "NewWizardDAUView";
    public static final String CHILD_LABEL = "label";
    public static final String CHILD_STATICTEXT = "StaticText";
    public static final String CHILD_DAU_DROPDOWN = "DAUDropDown";
    public static final String CHILD_STRIPE_FIELD = "stripeValue";
    public static final String CHILD_ALERT = "Alert";
    public static final String CHILD_IS_SHARED_HIDDEN = "isShared";
    protected String serverName = null;
    private boolean previous_error = false;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCLabel;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCStaticTextField;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCDropDownMenu;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCTextField;
    static /* synthetic */ Class class$com$sun$web$ui$view$alert$CCAlertInline;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHiddenField;

    public NewWizardFSDAUView(View parent, Model model) {
        this(parent, model, PAGE_NAME);
    }

    public NewWizardFSDAUView(View parent, Model model, String name) {
        super(parent, name);
        TraceUtil.initTrace();
        this.setDefaultModel(model);
        SamWizardModel wizardModel = (SamWizardModel)this.getDefaultModel();
        this.serverName = (String)wizardModel.getValue("SERVER_NAME");
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    protected void registerChildren() {
        TraceUtil.trace3("Entering");
        this.registerChild(CHILD_LABEL, class$com$sun$web$ui$view$html$CCLabel == null ? (class$com$sun$web$ui$view$html$CCLabel = NewWizardFSDAUView.class$("com.sun.web.ui.view.html.CCLabel")) : class$com$sun$web$ui$view$html$CCLabel);
        this.registerChild(CHILD_STATICTEXT, class$com$sun$web$ui$view$html$CCStaticTextField == null ? (class$com$sun$web$ui$view$html$CCStaticTextField = NewWizardFSDAUView.class$("com.sun.web.ui.view.html.CCStaticTextField")) : class$com$sun$web$ui$view$html$CCStaticTextField);
        this.registerChild(CHILD_DAU_DROPDOWN, class$com$sun$web$ui$view$html$CCDropDownMenu == null ? (class$com$sun$web$ui$view$html$CCDropDownMenu = NewWizardFSDAUView.class$("com.sun.web.ui.view.html.CCDropDownMenu")) : class$com$sun$web$ui$view$html$CCDropDownMenu);
        this.registerChild(CHILD_STRIPE_FIELD, class$com$sun$web$ui$view$html$CCTextField == null ? (class$com$sun$web$ui$view$html$CCTextField = NewWizardFSDAUView.class$("com.sun.web.ui.view.html.CCTextField")) : class$com$sun$web$ui$view$html$CCTextField);
        this.registerChild(CHILD_ALERT, class$com$sun$web$ui$view$alert$CCAlertInline == null ? (class$com$sun$web$ui$view$alert$CCAlertInline = NewWizardFSDAUView.class$("com.sun.web.ui.view.alert.CCAlertInline")) : class$com$sun$web$ui$view$alert$CCAlertInline);
        this.registerChild(CHILD_IS_SHARED_HIDDEN, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = NewWizardFSDAUView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        TraceUtil.trace3("Exiting");
    }

    protected View createChild(String name) {
        TraceUtil.trace3("Entering");
        CCLabel child = null;
        if (name.equals(CHILD_LABEL)) {
            child = new CCLabel((ContainerView)this, name, null);
        } else if (name.equals(CHILD_STATICTEXT)) {
            child = new CCStaticTextField((ContainerView)this, name, null);
        } else if (name.equals(CHILD_DAU_DROPDOWN)) {
            CCDropDownMenu dropdownChild = new CCDropDownMenu((ContainerView)this, name, null);
            child = dropdownChild;
        } else if (name.equals(CHILD_STRIPE_FIELD)) {
            child = new CCTextField((ContainerView)this, name, null);
        } else if (name.equals(CHILD_ALERT)) {
            CCAlertInline child1 = new CCAlertInline((ContainerView)this, name, null);
            child1.setValue((Object)"error");
            child = child1;
        } else if (name.equals(CHILD_IS_SHARED_HIDDEN)) {
            child = new CCHiddenField((ContainerView)this, name, null);
        } else {
            throw new IllegalArgumentException("NewWizardDAUView : Invalid child name [" + name + "]");
        }
        TraceUtil.trace3("Exiting");
        return child;
    }

    public String getPageletUrl() {
        TraceUtil.trace3("Entering");
        String url = null;
        url = !this.previous_error ? "/jsp/fs/NewWizardFSDAUPage.jsp" : "/jsp/fs/wizardErrorPage.jsp";
        TraceUtil.trace3("Exiting");
        return url;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        String t;
        TraceUtil.trace3("Entering");
        super.beginDisplay(event);
        CCDropDownMenu dauDropdown = (CCDropDownMenu)this.getChild(CHILD_DAU_DROPDOWN);
        SamWizardModel wizardModel = (SamWizardModel)this.getDefaultModel();
        String fsType = (String)wizardModel.getValue("fsTypeKey");
        String dauSize = (String)wizardModel.getValue(CHILD_DAU_DROPDOWN);
        TraceUtil.trace2(new NonSyncStringBuffer("dauSize is : ").append(dauSize).toString());
        OptionList dauOptions = new OptionList(new String[]{"samqfsui.fs.wizards.new.DAUPage.option.16", "samqfsui.fs.wizards.new.DAUPage.option.32", "samqfsui.fs.wizards.new.DAUPage.option.64"}, new String[]{"16", "32", "64"});
        dauDropdown.setOptions(dauOptions);
        dauDropdown.setDisabled(false);
        CCTextField stripeWidthField = (CCTextField)this.getChild(CHILD_STRIPE_FIELD);
        String stripeWidth = (String)wizardModel.getValue(CHILD_STRIPE_FIELD);
        if (stripeWidth == null) {
            stripeWidth = this.isSharedFileSystem(wizardModel) ? "0" : Integer.toString(this.getDefaultStripeWidth(wizardModel, dauSize));
            wizardModel.setValue(CHILD_STRIPE_FIELD, stripeWidth);
        }
        if ((t = (String)wizardModel.getValue("ERROR")) != null && t.equals("Yes")) {
            String msgs = (String)wizardModel.getValue("ERROR_MSGS");
            int code = Integer.parseInt((String)wizardModel.getValue("ERROR_CODE"));
            String errorSummary = "FSWizard.new.error.steps";
            this.previous_error = true;
            String errorDetails = (String)wizardModel.getValue("ERROR_DETAIL");
            if (errorDetails != null) {
                errorSummary = (String)wizardModel.getValue("ERROR_SUMMARY");
                this.previous_error = !errorDetails.equals("INLINE_ALERT");
            }
            if (this.previous_error) {
                SamUtil.setErrorAlert((ContainerView)this, CHILD_ALERT, errorSummary, code, msgs, this.serverName);
            } else {
                SamUtil.setWarningAlert((ContainerView)this, CHILD_ALERT, errorSummary, msgs);
            }
        }
        ((CCHiddenField)this.getChild(CHILD_IS_SHARED_HIDDEN)).setValue((Object)Boolean.toString(this.isSharedFileSystem(wizardModel)));
        TraceUtil.trace3("Exiting");
    }

    private int getDefaultStripeWidth(SamWizardModel wizardModel, String dauSize) {
        String fsType = (String)wizardModel.getValue("fsTypeKey");
        int dau = 64;
        try {
            dau = Integer.parseInt(dauSize);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        int stripeWidth = -1;
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
            int type = -1;
            int archType = -1;
            int shareStatus = 0;
            if (fsType.equals("qfs")) {
                type = 0;
                archType = 3;
            } else if (fsType.equals("fs")) {
                type = 1;
                archType = 2;
            }
            FileSystemMountProperties properties = sysModel.getSamQFSSystemFSManager().getDefaultMountProperties(type, archType, dau, false, shareStatus, false);
            stripeWidth = properties.getStripeWidth();
        }
        catch (SamFSException smfex) {
            SamUtil.processException((Exception)((Object)smfex), ((Object)((Object)this)).getClass(), "beginDisplay()", "Failed to get default stripe width value", this.serverName);
            SamUtil.setErrorAlert((ContainerView)this, CHILD_ALERT, "FSWizard.new.error.steps", smfex.getSAMerrno(), smfex.getMessage(), this.serverName);
        }
        TraceUtil.trace3("default stripe width = " + stripeWidth);
        return stripeWidth;
    }

    private boolean isSharedFileSystem(SamWizardModel wizardModel) {
        String fsType = (String)wizardModel.getValue("fsTypeKey");
        return fsType.equals("sharedqfs") || fsType.equals("sharedfs");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

