/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs.wizards;

import com.iplanet.jato.model.Model;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.fs.wizards.FSWizardDeviceSelectionPageView;
import com.sun.netstorage.samqfs.web.model.media.DiskCache;
import com.sun.netstorage.samqfs.web.model.media.SharedDiskCache;
import com.sun.netstorage.samqfs.web.util.Capacity;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.netstorage.samqfs.web.wizard.SamWizardModel;
import com.sun.web.ui.view.table.CCActionTable;
import java.util.ArrayList;

public class FSWizardDataDeviceSelectionPageView
extends FSWizardDeviceSelectionPageView {
    public static final String PAGE_NAME = "FSWizardDataDeviceSelectionPageView";
    public static final String PREV_FSTYPE_KEY = "PREV_FS_TYPE";

    public FSWizardDataDeviceSelectionPageView(View parent, Model model) {
        this(parent, model, PAGE_NAME);
    }

    public FSWizardDataDeviceSelectionPageView(View parent, Model model, String name) {
        super(parent, model, name);
        TraceUtil.initTrace();
        TraceUtil.trace3("Exiting");
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        SamWizardModel wizardModel = (SamWizardModel)this.getDefaultModel();
        String fsType = (String)wizardModel.getValue("fsTypeKey");
        String prevFSType = (String)wizardModel.getValue(PREV_FSTYPE_KEY);
        if (prevFSType != null && !prevFSType.equals(fsType)) {
            CCActionTable table = (CCActionTable)this.getChild("DeviceSelectionTable");
            table.resetStateData();
        }
        wizardModel.setValue(PREV_FSTYPE_KEY, fsType);
        if (fsType.equals("ufs")) {
            this.tableModel.setSelectionType("single");
        } else {
            this.tableModel.setSelectionType("multiple");
        }
        super.beginDisplay(event);
        TraceUtil.trace3("Exiting");
    }

    protected void createActionTableModel() {
        super.createActionTableModel();
        this.tableModel.setTitle("FSWizard.dataDeviceSelectionTable.title");
        TraceUtil.trace2("Leaving createActionTableModel");
    }

    protected void populateActionTableModel() throws SamFSException {
        TraceUtil.trace3("Entering");
        this.initSelected = 0;
        this.tableModel.clear();
        SamWizardModel wizardModel = (SamWizardModel)this.getDefaultModel();
        DiskCache[] devices = this.sharedChecked != null && this.sharedChecked.equals("true") ? (SharedDiskCache[])wizardModel.getValue("AllAllocatableDevices") : (DiskCache[])wizardModel.getValue("AllAllocatableDevices");
        this.totalItems = 0;
        if (devices == null) {
            TraceUtil.trace2("Device List is Null from Impl class");
            throw new SamFSException(null, -2001);
        }
        ArrayList selectedMetadataDevices = (ArrayList)wizardModel.getValue("SelectedMetaDevices");
        ArrayList selectedDevices = (ArrayList)wizardModel.getValue("SelectedDataDevices");
        String samfsServerAPIVersion = (String)wizardModel.getValue("SamServerAPIVersion");
        for (int i = 0; i < devices.length; ++i) {
            if (selectedMetadataDevices != null && selectedMetadataDevices.contains(devices[i].getDevicePath())) continue;
            if (i > 0) {
                this.tableModel.appendRow();
            }
            ++this.totalItems;
            String partition = null;
            int diskType = devices[i].getDiskType();
            if (diskType == 101) {
                partition = "FSWizard.diskType.slice";
            } else if (diskType == 102) {
                partition = "FSWizard.diskType.svm";
            } else if (diskType == 103) {
                partition = "FSWizard.diskType.vxvm";
            } else if (diskType == 104) {
                partition = "FSWizard.diskType.svm.mirror";
            } else if (diskType == 105) {
                partition = "FSWizard.diskType.vxvm.mirror";
            } else if (diskType == 106) {
                partition = "FSWizard.diskType.svm.raid5";
            } else if (diskType == 107) {
                partition = "FSWizard.diskType.vxvm.raid5";
            }
            String pathString = devices[i].getDevicePath();
            String[] sliceElement = pathString.split("/");
            if ((diskType == 102 || diskType == 104 || diskType == 106) && sliceElement.length == 6) {
                this.tableModel.setValue("DevicePath", (Object)(sliceElement[3] + "/" + sliceElement[5]));
            } else {
                int index = pathString.indexOf("/dsk/");
                this.tableModel.setValue("DevicePath", (Object)pathString.substring(index + 5));
            }
            this.tableModel.setValue("HiddenDevicePath", (Object)pathString);
            if (this.sharedChecked == null || !this.sharedChecked.equals("true")) {
                this.tableModel.setValue("Partition", (Object)partition);
            }
            long dCap = devices[i].getCapacity();
            this.tableModel.setValue("Capacity", (Object)new Capacity(dCap, 2));
            if (this.sharedChecked != null && this.sharedChecked.equals("true")) {
                int ii;
                String metaDataHostName = (String)wizardModel.getValue("SERVER_NAME");
                String[] serverHosts = ((SharedDiskCache)devices[i]).availFromServers();
                String[] clientHosts = ((SharedDiskCache)devices[i]).availFromClients();
                TraceUtil.trace3("client host is " + clientHosts.toString());
                ArrayList chosenClientHosts = (ArrayList)wizardModel.getValue("SelectedClientIndex");
                String displayHosts = metaDataHostName;
                for (ii = 0; ii < clientHosts.length; ++ii) {
                    displayHosts = displayHosts + ";" + clientHosts[ii];
                }
                for (ii = 0; ii < serverHosts.length; ++ii) {
                    displayHosts = displayHosts + ";" + serverHosts[ii];
                }
                ArrayList potentialHosts = (ArrayList)wizardModel.getValue("SelectedPotentialMetadataServerValue");
                ArrayList seleectedClientHosts = (ArrayList)wizardModel.getValue("SelectedClient");
                this.tableModel.setValue("AvailableFrom", (Object)displayHosts);
                if (((SharedDiskCache)devices[i]).usedByClient()) {
                    this.tableModel.setSelectionVisible(false);
                }
                if (seleectedClientHosts.size() != 0 && potentialHosts.size() != 0) {
                    if (serverHosts.length != potentialHosts.size() || clientHosts.length != seleectedClientHosts.size()) {
                        this.tableModel.setSelectionVisible(false);
                    }
                } else if (seleectedClientHosts.size() != 0) {
                    if (clientHosts.length == 0) {
                        this.tableModel.setSelectionVisible(false);
                    }
                    if (serverHosts.length != potentialHosts.size() || clientHosts.length != seleectedClientHosts.size()) {
                        this.tableModel.setSelectionVisible(false);
                    }
                } else if (potentialHosts.size() != 0 && (serverHosts.length != potentialHosts.size() || clientHosts.length != seleectedClientHosts.size())) {
                    this.tableModel.setSelectionVisible(false);
                }
            }
            if (samfsServerAPIVersion != null && samfsServerAPIVersion.compareTo("1.2") >= 0) {
                this.tableModel.setValue("Vendor", (Object)devices[i].getVendor());
                this.tableModel.setValue("ProductID", (Object)devices[i].getProductId());
            }
            if (selectedDevices == null || !selectedDevices.contains(devices[i].getDevicePath())) continue;
            this.tableModel.setRowSelected(true);
            ++this.initSelected;
        }
        TraceUtil.trace2("Finished Adding devices and populateModel");
        TraceUtil.trace3("Exiting");
    }
}

