/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs.wizards;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiHostException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiMsgException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiStepOpException;
import com.sun.netstorage.samqfs.mgmt.SamFSTimeoutException;
import com.sun.netstorage.samqfs.mgmt.SamFSWarnings;
import com.sun.netstorage.samqfs.web.fs.wizards.CreateFSWizardImplData;
import com.sun.netstorage.samqfs.web.fs.wizards.FSWizardDeviceSelectionPageView;
import com.sun.netstorage.samqfs.web.fs.wizards.FSWizardSharedMemberSelectionPageModel;
import com.sun.netstorage.samqfs.web.fs.wizards.FSWizardSharedMemberSelectionPageView;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemSharedFSManager;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.fs.FileSystemMountProperties;
import com.sun.netstorage.samqfs.web.model.fs.GenericFileSystem;
import com.sun.netstorage.samqfs.web.model.fs.SharedMember;
import com.sun.netstorage.samqfs.web.model.impl.jni.fs.GenericMountOptionsImpl;
import com.sun.netstorage.samqfs.web.model.media.DiskCache;
import com.sun.netstorage.samqfs.web.model.media.SharedDiskCache;
import com.sun.netstorage.samqfs.web.model.media.StripedGroup;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.ServerInfo;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.netstorage.samqfs.web.wizard.SamWizardImpl;
import com.sun.netstorage.samqfs.web.wizard.SamWizardModel;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCWizardWindowModel;
import com.sun.web.ui.model.wizard.WizardEvent;
import com.sun.web.ui.model.wizard.WizardInterface;
import com.sun.web.ui.view.table.CCActionTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.servlet.http.HttpSession;

public class CreateFSWizardImpl
extends SamWizardImpl {
    public static final String WIZARDPAGEMODELNAME = "CreateFSPageModelName";
    public static final String WIZARDPAGEMODELNAME_PREFIX = "WizardModel";
    public static final String WIZARDIMPLNAME = "CreateFSWizardImpl";
    public static final String WIZARDIMPLNAME_PREFIX = "WizardImpl";
    public static final String WIZARDCLASSNAME = "com.sun.netstorage.samqfs.web.fs.wizards.CreateFSWizardImpl";
    public static final String FSTYPE_KEY = "fsTypeKey";
    public static final String FSTYPE_FS = "fs";
    public static final String FSTYPE_QFS = "qfs";
    public static final String FSTYPE_SHAREDFS = "sharedfs";
    public static final String FSTYPE_SHAREDQFS = "sharedqfs";
    public static final String FSTYPE_UFS = "ufs";
    public static final String FSTYPE_HAFS = "hafs";
    public static final String FSTYPE_SHARED_HAFS = "sharedhafs";
    public static final String ARCHIVE_ENABLED_KEY = "archiveEnabled";
    private boolean dumpOn = false;
    private String fsType = "fs";
    private String OLD_FS_TYPE = "OLD_FS_TYPE";
    private String OLD_NUM_STRIPED_GROUPS = "OLD_NUM_STRIPED_GROUPS";
    private String samfsServerAPIVersion = "1.3";
    private short fsLicense = (short)3;
    private boolean archiveEnabled = false;
    private boolean sharedEnabled = false;
    private boolean newDAUPage = false;
    private int striped_group_base = 3;
    private DiskCache[] allAllocatableDevices = null;
    private ArrayList selectedDataDevicesList = null;
    private ArrayList selectedMetaDevicesList = null;
    private ArrayList selectedStripedGroupDevicesList = null;
    private ArrayList selectedPrimaryIPIndex = null;
    private ArrayList selectedSecondaryIPIndex = null;
    private ArrayList selectedClientIndex = null;
    private ArrayList selectedPotentialMetadataServerIndex = null;
    private ArrayList selectedClient = null;
    private ArrayList selectedPotentialMetadataServer = null;
    private ArrayList selectedSharedPotentialMetaServerHostList = null;
    private ArrayList selectedSharedClientHostList = null;
    private SharedMember[] allMemList = null;
    int memSize = 0;
    int intHWM = -1;
    int intLWM = -1;
    int intStripe = -1;
    protected String serverName = null;

    public static WizardInterface create(RequestContext requestContext) {
        TraceUtil.initTrace();
        TraceUtil.trace2("in create()");
        return new CreateFSWizardImpl(requestContext);
    }

    public CreateFSWizardImpl(RequestContext requestContext) {
        super(requestContext, WIZARDPAGEMODELNAME);
        this.initializeWizard(requestContext);
        this.initializeWizardControl(requestContext);
    }

    public static CCWizardWindowModel createModel(String cmdChild) {
        return CreateFSWizardImpl.getWizardWindowModel(WIZARDIMPLNAME, "FSWizard.new.title", WIZARDCLASSNAME, cmdChild);
    }

    public Class getPageClass(String pageId) {
        TraceUtil.trace2("Entered with pageID = " + pageId);
        int page = this.pageIdToPage(pageId);
        if (this.pages[page] == 3) {
            this.wizardModel.setValue("stripedGroupNumber", new Integer(page - this.striped_group_base));
            TraceUtil.trace2("This is striped group # " + (page - this.striped_group_base));
        }
        this.wizardModel.setValue("ERROR", "No");
        return super.getPageClass(pageId);
    }

    public String[] getFuturePages(String pageId) {
        TraceUtil.trace2("Entered with pageID = " + pageId);
        int page = this.pageIdToPage(pageId);
        String[] futurePages = null;
        if (this.pages[page] == 0) {
            futurePages = new String[]{};
        } else if (this.pages[page] == 6) {
            futurePages = new String[]{};
        } else {
            int howMany = this.pages.length - page - 1;
            futurePages = new String[howMany];
            for (int i = 0; i < howMany; ++i) {
                futurePages[i] = Integer.toString(page + i);
            }
        }
        return futurePages;
    }

    public String[] getFutureSteps(String pageId) {
        TraceUtil.trace2("Entered with pageID = " + pageId);
        int page = this.pageIdToPage(pageId);
        String[] futureSteps = null;
        if (this.pages[page] == 0) {
            futureSteps = new String[]{};
        } else if (this.pages[page] == 6) {
            futureSteps = new String[]{};
        } else {
            int howMany = this.pages.length - page - 1;
            futureSteps = new String[howMany];
            for (int i = 0; i < howMany; ++i) {
                int futureStep = page + 1 + i;
                int futurePage = this.pages[futureStep];
                futureSteps[i] = futurePage == 3 ? SamUtil.getResourceString(this.stepText[futurePage], new String[]{Integer.toString(futureStep - this.striped_group_base)}) : this.stepText[futurePage];
            }
        }
        return futureSteps;
    }

    public String getStepText(String pageId) {
        TraceUtil.trace2("Entered with pageID = " + pageId);
        int page = this.pageIdToPage(pageId);
        String text = null;
        text = this.pages[page] == 3 ? SamUtil.getResourceString(this.stepText[this.pages[page]], new String[]{Integer.toString(page - this.striped_group_base)}) : this.stepText[this.pages[page]];
        return text;
    }

    public String getStepInstruction(String pageId) {
        TraceUtil.trace2("Entered with pageID = " + pageId);
        int page = this.pageIdToPage(pageId);
        String text = null;
        if (this.pages[page] == 1) {
            TraceUtil.trace3("METADATA Host name = " + this.serverName);
            text = SamUtil.getResourceString(this.stepInstruction[this.pages[page]], this.serverName);
        } else {
            text = this.stepInstruction[this.pages[page]];
        }
        return text;
    }

    public String getStepTitle(String pageId) {
        TraceUtil.trace2("Entered with pageID = " + pageId);
        int page = this.pageIdToPage(pageId);
        String title = null;
        title = this.pages[page] == 3 ? SamUtil.getResourceString(this.pageTitle[this.pages[page]], new String[]{Integer.toString(page - this.striped_group_base)}) : this.pageTitle[this.pages[page]];
        return title;
    }

    public boolean nextStep(WizardEvent wizardEvent) {
        String pageId = wizardEvent.getPageId();
        TraceUtil.trace2("Entered with pageID = " + pageId);
        super.nextStep(wizardEvent);
        int page = this.pageIdToPage(pageId);
        boolean hafs = CreateFSWizardImpl.isHAFS(this.wizardModel);
        switch (this.pages[page]) {
            case 0: {
                boolean result = this.processFSNamePage(wizardEvent);
                if (result && !this.sharedEnabled && !hafs) {
                    result = this.populateDevicesInWizardModel();
                }
                return result;
            }
            case 1: {
                boolean result2 = this.processSharedMemberPage(wizardEvent);
                if (result2 && this.sharedEnabled) {
                    result2 = this.populateDevicesInWizardModel();
                }
                return result2;
            }
            case 2: {
                return this.processMetaDataDevicesPage(wizardEvent);
            }
            case 3: {
                return this.processStripedGroupPage(wizardEvent);
            }
            case 4: {
                return this.processDataDevicesPage(wizardEvent);
            }
            case 5: 
            case 6: {
                return this.processDAUPage(wizardEvent);
            }
            case 7: {
                return this.processMountOptionsPage(wizardEvent);
            }
            case 9: {
                return this.processSyntaxPage(wizardEvent);
            }
            case 8: {
                return this.processStdMountOptionsPage(wizardEvent);
            }
            case 14: {
                boolean result3 = this.processClusterNodes(wizardEvent);
                if (result3) {
                    result3 = this.populateDevicesInWizardModel();
                }
                return result3;
            }
        }
        return true;
    }

    public boolean previousStep(WizardEvent wizardEvent) {
        String pageId = wizardEvent.getPageId();
        TraceUtil.trace2("Entered with pageID = " + pageId);
        super.previousStep(wizardEvent);
        int page = this.pageIdToPage(pageId);
        switch (this.pages[page]) {
            case 5: 
            case 6: {
                this.processDAUPage(wizardEvent);
            }
        }
        return true;
    }

    public boolean finishStep(WizardEvent wizardEvent) {
        String singleAllocation;
        String syntax;
        String pageId = wizardEvent.getPageId();
        TraceUtil.trace2("Entered with pageID = " + pageId);
        if (!super.finishStep(wizardEvent)) {
            return true;
        }
        if (this.fsType.equals(FSTYPE_UFS)) {
            TraceUtil.trace2("Creating a UFS file system");
            return this.createUFS();
        }
        String fsName = ((String)this.wizardModel.getWizardValue("fsNameValue")).trim();
        int intFSType = 1;
        if (!this.fsType.equals(FSTYPE_FS) && !this.fsType.equals(FSTYPE_SHAREDFS)) {
            intFSType = 0;
        }
        int intArchType = 2;
        if (!this.archiveEnabled) {
            intArchType = 3;
        }
        int intEquipOrdinal = -1;
        int intShareStatus = 0;
        boolean boolCreateMountPoint = true;
        boolean boolMountAfterCreate = false;
        boolean boolMountAtBoot = false;
        boolean boolSingleAllocation = false;
        String mountPoint = ((String)this.wizardModel.getWizardValue("mountValue")).trim();
        String dumpPath = (String)this.wizardModel.getValue("locationTextField");
        String mountAtBoot = (String)this.wizardModel.getValue("bootTimeCheckBox");
        if (mountAtBoot != null && mountAtBoot.equals("samqfsui.yes")) {
            boolMountAtBoot = true;
        }
        if ((syntax = (String)this.wizardModel.getValue("mountOptionCheckBox")) != null && syntax.equals("samqfsui.yes")) {
            boolMountAfterCreate = true;
        }
        if ((singleAllocation = (String)this.wizardModel.getValue("allocSelect")) != null && singleAllocation.equals("FSWizard.new.qfs.singleAllocation")) {
            boolSingleAllocation = true;
        }
        TraceUtil.trace2("QFS Single Allocation: " + boolSingleAllocation);
        int intDAU = 16;
        try {
            intDAU = Integer.parseInt((String)this.wizardModel.getValue("DAUDropDown"));
        }
        catch (NumberFormatException nfe) {
            TraceUtil.trace1("Invalid DAU - " + nfe.getMessage());
        }
        SamQFSSystemModel sysModel = null;
        FileSystemMountProperties properties = null;
        try {
            sysModel = SamUtil.getModel(this.serverName);
            properties = sysModel.getSamQFSSystemFSManager().getDefaultMountProperties(intFSType, intArchType, intDAU, false, intShareStatus, false);
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "finishStep()", "Failed to get Default Mount Properties", this.serverName);
            this.wizardModel.setValue("Finish_result", "Failed");
            this.wizardModel.setValue("WizardResultAlertSummary", "FSWizard.new.error.summary");
            this.wizardModel.setValue("WizardResultAlertDetail", ex.getMessage());
            this.wizardModel.setValue("Detail_code", Integer.toString(ex.getSAMerrno()));
            return true;
        }
        properties = this.setSelectedMountProperties(properties);
        if (intArchType == 3) {
            properties.setArchive(false);
        }
        DiskCache[] metadataDevices = this.getSelectedDeviceArray(this.selectedMetaDevicesList);
        DiskCache[] dataDevices = this.getSelectedDeviceArray(this.selectedDataDevicesList);
        StripedGroup[] stripedGroups = null;
        try {
            stripedGroups = this.getSelectedStripedGroupsArray(this.selectedStripedGroupDevicesList);
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "finishStep()", "Failed to create striped groups", this.serverName);
            this.wizardModel.setValue("Finish_result", "Failed");
            this.wizardModel.setValue("WizardResultAlertSummary", "FSWizard.new.error.summary");
            this.wizardModel.setValue("WizardResultAlertDetail", ex.getMessage());
            this.wizardModel.setValue("Detail_code", Integer.toString(ex.getSAMerrno()));
            return true;
        }
        this.wizardModel.setValue("fs_name", fsName);
        LogUtil.info(this.getClass(), "finishStep", "Start creating new FS " + fsName);
        try {
            String dumpCheck = (String)this.wizardModel.getWizardValue("saveToFileCheck");
            if (dumpCheck != null && dumpCheck.equals("true")) {
                sysModel.setDumpPath(dumpPath);
            }
            String[] nodeList = null;
            if (CreateFSWizardImpl.isHAFS(this.wizardModel)) {
                ArrayList<String> hosts = new ArrayList<String>();
                String currentServer = new StringTokenizer(this.serverName, ".").nextToken();
                hosts.add(currentServer);
                Object[] nodes = this.wizardModel.getValues("clusterNode");
                for (int i = 0; i < nodes.length; ++i) {
                    String tempNodeName = nodes[i].toString().trim();
                    if (tempNodeName.equals("") || tempNodeName.equals(currentServer)) continue;
                    hosts.add(tempNodeName);
                }
                nodeList = new String[hosts.size()];
                nodeList = hosts.toArray(nodeList);
            }
            TraceUtil.trace2("Calling CreateFileSystem with name: " + fsName);
            if (this.sharedEnabled) {
                SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
                SamQFSSystemSharedFSManager fsManager = appModel.getSamQFSSystemSharedFSManager();
                ArrayList clientHosts = (ArrayList)this.wizardModel.getValue("SelectedClient");
                ArrayList potentialHosts = (ArrayList)this.wizardModel.getValue("SelectedPotentialMetadataServerValue");
                String[] clients = clientHosts.toArray(new String[0]);
                String[] potentials = potentialHosts.toArray(new String[0]);
                SharedMember[] memList = new SharedMember[this.memSize];
                TraceUtil.trace3("member list size is " + Integer.toString(this.memSize));
                int j = 0;
                for (int i = 0; i < this.allMemList.length; ++i) {
                    if (this.allMemList[i] != null) {
                        String tempName = this.allMemList[i].getHostName();
                        memList[j] = this.allMemList[i];
                        TraceUtil.trace2("member list host name is " + tempName);
                        String[] temp = this.allMemList[i].getIPs();
                        for (int ii = 0; ii < temp.length; ++ii) {
                            TraceUtil.trace2("member list ip is " + temp[ii]);
                        }
                        ++j;
                        continue;
                    }
                    TraceUtil.trace2("member list host name is null");
                }
                TraceUtil.trace2("before CreateSharedFileSystem with name: " + fsName);
                System.out.println("GUI: fsType is " + this.fsType);
                System.out.println("GUI: start fsManager.createSharedFileSystem");
                FileSystem fs2 = fsManager.createSharedFileSystem(fsName, mountPoint, intDAU, memList, properties, this.fsType.equals(FSTYPE_SHAREDFS) ? new DiskCache[]{} : metadataDevices, dataDevices, stripedGroups, boolSingleAllocation, boolMountAtBoot, boolCreateMountPoint, boolMountAfterCreate);
                System.out.println("GUI: done fsManager.createSharedFileSystem");
                this.memSize = 0;
            } else {
                FileSystem fs3 = CreateFSWizardImpl.isHAFS(this.wizardModel) ? sysModel.getSamQFSSystemFSManager().createHAFileSystem(nodeList, fsName, intFSType, intEquipOrdinal, mountPoint, intDAU, properties, metadataDevices, dataDevices, stripedGroups, boolSingleAllocation, boolCreateMountPoint, boolMountAfterCreate) : sysModel.getSamQFSSystemFSManager().createFileSystem(fsName, intFSType, intArchType, intEquipOrdinal, mountPoint, intShareStatus, intDAU, properties, metadataDevices, dataDevices, stripedGroups, boolSingleAllocation, boolMountAtBoot, boolCreateMountPoint, boolMountAfterCreate);
            }
            LogUtil.info(this.getClass(), "finishStep", "Done creating new FS " + fsName);
            this.wizardModel.setValue("Finish_result", "successful");
            this.wizardModel.setValue("WizardResultAlertSummary", "success.summary");
            this.wizardModel.setValue("WizardResultAlertDetail", SamUtil.getResourceString("FSSummary.createfs", fsName));
            TraceUtil.trace2("Succesfully created FS with name: " + fsName);
            return true;
        }
        catch (SamFSMultiHostException e) {
            SamUtil.doPrint(new NonSyncStringBuffer().append("error code is ").append(e.getSAMerrno()).toString());
            String errMsg = SamUtil.handleMultiHostException(e);
            if (errMsg == null) {
                TraceUtil.trace2("err is null");
                errMsg = "";
            } else {
                TraceUtil.trace2("err is " + errMsg);
            }
            this.wizardModel.setValue("Finish_result", "Failed");
            this.wizardModel.setValue("WizardResultAlertSummary", "FSWizard.new.error.summary");
            this.wizardModel.setValue("WizardResultAlertDetail", errMsg);
            int errCode = e.getSAMerrno();
            this.wizardModel.setValue("Detail_code", Integer.toString(errCode));
            return true;
        }
        catch (SamFSMultiStepOpException msex) {
            if (sysModel != null) {
                sysModel.clearContext();
            }
            this.processMultiStepException(msex);
            return true;
        }
        catch (SamFSTimeoutException toex) {
            TraceUtil.trace2("processing samfs time out exception...");
            this.wizardModel.setValue("Finish_result", "Warning");
            this.wizardModel.setValue("WizardResultAlertSummary", "FSWizard.new.warning.summary");
            this.wizardModel.setValue("WizardResultAlertDetail", SamUtil.getResourceStringError("-2801"));
            this.wizardModel.setValue("Detail_code", Integer.toString(toex.getSAMerrno()));
            String processExMessage = "Timed out when creating " + fsName + ": " + toex.getMessage();
            SamUtil.processException((Exception)((Object)toex), this.getClass(), "finishStep()", processExMessage, this.serverName);
            return true;
        }
        catch (SamFSException ex) {
            if (sysModel != null) {
                sysModel.clearContext();
            }
            boolean multiMsgOccurred = false;
            boolean warningOccurred = false;
            String processMsg = null;
            if (ex instanceof SamFSMultiMsgException) {
                processMsg = "Error in archiver configuration";
                multiMsgOccurred = true;
            } else if (ex instanceof SamFSWarnings) {
                warningOccurred = true;
                processMsg = "Warning in archiver configuration";
            } else {
                processMsg = "Failed to create FS" + fsName;
            }
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "finishStep()", processMsg, this.serverName);
            int errCode = ex.getSAMerrno();
            if (multiMsgOccurred) {
                this.wizardModel.setValue("Finish_result", "Failed");
                this.wizardModel.setValue("WizardResultAlertSummary", "ArchiveConfig.error");
                this.wizardModel.setValue("WizardResultAlertDetail", "ArchiveConfig.error.detail");
                this.wizardModel.setValue("Detail_code", Integer.toString(errCode));
            } else if (warningOccurred) {
                this.wizardModel.setValue("Finish_result", "Warning");
                this.wizardModel.setValue("WizardResultAlertSummary", "ArchiveConfig.error");
                this.wizardModel.setValue("WizardResultAlertDetail", "ArchiveConfig.warning.detail");
                this.wizardModel.setValue("Detail_code", Integer.toString(errCode));
            } else {
                this.wizardModel.setValue("Finish_result", "Failed");
                this.wizardModel.setValue("WizardResultAlertSummary", "FSWizard.new.error.summary");
                this.wizardModel.setValue("WizardResultAlertDetail", ex.getMessage());
                this.wizardModel.setValue("Detail_code", Integer.toString(errCode));
            }
            return true;
        }
        catch (Exception e) {
            System.out.println("caught unexpected exception");
            e.printStackTrace();
            e.printStackTrace(System.out);
            return true;
        }
    }

    public boolean cancelStep(WizardEvent wizardEvent) {
        super.cancelStep(wizardEvent);
        this.wizardModel.setValue("ERROR", "No");
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
            if (sysModel == null) {
                throw new SamFSException(null, -2001);
            }
            sysModel.getDataStore().clearAvailableAllocatableUnits();
            sysModel.getDataStore().clearTemporaryStripedGroups();
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "cancelStep()", "Failed to clear selected allocatableUnits", this.serverName);
            this.wizardModel.setValue("Finish_result", "Failed");
            this.wizardModel.setValue("Detail_msgs", ex.getMessage());
            this.wizardModel.setValue("Detail_code", Integer.toString(ex.getSAMerrno()));
        }
        this.wizardModel.clear();
        return true;
    }

    public void closeStep(WizardEvent wizardEvent) {
        TraceUtil.trace2("Clearing out wizard model...");
        this.wizardModel.clear();
        TraceUtil.trace2("Done!");
    }

    private void initializeWizard(RequestContext requestContext) {
        ServerInfo serverInfo;
        TraceUtil.trace2("Initializing wizard...");
        this.wizardName = WIZARDIMPLNAME;
        this.wizardTitle = "FSWizard.new.title";
        this.pageClass = CreateFSWizardImplData.pageClass;
        this.pageTitle = CreateFSWizardImplData.pageTitle;
        this.stepHelp = CreateFSWizardImplData.stepHelp;
        this.stepText = CreateFSWizardImplData.stepText;
        this.stepInstruction = CreateFSWizardImplData.stepInstruction;
        this.cancelMsg = CreateFSWizardImplData.cancelmsg;
        this.serverName = requestContext.getRequest().getParameter("serverNameParam");
        TraceUtil.trace2("serverNameParam = " + this.serverName);
        HttpSession session = RequestManager.getRequestContext().getRequest().getSession();
        Hashtable serverTable = (Hashtable)session.getAttribute("SAMFS_SERVER_INFO");
        if (serverTable != null && this.serverName != null && (serverInfo = (ServerInfo)serverTable.get(this.serverName)) != null) {
            this.samfsServerAPIVersion = serverInfo.getSamfsServerAPIVersion();
            this.fsLicense = serverInfo.getServerLicenseType();
        }
        TraceUtil.trace2("samfsServerAPIVersion = " + this.samfsServerAPIVersion);
        TraceUtil.trace2("fsLicense = " + this.fsLicense);
        this.wizardModel.setValue("SERVER_NAME", this.serverName);
        this.wizardModel.setValue("SamServerAPIVersion", this.samfsServerAPIVersion);
        this.wizardModel.setValue("LICENSE_TYPE", new Short(this.fsLicense));
        this.pages = CreateFSWizardImplData.qfsDualDAUPages;
        this.setShowResultsPage(true);
        this.initializeWizardPages(this.pages);
        TraceUtil.trace2("wizard initialized!");
    }

    private FileSystemMountProperties setSelectedMountProperties(FileSystemMountProperties properties) {
        String optimizeFS;
        if (this.intHWM != -1) {
            if (properties.getHWM() != this.intHWM) {
                properties.setHWM(this.intHWM);
            }
        } else {
            properties.setHWM(this.intHWM);
        }
        if (this.intLWM != -1) {
            if (properties.getLWM() != this.intLWM) {
                properties.setLWM(this.intLWM);
            }
        } else {
            properties.setLWM(this.intLWM);
        }
        if (this.intStripe != -1) {
            if (properties.getStripeWidth() != this.intStripe) {
                properties.setStripeWidth(this.intStripe);
            }
        } else {
            properties.setStripeWidth(this.intStripe);
        }
        boolean boolTrace = false;
        String traceString = (String)this.wizardModel.getValue("traceDropDown");
        if (traceString.equals("samqfsui.yes")) {
            boolTrace = true;
        }
        if (properties.isTrace() != boolTrace) {
            properties.setTrace(boolTrace);
        }
        if ((optimizeFS = (String)this.wizardModel.getValue("optimizeCheckBox")) != null && optimizeFS.equals("samqfsui.yes")) {
            properties.setQuickWrite(true);
            properties.setForceDirectIO(true);
        }
        return properties;
    }

    private boolean processFSNamePage(WizardEvent wizardEvent) {
        boolean numStripedGroups = false;
        String fsName = "";
        String fsTypeVal = (String)this.wizardModel.getWizardValue("qfsTypeSelect");
        if (fsTypeVal == null) {
            this.setWizardAlert(wizardEvent, "FSWizard.new.error.fstype");
            return false;
        }
        this.fsType = (String)this.wizardModel.getValue(FSTYPE_KEY);
        this.fsType = this.fsType == null ? FSTYPE_FS : this.fsType;
        String allocation = "";
        this.striped_group_base = 3;
        if (fsTypeVal.equals("FSWizard.new.fstype.qfs")) {
            String dauSize;
            String metaLocationVal = (String)this.wizardModel.getWizardValue("metaLocationSelect");
            TraceUtil.trace2(new NonSyncStringBuffer("metaLocationVal = ").append(metaLocationVal).toString());
            this.archiveEnabled = Boolean.valueOf((String)this.wizardModel.getValue("archiveCheck"));
            this.sharedEnabled = Boolean.valueOf((String)this.wizardModel.getValue("sharedCheck"));
            if (metaLocationVal.equals("FSWizard.new.fstype.qfs.metaSame")) {
                this.newDAUPage = false;
                this.pages = CreateFSWizardImplData.fsPages;
                dauSize = (String)this.wizardModel.getValue("DAUDropDown");
                if (dauSize == null || dauSize.trim().length() == 0 || !this.fsType.equals(FSTYPE_FS)) {
                    this.wizardModel.setValue("DAUDropDown", "64");
                }
                if (this.sharedEnabled) {
                    this.fsType = FSTYPE_SHAREDFS;
                    this.pages = CreateFSWizardImplData.sharedfsPages;
                } else {
                    this.fsType = FSTYPE_FS;
                }
            } else {
                if (!this.fsType.equals(FSTYPE_QFS) && !this.fsType.equals(FSTYPE_SHAREDQFS)) {
                    this.wizardModel.setValue("DAUDropDown", "64");
                    this.wizardModel.setValue("DAUSizeField", "64");
                    this.wizardModel.setValue("stripeValue", "");
                } else {
                    dauSize = (String)this.wizardModel.getValue("DAUDropDown");
                    if (dauSize == null || dauSize.trim().length() == 0) {
                        this.wizardModel.setValue("DAUDropDown", "64");
                    }
                    if ((dauSize = (String)this.wizardModel.getValue("DAUSizeField")) == null || dauSize.trim().length() == 0) {
                        this.wizardModel.setValue("DAUSizeField", "64");
                    }
                }
                this.fsType = FSTYPE_QFS;
                if (this.sharedEnabled) {
                    if (this.fsType.equals(FSTYPE_QFS)) {
                        this.wizardModel.setValue("stripeValue", "");
                    }
                    this.fsType = FSTYPE_SHAREDQFS;
                    this.sharedEnabled = true;
                    this.striped_group_base = 4;
                    this.pages = CreateFSWizardImplData.sharedqfsSingleDAUPages;
                } else {
                    if (this.fsType.equals(FSTYPE_SHAREDQFS)) {
                        this.wizardModel.setValue("stripeValue", "");
                    }
                    this.fsType = FSTYPE_QFS;
                    this.sharedEnabled = false;
                    this.pages = CreateFSWizardImplData.qfsSingleDAUPages;
                }
            }
            this.wizardModel.setValue(ARCHIVE_ENABLED_KEY, new Boolean(this.archiveEnabled));
            String hafs = (String)this.wizardModel.getValue(FSTYPE_HAFS);
            if (hafs != null && hafs.equals("true")) {
                this.striped_group_base = 4;
                this.pages = this.sharedEnabled ? CreateFSWizardImplData.sharedqfsPages : CreateFSWizardImplData.HAFSPages;
            }
        } else if (fsTypeVal.equals("FSWizard.new.fstype.ufs")) {
            this.fsType = FSTYPE_UFS;
            this.pages = CreateFSWizardImplData.ufsPages;
            this.newDAUPage = false;
        } else {
            this.setWizardAlert(wizardEvent, "FSWizard.new.error.fstype");
            return false;
        }
        this.wizardModel.setValue(FSTYPE_KEY, this.fsType);
        if (!fsTypeVal.equals("FSWizard.new.fstype.ufs")) {
            boolean invalidFSName = false;
            fsName = (String)this.wizardModel.getWizardValue("fsNameValue");
            if (fsName == null || fsName.trim().length() <= 0) {
                this.setWizardAlert(wizardEvent, "FSWizard.new.error.fsname");
                invalidFSName = true;
            } else if ((fsName = fsName.trim()).indexOf("/") != -1 || !SamUtil.isValidFSNameString(fsName)) {
                this.setWizardAlert(wizardEvent, "FSWizard.new.error.invalidfsname");
                invalidFSName = true;
            }
            if (!invalidFSName && this.isFileSystemExists(fsName)) {
                this.setWizardAlert(wizardEvent, "FSWizard.new.error.fsnameExists");
                invalidFSName = true;
            }
            if (invalidFSName) {
                this.wizardModel.setValue("DAUDropDown", "");
                return false;
            }
        }
        this.initializeWizardPages(this.pages);
        this.wizardModel.setValue("fsTypeSelect", fsTypeVal);
        return true;
    }

    private boolean processSharedMemberPage(WizardEvent wizardEvent) {
        TraceUtil.trace3("Entered");
        TraceUtil.trace2("Entered processSharedMemberPage.., ");
        boolean error = false;
        FSWizardSharedMemberSelectionPageView view = (FSWizardSharedMemberSelectionPageView)wizardEvent.getView();
        CCActionTable dataTable = (CCActionTable)view.getChild("SharedMemberSelectionTable");
        try {
            dataTable.restoreStateData();
        }
        catch (ModelControlException ex) {
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "handleSelectDataDeviceStep()", "Failed in restoring statedata", this.serverName);
            TraceUtil.trace1("Exception while restoreStateData: " + ex.getMessage());
            this.wizardModel.setValue("ERROR", "Yes");
            this.wizardModel.setValue("ERROR_MSGS", ex.getMessage());
            this.wizardModel.setValue("ERROR_CODE", "8001234");
            return false;
        }
        FSWizardSharedMemberSelectionPageModel memberModel = (FSWizardSharedMemberSelectionPageModel)dataTable.getModel();
        int tableSize = memberModel.getNumRows();
        String clientList = null;
        String potentialServerList = null;
        if (this.selectedClientIndex == null) {
            this.selectedClientIndex = new ArrayList();
        }
        this.selectedClientIndex.clear();
        if (this.selectedPotentialMetadataServerIndex == null) {
            this.selectedPotentialMetadataServerIndex = new ArrayList();
        }
        this.selectedPotentialMetadataServerIndex.clear();
        if (this.selectedPrimaryIPIndex == null) {
            this.selectedPrimaryIPIndex = new ArrayList();
        }
        this.selectedPrimaryIPIndex.clear();
        if (this.selectedSecondaryIPIndex == null) {
            this.selectedSecondaryIPIndex = new ArrayList();
        }
        this.selectedSecondaryIPIndex.clear();
        if (this.selectedClient == null) {
            this.selectedClient = new ArrayList();
        }
        this.selectedClient.clear();
        if (this.selectedPotentialMetadataServer == null) {
            this.selectedPotentialMetadataServer = new ArrayList();
        }
        this.selectedPotentialMetadataServer.clear();
        this.allMemList = null;
        this.allMemList = new SharedMember[tableSize + 1];
        this.memSize = 0;
        try {
            String secipAddr;
            SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
            SamQFSSystemSharedFSManager fsManager = appModel.getSamQFSSystemSharedFSManager();
            for (int i = 0; i < tableSize; ++i) {
                String[] info;
                FileSystem fileSystem;
                String fsName;
                SamQFSSystemModel model;
                view.tableModel.setRowIndex(i);
                String client = (String)view.tableModel.getValue("clientTextField");
                String potentialServer = (String)view.tableModel.getValue("potentialMetadataServerTextField");
                String hostName = (String)view.tableModel.getValue("HiddenHostName");
                String primaryIP = (String)view.tableModel.getValue("primaryIPTextField");
                String secondaryIP = (String)view.tableModel.getValue("secondaryIPTextField");
                TraceUtil.trace3("PRIMARY IP = " + primaryIP);
                TraceUtil.trace3("SECONDARY IP = " + secondaryIP);
                if (client.equals("false") && potentialServer.equals("false")) {
                    this.selectedPrimaryIPIndex.add(null);
                    this.selectedSecondaryIPIndex.add(null);
                } else {
                    this.selectedPrimaryIPIndex.add(primaryIP);
                    this.selectedSecondaryIPIndex.add(secondaryIP);
                }
                if (potentialServer != null && potentialServer.equals("true") && client != null && client.equals("true")) {
                    this.setWizardAlert(wizardEvent, "FSWizard.new.error.bothmember");
                    error = true;
                }
                if (potentialServer != null && potentialServer.equals("true")) {
                    TraceUtil.trace3("Process potential metadata server");
                    try {
                        model = SamUtil.getModel(hostName);
                        fsName = ((String)this.wizardModel.getWizardValue("fsNameValue")).trim();
                        fileSystem = model.getSamQFSSystemFSManager().getFileSystem(fsName);
                        if (fileSystem != null) {
                            info = new String[]{fsName, hostName};
                            this.setWizardAlert(wizardEvent, SamUtil.getResourceString("FSWizard.new.error.duplicateFSName", info));
                            error = true;
                        }
                    }
                    catch (SamFSException ex) {
                        SamUtil.processException((Exception)((Object)ex), this.getClass(), "processSharedMember()", "Failed to get filesystem", this.serverName);
                    }
                    if (primaryIP.equals(secondaryIP)) {
                        this.setWizardAlert(wizardEvent, "FSWizard.new.error.sameIP");
                        error = true;
                    }
                    String[] potMetaIP = null;
                    potMetaIP = secondaryIP == null || secondaryIP.equals("---") ? new String[]{primaryIP} : new String[]{primaryIP, secondaryIP};
                    this.allMemList[i] = fsManager.createSharedMember(hostName, potMetaIP, 1);
                    ++this.memSize;
                    TraceUtil.trace3("created memberlist for " + Integer.toString(i));
                    this.selectedPotentialMetadataServerIndex.add(Integer.toString(i));
                    this.selectedPotentialMetadataServer.add(hostName);
                    if (potentialServerList == null) {
                        potentialServerList = hostName + "(" + primaryIP + "," + secondaryIP + ")";
                        continue;
                    }
                    potentialServerList = potentialServerList + ", " + hostName + "(" + primaryIP + "," + secondaryIP + ")";
                    continue;
                }
                if (client == null || !client.equals("true")) continue;
                TraceUtil.trace3("Process metadata client");
                try {
                    model = SamUtil.getModel(hostName);
                    fsName = ((String)this.wizardModel.getWizardValue("fsNameValue")).trim();
                    fileSystem = model.getSamQFSSystemFSManager().getFileSystem(fsName);
                    if (fileSystem != null) {
                        info = new String[]{fsName, hostName};
                        this.setWizardAlert(wizardEvent, SamUtil.getResourceString("FSWizard.new.error.duplicateFSName", info));
                        error = true;
                    }
                }
                catch (SamFSException ex) {
                    SamUtil.processException((Exception)((Object)ex), this.getClass(), "processSharedMember()", "Failed to get filesystem", this.serverName);
                }
                if (primaryIP.equals(secondaryIP)) {
                    this.setWizardAlert(wizardEvent, "FSWizard.new.error.sameIP");
                    error = true;
                }
                String[] clientIP = null;
                clientIP = secondaryIP == null || secondaryIP.equals("---") ? new String[]{primaryIP} : new String[]{primaryIP, secondaryIP};
                this.allMemList[i] = fsManager.createSharedMember(hostName, clientIP, 2);
                ++this.memSize;
                TraceUtil.trace3("created memberlist for " + Integer.toString(i));
                this.selectedClientIndex.add(Integer.toString(i));
                this.selectedClient.add(hostName);
                clientList = clientList == null ? hostName + "(" + primaryIP + "," + secondaryIP + ")" : clientList + ", " + hostName + "(" + primaryIP + "," + secondaryIP + ")";
            }
            String ipAddr = (String)this.wizardModel.getValue("serverIP");
            if (ipAddr.equals(secipAddr = (String)this.wizardModel.getValue("secServerIP"))) {
                this.setWizardAlert(wizardEvent, "FSWizard.new.error.sameIP");
                error = true;
            }
            String[] metaIP = null;
            metaIP = secipAddr == null || secipAddr.equals("---") ? new String[]{ipAddr} : new String[]{ipAddr, secipAddr};
            if (this.memSize >= 5) {
                this.setWizardAlert(wizardEvent, "FSWizard.new.error.largerThan4");
                error = true;
            }
            this.allMemList[tableSize] = fsManager.createSharedMember(this.serverName, metaIP, 0);
            ++this.memSize;
            TraceUtil.trace3("membersize " + this.memSize);
            this.wizardModel.setValue("primaryIP", ipAddr);
            this.wizardModel.setValue("secondaryIP", secipAddr);
        }
        catch (SamFSMultiHostException e) {
            SamUtil.doPrint(new NonSyncStringBuffer().append("error code is ").append(e.getSAMerrno()).toString());
            String errMsg = SamUtil.handleMultiHostException(e);
            this.wizardModel.setValue("Finish_result", "Failed");
            this.wizardModel.setValue("WizardResultAlertSummary", "FSWizard.new.error.summary");
            this.wizardModel.setValue("WizardResultAlertDetail", errMsg);
            int errCode = e.getSAMerrno();
            this.wizardModel.setValue("Detail_code", Integer.toString(errCode));
            error = true;
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "processSharedMember()", "Failed to get filesystem", this.serverName);
            int errCode = ex.getSAMerrno();
            this.wizardModel.setValue("Finish_result", "Failed");
            this.wizardModel.setValue("WizardResultAlertSummary", "ArchiveConfig.error");
            this.wizardModel.setValue("WizardResultAlertDetail", "ArchiveConfig.error.detail");
            this.wizardModel.setValue("Detail_code", Integer.toString(errCode));
            error = true;
        }
        this.wizardModel.setValue("SelectedMemlist", this.allMemList);
        this.wizardModel.setValue("SelectedPrimaryIPIndex", this.selectedPrimaryIPIndex);
        this.wizardModel.setValue("SelectedSecondaryIPIndex", this.selectedSecondaryIPIndex);
        this.wizardModel.setValue("SelectedClient", this.selectedClient);
        this.wizardModel.setValue("SelectedPotentialMetadataServerValue", this.selectedPotentialMetadataServer);
        this.wizardModel.setValue("SelectedClientIndex", this.selectedClientIndex);
        this.wizardModel.setValue("SelectedPotentialMetadataServerIndex", this.selectedPotentialMetadataServerIndex);
        this.wizardModel.setValue("potentialMetadataServerTextField", potentialServerList);
        this.wizardModel.setValue("clientTextField", clientList);
        this.wizardModel.setValue("SelectedPotentialMetadataServer", potentialServerList);
        this.wizardModel.setValue("SelectedSharedClient", clientList);
        return !error;
    }

    private boolean processDataDevicesPage(WizardEvent wizardEvent) {
        int metaLuns;
        int usedLuns;
        TraceUtil.trace3("Entered");
        TraceUtil.trace2("Entered processDataDevicesPage.., ");
        boolean exceed = false;
        FSWizardDeviceSelectionPageView view = (FSWizardDeviceSelectionPageView)wizardEvent.getView();
        CCActionTable dataTable = (CCActionTable)view.getChild("DeviceSelectionTable");
        try {
            dataTable.restoreStateData();
        }
        catch (ModelControlException ex) {
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "handleSelectDataDeviceStep()", "Failed in restoring statedata", this.serverName);
            TraceUtil.trace1("Exception while restoreStateData: " + ex.getMessage());
            this.wizardModel.setValue("ERROR", "Yes");
            this.wizardModel.setValue("ERROR_MSGS", ex.getMessage());
            this.wizardModel.setValue("ERROR_CODE", "8001234");
            return false;
        }
        CCActionTableModel dataModel = (CCActionTableModel)dataTable.getModel();
        Integer[] selectedRows = dataModel.getSelectedRows();
        if (selectedRows.length < 1) {
            this.setWizardAlert(wizardEvent, "FSWizard.new.error.data");
            return false;
        }
        if (this.fsType.equals(FSTYPE_FS)) {
            if (selectedRows.length > 252) {
                exceed = true;
            }
        } else if (this.fsType.equals(FSTYPE_QFS) && (usedLuns = (metaLuns = this.selectedMetaDevicesList.size()) + selectedRows.length) > 252) {
            exceed = true;
        }
        TraceUtil.trace2("Number of selected rows are : " + selectedRows.length);
        String deviceSelected = null;
        Object device = null;
        if (this.selectedDataDevicesList == null) {
            this.selectedDataDevicesList = new ArrayList();
        }
        this.selectedDataDevicesList.clear();
        for (int i = 0; i < selectedRows.length; ++i) {
            dataModel.setRowIndex(selectedRows[i].intValue());
            deviceSelected = (String)dataModel.getValue("HiddenDevicePath");
            this.selectedDataDevicesList.add(deviceSelected);
        }
        this.wizardModel.setValue("SelectedDataDevices", this.selectedDataDevicesList);
        if (exceed) {
            this.setWizardAlert(wizardEvent, "FSWizard.maxlun");
            return false;
        }
        Collections.sort(this.selectedDataDevicesList);
        if (this.samfsServerAPIVersion.compareTo("1.1") >= 0) {
            int size = this.selectedDataDevicesList.size();
            String[] dataLUNs = new String[size];
            for (int i = 0; i < size; ++i) {
                dataLUNs[i] = (String)this.selectedDataDevicesList.get(i);
            }
            SamQFSSystemModel sysModel = null;
            String[] overlapLUNs = null;
            try {
                sysModel = SamUtil.getModel(this.serverName);
                if (sysModel == null) {
                    throw new SamFSException(null, -2001);
                }
                overlapLUNs = sysModel.getSamQFSSystemFSManager().checkSlicesForOverlaps(dataLUNs);
            }
            catch (SamFSException ex) {
                SamUtil.processException((Exception)((Object)ex), this.getClass(), "handleSelectDataDeviceStep()", "Failed to check data LUNs for overlaps", this.serverName);
                this.wizardModel.setValue("Finish_result", "Failed");
                this.wizardModel.setValue("Detail_msgs", ex.getMessage());
                this.wizardModel.setValue("Detail_code", Integer.toString(ex.getSAMerrno()));
                return false;
            }
            if (overlapLUNs != null && overlapLUNs.length > 0) {
                StringBuffer badLUNs = new StringBuffer(SamUtil.getResourceString("FSWizard.error.overlapDataLUNs"));
                badLUNs.append("<br>");
                for (int i = 0; i < overlapLUNs.length; ++i) {
                    badLUNs.append(overlapLUNs[i]).append("<br>");
                }
                TraceUtil.trace2(badLUNs.toString());
                this.wizardModel.setValue("ERROR", "Yes");
                this.wizardModel.setValue("ERROR_MSGS", badLUNs.toString());
                this.wizardModel.setValue("ERROR_CODE", "1007");
                this.wizardModel.setValue("ERROR_DETAIL", "INLINE_ALERT");
                this.wizardModel.setValue("ERROR_SUMMARY", "FSWizard.error.deviceError");
                return false;
            }
        }
        StringBuffer deviceList = new StringBuffer();
        for (int i = 0; i < this.selectedDataDevicesList.size(); ++i) {
            deviceList.append((String)this.selectedDataDevicesList.get(i)).append("<br>");
        }
        this.wizardModel.setValue("DataField", deviceList.toString());
        return true;
    }

    private boolean processStripedGroupPage(WizardEvent wizardEvent) {
        ArrayList thisGroupDevices;
        int usedLuns;
        TraceUtil.trace3("Entered");
        TraceUtil.trace2("Entered processStripedGroupPage.., ");
        boolean exceed = false;
        FSWizardDeviceSelectionPageView view = (FSWizardDeviceSelectionPageView)wizardEvent.getView();
        CCActionTable dataTable = (CCActionTable)view.getChild("DeviceSelectionTable");
        try {
            dataTable.restoreStateData();
        }
        catch (ModelControlException ex) {
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "handleSelectDataDeviceStep()", "Failed in restoring statedata", this.serverName);
            TraceUtil.trace1("Exception while restoreStateData: " + ex.getMessage());
            this.wizardModel.setValue("ERROR", "Yes");
            this.wizardModel.setValue("ERROR_MSGS", ex.getMessage());
            this.wizardModel.setValue("ERROR_CODE", "8001234");
            return false;
        }
        CCActionTableModel dataModel = (CCActionTableModel)dataTable.getModel();
        Integer[] selectedRows = dataModel.getSelectedRows();
        int groupNum = (Integer)this.wizardModel.getValue("stripedGroupNumber");
        if (selectedRows.length < 1) {
            this.setWizardAlert(wizardEvent, "FSWizard.new.error.data");
            return false;
        }
        int metaLuns = this.selectedMetaDevicesList.size();
        int totalStripeLuns = 0;
        if (this.selectedStripedGroupDevicesList != null) {
            for (int j = 0; j < groupNum; ++j) {
                ArrayList groupDevices = (ArrayList)this.selectedStripedGroupDevicesList.get(j);
                totalStripeLuns += groupDevices.size();
            }
        }
        if ((usedLuns = metaLuns + totalStripeLuns + selectedRows.length) > 252) {
            exceed = true;
        }
        TraceUtil.trace2("Number of selected rows are : " + selectedRows.length);
        String deviceSelected = null;
        Object device = null;
        if (this.selectedStripedGroupDevicesList == null) {
            this.selectedStripedGroupDevicesList = new ArrayList();
        }
        if (this.selectedStripedGroupDevicesList.size() <= groupNum) {
            thisGroupDevices = new ArrayList();
            this.selectedStripedGroupDevicesList.add(groupNum, thisGroupDevices);
        } else {
            thisGroupDevices = (ArrayList)this.selectedStripedGroupDevicesList.get(groupNum);
        }
        thisGroupDevices.clear();
        long groupDeviceSize = -1L;
        boolean deviceError = false;
        for (int i = 0; i < selectedRows.length; ++i) {
            dataModel.setRowIndex(selectedRows[i].intValue());
            deviceSelected = (String)dataModel.getValue("HiddenDevicePath");
            DiskCache disk = this.getDiskCacheObject(deviceSelected);
            if (groupDeviceSize < 0L) {
                groupDeviceSize = disk.getCapacity();
            }
            if (groupDeviceSize != disk.getCapacity()) {
                deviceError = true;
            }
            thisGroupDevices.add(deviceSelected);
        }
        this.wizardModel.setValue("SelectedStripedGroupDevices", this.selectedStripedGroupDevicesList);
        if (exceed) {
            this.setWizardAlert(wizardEvent, "FSWizard.maxlun");
            return false;
        }
        if (deviceError) {
            this.wizardModel.setValue("ERROR", "Yes");
            this.wizardModel.setValue("ERROR_MSGS", "FSWizard.error.stripedGroup.deviceSizeError");
            this.wizardModel.setValue("ERROR_CODE", "1007");
            this.wizardModel.setValue("ERROR_DETAIL", "INLINE_ALERT");
            this.wizardModel.setValue("ERROR_SUMMARY", "FSWizard.error.deviceError");
            return false;
        }
        Collections.sort(thisGroupDevices);
        if (this.samfsServerAPIVersion.compareTo("1.1") >= 0) {
            int size = thisGroupDevices.size();
            String[] dataLUNs = new String[size];
            for (int i = 0; i < size; ++i) {
                dataLUNs[i] = (String)thisGroupDevices.get(i);
            }
            SamQFSSystemModel sysModel = null;
            String[] overlapLUNs = null;
            try {
                sysModel = SamUtil.getModel(this.serverName);
                if (sysModel == null) {
                    throw new SamFSException(null, -2001);
                }
                overlapLUNs = sysModel.getSamQFSSystemFSManager().checkSlicesForOverlaps(dataLUNs);
            }
            catch (SamFSException ex) {
                SamUtil.processException((Exception)((Object)ex), this.getClass(), "handleSelectStripedGroupStep()", "Failed to check striped group for overlaps", this.serverName);
                this.wizardModel.setValue("Finish_result", "Failed");
                this.wizardModel.setValue("Detail_msgs", ex.getMessage());
                this.wizardModel.setValue("Detail_code", Integer.toString(ex.getSAMerrno()));
                return false;
            }
            if (overlapLUNs != null && overlapLUNs.length > 0) {
                StringBuffer badLUNs = new StringBuffer(SamUtil.getResourceString("FSWizard.error.overlapDataLUNs"));
                badLUNs.append("<br>");
                for (int i = 0; i < overlapLUNs.length; ++i) {
                    badLUNs.append(overlapLUNs[i]).append("<br>");
                }
                TraceUtil.trace2(badLUNs.toString());
                this.wizardModel.setValue("ERROR", "Yes");
                this.wizardModel.setValue("ERROR_MSGS", badLUNs.toString());
                this.wizardModel.setValue("ERROR_CODE", "1007");
                this.wizardModel.setValue("ERROR_DETAIL", "INLINE_ALERT");
                this.wizardModel.setValue("ERROR_SUMMARY", "FSWizard.error.deviceError");
                return false;
            }
        }
        StringBuffer deviceList = new StringBuffer();
        for (int j = 0; j < this.selectedStripedGroupDevicesList.size(); ++j) {
            ArrayList groupDevices = (ArrayList)this.selectedStripedGroupDevicesList.get(j);
            deviceList.append(SamUtil.getResourceString("FSWizard.new.stripedGroup.deviceListing", new String[]{Integer.toString(j)})).append("<br>");
            for (int i = 0; i < groupDevices.size(); ++i) {
                deviceList.append("&nbsp;&nbsp;&nbsp;").append((String)groupDevices.get(i)).append("<br>");
            }
        }
        this.wizardModel.setValue("DataField", deviceList.toString());
        this.wizardModel.setValue("ERROR", "No");
        return true;
    }

    private boolean processMetaDataDevicesPage(WizardEvent wizardEvent) {
        TraceUtil.trace3("Entered");
        TraceUtil.trace2("Entered processMetaDataDevicesPage.., ");
        boolean result = true;
        boolean exceed = false;
        FSWizardDeviceSelectionPageView view = (FSWizardDeviceSelectionPageView)wizardEvent.getView();
        CCActionTable dataTable = (CCActionTable)view.getChild("DeviceSelectionTable");
        try {
            dataTable.restoreStateData();
        }
        catch (ModelControlException ex) {
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "processMetaDataDevicesPage()", "Failed in restoring statedata", this.serverName);
            TraceUtil.trace1("Exception while restoreStateData: " + ex.getMessage());
            this.wizardModel.setValue("ERROR", "Yes");
            this.wizardModel.setValue("ERROR_MSGS", ex.getMessage());
            this.wizardModel.setValue("ERROR_CODE", "8001234");
            return false;
        }
        CCActionTableModel dataModel = (CCActionTableModel)dataTable.getModel();
        Integer[] selectedRows = dataModel.getSelectedRows();
        TraceUtil.trace2("Number of selected rows are : " + selectedRows.length);
        if (selectedRows.length < 1) {
            this.setWizardAlert(wizardEvent, "FSWizard.new.error.metadata");
            return false;
        }
        if (selectedRows.length > 252) {
            exceed = true;
        }
        String deviceSelected = null;
        Object device = null;
        if (this.selectedMetaDevicesList == null) {
            this.selectedMetaDevicesList = new ArrayList();
        }
        this.selectedMetaDevicesList.clear();
        for (int i = 0; i < selectedRows.length; ++i) {
            dataModel.setRowIndex(selectedRows[i].intValue());
            deviceSelected = (String)dataModel.getValue("HiddenDevicePath");
            this.selectedMetaDevicesList.add(deviceSelected);
        }
        this.wizardModel.setValue("SelectedMetaDevices", this.selectedMetaDevicesList);
        if (exceed) {
            this.setWizardAlert(wizardEvent, "FSWizard.maxlun");
            return false;
        }
        Collections.sort(this.selectedMetaDevicesList);
        if (this.samfsServerAPIVersion.compareTo("1.1") >= 0) {
            int size = this.selectedMetaDevicesList.size();
            String[] dataLUNs = new String[size];
            for (int i = 0; i < size; ++i) {
                dataLUNs[i] = (String)this.selectedMetaDevicesList.get(i);
            }
            SamQFSSystemModel sysModel = null;
            String[] overlapLUNs = null;
            try {
                sysModel = SamUtil.getModel(this.serverName);
                if (sysModel == null) {
                    throw new SamFSException(null, -2001);
                }
                overlapLUNs = sysModel.getSamQFSSystemFSManager().checkSlicesForOverlaps(dataLUNs);
            }
            catch (SamFSException ex) {
                SamUtil.processException((Exception)((Object)ex), this.getClass(), "handleSelectMetaDataDeviceStep()", "Failed to check metadata LUNs for overlaps", this.serverName);
                this.wizardModel.setValue("Finish_result", "Failed");
                this.wizardModel.setValue("Detail_msgs", ex.getMessage());
                this.wizardModel.setValue("Detail_code", Integer.toString(ex.getSAMerrno()));
                return false;
            }
            if (overlapLUNs != null && overlapLUNs.length > 0) {
                StringBuffer badLUNs = new StringBuffer(SamUtil.getResourceString("FSWizard.error.overlapMetadataLUNs"));
                badLUNs.append("<br>");
                for (int i = 0; i < overlapLUNs.length; ++i) {
                    badLUNs.append(overlapLUNs[i]).append("<br>");
                }
                TraceUtil.trace2(badLUNs.toString());
                this.wizardModel.setValue("ERROR", "Yes");
                this.wizardModel.setValue("ERROR_MSGS", badLUNs.toString());
                this.wizardModel.setValue("ERROR_CODE", "1007");
                this.wizardModel.setValue("ERROR_DETAIL", "INLINE_ALERT");
                this.wizardModel.setValue("ERROR_SUMMARY", "FSWizard.error.deviceError");
                return false;
            }
        }
        StringBuffer deviceList = new StringBuffer();
        for (int i = 0; i < this.selectedMetaDevicesList.size(); ++i) {
            deviceList.append((String)this.selectedMetaDevicesList.get(i)).append("<br>");
        }
        this.wizardModel.setValue("MetadataField", deviceList.toString());
        return result;
    }

    private boolean processDAUPage(WizardEvent wizardEvent) {
        String oldFSType;
        String stripeValue;
        TraceUtil.trace2("Entered with fsType = " + this.fsType);
        String allocation = "";
        int numStripedGroups = 0;
        if (!this.fsType.equals(FSTYPE_FS) && !this.fsType.equals(FSTYPE_SHAREDFS)) {
            allocation = (String)this.wizardModel.getWizardValue("allocSelect");
            if (allocation == null || allocation.equals("")) {
                this.setWizardAlert(wizardEvent, "FSWizard.new.error.allocation");
                return false;
            }
            if (allocation.equals("FSWizard.new.qfs.singleAllocation")) {
                this.newDAUPage = true;
                if (this.sharedEnabled) {
                    this.pages = CreateFSWizardImplData.sharedqfsSingleDAUPages;
                    TraceUtil.trace3("page is single shared dau");
                } else {
                    this.pages = CreateFSWizardImpl.isHAFS(this.wizardModel) ? CreateFSWizardImplData.HAFSPages : CreateFSWizardImplData.qfsSingleDAUPages;
                }
            } else if (allocation.equals("FSWizard.new.qfs.dualAllocation.label")) {
                this.newDAUPage = false;
                if (this.sharedEnabled) {
                    this.pages = CreateFSWizardImplData.sharedqfsPages;
                    TraceUtil.trace3("page is dual shared dau");
                } else {
                    this.pages = CreateFSWizardImpl.isHAFS(this.wizardModel) ? CreateFSWizardImplData.HAFSPages : CreateFSWizardImplData.qfsDualDAUPages;
                }
            } else if (allocation.equals("FSWizard.new.qfs.stripedGroup")) {
                int i;
                this.newDAUPage = true;
                String numGroups = (String)this.wizardModel.getWizardValue("numOfStripedGroupTextField");
                if (numGroups != null) {
                    try {
                        numStripedGroups = Integer.parseInt(numGroups);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                if (numStripedGroups < 1 || numStripedGroups > 126) {
                    this.setWizardAlert(wizardEvent, "FSWizard.new.error.numStripedGroup");
                    return false;
                }
                int totalPages = 0;
                if (this.sharedEnabled) {
                    totalPages = 7 + numStripedGroups;
                    this.pages = new int[totalPages];
                    this.pages[0] = 0;
                    this.pages[1] = 1;
                    this.pages[2] = 6;
                    this.pages[3] = 2;
                    for (i = 0; i < numStripedGroups; ++i) {
                        this.pages[4 + i] = 3;
                    }
                    this.pages[numStripedGroups + 4] = 7;
                    this.pages[numStripedGroups + 5] = 10;
                    this.pages[numStripedGroups + 6] = 13;
                } else if (CreateFSWizardImpl.isHAFS(this.wizardModel)) {
                    totalPages = 7 + numStripedGroups;
                    this.pages = new int[totalPages];
                    this.pages[0] = 0;
                    this.pages[1] = 14;
                    this.pages[2] = 6;
                    this.pages[3] = 2;
                    for (i = 0; i < numStripedGroups; ++i) {
                        this.pages[4 + i] = 3;
                    }
                    this.pages[numStripedGroups + 4] = 7;
                    this.pages[numStripedGroups + 5] = 10;
                    this.pages[numStripedGroups + 6] = 13;
                } else {
                    totalPages = 6 + numStripedGroups;
                    this.pages = new int[totalPages];
                    this.pages[0] = 0;
                    this.pages[1] = 6;
                    this.pages[2] = 2;
                    for (i = 0; i < numStripedGroups; ++i) {
                        this.pages[3 + i] = 3;
                    }
                    this.pages[numStripedGroups + 3] = 7;
                    this.pages[numStripedGroups + 4] = 10;
                    this.pages[numStripedGroups + 5] = 13;
                }
            }
            this.initializeWizardPages(this.pages);
            this.wizardModel.setValue("qfsSelect", allocation);
        }
        TraceUtil.trace2("allocation = " + allocation);
        TraceUtil.trace2("archiveEnabled = " + this.archiveEnabled);
        TraceUtil.trace2("newDAUPage = " + this.newDAUPage);
        if (this.newDAUPage) {
            int dauSize;
            String dauString = ((String)this.wizardModel.getWizardValue("DAUSizeField")).trim();
            String dauUnit = (String)this.wizardModel.getWizardValue("DAUSizeDropDown");
            TraceUtil.trace2("Entered with dauSize = " + dauString + ", and dauUnit = " + dauUnit);
            if (dauString.length() <= 0) {
                this.setWizardAlert(wizardEvent, "FSWizard.new.error.dauSize");
                return false;
            }
            try {
                dauSize = Integer.parseInt(dauString);
            }
            catch (NumberFormatException nfe) {
                this.setWizardAlert(wizardEvent, "FSWizard.new.error.dauSize");
                return false;
            }
            if (dauUnit.equals("mb")) {
                dauSize *= 1024;
            }
            if (dauSize < 16 || dauSize > 65536 || dauSize % 8 != 0) {
                this.setWizardAlert(wizardEvent, "FSWizard.new.error.dauSize");
                return false;
            }
            this.wizardModel.setWizardContextValue("DAUDropDown", Integer.toString(dauSize));
            TraceUtil.trace2("Set dauSize = " + dauSize);
        }
        String string = stripeValue = (stripeValue = (String)this.wizardModel.getWizardValue("stripeValue")) != null ? stripeValue.trim() : "";
        if (stripeValue.length() > 0) {
            try {
                this.intStripe = Integer.parseInt(stripeValue);
            }
            catch (NumberFormatException e) {
                this.setWizardAlert(wizardEvent, "FSWizard.new.error.stripeValueRange");
                return false;
            }
            if (this.intStripe < 0 || this.intStripe > 255) {
                this.setWizardAlert(wizardEvent, "FSWizard.new.error.stripeValueRange");
                return false;
            }
        }
        if ((oldFSType = (String)this.wizardModel.getValue(this.OLD_FS_TYPE)) != null) {
            int oldNum;
            Integer oldNumGroups;
            if (!oldFSType.equals(this.fsType)) {
                this.wizardModel.setValue("SelectedMetaDevices", null);
                this.wizardModel.setValue("SelectedDataDevices", null);
                this.wizardModel.setValue("SelectedStripedGroupDevices", null);
                if (this.selectedStripedGroupDevicesList != null) {
                    this.selectedStripedGroupDevicesList.clear();
                }
            } else if (this.fsType.equals(FSTYPE_QFS) && allocation.equals("FSWizard.new.qfs.stripedGroup") && (oldNumGroups = (Integer)this.wizardModel.getValue(this.OLD_NUM_STRIPED_GROUPS)) != null && (oldNum = oldNumGroups.intValue()) > numStripedGroups && this.selectedStripedGroupDevicesList != null) {
                int oldSize;
                TraceUtil.trace2("Clearing out striped group devices");
                for (int i = oldSize = this.selectedStripedGroupDevicesList.size(); i > numStripedGroups; --i) {
                    this.selectedStripedGroupDevicesList.remove(i - 1);
                }
                this.wizardModel.setValue("SelectedStripedGroupDevices", this.selectedStripedGroupDevicesList);
            }
        }
        this.wizardModel.setValue(this.OLD_FS_TYPE, this.fsType);
        this.wizardModel.setValue(this.OLD_NUM_STRIPED_GROUPS, new Integer(numStripedGroups));
        return true;
    }

    private boolean processStdMountOptionsPage(WizardEvent wizardEvent) {
        String mountPoint = ((String)this.wizardModel.getWizardValue("mountValue")).trim();
        if (mountPoint == null || mountPoint.length() < 1) {
            this.setWizardAlert(wizardEvent, "FSWizard.new.error.mountpoint");
            return false;
        }
        if (!SamUtil.isValidNonSpecialCharString(mountPoint)) {
            this.setWizardAlert(wizardEvent, "FSWizard.new.error.invalidmountpoint");
            return false;
        }
        if (!mountPoint.startsWith("/")) {
            this.setWizardAlert(wizardEvent, "FSWizard.new.error.mountpoint.absolutePath");
            return false;
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    private boolean processMountOptionsPage(WizardEvent wizardEvent) {
        String mountPoint = ((String)this.wizardModel.getWizardValue("mountValue")).trim();
        if (mountPoint == null || mountPoint.length() < 1) {
            this.setWizardAlert(wizardEvent, "FSWizard.new.error.mountpoint");
            return false;
        }
        if (!SamUtil.isValidNonSpecialCharString(mountPoint)) {
            this.setWizardAlert(wizardEvent, "FSWizard.new.error.invalidmountpoint");
            return false;
        }
        if (!mountPoint.startsWith("/")) {
            this.setWizardAlert(wizardEvent, "FSWizard.new.error.mountpoint.absolutePath");
            return false;
        }
        if (!this.fsType.equals(FSTYPE_SHAREDQFS) && this.fsLicense != 1) {
            String hwmString = ((String)this.wizardModel.getWizardValue("hwmValue")).trim();
            String lwmString = ((String)this.wizardModel.getWizardValue("lwmValue")).trim();
            int defaultHWM = 80;
            int defaultLWM = 60;
            if (hwmString.length() <= 0 || lwmString.length() <= 0) {
                int intFSType = 1;
                if (!this.fsType.equals(FSTYPE_FS)) {
                    intFSType = 0;
                }
                int intArchType = 2;
                if (!this.archiveEnabled) {
                    intArchType = 3;
                }
                int intShareStatus = 0;
                int intDAU = Integer.parseInt((String)this.wizardModel.getValue("DAUDropDown"));
                SamQFSSystemModel sysModel = null;
                FileSystemMountProperties properties = null;
                try {
                    sysModel = SamUtil.getModel(this.serverName);
                    properties = sysModel.getSamQFSSystemFSManager().getDefaultMountProperties(intFSType, intArchType, intDAU, false, intShareStatus, false);
                    defaultHWM = properties.getHWM();
                    defaultLWM = properties.getLWM();
                }
                catch (SamFSException ex) {
                    SamUtil.processException((Exception)((Object)ex), this.getClass(), "processMountOptionsPage()", "Failed to get Default Mount Properties", this.serverName);
                    TraceUtil.trace1("Exception while processMountOptionsPage: " + ex.getMessage());
                    this.wizardModel.setValue("ERROR", "Yes");
                    this.wizardModel.setValue("ERROR_MSGS", ex.getMessage());
                    this.wizardModel.setValue("ERROR_CODE", "8001234");
                    return false;
                }
            }
            if (hwmString.length() > 0) {
                try {
                    this.intHWM = Integer.parseInt(hwmString);
                }
                catch (NumberFormatException e) {
                    this.setWizardAlert(wizardEvent, "FSWizard.new.error.hwmrange");
                    return false;
                }
                if (this.intHWM < 0 || this.intHWM > 100) {
                    this.setWizardAlert(wizardEvent, "FSWizard.new.error.hwmrange");
                    return false;
                }
            } else {
                this.intHWM = defaultHWM;
            }
            if (lwmString.length() > 0) {
                try {
                    this.intLWM = Integer.parseInt(lwmString);
                }
                catch (NumberFormatException e) {
                    this.setWizardAlert(wizardEvent, "FSWizard.new.error.lwmrange");
                    return false;
                }
                if (this.intLWM < 0 || this.intLWM > 100) {
                    this.setWizardAlert(wizardEvent, "FSWizard.new.error.lwmrange");
                    return false;
                }
            } else {
                this.intLWM = defaultLWM;
            }
            if (this.intLWM >= this.intHWM) {
                if (hwmString.length() > 0) {
                    this.setWizardAlert(wizardEvent, "FSWizard.new.error.hwmblwm");
                } else {
                    this.setWizardAlert(wizardEvent, "FSWizard.new.error.lwmbhwm");
                }
                return false;
            }
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    private boolean processSyntaxPage(WizardEvent wizardEvent) {
        TraceUtil.trace3("Entering");
        String syntax = (String)this.wizardModel.getValue("syntaxSelectRadioButton");
        if (syntax.equals("samqfsui.save")) {
            String path = ((String)this.wizardModel.getValue("locationTextField")).trim();
            if (path.length() < 1) {
                this.setWizardAlert(wizardEvent, "FSWizard.new.error.path");
                return false;
            }
            if (!SamUtil.isValidNonSpecialCharString(path) || !path.startsWith("/")) {
                this.setWizardAlert(wizardEvent, "FSWizard.new.error.invalidpath");
                return false;
            }
        } else {
            this.wizardModel.setValue("locationTextField", "");
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    private boolean processClusterNodes(WizardEvent event) {
        TraceUtil.trace3("Entering");
        Object[] values = this.wizardModel.getValues("clusterNode");
        System.out.println("-Selected VALUES-");
        for (int i = 0; values != null && i < values.length; ++i) {
            System.out.println(1 + i + ") -> " + values[i]);
            String val = values[i].toString();
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    private DiskCache[] getSelectedDeviceArray(ArrayList selectedDevicePaths) {
        if (selectedDevicePaths == null) {
            return new DiskCache[0];
        }
        int numDevices = selectedDevicePaths.size();
        DiskCache[] selectedDevices = this.sharedEnabled ? new SharedDiskCache[numDevices] : new DiskCache[numDevices];
        Iterator iter = selectedDevicePaths.iterator();
        int i = 0;
        while (iter.hasNext()) {
            selectedDevices[i] = this.getDiskCacheObject((String)iter.next());
            ++i;
        }
        return selectedDevices;
    }

    private DiskCache getDiskCacheObject(String devicePath) {
        for (int i = 0; i < this.allAllocatableDevices.length; ++i) {
            if (!this.allAllocatableDevices[i].getDevicePath().equals(devicePath)) continue;
            return this.allAllocatableDevices[i];
        }
        TraceUtil.trace1("Selection device does not exist in Current Devicelist");
        return null;
    }

    private StripedGroup[] getSelectedStripedGroupsArray(ArrayList groupList) throws SamFSException {
        if (groupList == null) {
            return new StripedGroup[0];
        }
        SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
        if (sysModel == null) {
            throw new SamFSException(null, -2001);
        }
        int numGroups = groupList.size();
        StripedGroup[] stripedGroups = new StripedGroup[numGroups];
        for (int i = 0; i < numGroups; ++i) {
            ArrayList groupDevices = (ArrayList)groupList.get(i);
            DiskCache[] disks = this.getSelectedDeviceArray(groupDevices);
            stripedGroups[i] = sysModel.getSamQFSSystemFSManager().createStripedGroup("", disks);
        }
        return stripedGroups;
    }

    private DiskCache[] getAllAllocatableUnits() throws SamFSException {
        TraceUtil.trace3("Entering");
        SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
        if (sysModel == null) {
            throw new SamFSException(null, -2501);
        }
        String[] nodeList = null;
        if (CreateFSWizardImpl.isHAFS(this.wizardModel)) {
            ArrayList<String> hosts = new ArrayList<String>();
            String currentServer = new StringTokenizer(this.serverName, ".").nextToken();
            hosts.add(currentServer);
            Object[] nodes = this.wizardModel.getValues("clusterNode");
            for (int i = 0; i < nodes.length; ++i) {
                String tempNodeName = nodes[i].toString().trim();
                if (tempNodeName.equals("") || tempNodeName.equals(currentServer)) continue;
                hosts.add(tempNodeName);
            }
            nodeList = new String[hosts.size()];
            nodeList = hosts.toArray(nodeList);
        }
        this.allAllocatableDevices = sysModel.getSamQFSSystemFSManager().discoverAvailableAllocatableUnits(nodeList);
        return this.allAllocatableDevices;
    }

    private SharedDiskCache[] getAllSharedAllocatableUnits() throws SamFSMultiHostException, SamFSException {
        TraceUtil.trace3("Entering");
        ArrayList clientHosts = (ArrayList)this.wizardModel.getValue("SelectedClient");
        ArrayList potentialHosts = (ArrayList)this.wizardModel.getValue("SelectedPotentialMetadataServerValue");
        String[] clients = clientHosts.toArray(new String[0]);
        String[] potentialServers = potentialHosts.toArray(new String[0]);
        String[] serverHosts = new String[potentialServers.length + 1];
        serverHosts[0] = this.serverName;
        for (int i = 1; i < potentialServers.length + 1; ++i) {
            serverHosts[i] = potentialServers[i - 1];
        }
        SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
        SamQFSSystemSharedFSManager fsManager = appModel.getSamQFSSystemSharedFSManager();
        this.allAllocatableDevices = fsManager.discoverAllocatableUnitsForShared(serverHosts, clients);
        TraceUtil.trace3("all device = " + this.allAllocatableDevices.toString());
        return (SharedDiskCache[])this.allAllocatableDevices;
    }

    private boolean populateDevicesInWizardModel() {
        DiskCache[] devices = (DiskCache[])this.wizardModel.getValue("AllAllocatableDevices");
        try {
            this.allAllocatableDevices = this.sharedEnabled ? this.getAllSharedAllocatableUnits() : this.getAllAllocatableUnits();
        }
        catch (SamFSMultiHostException e) {
            SamUtil.doPrint(new NonSyncStringBuffer().append("error code is ").append(e.getSAMerrno()).toString());
            String errMsg = SamUtil.handleMultiHostException(e);
            String err = "failed to populate shared device \n" + errMsg;
            this.wizardModel.setValue("ERROR", "Yes");
            this.wizardModel.setValue("ERROR_MSGS", errMsg);
            this.wizardModel.setValue("ERROR_CODE", Integer.toString(e.getSAMerrno()));
            return false;
        }
        catch (SamFSException ex) {
            TraceUtil.trace1("Exception getting AllocatableUnits" + ex.getMessage(), ex);
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "populateDevicesInWizardModel()", "Failed to populate device table", this.serverName);
            this.wizardModel.setValue("ERROR", "Yes");
            this.wizardModel.setValue("ERROR_MSGS", ex.getMessage());
            this.wizardModel.setValue("ERROR_CODE", Integer.toString(ex.getSAMerrno()));
            return false;
        }
        this.wizardModel.setValue("AllAllocatableDevices", this.allAllocatableDevices);
        return true;
    }

    private String getServerAPIVersion() {
        ServerInfo serverInfo;
        String samfsServerAPIVersion = null;
        HttpSession session = RequestManager.getRequestContext().getRequest().getSession();
        Hashtable serverTable = (Hashtable)session.getAttribute("SAMFS_SERVER_INFO");
        if (serverTable != null && (serverInfo = (ServerInfo)serverTable.get(this.serverName)) != null) {
            samfsServerAPIVersion = serverInfo.getSamfsServerAPIVersion();
        }
        return samfsServerAPIVersion;
    }

    private boolean isFileSystemExists(String fsName) {
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
            if (sysModel == null) {
                throw new SamFSException(null, -2001);
            }
            String[] fsNames = sysModel.getSamQFSSystemFSManager().getAllFileSystemNames();
            for (int i = 0; i < fsNames.length; ++i) {
                if (!fsNames[i].equals(fsName)) continue;
                return true;
            }
            String serverVersion = this.getServerAPIVersion();
            if (serverVersion != null && serverVersion.compareTo("1.2") >= 0) {
                fsNames = sysModel.getSamQFSSystemFSManager().getFileSystemNamesAllTypes();
                for (int i = 0; i < fsNames.length; ++i) {
                    if (!fsNames[i].equals(fsName)) continue;
                    return true;
                }
            }
        }
        catch (SamFSException ex) {
            TraceUtil.trace1("Exception in checking if isFileSystemExists()" + ex.getMessage());
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "populateDevicesInWizardModel()", "Failed to populate device table", this.serverName);
            this.wizardModel.setValue("ERROR", "Yes");
            this.wizardModel.setValue("ERROR_MSGS", ex.getMessage());
            this.wizardModel.setValue("ERROR_CODE", Integer.toString(ex.getSAMerrno()));
        }
        return false;
    }

    private void setWizardAlert(WizardEvent wizardEvent, String message) {
        wizardEvent.setSeverity(0);
        wizardEvent.setErrorMessage(message);
    }

    private void processMultiStepException(SamFSMultiStepOpException msex) {
        String fsTypeVal = (String)this.wizardModel.getWizardValue("qfsTypeSelect");
        String fsName = "";
        if (fsTypeVal != null && !fsTypeVal.equals("FSWizard.new.fstype.ufs")) {
            fsName = ((String)this.wizardModel.getWizardValue("fsNameValue")).trim();
        }
        String processExMessage = null;
        String summaryMessage = null;
        int samerrno = msex.getSAMerrno();
        this.wizardModel.setValue("Finish_result", "Failed");
        this.wizardModel.setValue("Detail_code", Integer.toString(samerrno));
        this.wizardModel.setValue("WizardResultAlertDetail", msex.getMessage());
        int failedStep = msex.getFailedStep();
        switch (failedStep) {
            case 2: {
                summaryMessage = "FSWizard.new.error.createMountFailed";
                break;
            }
            case 3: {
                summaryMessage = "FSWizard.new.error.archivingInfoError";
                break;
            }
            case 4: {
                summaryMessage = "FSWizard.new.error.archiverFileError";
                break;
            }
            case 5: {
                summaryMessage = "FSWizard.new.error.mountFailed";
                break;
            }
            case 6: {
                summaryMessage = "FSWizard.new.error.archiverFileWarning";
                this.wizardModel.setValue("Finish_result", "Warning");
                break;
            }
            default: {
                summaryMessage = "FSWizard.new.error.summary";
            }
        }
        this.wizardModel.setValue("WizardResultAlertSummary", summaryMessage);
        processExMessage = "Failed to create FS - " + fsName + ": " + msex.getMessage();
        SamUtil.processException((Exception)((Object)msex), this.getClass(), "finishStep()", processExMessage, this.serverName);
    }

    private boolean createUFS() {
        String mountAfterCreate;
        String mountAtBoot;
        String noSetUID;
        boolean boolReadOnly = false;
        boolean boolCreateMountPoint = true;
        boolean boolMountAfterCreate = false;
        boolean boolMountAtBoot = false;
        boolean boolNoSetUID = false;
        DiskCache[] dataDevices = this.getSelectedDeviceArray(this.selectedDataDevicesList);
        for (int j = 0; j < dataDevices.length; ++j) {
            TraceUtil.trace3("Chosen device " + dataDevices[j]);
        }
        String mountPoint = ((String)this.wizardModel.getWizardValue("mountValue")).trim();
        TraceUtil.trace3("Mount point = " + mountPoint);
        String readOnly = (String)this.wizardModel.getValue("readOnlyCheckBox");
        if (readOnly != null && readOnly.equals("samqfsui.yes")) {
            boolReadOnly = true;
        }
        if ((noSetUID = (String)this.wizardModel.getValue("noSetUIDCheckBox")) != null && noSetUID.equals("samqfsui.yes")) {
            boolNoSetUID = true;
        }
        if ((mountAtBoot = (String)this.wizardModel.getValue("bootTimeCheckBox")) != null && mountAtBoot.equals("samqfsui.yes")) {
            boolMountAtBoot = true;
        }
        if ((mountAfterCreate = (String)this.wizardModel.getValue("mountAfterCreateCheckBox")) != null && mountAfterCreate.equals("samqfsui.yes")) {
            boolMountAfterCreate = true;
        }
        GenericMountOptionsImpl mountOpts = new GenericMountOptionsImpl(boolReadOnly, boolNoSetUID);
        TraceUtil.trace3("Set mount options");
        SamQFSSystemModel sysModel = null;
        try {
            sysModel = SamUtil.getModel(this.serverName);
            TraceUtil.trace3("Creating UFS with device " + dataDevices[0]);
            GenericFileSystem ufs = sysModel.getSamQFSSystemFSManager().createUFS(dataDevices[0], mountPoint, mountOpts, boolMountAtBoot, boolCreateMountPoint, boolMountAfterCreate);
            LogUtil.info(this.getClass(), "finishStep", "Done creating new FS " + mountPoint);
            this.wizardModel.setValue("Finish_result", "successful");
            this.wizardModel.setValue("WizardResultAlertSummary", "success.summary");
            this.wizardModel.setValue("WizardResultAlertDetail", SamUtil.getResourceString("FSSummary.createfs", mountPoint));
            TraceUtil.trace2("Succesfully created FS with name: " + mountPoint);
            return true;
        }
        catch (SamFSMultiStepOpException msex) {
            if (sysModel != null) {
                sysModel.clearContext();
            }
            this.processMultiStepException(msex);
            return true;
        }
        catch (SamFSTimeoutException toex) {
            TraceUtil.trace2("processing samfs time out exception...");
            this.wizardModel.setValue("Finish_result", "Warning");
            this.wizardModel.setValue("WizardResultAlertSummary", "FSWizard.new.warning.summary");
            this.wizardModel.setValue("WizardResultAlertDetail", SamUtil.getResourceStringError("-2801"));
            this.wizardModel.setValue("Detail_code", Integer.toString(toex.getSAMerrno()));
            String processExMessage = "Timed out when creating " + mountPoint + ": " + toex.getMessage();
            SamUtil.processException((Exception)((Object)toex), this.getClass(), "finishStep()", processExMessage, this.serverName);
            return true;
        }
        catch (SamFSException ex) {
            if (sysModel != null) {
                sysModel.clearContext();
            }
            boolean multiMsgOccurred = false;
            boolean warningOccurred = false;
            String processMsg = null;
            processMsg = "Failed to create FS " + mountPoint;
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "finishStep()", processMsg, this.serverName);
            int errCode = ex.getSAMerrno();
            this.wizardModel.setValue("Finish_result", "Failed");
            this.wizardModel.setValue("WizardResultAlertSummary", "FSWizard.new.error.summary");
            this.wizardModel.setValue("WizardResultAlertDetail", ex.getMessage());
            this.wizardModel.setValue("Detail_code", Integer.toString(errCode));
            return true;
        }
        catch (Exception e) {
            System.out.println("caught unexpected exception");
            e.printStackTrace();
            e.printStackTrace(System.out);
            return true;
        }
    }

    public static final boolean isHAFS(SamWizardModel model) {
        String temp = (String)model.getValue(FSTYPE_HAFS);
        if (temp == null) {
            return false;
        }
        return temp.equals("true");
    }

    private void printPages(String currentPage) {
        System.out.println("current Page = " + this.getPageClass(currentPage).getName());
        System.out.println("--Future pages--");
        for (int i = 0; i < this.pages.length; ++i) {
            System.out.println(1 + i + " -> " + CreateFSWizardImplData.pageClass[this.pages[i]].getName());
        }
    }

    private void printNodeList(String[] nodeList) {
        System.out.println("--Selected Nodes---");
        for (int i = 0; i < nodeList.length; ++i) {
            System.out.println(1 + i + nodeList[i]);
        }
    }
}

