/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.BasicCommandField;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiHostException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiMsgException;
import com.sun.netstorage.samqfs.mgmt.SamFSWarnings;
import com.sun.netstorage.samqfs.web.fs.SharedFSDetailsData;
import com.sun.netstorage.samqfs.web.fs.SharedFSDetailsModel;
import com.sun.netstorage.samqfs.web.fs.SharedFSDetailsTiledView;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemSharedFSManager;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.util.Authorization;
import com.sun.netstorage.samqfs.web.util.BreadCrumbUtil;
import com.sun.netstorage.samqfs.web.util.CommonTableContainerView;
import com.sun.netstorage.samqfs.web.util.CommonViewBeanBase;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.PageInfo;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.SecurityManagerFactory;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCWizardWindowModel;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCHref;
import com.sun.web.ui.view.html.CCRadioButton;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.servlet.ServletException;

public class SharedFSDetailsView
extends CommonTableContainerView {
    public static final String CHILD_ACTIONMENU_HREF = "ActionMenuHref";
    private String selectedFS = null;
    private SharedFSDetailsModel model = null;
    public String partialErrMsg = null;
    public String sharedMDServer = null;
    private static ArrayList updatedModelIndex = new ArrayList();
    public static final String CHILD_CANCEL_HREF = "CancelHref";
    public static final String CHILD_HIDDEN_FIELD3 = "GrowHiddenField";
    public static final String CHILD_TILED_VIEW = "SharedFSDetailsTiledView";
    public static final String CHILD_NEWFRWD_TO_CMDCHILD = "newforwardToVb";
    public static final String CHILD_ARFRWD_TO_CMDCHILD = "archiveforwardToVb";
    public static final String CHILD_FRWD_TO_CMDCHILD = "forwardToVb";
    private boolean wizardNewLaunched = false;
    private CCWizardWindowModel newWizWinModel;
    private CCWizardWindowModel growWizWinModel;
    private CCWizardWindowModel archiveWizWinModel;
    public static final String ALL_MOUNT_HIDDEN_FIELD = "HiddenAllMount";
    public static final String ALL_CLIENT_MOUNT_HIDDEN_FIELD = "HiddenAllClientMount";
    public static final String MDS_MOUNTED = "MDSMounted";
    public static final String HOST_NAME_HIDDEN_FIELD = "HiddenHostName";
    public static final String FS_NAME_HIDDEN_FIELD = "HiddenFsName";
    private String fsName = null;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHref;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHiddenField;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$SharedFSDetailsTiledView;
    static /* synthetic */ Class class$com$iplanet$jato$view$BasicCommandField;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$SharedFSDetailsViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$FSMountViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$FSDevicesViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$AdvancedNetworkConfigViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean;

    public SharedFSDetailsView(View parent, String name) {
        super(parent, name);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.CHILD_ACTION_TABLE = "SharedFSDetailsTable";
        this.fsName = (String)this.getParentViewBean().getPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME");
        if (this.fsName == null) {
            this.fsName = (String)this.getParentViewBean().getPageSessionAttribute("SAMQFS_POLICY_NAME");
        }
        this.model = new SharedFSDetailsModel(this.getServerName(), this.fsName);
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    public void registerChildren() {
        TraceUtil.trace3("Entering");
        this.registerChild(CHILD_ACTIONMENU_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = SharedFSDetailsView.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        this.registerChild(CHILD_CANCEL_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = SharedFSDetailsView.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        this.registerChild(ALL_MOUNT_HIDDEN_FIELD, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = SharedFSDetailsView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(ALL_CLIENT_MOUNT_HIDDEN_FIELD, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = SharedFSDetailsView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(MDS_MOUNTED, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = SharedFSDetailsView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(HOST_NAME_HIDDEN_FIELD, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = SharedFSDetailsView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(FS_NAME_HIDDEN_FIELD, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = SharedFSDetailsView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_HIDDEN_FIELD3, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = SharedFSDetailsView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_TILED_VIEW, class$com$sun$netstorage$samqfs$web$fs$SharedFSDetailsTiledView == null ? (class$com$sun$netstorage$samqfs$web$fs$SharedFSDetailsTiledView = SharedFSDetailsView.class$("com.sun.netstorage.samqfs.web.fs.SharedFSDetailsTiledView")) : class$com$sun$netstorage$samqfs$web$fs$SharedFSDetailsTiledView);
        this.registerChild(CHILD_FRWD_TO_CMDCHILD, class$com$iplanet$jato$view$BasicCommandField == null ? (class$com$iplanet$jato$view$BasicCommandField = SharedFSDetailsView.class$("com.iplanet.jato.view.BasicCommandField")) : class$com$iplanet$jato$view$BasicCommandField);
        this.registerChild(CHILD_NEWFRWD_TO_CMDCHILD, class$com$iplanet$jato$view$BasicCommandField == null ? (class$com$iplanet$jato$view$BasicCommandField = SharedFSDetailsView.class$("com.iplanet.jato.view.BasicCommandField")) : class$com$iplanet$jato$view$BasicCommandField);
        this.registerChild(CHILD_ARFRWD_TO_CMDCHILD, class$com$iplanet$jato$view$BasicCommandField == null ? (class$com$iplanet$jato$view$BasicCommandField = SharedFSDetailsView.class$("com.iplanet.jato.view.BasicCommandField")) : class$com$iplanet$jato$view$BasicCommandField);
        super.registerChildren(this.model);
        TraceUtil.trace3("Exiting");
    }

    public View createChild(String name) {
        TraceUtil.trace3("Entering");
        if (name.equals(CHILD_ACTIONMENU_HREF) || name.equals(CHILD_CANCEL_HREF)) {
            TraceUtil.trace3("Exiting");
            return new CCHref((ContainerView)this, name, null);
        }
        if (name.equals(CHILD_HIDDEN_FIELD3) || name.equals(ALL_MOUNT_HIDDEN_FIELD) || name.equals(ALL_CLIENT_MOUNT_HIDDEN_FIELD) || name.equals(MDS_MOUNTED) || name.equals(HOST_NAME_HIDDEN_FIELD) || name.equals(FS_NAME_HIDDEN_FIELD)) {
            TraceUtil.trace3("Exiting");
            return new CCHiddenField((ContainerView)this, name, null);
        }
        if (name.equals(CHILD_TILED_VIEW)) {
            SharedFSDetailsTiledView child = new SharedFSDetailsTiledView((View)this, this.model, name);
            TraceUtil.trace3("Exiting");
            return child;
        }
        if (name.equals(CHILD_FRWD_TO_CMDCHILD) || name.equals(CHILD_NEWFRWD_TO_CMDCHILD) || name.equals(CHILD_ARFRWD_TO_CMDCHILD)) {
            BasicCommandField bcf = new BasicCommandField((View)this, name);
            TraceUtil.trace3("Exiting");
            return bcf;
        }
        TraceUtil.trace3("Exiting");
        return super.createChild(this.model, name, CHILD_TILED_VIEW);
    }

    public void handleActionMenuHrefRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        String op = null;
        Class target = class$com$sun$netstorage$samqfs$web$fs$SharedFSDetailsViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$SharedFSDetailsViewBean = SharedFSDetailsView.class$("com.sun.netstorage.samqfs.web.fs.SharedFSDetailsViewBean")) : class$com$sun$netstorage$samqfs$web$fs$SharedFSDetailsViewBean;
        int index = -1;
        String value = (String)this.getDisplayFieldValue("ActionMenu");
        try {
            index = this.getSelectedRowIndex();
        }
        catch (ModelControlException ex) {
            SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "getSelectedRowIndex()", "Exception occurred within framework", this.getServerName());
            throw ex;
        }
        int option = 0;
        try {
            option = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        String clientHost = this.getSelectedValue(index);
        String clientHostType = this.getSelectedFSType(index);
        if (option != 0) {
            try {
                SamQFSSystemModel model = SamUtil.getModel(clientHost);
                FileSystem fileSystem = model.getSamQFSSystemFSManager().getFileSystem(this.fsName);
                if (fileSystem == null) {
                    throw new SamFSException(null, -1000);
                }
                switch (option) {
                    case 1: {
                        ViewBean targetView = this.getMountViewBean(fileSystem, clientHost, clientHostType);
                        ViewBean vb = this.getParentViewBean();
                        BreadCrumbUtil.breadCrumbPathForward(vb, PageInfo.getPageInfo().getPageNumber(vb.getName()));
                        ((CommonViewBeanBase)vb).forwardTo(targetView);
                        return;
                    }
                    case 2: {
                        op = "FSDetails.mountfs";
                        LogUtil.info(((Object)((Object)this)).getClass(), "handleActionMenuHrefRequest", "Start mounting filesystem " + this.fsName);
                        fileSystem.mount();
                        if (fileSystem.getState() == 1) {
                            throw new SamFSException("SharedFSDetails.warning.mount.cause", -1099);
                        }
                        LogUtil.info(((Object)((Object)this)).getClass(), "handleActionMenuHrefRequest", "Done mounting filesystem " + this.fsName);
                        break;
                    }
                    case 3: {
                        TraceUtil.trace3("Entering umount");
                        op = "FSDetails.umountfs";
                        LogUtil.info(((Object)((Object)this)).getClass(), "handleActionMenuHrefRequest", "Start unmounting filesystem " + this.fsName);
                        fileSystem.unmount();
                        TraceUtil.trace3("exiting umount");
                        LogUtil.info(((Object)((Object)this)).getClass(), "handleActionMenuHrefRequest", "Done unmounting filesystem " + this.fsName);
                        break;
                    }
                    default: {
                        throw new SamFSException(null, -1000);
                    }
                }
                this.showAlert(op, this.fsName);
                target = class$com$sun$netstorage$samqfs$web$fs$SharedFSDetailsViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$SharedFSDetailsViewBean = SharedFSDetailsView.class$("com.sun.netstorage.samqfs.web.fs.SharedFSDetailsViewBean")) : class$com$sun$netstorage$samqfs$web$fs$SharedFSDetailsViewBean;
            }
            catch (SamFSException smfex) {
                String processMsg = null;
                String errCause = null;
                String summary = null;
                boolean warning = false;
                if (smfex instanceof SamFSMultiMsgException) {
                    processMsg = "Error in archiver configuration";
                    summary = "ArchiveConfig.error";
                    errCause = "ArchiveConfig.error.detail";
                } else if (smfex instanceof SamFSWarnings) {
                    warning = true;
                    processMsg = "Warning in archiver configuration";
                    summary = "ArchiveConfig.error";
                    errCause = "ArchiveConfig.warning.detail";
                } else {
                    switch (option) {
                        case 1: {
                            summary = "SharedFSDetails.error.mountoption";
                            processMsg = "Failed to run edit mount options";
                            break;
                        }
                        case 2: {
                            summary = "SharedFSDetails.error.mount";
                            processMsg = "Failed to mount filesystem";
                            break;
                        }
                        case 3: {
                            summary = "SharedFSDetails.error.umount";
                            processMsg = "Failed to unmount filesystem";
                            break;
                        }
                    }
                    errCause = smfex.getMessage();
                }
                SamUtil.processException((Exception)((Object)smfex), ((Object)((Object)this)).getClass(), "handleActionMenuHrefRequest()", processMsg, clientHost);
                if (!warning) {
                    SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", summary, smfex.getSAMerrno(), errCause, clientHost);
                } else {
                    SamUtil.setWarningAlert((ContainerView)this.getParentViewBean(), "Alert", summary, errCause);
                }
                target = class$com$sun$netstorage$samqfs$web$fs$SharedFSDetailsViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$SharedFSDetailsViewBean = SharedFSDetailsView.class$("com.sun.netstorage.samqfs.web.fs.SharedFSDetailsViewBean")) : class$com$sun$netstorage$samqfs$web$fs$SharedFSDetailsViewBean;
            }
        } else if (option == 6) {
            // empty if block
        }
        ViewBean targetView = this.getViewBean(target);
        targetView.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    private ViewBean getMountViewBean(FileSystem fs2, String clientHost, String clientHostType) throws SamFSException {
        ViewBean targetView = null;
        if (fs2 == null) {
            throw new SamFSException(null, -1000);
        }
        int fsType = fs2.getFSTypeByProduct();
        int shareStatus = fs2.getShareStatus();
        String mountPageType = null;
        block0 : switch (fs2.getShareStatus()) {
            case 0: {
                switch (fsType) {
                    case 12: {
                        mountPageType = "UnsharedSAMQFS";
                        break block0;
                    }
                    case 11: {
                        mountPageType = "UnsharedQFS";
                        break block0;
                    }
                }
                mountPageType = "UnsharedSAMFS";
                break;
            }
            case 1: 
            case 2: {
                mountPageType = fsType == 12 ? "SharedSAMQFS" : "SharedQFS";
                break;
            }
            default: {
                mountPageType = fsType == 12 ? "SharedSAMQFS" : "SharedQFS";
            }
        }
        targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$fs$FSMountViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$FSMountViewBean = SharedFSDetailsView.class$("com.sun.netstorage.samqfs.web.fs.FSMountViewBean")) : class$com$sun$netstorage$samqfs$web$fs$FSMountViewBean);
        targetView.setPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME", (Serializable)((Object)fs2.getName()));
        targetView.setPageSessionAttribute("SHARED_METADATA_SERVER", (Serializable)((Object)this.getServerName()));
        targetView.setPageSessionAttribute("SHARED_METADATA_CLIENT", (Serializable)((Object)clientHost));
        targetView.setPageSessionAttribute("SAMQFS_SHARED_CLIENT_HOST", (Serializable)((Object)clientHostType));
        targetView.setPageSessionAttribute("SAMQFS_MOUNT_PAGE_TYPE", (Serializable)((Object)mountPageType));
        targetView.setPageSessionAttribute("SERVER_NAME", (Serializable)((Object)this.getServerName()));
        return targetView;
    }

    public void handleDeleteButtonRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        String mdServer;
        int sharedType;
        String selected;
        boolean errorFlag;
        block17: {
            String fs2;
            block16: {
                TraceUtil.trace3("Entering");
                int index = -1;
                errorFlag = false;
                try {
                    index = this.getSelectedRowIndex();
                }
                catch (ModelControlException ex) {
                    SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "getSelectedRowIndex()", "Exception occurred within framework", this.getServerName());
                    throw ex;
                }
                selected = this.getSelectedValue(index);
                fs2 = this.fsName;
                sharedType = 0;
                mdServer = null;
                try {
                    mdServer = (String)this.getParentViewBean().getPageSessionAttribute("SHARED_MD_SERVER");
                    TraceUtil.trace3("md_server =" + mdServer);
                    TraceUtil.trace3("delete_host =" + selected);
                    SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
                    SamQFSSystemSharedFSManager fsManager = appModel.getSamQFSSystemSharedFSManager();
                    sharedType = fsManager.getSharedFSType(selected, this.fsName);
                    fsManager.deleteSharedFileSystem(selected, fs2, mdServer);
                }
                catch (SamFSMultiHostException e) {
                    SamUtil.doPrint(new NonSyncStringBuffer().append("error code is ").append(e.getSAMerrno()).toString());
                    String err_msg = SamUtil.handleMultiHostException(e);
                    SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "SharedFSDetailsViewBean.error.delete", e.getSAMerrno(), err_msg, mdServer);
                    errorFlag = true;
                }
                catch (SamFSException ex) {
                    SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "handleDeleteButtonRequest", "Failed to remove shared filesystem", selected);
                    if (ex.getSAMerrno() == 30132) break block16;
                    SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "SharedFSDetails.error.delete", ex.getSAMerrno(), ex.getMessage(), mdServer);
                    errorFlag = true;
                }
            }
            try {
                SamQFSSystemModel sysModel = SamUtil.getModel(selected);
                FileSystem fileSystem = sysModel.getSamQFSSystemFSManager().getFileSystem(fs2);
                if (fileSystem != null) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException intEx) {
                        TraceUtil.trace3("InterruptedException Caught: Reason: " + intEx.getMessage());
                    }
                }
            }
            catch (SamFSException ex) {
                if (ex.getSAMerrno() == 30132) break block17;
                SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "SharedFSDetails.error.delete", ex.getSAMerrno(), ex.getMessage(), selected);
            }
        }
        if (!errorFlag) {
            this.setSuccessAlert("SharedFSDetails.action.delete", selected);
        }
        String uname = null;
        try {
            SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
            uname = appModel.getSamQFSSystemModel(this.getServerName()).getServerHostname();
        }
        catch (Exception e) {
            uname = this.getServerName();
        }
        if (sharedType == 1) {
            TraceUtil.trace3("potential type");
        }
        TraceUtil.trace3(" md server " + mdServer);
        TraceUtil.trace3(" selected " + selected);
        TraceUtil.trace3(" hostname " + this.getServerName());
        int index1 = this.getServerName().indexOf(".");
        String cmpHost = null;
        cmpHost = index1 == -1 ? this.getServerName() : this.getServerName().substring(0, index1);
        TraceUtil.trace3("cmp hostname " + cmpHost);
        if ((mdServer.equals(selected) || cmpHost.equalsIgnoreCase(selected) && sharedType == 1) && !errorFlag) {
            this.forwardToTargetPage(true);
        } else {
            this.getParentViewBean().forwardTo(this.getRequestContext());
        }
        TraceUtil.trace3("Existing");
    }

    public void handleViewDeviceButtonRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        ViewBean targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$fs$FSDevicesViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$FSDevicesViewBean = SharedFSDetailsView.class$("com.sun.netstorage.samqfs.web.fs.FSDevicesViewBean")) : class$com$sun$netstorage$samqfs$web$fs$FSDevicesViewBean);
        ViewBean vb = this.getParentViewBean();
        BreadCrumbUtil.breadCrumbPathForward(vb, PageInfo.getPageInfo().getPageNumber(vb.getName()));
        ((CommonViewBeanBase)vb).forwardTo(targetView);
        TraceUtil.trace3("Exiting");
    }

    public void handleAdvancedButtonRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        ViewBean targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$fs$AdvancedNetworkConfigViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$AdvancedNetworkConfigViewBean = SharedFSDetailsView.class$("com.sun.netstorage.samqfs.web.fs.AdvancedNetworkConfigViewBean")) : class$com$sun$netstorage$samqfs$web$fs$AdvancedNetworkConfigViewBean);
        ViewBean vb = this.getParentViewBean();
        BreadCrumbUtil.breadCrumbPathForward(vb, PageInfo.getPageInfo().getPageNumber(vb.getName()));
        ((CommonViewBeanBase)vb).forwardTo(targetView);
        TraceUtil.trace3("Exiting");
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        block13: {
            TraceUtil.trace3("Entering");
            CCDropDownMenu actionDropDown = (CCDropDownMenu)this.getChild("ActionMenu");
            actionDropDown.setValue((Object)"0");
            this.model.setTitle(SamUtil.getResourceString("SharedFSDetails.pageTitle1", this.fsName));
            this.model.setRowSelected(false);
            ((CCButton)this.getChild("DeleteButton")).setDisabled(true);
            if (SecurityManagerFactory.getSecurityManager().hasAuthorization(Authorization.FILESYSTEM_OPERATOR)) {
                ((CCButton)this.getChild("AddButton")).setDisabled(false);
                actionDropDown.setDisabled(false);
                try {
                    String samfsServerAPIVersion = SamUtil.getServerInfo(this.getServerName()).getSamfsServerAPIVersion();
                    if (SamUtil.isVersionCurrentOrLaterThan(samfsServerAPIVersion, "1.4")) {
                        ((CCButton)this.getChild("AdvancedButton")).setDisabled(false);
                        break block13;
                    }
                    ((CCButton)this.getChild("AdvancedButton")).setTitleDisabled("SharedFSDetails.button.advancedConfig.tooltip.disable");
                }
                catch (SamFSException samEx) {
                    TraceUtil.trace1("Exception caught while retrieving server name");
                }
            } else {
                this.model.setSelectionType("none");
            }
        }
        try {
            SharedFSDetailsData recordModel = new SharedFSDetailsData(this.getServerName(), this.fsName);
            boolean allMounted = true;
            boolean allClientNotMounted = true;
            boolean allClientMounted = true;
            boolean mdMounted = false;
            for (int i = 0; i < recordModel.size(); ++i) {
                Object[] record = (Object[])recordModel.get(i);
                boolean isMounted = (Boolean)record[2];
                int type = (Integer)record[1];
                if (isMounted) {
                    allMounted = false;
                }
                if (isMounted && type != 0) {
                    allClientNotMounted = false;
                }
                if (!isMounted && type != 0) {
                    allClientMounted = false;
                }
                if (!isMounted || type != 0) continue;
                mdMounted = true;
            }
            CCHiddenField hostNameHiddenField = (CCHiddenField)this.getChild(HOST_NAME_HIDDEN_FIELD);
            hostNameHiddenField.setValue((Object)this.getServerName());
            CCHiddenField fsNameHiddenField = (CCHiddenField)this.getChild(FS_NAME_HIDDEN_FIELD);
            fsNameHiddenField.setValue((Object)this.fsName);
            ((CCHiddenField)this.getChild(ALL_MOUNT_HIDDEN_FIELD)).setValue((Object)Boolean.toString(allMounted));
            CCHiddenField allClientMountHiddenField = (CCHiddenField)this.getChild(ALL_CLIENT_MOUNT_HIDDEN_FIELD);
            if (allClientNotMounted) {
                allClientMountHiddenField.setValue((Object)"allClientUnMounted");
            } else {
                allClientMountHiddenField.setValue((Object)"notAllClientUnMounted");
            }
            ((CCHiddenField)this.getChild(MDS_MOUNTED)).setValue((Object)Boolean.toString(mdMounted));
        }
        catch (SamFSException smfex) {
            SamUtil.processException((Exception)((Object)smfex), ((Object)((Object)this)).getClass(), "beginDisplay()", "Unable to populate shared file system details.", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "FSSummary.error.failedPopulate", smfex.getSAMerrno(), smfex.getMessage(), this.getServerName());
        }
        CCActionTable myTable = (CCActionTable)this.getChild(this.CHILD_ACTION_TABLE);
        CCRadioButton myRadio = (CCRadioButton)myTable.getChild("SelectionRadiobutton");
        myRadio.setTitle("");
        myRadio.setTitleDisabled("");
        TraceUtil.trace3("Exiting");
    }

    private void showAlert(String operation, String key) {
        TraceUtil.trace3("Entering");
        SamUtil.setInfoAlert((ContainerView)this.getParentViewBean(), "Alert", "success.summary", SamUtil.getResourceString(operation, key), this.getServerName());
        TraceUtil.trace3("Exiting");
    }

    private FileSystem getFileSystem(String fsName) throws SamFSException {
        return SamUtil.getModel(this.getServerName()).getSamQFSSystemFSManager().getFileSystem(fsName);
    }

    private int getSelectedRowIndex() throws ModelControlException {
        TraceUtil.trace3("Entering");
        int index = -1;
        CCActionTable child = (CCActionTable)this.getChild("SharedFSDetailsTable");
        child.restoreStateData();
        this.model.beforeFirst();
        while (this.model.next()) {
            if (!this.model.isRowSelected()) continue;
            index = this.model.getRowIndex();
        }
        TraceUtil.trace3("Exiting");
        return index;
    }

    private String getSelectedValue(int index) {
        TraceUtil.trace3("Entering");
        String value = null;
        ViewBean vb = this.getParentViewBean();
        this.model.setRowIndex(index);
        value = (String)this.model.getValue("FSHiddenField");
        TraceUtil.trace3("Exiting");
        return value;
    }

    private String getSelectedFSType(int index) {
        TraceUtil.trace3("Entering");
        String value = null;
        ViewBean vb = this.getParentViewBean();
        this.model.setRowIndex(index);
        value = (String)this.model.getValue("HiddenType");
        TraceUtil.trace3("Exiting");
        return value;
    }

    public void handleCancelHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void populateData() throws SamFSException, SamFSMultiHostException {
        TraceUtil.trace3("Entering");
        this.model.initModelRows();
        this.partialErrMsg = this.model.partialErrMsg;
        this.sharedMDServer = this.model.sharedMDServer;
        ViewBean vb = this.getParentViewBean();
        vb.setPageSessionAttribute("SHARED_MD_SERVER", (Serializable)((Object)this.sharedMDServer));
        TraceUtil.trace3("md_server = " + this.sharedMDServer);
        TraceUtil.trace3("Exiting");
    }

    private void setSuccessAlert(String msg, String item) {
        TraceUtil.trace3("Entering");
        SamUtil.setInfoAlert((ContainerView)this.getParentViewBean(), "Alert", "success.summary", SamUtil.getResourceString(msg, item), this.getServerName());
        TraceUtil.trace3("Exiting");
    }

    private void forwardToTargetPage(boolean showAlert) {
        TraceUtil.trace3("Entering");
        ViewBean targetView = null;
        String s = null;
        Integer[] temp = (Integer[])this.getParentViewBean().getPageSessionAttribute("PAGE_PATH");
        Integer[] path = BreadCrumbUtil.getBreadCrumbDisplay(temp);
        int index = path[path.length - 1];
        PageInfo pageInfo = PageInfo.getPageInfo();
        String targetName = pageInfo.getPagePath(index).getCommandField();
        TraceUtil.trace3("targetname = " + targetName);
        if (targetName.equals("FileSystemSummaryHref")) {
            targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean = SharedFSDetailsView.class$("com.sun.netstorage.samqfs.web.fs.FSSummaryViewBean")) : class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean);
            s = Integer.toString(BreadCrumbUtil.inPagePath(path, index, path.length - 1));
            TraceUtil.trace3("FSSummary target ");
        }
        if (showAlert) {
            this.showAlert(targetView);
        }
        ViewBean vb = this.getParentViewBean();
        BreadCrumbUtil.breadCrumbPathBackward(vb, PageInfo.getPageInfo().getPageNumber(targetView.getName()), s);
        ((CommonViewBeanBase)vb).forwardTo(targetView);
        TraceUtil.trace3("exiting");
    }

    private void showAlert(ViewBean targetView) {
        TraceUtil.trace3("Entering");
        String temp = SamUtil.getResourceString("SharedFSDetails.delete.success", this.fsName);
        TraceUtil.trace3("msg is " + temp);
        SamUtil.setInfoAlert((ContainerView)targetView, "Alert", "success.summary", temp, this.getServerName());
        TraceUtil.trace3("Exiting");
    }

    private String getServerName() {
        return (String)this.getParentViewBean().getPageSessionAttribute("SERVER_NAME");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

