/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.RequestHandlingViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.fs.NFSAddDirPopUpViewBean;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.fs.GenericFileSystem;
import com.sun.netstorage.samqfs.web.model.fs.NFSOptions;
import com.sun.netstorage.samqfs.web.remotefilechooser.RemoteFileChooserControl;
import com.sun.netstorage.samqfs.web.remotefilechooser.RemoteFileChooserModel;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.PageTitleUtil;
import com.sun.netstorage.samqfs.web.util.PropertySheetUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.view.filechooser.CCFileChooserWindow;
import java.io.IOException;
import javax.servlet.ServletException;

public class NFSAddDirPopUpView
extends RequestHandlingViewBase {
    public static final String CHILD_PATH_CHOOSER = "pathChooser";
    protected RemoteFileChooserModel pathChooserModel = null;
    protected CCPropertySheetModel propertySheetModel = null;
    protected CCPageTitleModel pageTitleModel = null;
    protected String serverName = null;
    protected String fileSystemName = null;
    protected String mountPoint = null;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl;

    public NFSAddDirPopUpView(View parent, String name) {
        super(parent, name);
        TraceUtil.trace3("Entering");
        NFSAddDirPopUpViewBean vb = (NFSAddDirPopUpViewBean)parent;
        this.serverName = vb.getServerName();
        this.fileSystemName = vb.getFSName();
        this.mountPoint = vb.getFSMountPoint();
        TraceUtil.trace3("Got serverName and fs mount point from page session: " + this.serverName + ", " + this.fileSystemName);
        this.createPageTitleModel();
        this.createPropertySheetModel();
        this.createFileChooserModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    public void registerChildren() {
        TraceUtil.trace3("Entering");
        this.registerChild(CHILD_PATH_CHOOSER, class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl == null ? (class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl = NFSAddDirPopUpView.class$("com.sun.netstorage.samqfs.web.remotefilechooser.RemoteFileChooserControl")) : class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl);
        PageTitleUtil.registerChildren((ContainerViewBase)this, this.pageTitleModel);
        PropertySheetUtil.registerChildren((ContainerViewBase)this, this.propertySheetModel);
        TraceUtil.trace3("Exiting");
    }

    public View createChild(String name) {
        TraceUtil.trace3("Entering with name" + name);
        if (name.equals(CHILD_PATH_CHOOSER)) {
            RemoteFileChooserControl child = new RemoteFileChooserControl((ContainerView)this, this.pathChooserModel, name);
            TraceUtil.trace3("Exiting");
            return child;
        }
        if (PageTitleUtil.isChildSupported(this.pageTitleModel, name)) {
            TraceUtil.trace3("Exiting");
            return PageTitleUtil.createChild((ContainerView)this, this.pageTitleModel, name);
        }
        if (PropertySheetUtil.isChildSupported(this.propertySheetModel, name)) {
            TraceUtil.trace3("Exiting");
            return PropertySheetUtil.createChild((ContainerView)this, this.propertySheetModel, name);
        }
        return null;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        CCFileChooserWindow folderChooser = (CCFileChooserWindow)this.getChild(CHILD_PATH_CHOOSER);
        String browsedDir = folderChooser.getDisplayFieldStringValue("browsetextfield");
        if (browsedDir == null) {
            folderChooser.setDisplayFieldValue("browsetextfield", (Object)this.mountPoint);
        }
        this.propertySheetModel.setValue("shareNowValue", (Object)"true");
        TraceUtil.trace3("Exiting");
    }

    private void createPageTitleModel() {
        TraceUtil.trace3("Entering");
        if (this.pageTitleModel == null) {
            this.pageTitleModel = PageTitleUtil.createModel("/jsp/fs/NFSAddDirPopUpPageTitle.xml");
        }
        TraceUtil.trace3("Exiting");
    }

    private CCPropertySheetModel createPropertySheetModel() {
        TraceUtil.trace3("Entering");
        if (this.propertySheetModel == null) {
            this.propertySheetModel = PropertySheetUtil.createModel("/jsp/fs/NFSAddDirPropertySheet.xml");
        }
        TraceUtil.trace3("Exiting");
        return this.propertySheetModel;
    }

    private void createFileChooserModel() {
        this.pathChooserModel = new RemoteFileChooserModel(this.serverName, 50);
        this.pathChooserModel.setFileListBoxHeight(15);
        NonSyncStringBuffer homeDir = new NonSyncStringBuffer();
        homeDir.append(this.mountPoint);
        this.pathChooserModel.setHomeDirectory(homeDir.toString());
        this.pathChooserModel.setProductNameAlt("secondaryMasthead.productNameAlt");
        this.pathChooserModel.setProductNameSrc("secondaryMasthead.productNameSrc");
        this.pathChooserModel.setPopupMode(true);
    }

    public void handleSubmitRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        NFSAddDirPopUpViewBean parent = (NFSAddDirPopUpViewBean)this.getParentViewBean();
        String fsName = this.fileSystemName;
        String dirName = ((ContainerViewBase)this.getChild(CHILD_PATH_CHOOSER)).getDisplayFieldStringValue("browsetextfield");
        String shareState = "true".equals(this.getDisplayFieldStringValue("shareNowValue")) ? "yes" : "config";
        System.out.println("fs name = " + fsName);
        System.out.println("dir name = " + dirName);
        System.out.println("share state = " + shareState);
        if (dirName != null) {
            try {
                SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
                NFSOptions opts = new NFSOptions(dirName, shareState);
                GenericFileSystem fs2 = sysModel.getSamQFSSystemFSManager().getGenericFileSystem(fsName);
                if (fs2 != null && opts != null) {
                    boolean setAlert = false;
                    StringBuffer alertBuf = new StringBuffer();
                    NFSOptions[] existOptsList = fs2.getNFSOptions();
                    for (int k = 0; k < existOptsList.length; ++k) {
                        NFSOptions existOpt = existOptsList[k];
                        if (dirName.compareTo(existOpt.getDirName()) == 0) {
                            setAlert = true;
                            alertBuf.append(SamUtil.getResourceString("NFSDetailsViewBean.error.failedAddDuplicate", dirName));
                            break;
                        }
                        if (this.isSubDir(dirName, existOpt.getDirName())) {
                            setAlert = true;
                            alertBuf.append(SamUtil.getResourceString("NFSDetailsViewBean.error.failedAddChild", dirName));
                            break;
                        }
                        if (!this.isParentDir(dirName, existOpt.getDirName())) continue;
                        setAlert = true;
                        alertBuf.append(SamUtil.getResourceString("NFSDetailsViewBean.error.failedAddParent", dirName));
                        break;
                    }
                    if (setAlert) {
                        SamUtil.setErrorAlert((ContainerView)parent, "Alert", "NFSDetailsViewBean.error.failedAdd", -2600, alertBuf.toString(), this.serverName);
                    } else {
                        LogUtil.info(((Object)((Object)this)).getClass(), "handleAddPopupHrefRequest", new NonSyncStringBuffer().append("Start adding new NFS directory ").append(dirName).append(" in file system ").append(fsName).toString());
                        fs2.setNFSOptions(opts);
                        LogUtil.info(((Object)((Object)this)).getClass(), "handleSubmitRequest", new NonSyncStringBuffer().append("finished adding new NFS directory ").append(dirName).append(" in file system ").append(fsName).toString());
                        SamUtil.setInfoAlert((ContainerView)parent, "Alert", "success.summary", SamUtil.getResourceString("filesystem.nfs.msg.add", dirName), this.serverName);
                    }
                }
                parent.setSubmitSuccessful(true);
            }
            catch (SamFSException ex) {
                SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "NFSAddDirPopUpViewBean()", "Failed to add directory as a NFS Shared Directory", this.serverName);
                SamUtil.setErrorAlert((ContainerView)parent, "Alert", "NFSDetailsViewBean.error.failedAdd", ex.getSAMerrno(), ex.getMessage(), this.serverName);
            }
        }
        parent.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    private boolean isSubDir(String dirName, String parent) {
        StringBuffer parentBuf = new StringBuffer(parent).append("/");
        TraceUtil.trace3(new NonSyncStringBuffer("Is ").append(dirName).append(" a subdirectory of ").append((Object)parentBuf).toString());
        TraceUtil.trace3("dir length =" + dirName.length() + "parent length = " + parentBuf.length());
        return dirName.length() > parentBuf.length() && dirName.startsWith(parentBuf.toString());
    }

    private boolean isParentDir(String dirName, String subDir) {
        StringBuffer parentBuf = new StringBuffer(dirName).append("/");
        TraceUtil.trace3(new NonSyncStringBuffer("Is ").append(dirName).append(" a parent of ").append(subDir).toString());
        TraceUtil.trace3("subdir length =" + subDir.length() + "parent length = " + parentBuf.length());
        if (subDir.length() > parentBuf.length() && subDir.startsWith(parentBuf.toString())) {
            TraceUtil.trace3("true");
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

